(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Sat Aug  1  0:29:25 PDT 1992 by meehan *)
(*      modified on Tue Jun 16 13:08:09 PDT 1992 by muller *)
(*      modified on Mon Jun 15 20:24:04 1992 by mhb *)

(* A "TrillSwitchVBT.T" is a switch version of Trestle's
   "TrillBtnVBT".

   Actually, a "TrillBtnVBT" does not exist.  If it existed, it
   would be a button that generates events repeatedly while the
   mouse is down and in its domain.  When the mouse leaves the
   domain, events generation is suspended until the mouse
   returns.

   The implementation uses the "AutoRepeat" interface for
   repeatedly generating events.  That interface defines the
   parameters that control how frequently events are generated,
   and how long to wait before starting to auto-repeat. *)

INTERFACE TrillSwitchVBT;

IMPORT ButtonVBT, Feedback, SwitchVBT, VBT;

TYPE
  T <: Public;
  Public = ButtonVBT.T OBJECT
           METHODS
             init     (f: Feedback.T; multiclass: MC := NIL): T;
             callback (READONLY cd: VBT.MouseRec);
           END;

  MC = SwitchVBT.MC;

END TrillSwitchVBT.




