(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Mon Aug 10  1:04:36 PDT 1992 by meehan *)
(*      modified on Tue Jun 16 13:08:01 PDT 1992 by muller *)
(*      modified on Mon Jun 15 08:20:03 1992 by mhb *)

(* A "ZChassisVBT" multi-filter provides a {\em chassis} for a
   subwindow.  (A {\em subwindow}\index{subwindow} is a non-background
   child of a "ZSplit".)  The visual display of the chassis is
   hard-wired into this module; in particular, it won't look like a
   top-level window of most of the common X window managers.  The top
   of the chassis is a banner containing (from left to right) a {\em
   close button}, {\em draggable title}, and a {\em grow button}.

   Clicking on the close button unmaps the "ZChassisVBT", thereby
   causing it to disappear.  Clicking on the grow button allows
   the user to change the size of the "ZChassisVBT", subject to
   its size contraints.  That is, the user isn't allowed to make
   the interior of the chassis smaller or larger than its
   reported bounds along each dimension.  Clicking on the title
   allows the user to reposition the "ZChassisVBT" within its
   parent. *)

INTERFACE ZChassisVBT;

IMPORT List, MultiClass, Shadow, VBT, ZChildVBT;

TYPE
  T <: Public;
  Public = ZChildVBT.T OBJECT
           METHODS
             init (ch        : VBT.T;
                   title     : VBT.T;
                   shadow    : Shadow.T := NIL;
                   closable             := TRUE;
                   open                 := TRUE;
                   at        : List.T   := NIL;
                   multiclass: MC       := NIL   ): T
           END;

  MC <: MultiClass.T;
(* The type "MC" overrides "MultiClass.T.replace". *)

(* The call "v.init(...)" initializes "v" as a "ZChassisVBT".  It is
   assumed that "v" will be a subwindow.  The interior of the chassis,
   "ch", is "v"'s child in the multi-child sense.

   A close button is displayed iff "closable" is set.  The grow
   button is implemented with a "ZGrowVBT".  The also functions
   as a drag bar.  It is implemented by a "ZMoveVBT" around
   "title".  The looks of these buttons is governed by the
   "shadow" parameter.

   If "open" is set, then "v" will be "mapped" when it is
   inserted as a child of its parent "ZSplit".  It's location is
   specified in "at".  More details about "open" and "at" appear
   in the "ZChild" interface.

   In the current implementation, a chassis has the following
   general structure (using FormsVBT notation):

|  (Border
|    (VBox
|      (HBox (CloseButton "C")
|            (ZMoveVBT `{\it title}`)
|            (ZGrowVBT "G"))
|      (Frame `{\it ch}`)))

   See Figure~\ref{fig:zchassis}.
   
   However, don't try to traverse the "VBT" tree directly; it is
   subject to change.  To retrieve the contents of a chassis "v",
   use "Multi.Child(v)".

   "v.callback(cd)" is invoked when the CloseButton is activated.

   A "ZChassisVBT"'s move, grow, and close buttons are not
   effective unless the "ZChassis" is a non-background child of a
   "ZSplit". *)

END ZChassisVBT.



