(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Fri Jul 31  0:26:13 PDT 1992 by meehan *)
(*      modified on Tue Jun 16 13:08:00 PDT 1992 by muller *)
(*      modified on Sun Jun 14 03:55:12 1992 by mhb   *)
(*      modified on Fri Mar 27 02:57:32 1992 by steveg*)


MODULE ZChassisVBT;

IMPORT Axis, BorderedVBT, Filter, FlexVBT, FlexShape, Font, HVSplit, List,
         Multi, MultiClass, Pts, Shadow, ShadowedFeedbackVBT, ShadowedVBT,
         Split, SwitchVBT, TextVBT, TextureVBT, VBT, VBTClass, ZChildVBT,
         ZGrowVBT, ZMoveVBT, ZSplit, ZSplitUtils;

<* FATAL Split.NotAChild, Multi.NotAChild *>

REVEAL
  T = Public BRANDED OBJECT 
        holder: Filter.T;  
      OVERRIDES 
        init := Init;
      END;

REVEAL 
  MC = MultiClass.T BRANDED OBJECT 
       OVERRIDES 
         replace := Replace; 
       END;

PROCEDURE NewBtn (t: TEXT; shadow: Shadow.T): VBT.T =
  BEGIN
    WITH textVBT = TextVBT.New (t) DO
      TextVBT.SetFont (textVBT, Font.BuiltIn, shadow);
      RETURN NEW (ShadowedFeedbackVBT.T).init (textVBT, shadow)
    END
  END NewBtn;

PROCEDURE Init (v       : T;
                ch      : VBT.T;
                title   : VBT.T;
                shadow  : Shadow.T := NIL;
                closable: BOOLEAN  := TRUE;
                open    : BOOLEAN  := TRUE;
                at      : List.T   := NIL ; multiclass: MC := NIL  ): T =
  VAR close, drag, stretchyDrag, grow, banner, box, borderedBox: VBT.T;
  BEGIN
    IF shadow = NIL THEN shadow := Shadow.None END;
    IF closable THEN
      close :=
        NEW (SwitchVBT.T, callback := Close).init (NewBtn ("C", shadow));
    END;
    drag := NEW (ZMoveVBT.T).init (
              NEW (ShadowedFeedbackVBT.T).init (title, shadow));
    stretchyDrag := NEW (FlexVBT.T).init (drag, FlexShape.StretchyShape);
    grow := NEW (ZGrowVBT.T).init (NewBtn ("G", shadow));
    banner := HVSplit.New (Axis.T.Hor);
    IF closable THEN Split.AddChild (banner, close, VBar (shadow)) END;
    Split.AddChild (banner, stretchyDrag, VBar (shadow), grow);
    v.holder := NEW (Filter.T).init (ch);
    box :=
      HVSplit.Cons (
        Axis.T.Ver, banner,
        FlexVBT.FromAxis (
          TextureVBT.New (shadow.fg), Axis.T.Ver, FlexShape.Rigid (1.0)),
        NEW (ShadowedVBT.T).init (v.holder, shadow, Shadow.Style.Raised));
    borderedBox := NEW (BorderedVBT.T).init (box, Pts.ToMM (1.0), shadow.fg);

    EVAL ZChildVBT.T.init (v, borderedBox, open, at);
    IF multiclass = NIL THEN multiclass := NEW (MC) END;
    MultiClass.Be (v, multiclass);
    MultiClass.BeChild (v, ch);
    RETURN v
  END Init;

PROCEDURE VBar (shadow: Shadow.T): VBT.T =
  BEGIN
    IF shadow.size # 0.0 THEN
      RETURN NIL
    ELSE
      RETURN FlexVBT.FromAxis (TextureVBT.New (shadow.bgFg), Axis.T.Hor,
                               FlexShape.Rigid (1.0))
    END
  END VBar;

PROCEDURE Close (v: VBT.T; READONLY cd: VBT.MouseRec) =
  VAR zch: T := ZSplitUtils.FindZChild (v);
  BEGIN
    IF zch # NIL THEN ZSplit.Unmap (zch); zch.callback (cd) END;
  END Close;

PROCEDURE Replace (m: MC; <* UNUSED *> ch: VBT.T; new: VBT.T)
  RAISES {Multi.NotAChild} =
  VAR v: T := m.vbt;
  BEGIN
    EVAL Filter.Replace (v.holder, new)
  END Replace;

BEGIN
END ZChassisVBT.
