(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Mon Aug 10  0:31:46 PDT 1992 by meehan *)
(*      modified on Tue Jun 16 13:07:55 PDT 1992 by muller *)
(*      modified on Sun Jun 14 03:33:47 1992 by mhb *)

(* A "ZTilps.T" multi-split is like a "ZSplit", except that the
   children are stored from bottom to top.  Thus,
   "Multi.Nth(v,0)" returns the background child of the "ZSplit".
   *)

INTERFACE ZTilps;

IMPORT MultiClass, ZSplit;

TYPE
  T <: Public;
  Public = ZSplit.T OBJECT
           METHODS
             init (saveBits       := FALSE;
                   parlim         := -1;
                   multiclass: MC := NIL    ): T
           END;

(* The call "v.init(...)" initializes "v" as a "ZTilps" and
   returns "v". See the "ZSplit" interface for a description of
   "saveBits" and "parlim", *)

TYPE MC <: MultiClass.T;
(* The type "MC" overrides the "replace", "insert", "pred", and
   "succ" methods of the type "MultiClass.T". *)

END ZTilps.



