(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* by Ken Brooks; Trexle/M3 by Marc H. Brown                   *)
(* Last modified on Tue Jun 16 12:54:32 PDT 1992 by muller                   *)
(*      modified on Fri Mar 27 02:15:23 1992 by steveg     *)
(*      modified on Sun Oct 20 14:25:02 PDT 1991 by mhb        *)
(*      modified on Mon Feb 11 16:06:44 PST 1991 by brooks     *)

MODULE AnyEvent;

IMPORT VBT;

PROCEDURE KeyToCode (READONLY event: VBT.KeyRec): KeyCode =
  BEGIN
    RETURN NEW(KeyCode, key := event);
  END KeyToCode;

PROCEDURE MouseToCode (READONLY event: VBT.MouseRec): MouseCode =
  BEGIN
    RETURN NEW(MouseCode, mouse := event);
  END MouseToCode;

PROCEDURE PositionToCode (READONLY event: VBT.PositionRec): PositionCode =
  BEGIN 
    RETURN NEW(PositionCode, position := event);
  END PositionToCode;

PROCEDURE MiscToCode (READONLY event: VBT.MiscRec): MiscCode =
  BEGIN
    RETURN NEW(MiscCode, misc := event);
  END MiscToCode;

PROCEDURE TimeStamp (code: Code): VBT.TimeStamp =
  BEGIN
    TYPECASE code OF
    | KeyCode (key) => RETURN key.key.time;
    | MouseCode (mouse) => RETURN mouse.mouse.time;
    | PositionCode (position) => RETURN position.position.time;
    | MiscCode (misc) => RETURN misc.misc.time;
    ELSE <* ASSERT(FALSE) *>
    END;
  END TimeStamp;

BEGIN
END AnyEvent.
