(* Copyright (C) 1992, Digital Equipment Corporation *)
(* All rights reserved. *)
(* See the file COPYRIGHT for a full description. *)
(* *)
(* Last modified on Thu Sep 10 10:19:36 PDT 1992 by mhb *)
(* modified on Tue Jun 16 13:16:19 PDT 1992 by muller *)

(* This interface converts an ascii representation of a VBTkit
   cursor into a "Cursor.T".  The VBTkit representation is
   undocumented. *)

INTERFACE CursorFromAscii;

IMPORT Cursor, Rd, Thread;

EXCEPTION Error;

PROCEDURE Read (rd: Rd.T): Cursor.T
  RAISES {Thread.Alerted, Error};
(* =Cursor.FromRaw(Read(rd)) *)

PROCEDURE ReadRaw (rd: Rd.T): Cursor.Raw
  RAISES {Thread.Alerted, Error};
(* Return a Cursor.Raw version of the cursor's ascii description
   stored in the reader.  The format of the ascii description is
   assumed to be in a VBTkit-specific format.  Raises Error if
   the ascii cursor description contains any sort of error. *)

END CursorFromAscii.

