(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Tue Jun 16 13:12:32 PDT 1992 by muller     *)
(*      modified on Mon Oct 14 17:45:10 PDT 1991 by meehan     *)
(*      modified on Mon Nov 12 17:20:07 1990 by jdd            *)

INTERFACE VTextDef;

IMPORT MText, Font, VBT, VTDef;

TYPE
  T = REF RECORD
            regionMax: Region;  (* highest-numbered region = number of
                                   regions - 1 *)
            region: ARRAY Region OF RegionRec;
            closed: BOOLEAN;
            vt    : VTDef.T;
            mtext   : MText.T;         (* the mutable text itself *)
            vbt     : VBT.T;           (* the bitmap we display in *)
            font    : Font.T;          (* the font for displaying *)
            vOptions: VTDef.VOptions;  (* the VOptions for the VText *)
            north, height: VTDef.Coord;
            west         : VTDef.Coord;  (* origin of display rectangle *)
            width        : VTDef.Coord;  (* size of display rectangle *)
            leftMargin, rightMargin: VTDef.Coord;  (* left and right
                                                      margins *)
            left      : VTDef.Coord;  (* = west + left margin *)
            turnMargin: VTDef.Coord;
            (* margin for displaying turning indicator *)
            topMargin  : VTDef.Coord;  (* top margin of every region *)
            leading    : VTDef.Coord;  (* how many pixels between lines *)
            lineSpacing: VTDef.Coord;  (* leading plus character height *)
            lineOffset : VTDef.Coord;
            (* how far a line's baseline is below its top *)
            caretState   : VTDef.OnOffState;
            dividersDirty: BOOLEAN;
            (* whether to redraw dividers at next Update *)
          END;

  RegionRec =
    RECORD
      view  : VTDef.View;
      north : VTDef.Coord;      (* top of region's rectangle (absolute) *)
      height: VTDef.Coord;      (* height of region's rectangle *)
      top   : VTDef.Coord;      (* = north + top margin *)
      nLines: INTEGER;          (* number of lines displayed (computed) *)
    END;

  Region = [0 .. 3];

END VTextDef.


