(* Copyright 1992 Digital Equipment Corporation. *)
(* Distributed only by permission. *)
(* Last modified on Mon Jul 27 21:06:28 PDT 1992 by johnh *)
(* modified on Tue May 12 08:51:01 1992 by mhb *)

INTERFACE Classes;

(* Maintains lists of algorithm and view classes for ZeusPanel.  This
   module does its own internal locking to prevent simultaneous access.  
   LL of all procedures is arbitrary. *)

IMPORT Algorithm, View, ZeusPanel;

EXCEPTION NotFound;


PROCEDURE RegisterAlg (proc: ZeusPanel.NewAlgProc; name: TEXT);

PROCEDURE FindAlg (name: TEXT): INTEGER RAISES {NotFound};

PROCEDURE NewAlg (which: INTEGER): Algorithm.T;

PROCEDURE AlgCount (): INTEGER;


PROCEDURE RegisterView (proc: ZeusPanel.NewViewProc; name: TEXT);

PROCEDURE FindView (name: TEXT): INTEGER RAISES {NotFound};

PROCEDURE NewView (which: INTEGER): View.T;

PROCEDURE ViewCount (): INTEGER;


END Classes.
