(* Copyright 1992 Digital Equipment Corporation. *)
(* Distributed only by permission. *)
(* Last modified on Thu Aug 20 19:15:45 PDT 1992 by johnh *)
(* modified on Thu Apr 16 14:10:24 1992 by mhb *)

INTERFACE View;

IMPORT ReactivityVBT, VBT, ZeusClass;

(* A View.T is a subclass of a ZeusClass.T with three additional
   methods: *)

(* init(ch) inserts the "ch" argument as the child of the View.T (which is
   a ReactivityVBT.T), sets the reactivity to Passive, and returns the
   View.T.  The init() method should be called just after the View.T is
   created.  Any user-supplied override to the init method must invoke the
   init method of the supertype. *)

(* startrun(v) is called by ZeusPanel just after the user issues the
   command to start running the algorithm, and before the algorithm is
   actually run.  Many subclasses will override the "startrun" method to
   erase anything in the window left over from the previous execution of
   the algorithm.  If a view's startrun procedure is called, ZeusPanel
   guarantees that its endrun procedure will eventually be called. *)

(* endrun(v) is called by ZeusPanel just after the algorithm finishes
   running, either because it was aborted by the user, it crashed, or it
   came to a normal completion.  Typically, it is used by views to "clean
   up" after themselves -- to kill any active threads, etc.  An endrun
   method will only be called if its startrun method had been called
   previously. *)

(* The default ZeusClass "config" method is a noop.  The other ZeusClass
   methods have the following defaults:

   "install" tells Trestle to insert self into the window system

   "delete" tells Trestle to delete self from the window system

   "snapshot" records location of Trestle window

   "restore" installs and moves self to a previously recorded location

   "reactivity" calls ReactivityVBT.Set to make the view Passive or Active

   Subclasses of View.T that are created by zume will be extended with
   methods for each OUTPUT event and UPDATE event in the .evt file.  The
   output methods are invoked with LL < VBT.mu.  Update methods (which are
   called in response to a feedback event) are invoked with LL = VBT.mu.
   User-supplied overrides for OUTPUT and UPDATE methods MUST NOT invoke
   the corresponding supertype methods. *)

REVEAL
   ZeusClass.Private <: ReactivityVBT.T;
   
TYPE
  T <: Public;
  Public = ZeusClass.T OBJECT
           METHODS
             (* LL = VBT.mu *)
             init (ch: VBT.T): T;
             (* LL < VBT.mu *)
             startrun ();
             endrun   ();
           END;

END View.
