(* Copyright 1992 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Wed Oct 28 15:01:26 PST 1992 by johnh  *)

MODULE ZeusUtil;

IMPORT List, Point, Rect, SxSymbol, Text, Trestle, TrestleComm;

<*PRAGMA LL*>
<*FATAL TrestleComm.Failure*>

PROCEDURE KeywordCheck (arg: REFANY; t: TEXT) RAISES {BadSnapshot} =
  (* arg should be a list whose first element is an SxSymbol.T whose name
     is t.  If it isn't, complain. *)
  BEGIN
    IF ISTYPE(arg, List.T) AND (arg # NIL)
         AND ISTYPE(List.First(arg), SxSymbol.T) THEN
      IF NOT Text.Equal(NARROW(List.First(arg), SxSymbol.T).name, t) THEN
        RAISE BadSnapshot("keyword mismatch: " & t);
      END;
    ELSE
      RAISE BadSnapshot("Bad snapshot at keyword: " & t);
    END
  END KeywordCheck;

PROCEDURE ScreenPosOK (scr: Trestle.ScreenID; pt: Point.T): BOOLEAN =
  <* LL = VBT.mu *>
  (* RETURN TRUE iff the screen exists and pt is on it. *)
  VAR screens := Trestle.GetScreens();
  BEGIN
    FOR i := 0 TO LAST(screens^) DO
      IF (scr = screens^[i].id) AND Rect.Member(pt, screens^[i].dom) THEN
        RETURN TRUE
      END;
    END;
    RETURN FALSE;
  END ScreenPosOK;

BEGIN
END ZeusUtil.
