/*
 * PSres.h
 *
 * Copyright (C) 1991 by Adobe Systems Incorporated.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notices appear in all copies and that
 * both those copyright notices and this permission notice appear in
 * supporting documentation and that the name of Adobe Systems
 * Incorporated not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission.  If any portion of this software is changed, it cannot be
 * marketed under Adobe's trademarks and/or copyrights unless Adobe, in
 * its sole discretion, approves by a prior writing the quality of the
 * resulting implementation.
 * 
 * ADOBE MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE SOFTWARE FOR
 * ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 * ADOBE DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY FITNESS FOR A PARTICULAR PURPOSE AND
 * NON-INFRINGEMENT OF THIRD PARTY RIGHTS.  IN NO EVENT SHALL ADOBE BE LIABLE
 * TO YOU OR ANY OTHER PARTY FOR ANY SPECIAL, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE, STRICT LIABILITY OR ANY OTHER ACTION ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.  ADOBE WILL NOT
 * PROVIDE ANY TRAINING OR OTHER SUPPORT FOR THE SOFTWARE.
 * 
 * PostScript, Display PostScript, and Adobe are trademarks of Adobe Systems
 * Incorporated registered in the U.S.A. and other countries.
 *
 * Author: Adobe Systems Incorporated
 */

extern char *PSResFontOutline, *PSResFontPrebuilt, *PSResFontAFM,
	*PSResFontBDF, *PSResFontFamily, *PSResFontBDFSizes,
	 *PSResForm, *PSResPattern, *PSResEncoding, *PSResProcSet;

typedef enum {PSSaveReturnValues, PSSaveByType, PSSaveEverything}
	PSResourceSavePolicy;

#ifdef _NO_PROTO

extern int ListPSResourceFiles();
extern int ListPSResourceTypes();
extern void FreePSResourceStorage();
extern void SetPSResourcePolicy();
typedef int (*PSResourceEnumerator)();
extern void EnumeratePSResourceFiles();
extern int CheckPSResourceTime();
typedef char *(*PSResMallocProc)();
typedef char *(*PSResReallocProc)();
typedef void (*PSResFreeProc)();
typedef void (*PSResFileWarningHandlerProc)();

#else /* _NO_PROTO */

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

extern int ListPSResourceFiles(char *psResourcePathOverride,
			       char *defaultPath,
			       char *resourceType,
			       char *resourceName,
			       char ***resourceNamesReturn,
			       char ***resourceFilesReturn);

extern int ListPSResourceTypes(char *psResourcePathOverride,
			       char *defaultPath,
			       char ***resourceTypeReturn);

extern void FreePSResourceStorage(int everything);

extern void SetPSResourcePolicy(PSResourceSavePolicy policy,
				int willList,
				char **resourceTypes);

typedef int (*PSResourceEnumerator)(char *resourceType,
				    char *resourceName,
				    char *resourceFile,
				    char *private);

extern void EnumeratePSResourceFiles(char *psResourcePathOverride,
				     char *defaultPath,
				     char *resourceType,
				     char *resourceName,
				     PSResourceEnumerator enumerator,
				     char *private);

extern int CheckPSResourceTime(char *psResourcePathOverride,
			       char *defaultPath);

typedef char *(*PSResMallocProc)(int size);

typedef char *(*PSResReallocProc)(char *ptr,
				  int size);

typedef void (*PSResFreeProc)(char *ptr);

typedef void (*PSResFileWarningHandlerProc)(char *fileNamem, char *extraInfo);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif /* _NO_PROTO */

extern PSResMallocProc PSResMalloc;

extern PSResReallocProc PSResRealloc;

extern PSResFreeProc PSResFree;

extern PSResFileWarningHandlerProc PSResFileWarningHandler;
