/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	dirent.h,v $
 * Revision 4.2.2.3  92/06/04  14:13:22  Anthony_Decarlo
 * 	bmerge done
 * 	[92/06/04  14:00:05  Anthony_Decarlo]
 * 
 * 	Moved MAXNAMLEN from within _BSD to within _OSF_SOURCE for OSF1.1
 * 	compatibility.
 * 	[92/06/04  08:16:53  Anthony_Decarlo]
 * 
 * Revision 4.2.2.2  92/03/27  15:22:53  Craig_Horman
 * 	Merge with AG
 * 	[92/03/27  13:51:19  Craig_Horman]
 * 
 * 	Merge with BL5
 * 	[92/03/10  11:38:05  Craig_Horman]
 * 
 * 	Added C++ Support
 * 	[92/02/26  15:21:50  Craig_Horman]
 * 
 * Revision 4.2  91/09/20  05:14:38  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: dirent.h,v $ $Revision: 4.2.2.3 $ (DEC) $Date: 92/06/04 14:13:22 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
/*
 * RESTRICTED RIGHTS LEGEND
 * Use, Duplication or Disclosure by the Government is subject to
 * restrictions as set forth in paragraph (b)(3)(B) of the rights in
 * Technical Data and Computer Software clause in DAR 7-104.9(a).
 */ 

/*
 * (C) COPYRIGHT International Business Machines Corp. 1988, 1989
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */

/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 */
#ifndef _DIRENT_H_
#define _DIRENT_H_

#include <standards.h>
#include <sys/types.h>


#ifdef _POSIX_SOURCE
/*
 * The POSIX standard way of returning directory entries is in directory entry
 * structures, which are of variable length.  Each directory entry has
 * a struct direct at the front of it, containing its inode number,
 * the length of the entry, and the length of the name contained in
 * the entry.  These are followed by the name padded to a 4 byte boundary
 * with null bytes.  All names are guaranteed null terminated.
 * The maximum length of a name in a directory is returned by
 * pathconf(directory_pathname, _PC_NAME_MAX).  The type struct dirent is
 * a template for the beginning of the actual structure, since the
 * length is variable, and so should only be used to declare
 * struct dirent * pointer types.
 */

struct  dirent {
        ino_t    d_ino;               /* file number of entry */
        ushort_t d_reclen;            /* length of this record */
        ushort_t d_namlen;            /* length of string in d_name */
        char    d_name[256];		/* DUMMY NAME LENGTH */
					/* the real maximum length is */
					/* returned by pathconf() */
					/* At this time, this MUST */
					/* be 256 -- the kernel */
					/* requires it */
};

#ifndef _KERNEL
/*
 * Definitions for library routines operating on directories.
 */
typedef struct dirdesc {
        int     dd_fd;        /* file descriptor associated with directory */
        long    dd_loc;       /* offset in current buffer */
        long    dd_size;      /* amount of data returned by getdirentries */
        char    *dd_buf;      /* data buffer */
	int	dd_bufsiz;
        int     dd_len;       /* size of data buffer */
        long    dd_seek;      /* magic cookie returned by getdirentries */
	void	*dd_lock;	/* for inter-thread locking */
} DIR;

#if defined(__STDC__) || defined(__cplusplus)
#if defined(__cplusplus)
extern "C" {
#endif
extern  DIR *opendir(const char *);
extern  struct dirent *readdir(DIR *);
#if defined(_REENTRANT) || defined(_THREAD_SAFE)
extern int readdir_r(DIR *, struct dirent *);
#endif
extern  int closedir(DIR *);
extern  void rewinddir(DIR *);
#if defined(__cplusplus)
}
#endif /* __cplusplus */
#else  /* __STDC__ */
extern	DIR *opendir();
extern	struct dirent *readdir();
#if defined(_REENTRANT) || defined(_THREAD_SAFE)
extern int readdir_r();
#endif
extern	int closedir();
extern  void rewinddir();
#endif /* __STDC__ */
#endif /* _KERNEL */

#endif /* _POSIX_SOURCE */

#ifdef _XOPEN_SOURCE
#ifndef _KERNEL
#if defined(__STDC__) || defined(__cplusplus)
#if defined(__cplusplus)
extern "C" {
#endif
extern void seekdir(DIR *, long );
extern long telldir(DIR *);
#if defined(__cplusplus)
}
#endif /* __cplusplus */
#else  /* _NO_PROTO */
extern	long telldir();
extern	void seekdir();
#endif /* __STDC__ */
#endif /* _KERNEL */
#endif /* _XOPEN_SOURCE */

#ifdef _OSF_SOURCE

#define d_fileno d_ino          /* backward compatibility */
#define MAXNAMLEN	NAME_MAX

/* For BSD compatibility */
#ifdef _BSD

#ifndef _KERNEL
#define direct dirent		/* backward compatibility */
#define dirfd(dirp)     ((dirp)->dd_fd)
#endif	/* _KERNEL */

/*
 * The DIRSIZ macro gives the minimum record length which will hold
 * the directory entry.  This requires the amount of space in struct dirent
 * without the d_name field, plus enough space for the name with a terminating
 * null byte (dp->d_namlen+1), rounded up to a 4 byte boundary.
 * XXX The "256" below (the size of d_name) is subject to compiler alignment.
 */
#define DIRSIZ(dp) \
    ((sizeof (struct dirent) - 256) + (((dp)->d_namlen+1 + 3) &~ 3))

#ifndef _KERNEL
#ifdef _NO_PROTO
extern int scandir();
#else
extern int scandir(const char *, struct dirent ***, int (*)(), int (*)());
#endif
#endif /* _KERNEL */

#endif /* _BSD */

#endif /* _OSF_SOURCE */

#endif /* _DIRENT_H_ */
