/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	stropts.h,v $
 * Revision 4.2  91/09/19  23:00:39  devbld
 * Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: stropts.h,v $ $Revision: 4.2 $ (DEC) $Date: 91/09/19 23:00:39 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
/** Copyright (c) 1989  Mentat Inc.
 ** stropts.h 1.5, last change 10/17/89
 **/

#ifndef	_SYS_STROPTS_H
#define	_SYS_STROPTS_H

#include <sys/secdefines.h>
#include <sys/ioctl.h>

/* priority message request on putmsg() or strpeek */
#define	RS_HIPRI	0x1

/* return values from getmsg(), 0 indicates all ok */
#define	MORECTL		0x1	/* more control info available */
#define	MOREDATA	0x2	/* more data available */

/* flush requests */
#define	FLUSHR		1	/* Flush the read queue */
#define	FLUSHW		2	/* Flush the write queue */
#define	FLUSHRW		3	/* Flush both */

/* signal event masks */
#define	S_INPUT		0x1	/* non-priority message has arrived */
#define	S_HIPRI		0x2	/* priority message on stream head read q */
#define	S_OUTPUT	0x4	/* write queue is no longer full */
#define	S_MSG		0x8	/* signal message at front of read queue */

/* read modes for I_S|GRDOPT */
#define	RNORM		0	/* byte-stream mode, default */
#define	RMSGD		1	/* message-discard mode */
#define	RMSGN		2	/* message-nondiscard mode */
#define	RFILL		3	/* fill read buffer mode (PSE private) */

struct	strbuf {
	int	maxlen;		/* max buffer length */
	int	len;		/* length of data */
	char *	buf;		/* pointer to buffer */
};

/* structure of ioctl data on I_FDINSERT */
struct	strfdinsert {
	struct strbuf	ctlbuf;
	struct strbuf	databuf;
	long		flags;	/* type of message, 0 or RS_HIPRI */
	int		fildes;	/* fd of other stream */
	int		offset;	/* where to put other stream read qp */
};

/* I_PEEK structure */
struct	strpeek {
	struct strbuf	ctlbuf;
	struct strbuf	databuf;
	long		flags;	/* if RS_HIPRI, get priority messages only */
};

/* structure of ioctl data on I_RECVFD */
struct	strrecvfd {
	int		fd;	/* new file descriptor */
/* XXX uid_t, gid_t? */
	unsigned short	uid;	/* user id of sending stream */
	unsigned short	gid;
	char		fill[8];
};

/* structure of ioctl data on I_STR */
struct	strioctl {
	int	ic_cmd;		/* downstream command */
	int	ic_timout;	/* ACK/NAK timeout */
	int	ic_len;		/* length of data arg */
	char *	ic_dp;		/* ptr to data arg */
};
#if SEC_BASE

/* structure of ioctl data for I_FDINSERT_ATTR */
struct strfdinsert_attr {
        struct strbuf   ctlbuf;
        struct strbuf   databuf;
        long            flags;  /* type of message, 0 or RS_HIPRI */
        int             fildes; /* fd of other stream */
        int             offset; /* where to put other stream read qp */
        struct strbuf   attrbuf;
};

/* structure of ioctl data for I_PEEK_ATTR */
struct strpeek_attr {
        struct strbuf   ctlbuf;
        struct strbuf   databuf;
        long            flags;  /* if RS_HIPRI, get priority messages only */
        struct strbuf   attrbuf;
};

/* structure of ioctl data for I_RECVFD_ATTR */
struct strrecvfd_attr {
        int             fd;     /* new file descriptor */
/* XXX uid_t, gid_t? */
        unsigned short  uid;    /* user id of sending stream */
        unsigned short  gid;
        struct strbuf   attrbuf;
};

/* structure of ioctl data for I_SENDFD_ATTR */
struct strsendfd_attr {
        int             fd;     /* file descriptor to be passed */
        struct strbuf   attrbuf;
};

/* structure of ioctl data for I_STR_ATTR */
struct strioctl_attr {
        int     ic_cmd;         /* downstream command */
        int     ic_timout;      /* ACK/NAK timeout */
        int     ic_len;         /* length of data arg */
        char *  ic_dp;          /* ptr to data arg */
        struct strbuf   attrbuf;
};
#endif /* SEC_BASE */
#endif /* _SYS_STROPTS_H */
