#!/bin/sh -
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log:	newvers.sh,v $
# Revision 4.3.2.6  92/03/03  18:43:34  Joshua_Friedman
# 	remove space to left of 'variant'; new form is "-5" (eg. for BL5)
# 	[92/03/03  18:28:31  Joshua_Friedman]
# 
# Revision 4.3.2.5  92/02/28  16:57:56  William_Burns
# 	Make version 'X' rather than 'V' for Silver development
# 	[92/02/28  16:57:10  William_Burns]
# 
# Revision 4.3.2.4  92/01/16  09:28:12  William_Burns
# 	Merge from ODE/TIN: revision 3.5.9.5
# 	date: 92/01/13 12:14:07;  author: devrcs;  state: Exp;  lines added/del: 3/3
# 	sccs rev: 3.9;  orig date: 91/12/04 15:57:39;  orig author: fred
# 	Fred Canter - change to V1.0 for SSB build.
# 	[92/01/14  09:59:51  William_Burns]
# 
# Revision 4.3.2.3  91/12/20  13:08:28  William_Burns
# 	Merge from ODE/TIN: revision 3.5.9.4
# 	date: 91/11/19 13:43:41;  author: devrcs;  state: Exp;  lines added/del: 5/1
# 	sccs rev: 3.8;  orig date: 91/11/07 13:36:17;  orig author: fred
# 	Fred Canter - Id realtime kernels.
# 	[91/12/20  09:47:05  William_Burns]
# 
# Revision 4.3.2.2  91/12/18  21:41:14  William_Burns
# 	Merge from ODE/TIN: revision 3.5.9.3
# 	date: 91/11/14 15:48:16;  author: devrcs;  state: Exp;  lines added/del: 2/2
# 	sccs rev: 3.7;  orig date: 91/11/05 14:37:52;  orig author: fred
# 	Fred Canter - correct product name.
# 	[91/12/04  14:53:00  William_Burns]
# 
# Revision 4.3  91/11/26  11:05:31  devbld_zk3
# 	Baselevel AG_BL0
# 
# Revision 4.2.2.2  91/10/23  15:01:43  William_Burns
# 	Merge from ODE/TIN: revision 3.5.9.2
# 	date: 91/10/17 21:16:37;  author: devrcs;  state: Exp;  lines added/del: 2/2
# 	sccs rev: 3.6;  orig date: 91/10/02 17:47:10;  orig author: fred
# 	Fred Canter - bl7, change T back to X.
# 	[91/10/23  12:47:37  William_Burns]
# 
# Revision 4.2  91/09/21  11:13:33  devrcs
# 	Adding ODE Headers
# 
# $EndLog$
# 
# @(#)$RCSfile: newvers.sh,v $ $Revision: 4.3.2.6 $ (DEC) $Date: 92/03/03 18:43:34 $ 
#
# (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
# ALL RIGHTS RESERVED
#
#
# Mach Operating System
# Copyright (c) 1989 Carnegie-Mellon University
# All rights reserved.  The CMU software License Agreement specifies
# the terms and conditions for use and redistribution.
#
#
# OSF/1 Release 1.0

#
# Copyright (c) 1980, 1986 Regents of the University of California.
# All rights reserved.  The Berkeley software License Agreement
# specifies the terms and conditions for redistribution.
#

#
#
case $# in
	6)
		copyright="$1"; major="$2"; min="$3";variant="";rev="$4"
		;;
	*)
		copyright="$1"; major="$2"; min="$3";variant="$4";rev="$5"
		;;
esac

# ULTRIX vs OSF Bourne shell, which is wrong?
if [ `/bin/uname` != OSF1 ]
then
	nl="\\n"
else
	nl="\\\n"
fi
h=`hostname` t=`date`
v="${major}.${min}"
CONFIG=`cat vers.config`
if [ -z "$h" -o -z "$t" -o -z "${CONFIG}" ]; then
    exit 1
fi
(
  echo "#ifdef __STDC__" ;
  echo "#define CONST const" ;
  echo "#else" ;
  echo "#define CONST" ;
  echo "#endif" ;
  echo "CONST int  version_major      = ${major};" ;
  echo "CONST int  version_minor      = ${min};" ;
  echo "CONST char version_version[32]  = \"${major}.${min}\";" ;
  echo "CONST char version_release[32]  = \"${major}.${min}\";" ;
  echo "#ifdef REALTIME" ;
  echo "CONST char version[] = \"DEC OSF/1 [RT] X${v}${variant} (Rev. ${rev}); ${t} ${nl}\";" ;
  echo "#else" ;
  echo "CONST char version[] = \"DEC OSF/1 X${v}${variant} (Rev. ${rev}); ${t} ${nl}\";" ;
  echo "#endif" ;
  echo "CONST char copyright[] = \"\\" ;
  sed <$copyright -e '/^#/d' -e 's;[ 	]*$;;' -e '/^$/d' -e 's;$;\\n\\;' ;
  echo "\";";
) > vers.c
if [ -s vers.suffix -o ! -f vers.suffix ]; then
    echo ".${b}.${CONFIG}" >vers.suffix
fi
exit 0
