/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	machparam.h,v $
 * Revision 1.1.3.4  92/03/13  17:27:34  halproject_Donald_Dutile
 * 	Merge to AG from HALPROJECT
 * 	[92/03/13  16:48:10  halproject_Donald_Dutile]
 * 
 * 	Changed in-line macros USERMODE & BASEPRI to functions;
 * 	necessary since (future) R4000 psw/status reg. significantly
 * 	different then R2000/R3000 psw/status reg.; moved the
 * 	functionality/functions into sr_masks.c
 * 	[92/03/10  09:54:22  Donald_Dutile]
 * 
 * 	Moved DELAY to hal/cpusw.c; made it into
 * 	a real function (not a macro).
 * 	[92/03/09  22:03:04  Donald_Dutile]
 * 
 * Revision 1.1.3.3  92/01/16  14:37:18  William_Burns
 * 	TIN BL9 Merge: revision 3.1.9.2
 * 	date: 92/01/14 10:28:38;  author: devrcs;  state: Exp;  lines added/del: 6/2
 * 	sccs rev: 3.2;  orig date: 91/12/10 14:56:47;  orig author: fred
 * 	Fred Canter - fix BASEPRI macro so 3min gives correct statistics.
 * 	[92/01/16  14:35:59  William_Burns]
 * 
 * Revision 1.1.3.2  91/11/20  13:44:40  Hal_Project
 * 	Moved from dec/machine/mips; pool reorg.
 * 	[91/11/18  00:07:14  Donald_Dutile]
 * 
 * Revision 4.2  91/09/19  23:12:15  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: machparam.h,v $ $Revision: 1.1.3.4 $ (DEC) $Date: 92/03/13 17:27:34 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */

/* ------------------------------------------------------------------ */
/* | Copyright Unpublished, MIPS Computer Systems, Inc.  All Rights | */
/* | Reserved.  This software contains proprietary and confidential | */
/* | information of MIPS and its suppliers.  Use, disclosure or     | */
/* | reproduction is prohibited without the prior express written   | */
/* | consent of MIPS.                                               | */
/* ------------------------------------------------------------------ */

#ifndef BYTE_ORDER
#ifndef ASSEMBLER
#include <machine/endian.h>
#endif
#endif
#include <machine/machlimits.h>

/*
 * Machine dependent constants for mips.
 */
#define	MACHINE		"mips"

#define	NBPG		4096		/* bytes/page */
#define	PGOFSET		(NBPG-1)	/* byte offset into page */
#define	PGSHIFT		12		/* LOG2(NBPG) */
#define	DBSHIFT		9		/* LOG2(Disk block size) */

#define	CLSIZE		1
#define	CLSIZELOG2	0

#define	SSIZE		1		/* initial stack size/NBPG */
#define	SINCR		1		/* increment of stack/NBPG */

#define	UPAGES		2		/* pages of u-area */
#define	KERNELSTACK	0xffffe000	/* Top of kernel stack */
#define	UADDR		0xffffc000	/* address of u */
#define	UVPN		(UADDR>>PGSHIFT)/* virtual page number of u */

/*
 * Some macros for units conversion
 */
/* Core clicks (4096 bytes) to segments and vice versa */
#define	ctos(x)	(x)
#define	stoc(x)	(x)

/* Core clicks (4096 bytes) to disk blocks */
#define	ctod(x)	((x)<<(PGSHIFT-DBSHIFT))
#define	dtoc(x)	((unsigned)(x)>>(PGSHIFT-DBSHIFT))
#define	dtob(x)	((x)<<DBSHIFT)

/* clicks to bytes */
#define	ctob(x)	((x)<<PGSHIFT)

/* bytes to clicks */
#define	btoc(x)	(((unsigned)(x)+PGOFSET)>>PGSHIFT)

/*
 * Macros to decode processor status word.
 */
#define	USERMODE(sr)	usermode(sr)
#define BASEPRI(sr)     basepri(sr)
