/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	lat.h,v $
 * Revision 1.1.2.2  92/05/04  14:46:03  Philip_Vitale
 * 	merged with ag.latest
 * 	[92/05/04  14:20:17  Philip_Vitale]
 * 
 * 	Created original file.
 * 	Developed by Matt Thomas.
 * 	[92/05/01  12:22:52  Philip_Vitale]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: lat.h,v $ $Revision: 1.1.2.2 $ (DEC) $Date: 92/05/04 14:46:03 $
 */

#ifndef _DEC_LAT_LAT_H
#define	_DEC_LAT_LAT_H

#include <sys/types.h>

#define	LAT_MAXNAME	16
#define	LAT_MAXDESC	64

/*
 * User IOCTL's
 */
#define	LIOCCONN	_IOW('L', 1, struct latioctl_ttyi) /* Connects to a node/port/serivce (master or slave) */
#define	LIOCTTYI	_IOR('L', 2, struct latioctl_ttyi) /* Returns remote node/port -- destination service */
#define	LIOCBIND	_IOW('L', 3, struct latioctl_ttyi) /* binds a tty to service name (used by lattelnet/latvtp/etc) */

struct latioctl_ttyi {
    u_char li_service[LAT_MAXNAME+1];
    u_char li_host[LAT_MAXNAME+1];
    u_char li_port[LAT_MAXNAME+1];
};

/*
 * For backwards compatibility with ULTRIX, define the following so
 * that those programs which the ltattyi.h definitions will work. 
 */
#define	ltattyi		latioctl_ttyi
#define	lta_dest_port	li_service
#define	lta_server_name	li_host
#define	lta_server_port	li_port

/*
 * Control interfaces for LCP
 */
#define	LIOCGNODE	_IOR ('L', 10, struct latioctl_node)
#define	LIOCSNODE	_IOWR('L', 11, struct latioctl_node)
#define	LIOCASERVICE	_IOWR('L', 12, struct latioctl_service)
#define	LIOCGSERVICE	_IOWR('L', 13, struct latioctl_service)
#define	LIOCSSERVICE	_IOWR('L', 14, struct latioctl_service)
#define	LIOCDSERVICE	_IOW ('L', 15, struct latioctl_service)
#define	LIOCGPORT	_IOWR('L', 16, struct latioctl_port)
#define	LIOCSPORT	_IOW ('L', 17, struct latioctl_port)
#define	LIOCALINK	_IOW ('L', 18, struct latioctl_link)
#define	LIOCGLINK	_IOWR('L', 19, struct latioctl_link)
#define	LIOCDLINK	_IOW ('L', 20, struct latioctl_link)
#define	LIOCGNODECTRS	_IOR ('L', 21, struct latioctl_nodectrs)
#define	LIOCGLINKCTRS	_IOWR('L', 22, struct latioctl_linkctrs)
#define	LIOCGSESSCTRS	_IOWR('L', 23, struct latioctl_slotctrs)
#define LIOCGPORTCTRS	_IOWR('L', 24, struct latioctl_portctrs)
#define	LIOCGHOST	_IOWR('L', 25, struct latioctl_host)
#define	LIOCZNODECTRS	_IO  ('L', 26)
#define	LIOCZLINKCTRS	_IOW ('L', 27, struct latioctl_linkctrs)
#define	LIOCZSESSCTRS	_IOW ('L', 28, struct latioctl_slotctrs)
#define LIOCZPORTCTRS	_IOW ('L', 29, struct latioctl_portctrs)
#define	LIOCDEBUG	_IO  ('L', 99)

struct latioctl_node {
    unsigned int ln_flags;		/* */
#define	LATIOCTL_NODE_NAME		0x01 /* Name is present */
#define	LATIOCTL_NODE_DESC		0x02 /* Description is present */
#define	LATIOCTL_NODE_GROUPS		0x04 /* Groups are present */
#define	LATIOCTL_NODE_SATIMER		0x08 /* Service Announcement Timer */
#define	LATIOCTL_NODE_STATE		0x10 /* New state is present */
#define	LATIOCTL_NODE_MAXHOSTS		0x20 /* Maximum hosts allowed */
#define	LATIOCTL_NODE_MAXSERVICES	0x40 /* Maximum services allowed */
#define	LATIOCTL_NODE_IFNET		0x8000 /* ifnet based */
    unsigned char ln_name[LAT_MAXNAME+1]; /* */
    unsigned char ln_desc[LAT_MAXDESC+1]; /* */
    unsigned char ln_groups[32];	/* */
    unsigned char ln_satimer;		/* */
    unsigned char ln_state;		/* */
#define	LAT_STATE_ON	1
#define	LAT_STATE_OFF	0
    unsigned char ln_maxservices;	/* # of services (RW) */
    unsigned char ln_maxhosts;		/* max # of hosts allowed in (RW) */
};

struct latioctl_service {
    unsigned int ls_flags;		/* */
#define	LATIOCTL_SERVICE_NAME		0x01
#define	LATIOCTL_SERVICE_DESC		0x02
#define	LATIOCTL_SERVICE_RATING_DYANMIC	0x04
#define	LATIOCTL_SERVICE_RATING_STATIC	0x08
#define	LATIOCTL_SERVICE_DEFAULT	0x10
#define	LATIOCTL_SERVICE_GROUPS		0x20
    unsigned char ls_index;		/* */
    unsigned char ls_name[LAT_MAXNAME+1]; /* */
    unsigned char ls_desc[LAT_MAXDESC+1]; /* */
    unsigned char ls_rating;		/* */
    unsigned char ls_groups[32];	/* Groups for this service */
};

struct latioctl_port {
    unsigned int lp_flags;		/* */
#define	LATIOCTL_PORT_NODE		0x01
#define	LATIOCTL_PORT_SERVICE		0x02
#define	LATIOCTL_PORT_REMOTEPORT	0x04
#define	LATIOCTL_PORT_OUTBOUND		0x08
#define	LATIOCTL_PORT_RESET		0x10
#define	LATIOCTL_PORT_NONQUEUED		0x20
#define	LATIOCTL_PORT_CONNECTED		0x40
    dev_t lp_devno;			/* */
    unsigned char lp_node[LAT_MAXNAME+1];	/* */
    unsigned char lp_service[LAT_MAXNAME+1];	/* */
    unsigned char lp_remoteport[LAT_MAXNAME+1];	/* */
};

struct latioctl_link {
    char ll_ifname[16];			/* link (interface) name */
    int ll_muxid;			/* optional mux id */
};

struct latioctl_linkctrs {
    char llc_ifname[16];		/* ctrs for this link */
    unsigned int llc_seconds;		/* elapsed time */
    unsigned int llc_octetssent;	/* total octets sent */
    unsigned int llc_octetsrcvd;	/* total octets received */
    unsigned int llc_pdussent;		/* total pdus sent */
    unsigned int llc_pdusrcvd;		/* total pdu received */
    unsigned int llc_moctetssent;	/* multicast octets sent */
    unsigned int llc_moctetsrcvd;	/* multicast octets received */
    unsigned int llc_mpdussent;		/* multicast pdus sent */
    unsigned int llc_mpdusrcvd;		/* multicast pdu received */
};

struct latioctl_nodectrs {
    unsigned int lnc_seconds;		/* elasped time (in seconds) */
    unsigned int lnc_octetssent;	/* total octets sent */
    unsigned int lnc_octetsrcvd;	/* total octets received */
    unsigned int lnc_pdussent;		/* total pdus sent */
    unsigned int lnc_pdusrcvd;		/* total pdus received */
    unsigned int lnc_dupoctetssent;	/* duplicate octets sent */
    unsigned int lnc_dupoctetsrcvd;	/* duplicate octets received */
    unsigned int lnc_duppdussent;	/* duplicate pdus sent */
    unsigned int lnc_duppdusrcvd;	/* duplicate pdus received */
    unsigned int lnc_vcstarts_rcvd;	/* virtual circuit starts received */
    unsigned int lnc_slotstarts_rcvd;	/* sessions starts received */
    unsigned int lnc_badslots_rcvd;	/* illegal messages received */
    unsigned int lnc_badpdus_rcvd;	/* illegal slots received */
    unsigned int lnc_droppedpdus;	/* unrecognized pdus */

};

struct latioctl_slotctrs {
    unsigned int lsc_seconds;		/* elapsed time */
    unsigned int lsc_octetssent;	/* total octets sent */
    unsigned int lsc_octetsrcvd;	/* total octets received */
    unsigned int lsc_slotssent;		/* total slots sent */
    unsigned int lsc_slotsrcvd;		/* total slots received */
    unsigned int lsc_ooctetssent;	/* non-data_a octets sent */
    unsigned int lsc_ooctetsrcvd;	/* non-data_a octets received */
    unsigned int lsc_oslotssent;	/* non-data_a slots sent */
    unsigned int lsc_oslotsrcvd;	/* non-data_a slots recevied */
};

struct latioctl_portctrs {
    unsigned int ltc_savedoctets;
    unsigned int ltc_lostoctets;
    unsigned int ltc_fetchedoctets;
    unsigned int ltc_canq;
    unsigned int ltc_rawq;
    unsigned int ltc_outq;
    unsigned int ltc_ovrq;
    unsigned int ltc_remcredits;
    unsigned int ltc_loccredits;
    unsigned int ltc_tstate;
    unsigned int ltc_maxo;
};

struct latioctl_host {
    unsigned int lh_index;		/* host index */
    char lh_ifname[16];			/* host reachable via this interface */
    unsigned char lh_hwaddr[6];		/* ISO8802.1 address of host */
    unsigned char lh_name[LAT_MAXNAME+1]; /* host name (null terminated) */
    unsigned short lh_framesize;	/* framesize to used with host */
    unsigned char lh_type;		/* remote host type */

    unsigned int lh_seconds;		/* elapsed time of counters */
    unsigned int lh_octetssent;		/* total octets sent */
    unsigned int lh_octetsrcvd;		/* total octets received */
    unsigned int lh_pdussent;		/* total pdus sent */
    unsigned int lh_pdusrcvd;		/* total pdus received */
    unsigned int lh_dupoctetssent;	/* duplicate octets sent */
    unsigned int lh_dupoctetsrcvd;	/* duplicate octets received */
    unsigned int lh_duppdussent;	/* duplicate pdus sent */
    unsigned int lh_duppdusrcvd;	/* duplicate pdus received */
};

#endif /* _DEC_LAT_LAT_H */
