/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	bvpscs.h,v $
 * Revision 1.1.2.3  92/05/05  12:47:01  Peter_Keilty
 * 	Change u_long to u_int for 64 bit ALPHA.
 * 	[92/05/04  17:02:20  Peter_Keilty]
 * 
 * Revision 1.1.2.2  92/02/24  11:47:02  Peter_Keilty
 * 	Initial checkin of DSA IO subsystem and
 * 	related system files
 * 	[92/02/12  18:37:38  Peter_Keilty]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: bvpscs.h,v $ $Revision: 1.1.2.3 $ (DEC) $Date: 92/05/05 12:47:01 $
 */
/*
 * derived from bvpscs.h	4.3	(ULTRIX)	10/11/90	
 */


typedef struct _bvp_ssppccb {		/* BVP SSP specific fields of PCCB */

	struct	_gvpbq	dfreeq;		/* Datagram free queue head	*/
	struct	_gvpbq	mfreeq;		/* Message free queue head	*/
	struct	bvpregs	*port_regs;	/* Pointer to Port Registers	*/
	struct biic_regs *nxv;		/* VA of Adapter BIIC Regs	*/
	struct	_pb	*pb;		/* Pointer to Path Block	*/
	u_int		bvp_ctlr;	/* Controller number		*/
	int		binumber;	/* BI number			*/
	int		binode;		/* BI node number		*/
	struct	bidata	*bidata;	/* Pointer to bidata structure	*/
	u_int		cmd_pend;	/* Port command pending vector	*/
	u_int		ivec;		/* Interrupt vector		*/
	int		poll_rate;	/* Timer poll rate		*/
	u_int		port_state;	/* Current port state		*/
	int		rip;		/* Recovery in progress ind.	*/
	int		incarn;		/* Port incarnation number	*/
	} BVPSSPPCCB;



typedef struct _bvp_ssppqb {		/* BVP SSP specific fields of PQB */

	struct _gvpbq	*dfreeq_hdr;	/* Datagram free queue head pointer */
	struct _gvpbq	*mfreeq_hdr; 	/* Message free queue head pointer  */
	u_int		dqe_len	: 16;	/* Datagram queue entry length	*/
	u_int			: 16;	/* MBZ				*/
	u_int		mqe_len	: 16;	/* Message queue entry length	*/
	u_int			: 16;	/* MBZ				*/
	struct _gvppqb	*vpqb_base;	/* PQB system virtual address	*/
	struct _gvpbd	*bdt_base;	/* BDT system virtual address	*/
	u_short		bdt_len;	/* BDT octaword length		*/
	u_short			: 16;	/* MBZ				*/
	struct pte	*spt_base;	/* System page table physical address*/
	u_int		spt_len	: 22;	/* SPT longword length		*/
	u_int			: 10;	/* MBZ				*/
	struct pte	*gpt_base;	/* Global page table physical address*/
	u_int		gpt_len	: 22;	/* GPT longword length		*/
	u_int			: 10;	/* MBZ				*/
	u_int		keep_alive;	/* Keep-alive timer		*/
	u_int		function_mask;	/* Port charateristics mask	*/
	u_int		piv;		/* Port Interrupt Vector	*/
	u_int		bvp_level;	/* BVP funtionality level	*/
	u_char		reserved1[ 32 ];/* Reserved			*/
	u_int		pd_prtvrs  :8;	/* Port driver PPD version	*/
	u_int		reserved2  :24;	/* Reserved			*/
	u_int		pd_max_dg  :16;	/* Maximum datagram size - port	*/
	u_int		pd_max_msg :16;	/* Maximum message size - port	*/
	u_int		pd_sw_type;	/* Operating system "U-32" 	*/
	u_int		pd_sw_version;	/* Operating system version	*/
	u_int		pd_hw_type;	/* Port hardware type		*/
	u_dodec		pd_hw_version;	/* Port hardware version	*/
	u_quad		pd_cur_time;	/* Current time			*/
	u_char		reserved4[ 24 ];/* Reserved			*/
	u_int		ad_prtvrs  :8;	/* Adapter PPD protocol version	*/
	u_int		ad_type	   :8;	/* Adapter port type		*/
	u_int		reserved3  :16;	/* Reserved			*/
	u_int		reserved6;	/* Reserved			*/
	u_int		ad_max_dg  :16;	/* Maximum datagram size - adap	*/
	u_int		ad_max_msg :16;	/* Maximum message size - adap	*/
	u_int		ad_sw_type;	/* Adapter software type	*/
	u_int		ad_sw_version;	/* Adapter software version	*/
	u_int		ad_hw_type;	/* Adapter hardware type	*/
	u_dodec		ad_hw_version;	/* Adapter harware version	*/
	u_char		reserved5[ 24 ];/* Reserved			*/
	struct	_gvph	*qe_logout[ BVP_NOLOG ];/* Queue Entry logout area */
	} BVPSSPPQB;

