/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	dkio.h,v $
 * Revision 1.1.3.2  92/06/02  11:28:42  cam_proj_Janet_Schank
 * 	Moved header files from sys to io/cam
 * 	[92/05/13  09:58:53  Janet_Schank]
 * 
 * 	Initial checkin of DSA IO subsystem and
 * 	related system files
 * 	[92/02/12  18:45:57  Peter_Keilty]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: dkio.h,v $ $Revision: 1.1.3.2 $ (DEC) $Date: 92/06/02 11:28:42 $
 */

/*
 * derived from dkio.h	4.1	(ULTRIX)	7/2/90
 */

/*
 * dkio.h	6.1	07/29/83
 *
 * Modification history
 *
 * Common structures and definitions for disk drivers and ioctl
 *
 *  6-Mar-86 - ricky palmer
 *
 *	Derived from 4.2BSD labeled: mtio.h	6.1	83/07/29.
 *	Moved DKIOCHDR to ioctl.h. V2.0
 *	Added dkop and dkget structures. V2.0
 *
 *  1-May-86 - ricky palmer
 *
 *	Added dkacc structure for bad block replacement effort. V2.0
 *
 */
#define NO_ACCESS -13	/* No access mscp command suport */

/* Structure for DKIOCDOP ioctl - disk operation command */
struct	dkop	{
	short	dk_op;			/* Operations defined below	*/
	daddr_t dk_count;		/* How many of them		*/
};

/* Structure for DKIOCGET ioctl - disk get status command */
struct	dkget	{
	short	dk_type;		/* Type of device defined below */
	short	dk_dsreg;		/* ``drive status'' register	*/
	short	dk_erreg;		/* ``error'' register		*/
	short	dk_resid;		/* Residual count		*/
};

/*	IOCTL DKIOACC opcodes 	*/
#define ACC_SCAN        1
#define ACC_CLEAR       2
#define ACC_REVEC       3
#define ACC_UNPROTECT   4
#define ACC_PRINT       5

/* Structure for DKIOCACC ioctl - disk access command */
struct	dkacc	{
	short	dk_opcode;		/* Operation code for access	*/
	long	dk_lbn;			/* Disk sector number		*/
	long	dk_length;		/* Length of transfer		*/
	unsigned dk_status;		/* Status of operation		*/
	unsigned dk_flags;		/* Status flags			*/
};
