/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	ioasic.h,v $
 * Revision 1.1.3.3  91/12/16  10:50:43  Gary_Dupuis
 * 
 * 	91/12/06	Gary Dupuis
 * 	Added support for Maxine (PERSONAL_DECstation)
 * 	Defined two values; RESERVED_SIR_BITS and RESERVED_SSR_BITS to
 * 	define the SIR and SSR bits not used by the MAXine. This comes
 * 	about because it only has one serial line.
 * 	[91/12/12  09:37:06  Gary_Dupuis]
 * 
 * Revision 1.1.3.2  91/11/20  14:03:04  Hal_Project
 * 	Moved from dec/io/...; pool reorg
 * 	[91/11/18  08:53:38  Donald_Dutile]
 * 
 * Revision 4.2  91/09/19  23:20:58  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: ioasic.h,v $ $Revision: 1.1.3.3 $ (DEC) $Date: 91/12/16 10:50:43 $
 */ 
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */

/*
 * derived from ioasic.h	4.1	(ULTRIX)	8/9/90
 */
/*
 * ioasic.h
 *
 * Modification history
 *
 * 10-May-1991 - Paul Grist
 * 	Made handling of IOASIC base address generic, so other systems
 *	which use the IOASIC, like 3max+, can be easily added.
 *
 * 20-Feb-1990 - pgt (Philip Gapuz Te)
 * 	created file.
 *
 */

/* IOASIC locations using variable offset assigned at cons_init time */


#define  IOC_COMM1_DMA_BASE      (PHYS_TO_K1((scc_ioasic_base) + 0x00040030))
#define  IOC_COMM2_DMA_BASE      (PHYS_TO_K1((scc_ioasic_base) + 0x00040050))
#define  IOC_SSR                 (PHYS_TO_K1((scc_ioasic_base) + 0x00040100))
#define  IOC_SIR                 (PHYS_TO_K1((scc_ioasic_base) + 0x00040110))


#define  SCC_INTR (SIR_COMM1_XINT | SIR_COMM1_RINT | \
		   SIR_COMM1_XERROR | SIR_COMM1_RERROR | \
		   SIR_COMM2_XINT | SIR_COMM2_RINT | \
		   SIR_COMM2_XERROR | SIR_COMM2_RERROR | \
		   SIR_SCC0 | SIR_SCC1)

/* IOASIC System Interrupt Register bits */
#define  SIR_COMM1_XINT      0x80000000
#define  SIR_COMM1_XERROR    0x40000000
#define  SIR_COMM1_RINT      0x20000000
#define  SIR_COMM1_RERROR    0x10000000
#define  SIR_COMM2_XINT      0x08000000
#define  SIR_COMM2_XERROR    0x04000000
#define  SIR_COMM2_RINT      0x02000000
#define  SIR_COMM2_RERROR    0x01000000
#define  SIR_SCC1            0x00000080
#define  SIR_SCC0            0x00000040

/* The following aren't used on MAXine */
#define  RESERVED_SIR_BITS   ( SIR_COMM2_XINT | SIR_COMM2_XERROR | \
                               SIR_COMM2_RINT | SIR_COMM2_RERROR | \
                               SIR_SCC1)

/* IOASIC System Support Register bits */
#define  SSR_COMM1_XEN       0x80000000
#define  SSR_COMM1_REN       0x40000000
#define  SSR_COMM2_XEN       0x20000000
#define  SSR_COMM2_REN       0x10000000
#define  SSR_RESET           0x00000800

/* The following aren't used on MAXine */
#define  RESERVED_SSR_BITS   (SSR_COMM2_XEN | SSR_COMM2_REN)

#define  IOC_RD(reg, var)        (var) = (*(u_long *)(reg))
#define  IOC_WR(reg, var)        *(u_long *)(reg) = (u_long)(var) 

#define  IOC_SET(reg, mask)      {   u_long temp; \
				     IOC_RD((reg), temp); \
				     IOC_WR((reg), temp|(mask)); \
				     }

#define  IOC_CLR(reg, mask)      {   u_long temp; \
				     IOC_RD((reg), temp); \
                                     IOC_WR((reg), temp & ~(mask)); \
				     }

