/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	vba_xvia.h,v $
 * Revision 1.1.2.4  92/06/18  15:11:03  Stuart_Hollander
 * 	tc300 pio mask, highest 4 bits unimplemented in hardware.
 * 	Add defines for new 6U DMA addr scheme.
 * 
 * Revision 1.1.2.3  92/05/20  15:41:18  Stuart_Hollander
 * 	add tc300 fields
 * 	add defines for tc300 version of adapter
 * 
 * Revision 1.1.2.2  92/02/14  13:31:38  Stuart_Hollander
 * 	xvia specific defines collected in one file for
 * 	generic vme interface.
 * 	[92/02/10  22:34:45  Stuart_Hollander]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: vba_xvia.h,v $ $Revision: 1.1.2.4 $ (DEC) $Date: 92/06/18 15:11:03 $
 */

/*
 *
 * Revision History
 *
 *	05-Jun-1991	Mark Parenti (map)
 *		Fix define of DMA mask to reflect 1GB
 *
 *	Above this line is OSF/1
 * ------------------------------------------------------------------------
 *
 *	19-Feb-1991	Mark Parenti (map)
 *		Add define for board revision level.
 *
 *	22-Jan-1991	Mark Parenti (map)
 *		Fix defines for error bit resets.
 *		Add defines for address space selection.
 *		Add define for DMA PMR address space enable.
 *
 *	18-Dec-1990	Mark Parenti (map)
 *		Add new registers.
 *		Remove MVIA support.
 *
 *	12-Oct-1990	Mark Parenti (map)
 *		Use native hardware register sizes when accessing the
 *		registers.
 *		Add some additional VIC registers needed for initialization.
 *
 *	08-Mar-1990	Mark Parenti (map)
 *		Add defines for mapping.
 *
 *      27-Feb-1990     Paul Grist
 *              Added some error masks needed by error handlers
 *
 *	14-Nov-1989	Mark Parenti (map)
 *		Original Version
 */


/* Xvia general definitions	*/

#define	XVIA_NDMAPMR	0x8000		/* Number of DMA PMR's	(32K)	  */
#define	XVIA_N24DMAPMR	(0x800000 >> XVIA_DMAPMR_SHIFT) /* number of A24 DMA PMR's */
#define	XVIA_NBYTE_DMAPMR 0x1000	/* Page size for DMA PMR's(4K)	  */
#define	XVIA_DMAPMR_SHIFT 0xC		/* Shift count for DMA page size  */
#define	XVIA_INT_VEC	0x0000FFFC	/* Mask for interrupt vector	  */
#define	XVIA_INT_IPL	0x000F0000	/* Mask for interrupt ipl	  */
#define	XVIA_PIO_BASE_OFF 0x00080000	/* Offset for base of PIO space	  */

#define	VBA_ADPT_VEC	0x01	/* VME Interrupt vector for adapter use	*/
#define	NVME_VECS	0x100	/* Number of VME vectors		*/
#define	VME_VEC_SIZE	0x4	/* Size of a scb entry (32-bits)	*/

#define	VME_A24_VALID	0x800000 /* Lowest valid A24 csr		*/
#define	VME_A32_VALID	0x80000000 /* Lowest valid A32 csr		*/

#define	Xviaregs	((struct xvia_regs *)(vhp->adapt_regs))
#define	Xviavars	((struct xvia_vars *)(vhp->adapt_vars))

#define	VBAMSIZ		200	/* size of VME addrs space resource map */
#define	VME_DMASIZ	100	/* size of DMA resource map */
#define	VME_PIOSIZ	100	/* size of PIO resource map */

/* adapter specific struct */
struct xvia_vars {
#define	VME_NMAPS 3			/* 3 VME Address spaces		*/
	struct	map *vba_map[VME_NMAPS]; /* VME Address Space maps	*/
	struct	map *dma_map[VME_NMAPS]; /* VME DMA PMR maps		*/
	struct	map *pio_map;		/* VME PIO PMR map		*/
	caddr_t pio_base;		/* base of PIO mapped space */
};

struct	xviadata {
	int		vme_brl;
	unsigned int	arb_to;
	int		arb_type;
	int		intr_mask;
	int		syscon;
	int		release;
	int		asc;
	unsigned long	tc300_ss;	/* 64kb register region base */
	unsigned long	tc300_tt;	/* A32 DMA 16M addr region base */
};

	/* vbadata.asc field definitions */
#define XVIA_VME_MAP_LOW	0	/* DMA to low half of DMA space */
#define XVIA_VME_MAP_HIGH	1	/* DMA to upper half of DMA space */
#define XVIA_VME_MAP_MULT	2	/* DMA to multiple */

#define _3VIA_VEC_ADDR(vhp, vector) \
	((((struct gen_bus_adapt *)vhp)->intr_vec)+(vector))

	/* Page shift for xvia adapter page size */
#define XVIA_PAGE_SHIFT	12
#define XVIA_BTOP(x) (((unsigned)(x)) >> XVIA_PAGE_SHIFT)


/*	3VIA Registers	*/

struct xvia_regs {
	volatile unsigned int	*csr;	/* device/configuration reg */
	volatile unsigned int	*vfadr; /* vme failing address register */
	volatile unsigned int	*cfadr; /* cpu failing address register */
	volatile unsigned int	*ior;	/* interrupt offset register	*/
	volatile unsigned char  *besr;  /* bus error status register */
	volatile unsigned char	*icr;	/* interrupt control registers 	*/
	volatile unsigned char	*errgi; /* error group int ctrl reg 	*/
	volatile unsigned char	*lvb;	/* local vector base register  	*/
	volatile unsigned char	*err;	/* error vector register    	*/
	volatile unsigned int	*viacsr; /*xVIA command/status register */
	volatile unsigned int	*viaclr; /*xVIA status/clear register */
	volatile unsigned short	*ivs;	/* interrupt vector source	*/
	volatile unsigned char	*arcr;	/* arbiter/requester config register */
	volatile unsigned char	*ttr;	/* transfer timeout register    */
	volatile unsigned char	*rcr;	/* release control register	*/
	volatile unsigned char	*licr;	/* local intr control registers	*/
	volatile unsigned char	*lbtr;	/* local bus timing register 	*/
	volatile unsigned char	*icfr;	/* interface config register	*/
	volatile unsigned char	*amsr;	/* address modifier source reg 	*/
	volatile unsigned char  *s0c0;  /* slave sel 0 control reg 0	*/
	volatile unsigned char  *s0c1;  /* slave sel 0 control reg 1	*/
	volatile unsigned char  *s1c0;  /* slave sel 1 control reg 0	*/
	volatile unsigned char  *s1c1;  /* slave sel 1 control reg 1	*/
	volatile unsigned int	(*pio_pmr)[];	/* PIO PMR's		    */
	volatile unsigned int	(*dma_pmr)[];	/* DMA PMR's		    */
};

/* XVIA Register Offsets		*/

/* 3VIA Offsets				*/
#define	CSR_XVIA_OFF	0x00040000
#define	VFADR_XVIA_OFF	0x00040004
#define	CFADR_XVIA_OFF	0x00040008
#define	IOR_XVIA_OFF	0x0004000C
#define	BESR_XVIA_OFF	0x000440B8
#define	ICR_XVIA_OFF	0x00044004
#define	ERRGI_XVIA_OFF	0x00044048
#define	LVB_XVIA_OFF	0x00044054
#define	ERR_XVIA_OFF	0x00044058
#define	VIACSR_XVIA_OFF	0x00049000
#define VIACLR_XVIA_OFF 0x0004a000
#define	IVS_XVIA_OFF	0x00048004
#define	ARCR_XVIA_OFF	0x000440B0
#define	TTR_XVIA_OFF	0x000440A0
#define	RCR_XVIA_OFF	0x000440D0
#define	LICR_XVIA_OFF	0x00044024
#define	LBTR_XVIA_OFF	0x000440A4
#define	ICFR_XVIA_OFF	0x000440AC
#define	AMSR_XVIA_OFF	0x000440B4
#define S0C0_XVIA_OFF	0x000440C0
#define S0C1_XVIA_OFF	0x000440C4
#define S1C0_XVIA_OFF	0x000440C8
#define S1C1_XVIA_OFF	0x000440CC
#define	PIOPMR_XVIA_OFF	0x00050000
#define	DMAPMR_XVIA_OFF	0x00060000


/* XVIA Register Definitions		*/

/* CSR - Command/Status Register	*/

#define	CSR_DMA		0x00001000	/* DMA Pagesize (1 = 4K, 0 = 512)*/
#define	CSR_SEL_UDMA	0x00000800	/* Enable Upper DMA space	*/
#define	CSR_SEL_LDMA	0x00000400	/* Enable Lower DMA space	*/
#define	CSR_SEL_A24UDMA	0x01000000	/* A24, Enable Upper DMA space	*/
#define	CSR_SEL_A32XDMA	0x1E000000	/* A24, Select DMA space	*/
#define	CSR_INT_XACT	0x00000200	/* Perform interlocked xaction (RMW) */
#define CSR_DMA_PMFE	0x00000100	/* DMA Page Map Fault Error	*/
#define	CSR_REV		0x000F0000	/* Board revision		*/
#define	CSR_PIO_PMFE	0x00000080	/* PIO Page Map Fault Error	*/
#define	CSR_YAB_PE	0x00000040	/* YAbus Parity Error		*/
#define	CSR_YAB_XAFE	0x00000020	/* YAbus Transaction Fault Error */
#define	CSR_VME_MFE	0x00000010	/* VMEbus SYSFAIL asserted	*/
#define	CSR_VME_ACLOW	0x00000008	/* VME AC Power Fail		*/
#define	CSR_VME_SYSRST	0x00000004	/* VMEbus SYSRESET asserted	*/
#define	CSR_VME_RESET	0x00000002	/* Reset VMEbus			*/
#define	CSR_MVIB_RST	0x00000001	/* Reset MVIB			*/
#define	CSR_ERR_MSK	( CSR_DMA_PMFE |				\
                        CSR_PIO_PMFE |				\
                        CSR_YAB_PE |				\
                        CSR_YAB_XAFE |				\
                        CSR_VME_MFE )

#define CSR_RESET_ERROR_BITS 0xFFFFFE07     /* used to reset error bits */
#define	CSR_CLR_INT_XACT     0xFFFFFDFF	  /* clear interlocked xaction (RMW) */

/* VIACSR - xVIA Command/Status Register */

#define	VIACSR_ENAB_INT	0x00800000	/* Enable local interrupts	*/
#define	VIACSR_32MB_IO	0x00100000	/* Use 32MB I/O Window size	*/
#define	VIACSR_ENAB_ADP	0x00080000	/* Enable xVIA adapter		*/
#define	VIACSR_3VIA_RST	0x00040000	/* Reset 3VIA			*/
#define	VIACSR_MVIB_RST	0x00020000	/* Reset MVIB			*/
#define	VIACSR_MODEL100	0x00010000	/* Indicates DS5000_100		*/
#define	VIACSR_YAB_FRR	0x00008000	/* YAbus Fail_Request received	*/
#define	VIACSR_YAB_FAIL	0x00004000	/* YAbus Fail_Request sent	*/
#define	VIACSR_YAB_NACK	0x00002000	/* YAbus Nack received		*/
#define	VIACSR_YAB_NCLK	0x00001000	/* No YAbus Receive Clock	*/
#define	VIACSR_YAB_XACT	0x00000800	/* YAbus Xaction error		*/
#define	VIACSR_YAB_TAM	0x00000400	/* YAbus TAM error		*/
#define	VIACSR_YAB_DPE	0x00000200	/* YAbus data parity error	*/
#define	VIACSR_YAB_IDL	0x00000100	/* YAbus idle error		*/
#define	VIACSR_VEC_MASK	0x000000FF	/* xVIA interrupt vector	*/
#define VIACSR_ERR_MSK  0x0000DF00      /* error bits */

/* VIACLR - xVIA Status/Clear Register */

#define VIACLR_CLR_ALL 0x0000FF00	/* clear all error bits */

/* DRRF - Device Revision Register	*/

#define	DRRF_REV	0x0000000F	/* Device Hardware Revision	*/



/* BER - Bus Error Register (VIC)	*/

#define BER_LBERR	0x00000040	/* Local Bus Error		*/
#define BER_VMEBERR	0x00000020	/* VMEbus Error			*/
#define	BER_VMETO	0x00000010	/* VMEbus Time Out		*/
#define	BER_LBTO	0x00000008	/* Local Bus Time Out		*/
#define	BER_SLFACC0	0x00000004	/* Self Access while Master(SLSEL0)*/
#define	BER_SLFACC1	0x00000002	/* Self Access while Master(SLSEL1)*/
#define	BER_LBTO_VME	0x00000001	/* Local Bus timeout during VME acc */
#define	BER_ERR_MSK	( BER_LBERR |				\
                          BER_VMEBERR |				\
                          BER_VMETO |				\
                          BER_LBTO |				\
			  BER_SLFACC0 |                         \
			  BER_SLFACC1 |                         \
                          BER_LBTO_VME )

/* ICR -  Interrupt Control Register (VIC) */

#define	ICR_ENABLE	0x00000080
#define	ICR_IPL_2	0x00000002

/* LICR - Local Interrupt Control Register (VIC) */

#define LICR_EDGE	0x00000020
#define LICR_VECTOR	0x00000010
#define LICR_DISABLE  	0x00000080
/* ERRGI -  Interrupt Control Register (VIC) */

#define	ERRGI_ENABLE	0x000000F0

/* VIVS - Interrupt Vector Source	*/

#define	IVS_VEC_MASK	0x000000FF

/* PIOMR - PIO Map Register		*/

#define	XVIA_PIO_VALID	0x00000001	/* PIO Map Register Valid	    */
#define	XVIA_PIO_BSWAP	0x00000006	/* Byte swap mode mask		    */
#define	XVIA_PIO_ASIZE	0x00000030	/* Address size mask		    */
#define	XVIA_PIO_MASK	0xFFFFF000	/* PIO Map Register Entry Mask	    */
#define	XVIA_PIO_OFFSET 0x00000FFF	/* Offset into 4K page	            */
#define	XVIA_PIO_REGSHFT 12		/* Shift for PIO reg number	    */
#define	XVIA_PIO_ADD_SHIFT 12		/* Shift count for Address/PIO reg  */
#define	XVIA_PIO_FC_SHIFT 10		/* Shift count for Function/PIO reg */
#define	XVIA_PIO_AS_SHIFT 8		/* Shift count for Add Size/PIO reg */
#define	XVIA_PIO_BS_SHIFT 1		/* Shift count for Byte Swap/PIO reg */
#define	XVIA_PIO_DL_SHIFT 3		/* Shift count for Data Len/PIO reg */
#define	_3VIA_NPIOPMR 	0x400		/* Number of PIO PMR's 3VIA(1K)	    */
#define	_3VIA_PLUS_NPIOPMR	0x2000	/* Number of PIO PMR's 3VIA+(8K)    */
#define	XVIA_NBYTE_PIOPMR 0x1000	/* Number of bytes per PIO PMR(4K) */

/* PIO Function Codes			*/

#define	XVIA_PIO_UDAT	0x00		/* User Data			*/
#define	XVIA_PIO_UPROG	0x01		/* User Program			*/
#define	XVIA_PIO_SDAT	0x02		/* Supervisor Data		*/
#define	XVIA_PIO_SPROG	0x03		/* Supervisor Program		*/

/* PIO Address Size Codes		*/

#define	XVIA_PIO_A16	0x02		/* A16 Address Space		*/
#define	XVIA_PIO_A24	0x03		/* A24 Address Space		*/
#define	XVIA_PIO_A32	0x01		/* A32 Address Space		*/

/* DMA_PMR - DMA Map Register		*/

#define	XVIA_DMA_VALID	0x00000001	/* Map Register Valid		    */
#define	XVIA_DMA_SU	0x00000060	/* Allow both user and supervisor   */
#define	XVIA_DMA_ADD_SHIFT 12		/* Shift count for Address/DMA reg  */
#define	XVIA_DMA_BS_SHIFT 1		/* Shift count for Byte Swap/DMA reg */
#define	XVIA_DMA_2432	0x00000018	/* Enable 24 and 32-bit DMA access  */
#define	XVIA_DMA_UDMA	0x40000000	/* Select 2nd GB for PMR mapping    */
#define	XVIA_DMA_MASK	0xC0000000	/* Mask off upper bits, A32/2 regions */
#define	XVIA_DMA_MASK_A32 0xF8000000	/* Mask off upper bits, A32/16 regions */
#define	XVIA_DMA_MASK_A24 0xFFC00000	/* Mask off upper bits, A24/2 regions */


/* IMR - Interrupt Mask Register	*/

#define	IMR_PMRPE	0x00100000	/* Interrupt on Page Map Read Parity */
                                        /* Error			     */
#define	IMR_PMBFE	0x00080000	/* Interrupt on Page Map Fault Error */
#define	IMR_PMFE	0x00040000	/* Interrupt on PIO Map Fault Error  */
#define	IMR_IB_PE	0x00000800	/* Interrupt on IBUS Parity Error    */
#define	IMR_IB_TRFE	0x00000400	/* Interrupt on IBUS Transaction     */
                                        /* Fault Error			     */
#define	IMR_VME_MF	0x00000400	/* Interrupt on VME Module Failure   */
#define	IMR_VME_SYSRST	0x00000200	/* Interrupt on VME System Reset     */
#define	IMR_VME_AC_LOW	0x00000100	/* Interrupt on VME AC Low	     */

/* ARCR	- Arbiter/Requester Configuration Register	*/

#define	ARCR_BR_SHIFT	5		/* Shift of BR level from vbadata    */
                                        /* structure to arcr register        */

/* TTR	- Transfer Timeout Register			*/

#define	TTR_VMETO_SHIFT	5      		/* Shift of VMEbus timeout value from*/
                                        /* vbadata structure to ttr register */
#define	TTR_LBTO_SHIFT	2      		/* Shift of localbus timeout value   */
                                        /* from vbadata structure to ttr     */
                                        /* register.			     */


/*	TC300 Registers	*/

typedef struct tc300_regs {
	volatile unsigned int	*tc_map;  /* COMMENT */
	volatile unsigned int	*tc_csr;      /* */
	volatile unsigned int	*tc_interrupt;/* */
	volatile unsigned int	*vme_map;    /* */
	volatile unsigned int	*vme_csr0;    /* */
	volatile unsigned int	*vme_csr1;    /* */
	volatile unsigned int	*vme_csr2;    /* */
	volatile unsigned int	*vme_csr3;    /* */
	volatile unsigned int	*vme_int_ack;    /* */
	volatile unsigned int	*vme_reset;    /* */
}TC300REGPTRS;

/* TC300 Register Offsets		*/
#define TC_MAP__TC300_OFF	0x020000
#define TC_CSR__TC300_OFF	0x021000
#define INTERRUPT__TC300_OFF	0x022000
#define VME_MAP__TC300_OFF	0x023000
#define VME_CSR0__TC300_OFF	0x027000
#define VME_CSR1__TC300_OFF	0x027004
#define VME_CSR2__TC300_OFF	0x027008
#define VME_CSR3__TC300_OFF	0x02700C
#define VME_INT_ACK__TC300_OFF	0x02B000
#define VME_RESET__TC300_OFF	0x02C000
	/* LAST__TC300_OFF is any address in the last reserved 4K page */
#define VME_LAST__TC300_OFF	0x02CFFF

/* TURBOchannel Side CSR - Command/Status Register  (rw) */

#define TC300_CSR_TEST	0x00000040	/* diagnostic mode */
#define TC300_CSR_RESET	0x00000020	/* Resets link and TC side controller.
					   Causes interrupt. */
#define TC300_CSR_ERROR	0x00000010	/* Error.  Causes interrupt. (w1toclr)*/
#define TC300_CSR_INTR	0x00000008	/* Interrupt asserted. (w1toclr) */
#define TC300_CSR_FIFO_FULL 0x00000002	/* Inbound FIFO is full.
					   Should never happen.  (read-only)
					   Causes interrupt. */
#define TC300_CSR_VIOLATION 0x00000001	/* Encoding violation over bus link
					   seen by TC side.  Cable disconnect
					   will set bit.  */
/* TURBOchannel Side Interrupt Register
   A write to this register causes a TC side interrupt.
   A read from this register is formatted to have bits
	TC_CSR_TEST TC_CSR_RESET TC_CSR_ERROR TC_CSR_INTR as in TC_CSR above,
   plus INT_BUS_ID field.  */

#define TC300_INT_BUS_ID		0x00000007 /* identifies module as TC portion
					      of bus link. (ro) */
#define TC300_INT_BUS_ID_VALUE	0x00000004 /* expected value of INT_BUS_ID */

/* VME Side CSR0 */
#define TC300_CSR0_INT_ENABLE	0x08	/* Enable Send Interrupts VME to TC */
#define TC300_CSR0_BUS_TYPE	0x07	/* Bus Type Mask.  ro */
#define TC300_CSR0_BUS_TYPE_VALUE	0x02	/* Bus Type Mask expected value.
				  Identifies module as VME side of link. */
#define TC300_CSR0_RESET_MODULE	0x01	/* reset vme module, but not VMEbus */

/* VME Side CSR1 */
#define TC300_CSR1_DEADLOCK			0x80 /* deadlock over bus link */
#define TC300_CSR1_PARITY_ERROR		0x40 /* parity error over bus link */
#define TC300_CSR1_ENABE_TIMEOUT		0x20 /* enable BERR on timeout on VME */
#define TC300_CSR1_ENABLE_SERIAL_PARITY	0x10 /* check parity on link */
#define TC300_CSR1_ENABLE_DEADLOCK_KILL	0x08 /* assert BERR on VME deadlock */
				             /* (doc says set to zero.) */
#define TC300_CSR1_ENABLE_REMOTE_BUS_ADDR	0x04 /* enable response to VME xactions */
#define TC300_CSR1_RESET_TC			0x02
				     /* causes TC side to set RESET bit */
				     /* in its CSR and request TC interrupt */
#define TC300_CSR1_LOCAL_VECTOR_ENABLE	0x01
				     /* MBZ, (vector src is VME side jumpers)*/

/* VME Side CSR3 */
#define TC300_CSR3_INT_MASK 0xfe	/* Bits 1 to 7 correspond with int levels. */

/* PIOMR - PIO Map Register		*/

#define	 TC300_PIO_SWAP		    0x80000000	/* PIO Map Register Valid  */
#define	 TC300_PIO_ADDR_SPACE_MSK   0x70000000	/* Address space mask	   */
#define   TC300_SPC_0		    0x00000000
#define   TC300_SPC_1		    0x10000000
#define   TC300_SPC_2		    0x20000000
#define   TC300_SPC_3		    0x30000000
#define   TC300_SPC_STANDARD_USER_DATA    TC300_SPC_0
#define   TC300_SPC_SHORT_USER_DATA_PROG  TC300_SPC_1
#define   TC300_SPC_EXTENDED_USER_DATA    TC300_SPC_2
#define   TC300_SPC_STANDARD_USER_PROG    TC300_SPC_3
#define   TC300_SPC_INTR_ACK	    0x40000000
#define   TC300_SPC_BUS_CTRL_REG    0x50000000
#define   TC300_SPC_VME_RESET	    0x60000000
#define   TC300_SPC_INVALID_ENTRY   0x70000000

#define	 TC300_PIO_MASK	0x000FFFFF	/* PIO Map Register Entry Mask	   */
#define	 TC300_PIO_OFFSET 0x00000FFF	/* Offset into 4K page	           */
#define	 TC300_PIO_REGSHFT 12		/* Shift for PIO reg number	   */
#define	 TC300_PIO_ADD_SHIFT 12		/* Shift count for Address/PIO reg */
#define	 TC300_NPIOPMR 	0x400		/* Number of PIO PMR's TC300(1K)   */
#define	 TC300_NBYTE_PIOPMR 0x1000	/* Number of bytes per PIO PMR(4K) */


/* DMA_PMR - DMA Map Register		*/

#define	 TC300_DMA_VALID	0x00000008	/* Map Register Valid	    */
#define	 TC300_DMA_BLOCK	0x00000002	/* use block mode           */
#define	 TC300_DMA_WRQUE	0x00000001	/* Use write queueing       */
#define	 TC300_DMA_ADD_SHIFT 4		/* Shift count for Address/DMA reg  */
#define	 TC300_DMA_BS_SHIFT 22		/* Shift count for Byte Swap/DMA reg */
			/* Note that TC300 byte swapping for Bytes and Words
			   are reverse of the defines in vbareg.h */
#define  TC300_DMA_BS_NONE 0
#define  TC300_DMA_BS_WORDS 1	/* Swap words in longwords */
#define  TC300_DMA_BS_BYTES 2	/* Swap bytes in words */
#define  TC300_DMA_BYTES_AND_WORDS 3	/* Swap bytes in words and
					   words in longwords */
#define  TC300_DMA_USED_MASK 0x00ffffff /* which bits are used */


/*  TC300 general definitions	*/

#define	 TC300_NDMAPMR	0x1000		/* Number of DMA PMR's	(4K)	  */
#define	 TC300_N24DMAPMR (0x800000 >> TC300_DMAPMR_SHIFT) /* number of A24 DMA PMR's */
#define	 TC300_NBYTE_DMAPMR 0x1000	/* Page size for DMA PMR's(4K)	  */
#define	 TC300_DMAPMR_SHIFT 0xC		/* Shift count for DMA page size  */

#define	Tc300regs	((struct tc300_regs *)(vhp->adapt_regs))
#define	Tc300vars	((struct tc300_vars *)(vhp->adapt_vars))

/* adapter specific struct */
struct tc300_vars {
	struct	map *vba_map[VME_NMAPS]; /* VME Address Space maps	*/
	struct	map *dma_map[VME_NMAPS]; /* VME DMA PMR maps		*/
	struct	map *pio_map;		/* VME PIO PMR map		*/
	caddr_t pio_base;		/* base of PIO mapped space */
};

struct	tc300data {
	int		vme_brl;
	unsigned int	arb_to;
	int		arb_type;
	int		intr_mask;
	int		syscon;
	int		release;
	int		asc;
	unsigned long	tc300_ss;	/* 64kb register region base */
	unsigned long	tc300_tt;	/* A32 DMA 16M addr region base */
};

#define _TC300_VEC_ADDR(vhp, vector) \
	((((struct gen_bus_adapt *)vhp)->intr_vec)+(vector))

	/* Page shift for xvia adapter page size */
#define TC300_PAGE_SHIFT	12
#define TC300_BTOP(x) (((unsigned)(x)) >> TC300_PAGE_SHIFT)


