/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	i2c.h,v $
 * Revision 1.1.3.2  91/11/20  14:07:51  Hal_Project
 * 	Moved from dec/io/...; pool reorg
 * 	[91/11/18  08:57:06  Donald_Dutile]
 * 
 * Revision 4.2  91/09/19  23:22:30  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: i2c.h,v $ $Revision: 1.1.3.2 $ (DEC) $Date: 91/11/20 14:07:51 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
/*
 *	i2c.h:	Definitions associated with the I2C bus and its peripherals.
 */

#ifndef i2c_DEFINED
#define i2c_DEFINED 1

/*
 *
 *	I2C control bits and access macros:
 *
 */
#define I2C_CLOCK_OFF           (u_int)0xBF
#define I2C_CLOCK_OFF_DATA_ZERO (u_int)0x3F
#define I2C_CLOCK_ON            (u_int)0x40
#define I2C_CLOCK_ON_DATA_ONE   (u_int)0xC0
#define I2C_DATA_ONE            (u_int)0x80
#define I2C_DATA_ZERO           (u_int)0x7F

#define I2C_CLOCK_DELAY i2c_clock_delay()
#define I2C_DATA_DELAY i2c_data_delay()

#define I2C_CLOCK_DATA_LOW  {*port &= I2C_CLOCK_OFF_DATA_ZERO; I2C_CLOCK_DELAY;}
#define I2C_CLOCK_DATA_HIGH {*port |= I2C_CLOCK_ON_DATA_ONE; I2C_CLOCK_DELAY;}
#define I2C_CLOCK_LOW       {*port &= I2C_CLOCK_OFF; I2C_CLOCK_DELAY;}
#define I2C_CLOCK_HIGH      {*port |= I2C_CLOCK_ON; I2C_CLOCK_DELAY;}
#define I2C_DATA_LOW        {*port &= I2C_DATA_ZERO; I2C_DATA_DELAY;}
#define I2C_DATA_HIGH       {*port |= I2C_DATA_ONE; I2C_DATA_DELAY;}

#define I2C_READ_BIT        (u_int)0x01
 
/*
 *
 *	Definitions associated with the Phillips Digital Color Space Convertor(DCSC).
 *
 */
#define I2C_ADDR_DCSC          0xE0		/* Address of DCSC chip. */
#define I2C_SUBA_DCSC_CONTROL  0x00		/* Subaddress of DCSC control register. */
#define I2C_SUBA_DCSC_DATA     0x01		/* Subaddress of DCSC lut data register. */

/*
 *	Control register (subaddress 0) bit definitions:
 */
#define DCSC_VLUT_READ_ENABLED                0x40
#define DCSC_VLUT_WRITE_ENABLED 			  0x00
#define DCSC_VLUT_OUTPUT_DATA_TRISTATED_BY_OE 0x20
#define DCSC_VLUT_OUTPUT_DATA_TRISTATED       0x00
#define DCSC_INPUT_DATA_TO_FORMATTER          0x10
#define DCSC_INPUT_DATA_AT_FIXED_VALUES       0x00
#define DCSC_MATRIX_IN_USE                    0x08
#define DCSC_MATRIX_BYPASSED                  0x00
#define DCSC_INPUT_FORMATTER_TO_FORMAT_1      0x00
#define DCSC_INPUT_FORMATTER_TO_FORMAT_2      0x01
#define DCSC_INPUT_FORMATTER_TO_FORMAT_3      0x02
#define DCSC_INPUT_FORMATTER_TO_FORMAT_4      0x03
#define DCSC_INPUT_FORMATTER_TO_FORMAT_5      0x04

#define DCSC_LOAD_LUT (DCSC_VLUT_WRITE_ENABLED | \
                             DCSC_VLUT_OUTPUT_DATA_TRISTATED_BY_OE | \
                             DCSC_INPUT_DATA_TO_FORMATTER | \
                             DCSC_MATRIX_IN_USE | \
                             DCSC_INPUT_FORMATTER_TO_FORMAT_3 )

#define DCSC_COMPOSITE_LUT  (DCSC_VLUT_READ_ENABLED | \
                             DCSC_VLUT_OUTPUT_DATA_TRISTATED_BY_OE | \
                             DCSC_INPUT_DATA_TO_FORMATTER | \
                             DCSC_MATRIX_IN_USE | \
                             DCSC_INPUT_FORMATTER_TO_FORMAT_3)

#define DCSC_S_VIDEO_LUT    (DCSC_VLUT_READ_ENABLED | \
                             DCSC_VLUT_OUTPUT_DATA_TRISTATED_BY_OE | \
                             DCSC_INPUT_DATA_TO_FORMATTER | \
                             DCSC_MATRIX_IN_USE | \
                             DCSC_INPUT_FORMATTER_TO_FORMAT_3)

#define DCSC_RGB_LUT        (DCSC_VLUT_READ_ENABLED | \
                             DCSC_VLUT_OUTPUT_DATA_TRISTATED_BY_OE | \
                             DCSC_INPUT_DATA_TO_FORMATTER | \
                             DCSC_MATRIX_BYPASSED | \
                             DCSC_INPUT_FORMATTER_TO_FORMAT_4)

/*
 *
 *	Definitions associated with the Phillips Digital Multi-Signal Decoder (DMSD).
 * 
 */
#define I2C_ADDR_DMSD	0x8A	/* Address of DMSD chip. */

#endif /* !i2c_DEFINED */
