/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	pvres.h,v $
 * Revision 4.2  91/09/19  22:32:43  devbld
 * Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: pvres.h,v $ $Revision: 4.2 $ (DEC) $Date: 91/09/19 22:32:43 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */

#ifndef _PVRES_H_
#define _PVRES_H_

/*
 *	Physical Volume Reserve Area Definitions.
 */

#include <sys/types.h>
#include <lvm/lvm.h>

/*
 * Layout of the LVM record in the physical volume reserved area.  In the
 * following structure all lengths are in DEV_BSIZE units.  All PSNs are in
 * DEV_BSIZE units.  pxsize and pxspace are in bytes.
 */
struct lv_lvmrec {
	char		lvm_id[8];	/* Should be LVMRECXX.		*/
	lv_uniqueID_t	pv_id;		/* The physical volume ID.	*/
	lv_uniqueID_t	vg_id;		/* The volume group ID.		*/
	ulong_t		last_psn;	/* Last physical sector number.	*/
	ulong_t		pv_num;		/* Physical Volume Number in VG */
	ulong_t		vgra_len;	/* Length of the VGRA.		*/
	ulong_t		vgra_psn;	/* PSN of the VGRA.		*/
	ulong_t		vgda_len;	/* Length of the VGDA.		*/
	ulong_t		vgsa_len;	/* Length of the VGSA.		*/
	ulong_t		vgda_psn1;	/* PSN of the primary VGDA.	*/
	ulong_t		vgda_psn2;	/* PSN of the secondary VGDA.	*/
	ulong_t		mcr_len;	/* Length of the mirror		*/
					/*    consistency record (MCR).	*/
	ulong_t		mcr_psn1;	/* PSN of the primary MCR.	*/
	ulong_t		mcr_psn2;	/* PSN of the secondary MCR.	*/
	ulong_t		data_len;	/* Length of the user data.	*/
	ulong_t		data_psn;	/* The start of the user data.	*/
	ulong_t		pxsize;		/* Size of each physical extent.*/
	ulong_t		pxspace;	/* Size of physical space.	*/
	ulong_t		altpool_len;	/* Alternate block pool length. */
	ulong_t		altpool_psn;	/* Alternate block pool start.  */
};
typedef struct lv_lvmrec lv_lvmrec_t;

/*
 * Physical Volume Reserved Area (PVRA) Definitions.
 */
#define	PVRA_SIZE		128	/* Size of the PVRA in sectors.	*/
#define	PVRA_LVM_REC_SN1	8	/* Sector of LVM record.	*/
#define	PVRA_LVM_REC_SN2	72	/* Sector of backup LVM record.	*/
#define	PVRA_BBDIR_SN1		9	/* Sector of bad block dir.	*/
#define	PVRA_BBDIR_SN2		73	/* Sector of backup bad block dir. */
#define	PVRA_BBDIR_LENGTH	55	/* The number of sectors of the bad */
					/* block directory */

#endif  /* _PVRES_H_ */
