/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	s5mount.h,v $
 * Revision 4.2  91/09/19  22:52:09  devbld
 * Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: s5mount.h,v $ $Revision: 4.2 $ (DEC) $Date: 91/09/19 22:52:09 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * 20-aug-1991: vipul patel
 *	OSF/1 Release 1.0.1. s5fsmount size change.
 *	with fields for locks.
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * All rights reserved.
 *

 */

#ifndef _S5_MOUNT_H_
#define	_S5_MOUNT_H_

/*
 * Mount structure.
 * One allocated on every mount.
 * Used to find the super block.
 */

struct	s5fsmount {
	struct	mount *um_mountp;	/* vfs structure for this fs */
	dev_t	um_dev;			/* device mounted */
	struct	vnode *um_devvp;	/* vnode for block device mounted */
	struct	filsys *um_fs;		/* pointer to superblock */
	lock_data_t um_fsflock;		/* lock over superblock free list */
	lock_data_t um_fsilock;		/* lock over superblock inode list */
	char	um_mntname[MNAMELEN];	/* mounted filesystem */
};
#ifdef KERNEL
/*
 * Convert mount ptr to s5fsmount ptr.
 */
#define VFSTOS5FS(mp)	((struct s5fsmount *)((mp)->m_data))

/*
 * mount table
 */
extern struct s5fsmount	s5fs_mounttab[NMOUNT];

#endif	/* KERNEL */

#endif /* _S5_MOUNT_H_ */








