/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	xtiso.h,v $
 * Revision 4.2.2.5  92/06/18  13:57:40  Ajay_Kachrani
 * 	Change max_accept_conn variable to somaxconn for consistency
 * 	[92/06/18  13:54:25  Ajay_Kachrani]
 * 
 * Revision 4.2.2.4  92/05/21  14:34:40  Craig_Peterson
 * 	Changes to support variable size connection queue.
 * 	[92/05/20  14:04:30  Craig_Peterson]
 * 
 * Revision 4.2.2.3  91/12/19  14:06:29  William_Burns
 * 	Merge from ODE/TIN: revision 3.3.9.3
 * 	date: 91/11/14 15:57:27;  author: devrcs;  state: Exp;  lines added/del: 3/3
 * 	sccs rev: 3.6;  orig date: 91/11/06 08:12:14;  orig author: fred
 * 	Fred Canter - fix wrong keywords (had .c file keywords).
 * 	[91/12/19  10:28:05  William_Burns]
 * 
 * Revision 4.2.2.2  91/12/18  21:48:12  William_Burns
 * 	Merge from ODE/TIN: revision 3.3.9.2
 * 	date: 91/11/14 15:39:28;  author: devrcs;  state: Exp;  lines added/del: 4/5
 * 	sccs rev: 3.5;  orig date: 91/11/04 14:12:29;  orig author: kachrani
 * 	Put back sccs header
 * 	[91/12/04  09:52:07  William_Burns]
 * 
 * Revision 4.2  91/09/19  22:56:08  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: xtiso.h,v $ $Revision: 4.2.2.5 $ (DEC) $Date: 92/06/18 13:57:40 $
 */ 
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */

#ifndef _XTISO_H
#define _XTISO_H

#include <streamsm/xtiso_config.h>	/* struct xti_proto ...	*/

/* 
 * Connection Indication Structure
 */
struct xtiseq { 
	long    seq_no;			/* sequence number		*/
	int     seq_used;		/* used or not?			*/
	struct  socket *seq_so;		/* associated socket		*/
};

/* Statically defined */
#define XTI_MAXOPENS	(minor(~0) + 1)	/* XXX */

/*
 * XTI-Socket Control Block
 */
struct xticb {
	int	 xti_state;		/* state of transport provider	*/
	long	 xti_flags;		/* internal flags, see below	*/
	dev_t    xti_minor;             /* minor device # 		*/

	struct   socket   *xti_so;	/* corresponding socket		*/
	int	 xti_sostate;		/* safe state of socket		*/
	int	 xti_soerror;		/* safe socket error		*/
	long	 xti_sorcount;		/* safe read-count of socket	*/
	long	 xti_sowspace;		/* safe write-space of socket	*/
	int	 xti_sosnap;		/* async state of socket	*/

	struct   socket   *xti_lso;	/* "saved" listening socket	*/

	/* We're setting this up so we can vary the size of the queue through
	   changing a variable in the kernel -- somaxconn.
	   Craig Peterson */

	int	 xti_maxqlen;
	struct   xtiseq    *xti_seq;		
					/* outstanding conn ind seq #s	*/
	short	 xti_qlen;		/* # of conn ind. allowed	*/
        short	 xti_cindno;		/* # of outstanding conn ind	*/

	int 	 xti_seqcnt;		/* sequence counter 		*/
        int	 xti_pendind;		/* pending indication		*/
	long     xti_tsdu;
	long     xti_etsdu;

	queue_t  *xti_rq;		/* stream read queue ptr	*/
	queue_t  *xti_wq;		/* stream write queue ptr	*/

	mblk_t   *xti_wdata;		/* pending write-side data	*/
	struct   mbuf *xti_wnam;	/* destination addr of unitdata	*/
	mblk_t   *xti_wexdata;		/* pending write-side exdata	*/

	struct   mbuf *xti_rdata;	/* pending read-side data	*/
	int      xti_rflags;		/* pending read-side flags	*/
	struct   mbuf *xti_rexdata;	/* pending read-side exdata	*/
	int      xti_rexflags;		/* pending read-side exflags	*/

	struct   xtisocfg *xti_cfg;	/* link back to cfg head	*/
#define	xti_proto xti_cfg->xti_cfgproto	/* xtiproto for xticb		*/
	/* Following list handy for weeding all connections */
	struct   xtilist { struct xticb *xti_next, *xti_prev; } xti_list;
};

/*
 * XTI configuration block.
 */
struct xtisocfg {
	dev_t 			xti_cfgmajor;	/* major device # 	*/
	int			xti_cfgnopen;	/* # of current opens	*/
	u_char	xti_cfgminor[XTI_MAXOPENS/8];	/* allocated minor devs	*/
	struct	xtilist		xti_cfglist;	/* handy list of cb's	*/
	struct	xtiproto	xti_cfgproto;	/* protocol information	*/
	struct	xtisocfg *	xti_cfgnext;	/* more config structs	*/
	decl_simple_lock_data(,xti_cfglock)	/* protects struct	*/
};

/*
 * Socket types
 */
#define XTI_NEWSOCK     1		/* New Socket, open		*/
#define XTI_NOSOCK	2		/* Socket disabled, no close 	*/
#define XTI_CLOSESOCK	3		/* Close indicator 		*/

/* 
 * Internal XTI Flags
 */
#define XTI_ACTIVE	0x0001		/* if set, this xticb is in use */
#define XTI_FATAL	0x0002          /* fatal condition occurred     */
#define XTI_DISCONMAIN  0x0004          /* disconnect the main conn.    */
#define XTI_MOREDATA	0x0010          /* more data expected from TU   */
#define XTI_MOREEXDATA	0x0020		/* more exdata expected from TU	*/
#define XTI_INBUF       0x0040          /* bufcall active on read side  */
#define XTI_FLOW	0x0100		/* flow control on output       */
#define XTI_OUTBUF      0x0200          /* bufcall active on write side */

/* 
 * State for connection indications
 */
#define	XTIS_AVAILABLE	0		/* Available			*/
#define XTIS_AWAITING	1		/* Awaiting acceptance		*/
#define XTIS_ACTIVE	2		/* Connected/accepted		*/
#define XTIS_LOST	3		/* Connection lost before accept*/

/*
 * Disconnect reason codes
 */
#define XTID_TPINIT		1  /* Initiated by transport provider    */
#define XTID_REMWITHDRAW	2  /* Connect req withdrawn by remote    */
#define XTID_REMREJECT  	3  /* Connect req rejected by remote     */
#define XTID_REMINIT		4  /* Disconnect req Initiated by remote */

/*
 * UDERR IND error types
 */
#define XTIU_BADOPTSZ		1  /* Initiated by transport provider    */
#define XTIU_BADMSGSZ		2  /* Connect req withdrawn by remote    */
#define XTIU_NOOPT		1  /* UDP Option not supported           */

#define XTI_INFO_ID	5010	/* module/driver ID */

#define XTI_INIT_HI	4096	/* hi-water mark, flow control on queue */
#define XTI_INIT_LO	1024	/* lo-water mark, flow control on queue */

/* Glue for union T_primitives for now */
#define	tbindack	bind_ack
#define	tbindreq	bind_req
#define	tconncon	conn_con
#define	tconnind	conn_ind
#define	tconnreq	conn_req
#define	tconnres	conn_res
#define	tdataind	data_ind
#define	tdatareq	data_req
#define	tdisconind	discon_ind
#define	tdisconreq	discon_req
#define	texdataind	exdata_ind
#define	texdatareq	exdata_req
#define	terrorack	error_ack
#define	tinfoack	info_ack
#define	tinforeq	info_req
#define	tokack		ok_ack
#define	toptmgmtack	optmgmt_ack
#define	toptmgmtreq	optmgmt_req
#define	tordrelind	ordrel_ind
#define	tordrelreq	ordrel_req
#define	tunbindreq	unbind_req
#define	tuderrorind	uderror_ind
#define	tunitdataind	unitdata_ind
#define	tunitdatareq	unitdata_req

/*
 * Debugging
 */
#include <streams_debug.h>

#ifdef	STREAMS_DEBUG
#define XTIDEBUG	1	/* Not quite, but handy */
#else
#define XTIDEBUG	0
#endif

#if	XTIDEBUG

/*
 * Internal DEBUG flags
 */
#define XTIF_ALL	(~0)
#define XTIF_CONFIGURE	0x00000001	/* configuration  		*/
#define XTIF_OPEN	0x00000002	/* open routine  		*/
#define XTIF_WPUT	0x00000004	/* write put routine 		*/
#define XTIF_MISC	0x00000008	/* miscellaneous trace 		*/
#define XTIF_WSRV	0x00000010	/* write service routine	*/
#define XTIF_OUTPUT	0x00000020	/* xti output routine		*/
#define XTIF_INPUT	0x00000040	/* xti input routine		*/
#define XTIF_EVENTS	0x00000080	/* socket event tracing		*/
#define XTIF_INFO	0x00000100	/* info request			*/
#define XTIF_BINDING	0x00000200	/* binding-related tracing	*/
#define XTIF_CONNECT	0x00000400	/* connect/disconnect trace	*/
#define XTIF_DATA	0x00000800	/* data xfer trace		*/
#define XTIF_SEND	0x00001000	/* xti send routine trace	*/
#define XTIF_RECV	0x00002000	/* xti receive routine trace 	*/
#define XTIF_CLOSE	0x00004000	/* close-related trace		*/
#define XTIF_ERRORS	0x00008000	/* stream error trace		*/
#define XTIF_SOCKET	0x00010000	/* socket misc			*/
#define XTIF_CHECKPOINT	0x00020000	/* routine entry trace		*/
#define XTIF_SEND_FLOW	0x00040000	/* send flow control trace	*/
#define XTIF_STRLOG	0x00080000	/* enable strlog trace		*/
#define XTIF_BREAK	0x40000000	/* enable debugger on "panic"	*/
#define XTIF_PANIC	0x80000000	/* enable "real" panic		*/

extern int xtiDEBUG;

#define PUTNEXT(q,mp)	xti_putnext((q),(mp))
#define XTITRACE(f,v)	do { if (xtiDEBUG & (f)) { v } } while (0)
#define CHECKPOINT(v)	XTITRACE(XTIF_CHECKPOINT, \
			 printf( "\n xtiso: ========>> entered %s()...\n",(v));)

#else	/* !XTIDEBUG */

#define PUTNEXT(q,mp)	putnext((q),(mp))
#define XTITRACE(f,v)
#define CHECKPOINT(v)

#endif	/* !XTIDEBUG */

#endif /* _XTISO_H */
