/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	utsname.h,v $
 * Revision 4.2.2.2  92/03/27  15:16:48  Craig_Horman
 * 	Merge with AG
 * 	[92/03/27  13:45:09  Craig_Horman]
 * 
 * 	Merge with BL5
 * 	[92/03/10  12:35:45  Craig_Horman]
 * 
 * 	Added C++ Support
 * 	[92/02/26  18:57:51  Craig_Horman]
 * 
 * Revision 4.2  91/09/19  23:02:52  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: utsname.h,v $ $Revision: 4.2.2.2 $ (DEC) $Date: 92/03/27 15:16:48 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */


#ifndef	_SYS_UTSNAME_H_
#define	_SYS_UTSNAME_H_
#include <standards.h>

/*
 * POSIX requires that certain values be included in utsname.h.  It also
 * requires that when _POSIX_SOURCE is defined only those standard
 * specific values are present.  This header includes all the POSIX
 * required entries.
 */
#ifdef _POSIX_SOURCE

#define  _SYS_NMLN           32     /* Important: do not change this value ! */

struct utsname {
	char    sysname[_SYS_NMLN];
	char    nodename[_SYS_NMLN];
	char    release[_SYS_NMLN];
	char    version[_SYS_NMLN];
	char    machine[_SYS_NMLN];
};

#ifndef _KERNEL
#ifdef _NO_PROTO	
extern int uname();
#else
#if defined(__STDC__) || defined(__cplusplus)
#if defined(__cplusplus)
extern "C"
{
#endif
extern int uname(struct utsname *);
#if defined(__cplusplus)
}
#endif
#endif
#endif /* _NO_PROTO */
#endif /* _KERNEL */

#endif /* _POSIX_SOURCE */

#ifdef _OSF_SOURCE

#define SYS_NMLN	_SYS_NMLN

extern struct utsname utsname;

#endif /* _OSF_SOURCE */

#endif /* _SYS_UTSNAME_H_ */
