/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	vm_tune.h,v $
 * Revision 1.1.2.5  92/06/15  15:23:38  Marian_Macartney
 * 	Increase MAXVAS default value
 * 	[92/06/15  15:17:31  Marian_Macartney]
 * 
 * Revision 1.1.2.4  92/05/21  13:27:07  Marian_Macartney
 * 	Make vm_tune parameters configurable
 * 	[92/05/21  12:51:19  Marian_Macartney]
 * 
 * Revision 1.1.2.3  92/03/26  11:46:00  Robert_Picco
 * 	bug fix
 * 	[92/03/24  10:09:07  Robert_Picco]
 * 
 * Revision 1.1.2.2  92/02/26  15:56:34  Charles_Briggs
 * 	UBC merge.
 * 	[92/02/22  14:53:22  Charles_Briggs]
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: vm_tune.h,v $ $Revision: 1.1.2.5 $ (DEC) $Date: 92/06/15 15:23:38 $
 */
#ifndef	__VM_TUNE__
#define	__VM_TUNE__

struct vm_tune {
	unsigned char	vt_cowfaults;		/* Copy point */
	unsigned short	vt_mapentries;		/* Maximum map entries */
	vm_offset_t	vt_maxvas;		/* Maximum VAS for user map */
	vm_offset_t	vt_maxwire;		/* Maximum wired memory */
	unsigned char	vt_heappercent;		/* kva percentage for heap */
	unsigned short	vt_anonklshift;		/* anon page shift */
	unsigned short	vt_anonklpages;		/* pages to fetch in kluster */
	unsigned long	vt_vpagemax;		/* Maximum vpage for umap */
	unsigned short	vt_ubcpagesteal;	/* Steal vnode clean list */
	unsigned char	vt_ubcdirtypercent;	/* Percent dirty push value */
	unsigned char	vt_ubcseqstartpercent;	/* Start ubcseqpercent */
	unsigned char	vt_ubcseqpercent;	/* Sequential allocation */
	vm_size_t 	vt_csubmapsize;		/* Size of kernel copy map */
	unsigned short	vt_ubcbuffers;		/* ubc buffers */
	unsigned short	vt_swapbuffers;		/* swap buffers */
	unsigned long	vt_clustermap;		/* ckluster dup map size */
	unsigned long	vt_clustersize;		/* max cluster bp size */
};

#define	vm_tune_compare(VALUE,FIELD,ROP) ((VALUE) ROP vm_tune.vt_/**/FIELD)
#define	vm_tune_value(FIELD)	vm_tune.vt_/**/FIELD

extern struct vm_tune vm_tune;

#ifndef COWFAULTS
#define COWFAULTS (4)		/*Copy point */
#endif

#ifndef MAPENTRIES
#define MAPENTRIES (200)       	/*Maximum map entries */
#endif

#ifndef MAXVAS
#define MAXVAS  (1024*1024*1024) /*Maximum VAS for user maps */
#endif

#ifndef MAXWIRE
#define MAXWIRE (1024*1024*16)	/*Maximum wired memory*/
#endif

#ifndef HEAPPERCENT
#define HEAPPERCENT (7)		/*Percent of memory for heap*/
#endif

#ifndef ANONKLSHIFT
#define ANONKLSHIFT (17)       	/*Anon page shift*/
#endif

#ifndef ANONKLPAGES
#define ANONKLPAGES (10)	/*Pages to fetch in kluster*/
#endif

#ifndef VPAGEMAX
#define VPAGEMAX (1024)		/*Maximum vpage for umap*/
#endif

#ifndef UBCPAGESTEAL
#define UBCPAGESTEAL (24)	/*Steal vnode clean list*/
#endif

#ifndef UBCDIRTYPERCENT
#define UBCDIRTYPERCENT (10)	/*Percent dirty push value*/
#endif

#ifndef UBCSEQSTARTPERCENT
#define UBCSEQSTARTPERCENT (50)	/*Start ubcseqpercent */
#endif

#ifndef UBCSEQPERCENT
#define UBCSEQPERCENT (10)	/*Sequential allocation*/
#endif

#ifndef CSUBMAPSIZE
#define CSUBMAPSIZE (1024*1024)	/*Size of kernel copy map*/
#endif

#ifndef UBCBUFFERS
#define UBCBUFFERS (256)	/*ubc buffers*/
#endif

#ifndef SWAPBUFFERS
#define SWAPBUFFERS (128)	/*swap buffers*/
#endif

#ifndef CLUSTERMAP
#define CLUSTERMAP (1024*1024*1) /*Cluster dup map size*/
#endif

#ifndef CLUSTERSIZE
#define CLUSTERSIZE (1024*64)	/*Max cluster dup per bp */
#endif

#endif	/* !__VM_TUNE__ */






