/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	sim_config.c,v $
 * Revision 1.1.3.4  92/06/02  11:22:26  cam_proj_Janet_Schank
 * 	Added call to simsii_enable_interrupts for DS_3100
 * 	[92/05/27  12:23:14  Janet_Schank]
 * 
 * 	Merged with ag.latest
 * 	[92/05/26  13:09:01  Janet_Schank]
 * 
 * 	Merged with ag.latest
 * 	[92/05/13  10:47:44  Janet_Schank]
 * 
 * 	merged with ag.latest
 * 	[92/05/13  09:42:56  Janet_Schank]
 * 
 * 	Moved CAM include files from sys to io/cam
 * 	[92/05/13  08:27:05  Janet_Schank]
 * 
 * 	Added KZQSA support
 * 	[92/03/06  14:32:46  William_Dallas]
 * 
 * Revision 1.1.3.3  92/03/11  09:53:25  cam_proj_Janet_Schank
 * 	"bsubmitted from shared SB"
 * 
 * Revision 1.1.3.2  92/02/27  16:04:43  cam_proj_Janet_Schank
 * 	"bsubmitted from shared SB"
 * 
 * Revision 1.1.2.5  92/02/21  13:59:54  Janet_Schank
 * 	Added include of <mach/vm_param.h> for Alpha.
 * 	[92/02/21  13:33:15  Janet_Schank]
 * 
 * Revision 1.1.2.4  92/01/31  11:19:39  Janet_Schank
 * 	Made 64bit modifications
 * 	[92/01/31  09:55:34  Janet_Schank]
 * 
 * Revision 1.1.2.3  92/01/28  18:28:12  Janet_Schank
 * 	Merged in changes from LA.
 * 	[92/01/28  18:08:29  Janet_Schank]
 * 
 * Revision 1.1.2.2  92/01/17  13:22:50  Janet_Schank
 * 	CAM support added
 * 	[92/01/17  11:18:30  Janet_Schank]
 * 
 * $EndLog$
 */
#ifndef lint
static char *rcsid = "@(#)$RCSfile: sim_config.c,v $ $Revision: 1.1.3.4 $ (DEC) $Date: 92/06/02 11:22:26 $";
#endif

/************************************************************************
 *
 * File:	sim_config.c
 * Date:	June 17, 1991
 * Author:	Robert P. Scott
 *
 * Description:
 *	CAM peripheral driver configuration information.
 *
 * Modification History:
 *
 *	91/07/03	rps	Changed TC option names to match std.
 *
 *	91/07/20	rps	Added spurious interrupt handling code.
 *
 * 	91/09/09	rps	Added temp. MAXINE/BIGMAX support.
 *
 *	91/09/26	rps	Needed check for turbo channel exist.
 *
 *	91/10/22	janet
 *	o Removed "#ifndef GENERIC" ifdefs.
 *	o Modified sim_enable_interrupts to take SIM_SOFTC pointer
 *	  as an argument.  Added "#ifdef (DS5000 | DS5000_100)" around
 *	  call to tc_enable_option().
 *
 *	91/10/24	janet
 *	Added Mipsmate support.
 *
 *	91/10/25	janet
 *	Added default configuration functins: hba_default_probe(),
 *	hba_default_attach(), hba_default_chip_reset(), dme_default_attach(),
 *	dme_default_unload().
 *
 *	91/11/15	jag
 *	Made the changes from LARRY to the LR specific defines.
 */

#include <io/common/iotypes.h>
#include <sys/types.h>			/* system level types */
#include <sys/param.h>			/* system level parameter defs */
#include <sys/buf.h>
#include <sys/time.h>
#include <kern/lock.h>
#include <io/cam/dec_cam.h>
#include <mach/vm_param.h>
#include <io/cam/cam.h>
#include <io/cam/scsi_all.h>
#include <hal/cpuconf.h>
#include <io/dec/tc/tc.h>
#include <io/cam/cam_config.h>
#include <io/cam/sim_config.h>
#include <io/cam/cam_debug.h>
#include <io/cam/sim_target.h>
#include <io/cam/sim_cirq.h>
#include <io/cam/dme.h>
#include <io/cam/sim.h>
#include <io/cam/sim_common.h>
#include <io/cam/sim_94.h>
#include <io/cam/sim_sii.h>
#include <io/cam/scsi_status.h>
#include <io/cam/dme_3min_94_dma.h>
#include <io/common/devdriver.h>

#include "asc.h"
#include "sii.h"
#include "kzq.h"

/* ---------------------------------------------------------------------- */
/* Local defines.
 */
#define SIM_KN02_SYNC_OFFSET	0x0f
#define SIM_KN02_SYNC_PERIOD	0x46
#define SIM_KN02_CLK_CONVERSION	0x05	/* 25 MHz */
    
#define OPTION_SLOTS 3

#define SLOT_0_ADDR 0x1e000000
#define SLOT_1_ADDR 0x1e400000
#define SLOT_2_ADDR 0x1e800000
#define SLOT_3_ADDR 0x0
#define SLOT_4_ADDR 0x0
#define SLOT_5_ADDR 0x1f400000
#define SLOT_6_ADDR 0x1f800000
#define SLOT_7_ADDR 0x1fc00000

void sii_ds3100_spurious_interrupt( int );

extern int cpu;
extern SIM_SOFTC *softc_directory[];

#ifdef DS5000_300	/* 3max+ */
    extern dma94_kn03_dme_attach();
#endif

#if NASC > 0
extern sim94_probe(), sim94_attach(), sim94_unload();
extern sim_kn02_chip_reset(), sim_kn02ba_chip_reset();

extern ram94_dme_attach(), ram94_dme_unload();
extern dma94_dme_attach(), dma94_dme_unload();
#endif
#if NSII > 0
extern simsii_probe(), simsii_attach(), simsii_unload();
extern sim_kn01_chip_reset();

extern ds3100_dme_attach(), ds3100_dme_unload();
extern ds5100_dme_attach(), ds5100_dme_unload();
#endif
#if NKZQ > 0
extern simkzq_probe(), simkzq_slave(), simkzq_attach(), simkzq_unload();
extern sim_kzq_chip_reset();

extern ds5500_kzq_dme_attach(), ds5500_kzq_dme_unload();
extern ds5500_kzq_dme_attach(), ds5500_kzq_dme_unload();
#endif

/* Default config functions */
int hba_default_probe(), hba_default_attach(), hba_default_chip_reset(),
    dme_default_attach(), dme_default_unload();


int cam_hba_limit = INIT_CAM_HBA_LIMIT;
int cam_dme_limit = INIT_CAM_DME_LIMIT;

CAM_HBA_LIST_ENTRY           cam_hba_list[INIT_CAM_HBA_LIMIT+1];
CAM_DME_LIST_ENTRY           cam_dme_list[INIT_CAM_DME_LIMIT+1];

int cam_hba_entries = 0;
int cam_dme_entries = 0;

static int config_init = 0;        /* remove this or do it right */

void
init_sim_components( void )
{
    int i;

    if ( config_init != 4192 )           /* init these structs on first */
      {                                  /* time through only */
	for( i=0; i<cam_hba_limit; i++ )
	  {
	    cam_hba_list[i].cs_name = (char *) NULL;
	    cam_hba_list[i].cs_probe = NULL;
	    cam_hba_list[i].cs_unload = NULL;
	  }
	cam_hba_entries = 0;
	
	for( i=0; i<cam_dme_limit; i++ )
	  {
	    cam_dme_list[i].dme_name = (char *) NULL;
	    cam_dme_list[i].dme_init = NULL;
	    cam_dme_list[i].dme_unload = NULL;
	  }
	cam_dme_entries = 0;
	
#if NASC > 0
    add_cam_hba_entry( "asc", sim94_probe, sim94_attach, sim_kn02_chip_reset, 
		      sim94_unload );
    add_cam_hba_entry( "PMAZ-AA ", sim94_probe, sim94_attach, 
		      sim_kn02_chip_reset, sim94_unload );
    add_cam_hba_entry( "PMAZ-BA ", sim94_probe, sim94_attach, 
		      sim_kn02ba_chip_reset, sim94_unload );
#ifdef DS5000_300	/* 3max+ */
    add_cam_hba_entry( "PMAZ-CA ", sim94_probe, sim94_attach, 
		      sim_kn02ba_chip_reset, sim94_unload );
#endif /* DS5000_300 */

    add_cam_dme_entry( "ram94", ram94_dme_attach, ram94_dme_unload );
    add_cam_dme_entry( "PMAZ-AA ", ram94_dme_attach, ram94_dme_unload );
    add_cam_dme_entry( "PMAZ-BA ", dma94_dme_attach, dma94_dme_unload );

#ifdef DS5000_300	/* 3max+ */
    /* JAG add_cam_dme_entry("PMAZ-BA-KN03 ", dma94_kn03_dme_attach, dma94_dme_unload); */
    add_cam_dme_entry("PMAZ-CA ", dma94_kn03_dme_attach, dma94_dme_unload);
#endif /* DS5000_300 */
#endif /* NASC */

#if NSII > 0
    add_cam_hba_entry( "sii", simsii_probe, simsii_attach, sim_kn01_chip_reset,
	simsii_unload );
    add_cam_dme_entry( "siiram", ds3100_dme_attach, ds3100_dme_unload );
    add_cam_dme_entry( "sii_kn230", ds5100_dme_attach, ds5100_dme_unload );
#endif /* NSII */

#if NKZQ > 0
    add_cam_hba_entry( "kzq", simkzq_probe, simkzq_attach, sim_kzq_chip_reset,
	simkzq_unload );
    add_cam_dme_entry( "kzqram", ds5500_kzq_dme_attach, ds5500_kzq_dme_unload );
#endif /* NKZQ */

    /*
     * Default entries.
     */
    add_cam_hba_entry( "hba_default", hba_default_probe, hba_default_attach,
		       hba_default_chip_reset);
    add_cam_dme_entry( "dme_default", dme_default_attach, dme_default_unload);
    

      }

    config_init = 4192;              /* so we don't go through again */
}

int
add_cam_hba_entry( char *name, int (*probe)(), int (*attach)(),
		  int (*reset_attach)(), int (*unload)() )
{
    int i;

    if ( cam_hba_entries == cam_hba_limit )
      {
        PRINTD( NOBTL, NOBTL, NOBTL, CAMD_INOUT, 
	       ("[b/t/l] (add_cam_hba_entry) Count = %d, cannot yet expand list.\n" ));
	return CAM_REQ_CMP_ERR;
      }

    for( i=0; i<cam_hba_entries && cam_hba_list[i].cs_name &&
	strcmp( name, cam_hba_list[i].cs_name );
	i++ )
      {}

    if ( i < cam_hba_entries )   /* we didn't hit the end of the list? */
      {
	PRINTD( NOBTL, NOBTL, NOBTL, CAMD_INOUT, 
	       ("[b/t/l] (add_cam_hba_entry) duplicate entry '%s'\n", name ));
	return CAM_REQ_CMP_ERR;
      }

    cam_hba_list[cam_hba_entries].cs_name = name;
    cam_hba_list[cam_hba_entries].cs_probe = probe;
    cam_hba_list[cam_hba_entries].cs_attach = attach;
    cam_hba_list[cam_hba_entries].cs_reset_attach = reset_attach;
    cam_hba_list[cam_hba_entries].cs_unload = unload;

    cam_hba_entries++;
    return CAM_REQ_CMP;
}

int 
remove_cam_hba_entry( char *name )
{
    int i;

    for( i=0; i<cam_hba_entries && cam_hba_list[i].cs_name && 
	strcmp( name, cam_hba_list[i].cs_name );
	i++ )
      {}

    if ( i == cam_hba_entries )          /* we hit the end of the list? */
        return CAM_REQ_CMP_ERR;

    while( i < cam_hba_entries )
      {
	cam_hba_list[i].cs_name = 
            cam_hba_list[i+1].cs_name;
	cam_hba_list[i].cs_probe = 
            cam_hba_list[i+1].cs_probe;
	cam_hba_list[i].cs_unload = 
            cam_hba_list[i+1].cs_unload;
	
	i++;
      }

    cam_hba_list[i].cs_name = (char *) NULL;
    cam_hba_list[i].cs_probe = NULL;
    cam_hba_list[i].cs_unload = NULL;

    cam_hba_entries--;
    return CAM_REQ_CMP;
}

int
name_lookup_hba_probe(name, ba, prb)
char *name;
char *ba;
struct controller *prb;
{
  int i;

  for( i=0; i<cam_hba_entries && cam_hba_list[i].cs_name &&
      strcmp( name, cam_hba_list[i].cs_name );
      i++ )
    {}

  if ( i == cam_hba_entries )
    {
      PRINTD( NOBTL, NOBTL, NOBTL, CAMD_INOUT,
	     ("[b/t/l] (name_lookup_hba_probe) name '%s' not found.\n", name ) );
      return CAM_REQ_CMP_ERR;
    }

  return cam_hba_list[i].cs_probe( ba, prb );
}

int
name_lookup_hba_attach( char *name, SIM_SOFTC *sc )
{
  int i;

    PRINTD( NOBTL,NOBTL,NOBTL,CAMD_INOUT,
	   ("[b/t/l] (name_lookup_hba_attach) entry - name='%s', sc=0x%x \n", 
	    name, sc ) );

  for( i=0; i<cam_hba_entries && cam_hba_list[i].cs_name &&
      strcmp( name, cam_hba_list[i].cs_name );
      i++ )
    {}

  if ( i == cam_hba_entries )
    {
      PRINTD( NOBTL, NOBTL, NOBTL, CAMD_INOUT,
	     ("[b/t/l] (name_lookup_hba_attach) name '%s' not found.\n", name ) );
      return CAM_REQ_CMP_ERR;
    }

  return cam_hba_list[i].cs_attach( sc );
}

int
name_lookup_hba_reset_attach( char *name, SIM_SOFTC *sc )
{
  int i;

    PRINTD( NOBTL,NOBTL,NOBTL,CAMD_INOUT,
	   ("[b/t/l] (name_lookup_hba_reset_attach) entry - name='%s', sc=0x%x \n", 
	    name, sc ) );

  for( i=0; i<cam_hba_entries && cam_hba_list[i].cs_name &&
      strcmp( name, cam_hba_list[i].cs_name );
      i++ )
    {}

  if ( i == cam_hba_entries )
    {
      PRINTD( NOBTL, NOBTL, NOBTL, CAMD_INOUT,
	     ("[b/t/l] (name_lookup_hba_reset_attach) name '%s' not found.\n", name ) );
      return CAM_REQ_CMP_ERR;
    }

  return (int) cam_hba_list[i].cs_reset_attach;
}


int
add_cam_dme_entry( char *name, int (*init)(), int (*unload)() )
{
    int i;

    if ( cam_dme_entries == cam_dme_limit )
      {
        PRINTD( NOBTL, NOBTL, NOBTL, CAMD_INOUT, 
	       ("[b/t/l] (add_cam_dme_entry) Count = %d, cannot yet expand list.\n" ) );
	return CAM_REQ_CMP_ERR;
      }
    
    for( i=0; i<cam_dme_entries && cam_dme_list[i].dme_name &&
        strcmp( name, cam_dme_list[i].dme_name );
        i++ )
      {}

    if ( i < cam_dme_entries )
      {
	PRINTD( NOBTL, NOBTL, NOBTL, CAMD_INOUT, 
	       ("[b/t/l] (add_cam_dme_entry) duplicate name '%s'\n", name ) );
        return CAM_REQ_CMP_ERR;
      }

    cam_dme_list[cam_dme_entries].dme_name = name;
    cam_dme_list[cam_dme_entries].dme_init = init;
    cam_dme_list[cam_dme_entries].dme_unload = unload;

    cam_dme_entries++;
    return CAM_REQ_CMP;
}

int 
remove_cam_dme_list( char *name )
{
    int i;

    for( i=0; i<cam_dme_entries &&  cam_dme_list[i].dme_name &&
	strcmp( name, cam_dme_list[i].dme_name );
	i++ )
      {}

    if ( i == cam_dme_entries )          /* we hit the end of the list? */
        return CAM_REQ_CMP_ERR;

    while( i < cam_dme_entries )
      {
	cam_dme_list[i].dme_name = 
            cam_dme_list[i+1].dme_name;
	cam_dme_list[i].dme_init = 
            cam_dme_list[i+1].dme_init;
	cam_dme_list[i].dme_unload = 
            cam_dme_list[i+1].dme_unload;
	
	i++;
      }

    cam_dme_list[i].dme_name = (char *) NULL;
    cam_dme_list[i].dme_init = NULL;
    cam_dme_list[i].dme_unload = NULL;

    cam_dme_entries--;
    return CAM_REQ_CMP;
}

int
name_lookup_dme_init( char *name, SIM_SOFTC *sc )
{
  int i;

    PRINTD( NOBTL,NOBTL,NOBTL,CAMD_INOUT,
	   ("[b/t/l] (name_lookup_dme_init) entry - name='%s', sc=0x%x \n", 
	    name, sc ) );

  for( i=0; i<cam_dme_entries && cam_dme_list[i].dme_name &&
      strcmp( name, cam_dme_list[i].dme_name );
      i++ )
    {}

  if ( i == cam_dme_entries )
    {
      PRINTD( NOBTL, NOBTL, NOBTL, CAMD_INOUT,
	     ("[b/t/l] (name_lookup_dme_init) name '%s' not found.\n", name ) );
      return CAM_REQ_CMP_ERR;
    }

  return cam_dme_list[i].dme_init( sc );
}

int
hba_dme_attach( U32 pathid, SIM_SOFTC *sc )
{
    int retval = CAM_REQ_CMP;
    char *hbaname, *dmename;            /* used in config process */
    char modname[32];                   /* TC module name - what size? -RPS */
    caddr_t csr;			/* CSR addess from softc struct */
    int tpt;

    PRINTD( NOBTL,NOBTL,NOBTL,CAMD_INOUT,
	   ("[b/t/l] (hba_dme_attach) entry - pathid=%d, sc=0x%x \n", pathid, sc ) );

    csr = sc->csr_probe;		/* get what was stored by probe */

    switch( cpu )
        {
	case DS_3100:             /* sii base */
	    hbaname = "sii";
	    dmename = "siiram";
	    break;

        case DS_5000:             /* asc base */
	    if ( pathid == 0 )                  /* base scsi? */
	      {
              hbaname = "asc";
	      dmename = "ram94";
	      }
            else                               /* TC scsi */
	      {
		if( tc_addr_to_name( csr, modname ) == -1)
		  PRINTD( NOBTL, NOBTL, NOBTL, CAMD_INOUT, 
			 ("[b/t/l] (hba_dme_attach) tc_addr_to_name failed ") );
		hbaname = modname;
		dmename = modname;
	      }
	    break;

        case DS_5000_100:         /* asc base */
#ifdef DSPERSONAL_DECSTATION
	case DS_MAXINE:
#endif /* DSPERSONAL_DECSTATION */
	    if( tc_addr_to_name( csr, modname ) == -1)
	      PRINTD( NOBTL, NOBTL, NOBTL, CAMD_INOUT, 
		     ("[b/t/l] (hba_dme_attach) tc_addr_to_name failed ") );
	    hbaname = modname;
	    dmename = modname;
	    break;

#ifdef DS5000_300
	case DS_5000_300:         /*3MAX+, BIGMAX*/
	    if( tc_addr_to_name( csr, modname ) == -1)
	      PRINTD( NOBTL, NOBTL, NOBTL, CAMD_INOUT, 
		     ("[b/t/l] (hba_dme_attach) tc_addr_to_name failed ") );
	    hbaname = modname;
	    /* JAG dmename = "PMAZ-BA-KN03 "; */
	    dmename = modname;
	    break;
#endif /* DS5000_300 */

	case DS_5100:
	    hbaname = "sii";
	    dmename = "sii_kn230";
	    break;

	case DS_5500:             /* 94 but no TC on baseboard  */
	    if ( pathid == 0 ||  pathid == 1 ||  pathid == 2 || pathid == 3 )                  /* base scsi? */
	    {
		/* 
		 * Get our controller name and compare it
		 */
		if(strcmp(((struct controller *)sc->um_probe)->ctlr_name, 
				"asc") == NULL){ 
		    hbaname = "asc";
		    dmename = "ram94";
		}
		else if(strcmp(((struct controller *)sc->um_probe)->ctlr_name, 
				"kzq") == NULL){ 
		    hbaname = "kzq";
		    dmename = "kzqram";
		}
		else {
		     hbaname = "hba_default";
		     dmename = "dme_default";
		}
	    }
	    else {
		/*
		 * Invalid pathid fail it now.
		 */
		printf("hba_dme_attach: (%d/n/n) - hba '%s' path invalid.\n",
			 pathid, hbaname );
		return(  CAM_REQ_CMP_ERR );
	    }
	    break;

	case DS_5400:             /* No such SCSI! */

	case DS_5800:             /* ? */

        default:
	    hbaname = "hba_default";
	    dmename = "dme_default";
	    break;
	}

    /*
     * First perform the attach function which will link the SIM XPT to the
     * underlying SIM HBA's and DME's. The softc for this HBA is setup to
     * allow further initialization of the CAM subsystem.
     */
    if ( name_lookup_hba_attach( hbaname, sc ) != CAM_REQ_CMP )
        {
	/* 
	 * If the attach fails don't do any further initialization.
	 */
	printf("hba_dme_attach: (%d/n/n) - hba '%s' attach failed.\n", 
	       pathid, hbaname );
	retval = CAM_REQ_CMP_ERR;
        }
    else
    {
	tpt = name_lookup_hba_reset_attach( hbaname, sc );
	if ( tpt != CAM_REQ_CMP_ERR )
	{
	    sc->hba_chip_reset = (void *) tpt;
	}
	else
	{
	    printf("hba_dme_attach: (%d/n/n) - reset attach of '%s' failed.\n",
		   pathid, hbaname );
	}
    }

    if ( name_lookup_dme_init( dmename, sc ) != CAM_REQ_CMP )
	{
	printf("hba_dme_attach: (%d/n/n) - dme '%s' attach failed.\n",
	       pathid, dmename );
	retval = CAM_REQ_CMP_ERR;
	}

    return retval;
}

#define	BASE_IOASIC	0x1c040000		/* motherboard IO-ASIC */
#define KN03_BASE_IOASIC 0x1f840000		/* 3max+ Base address */

void
sim_spurious_interrupt( int controller )
{
    unsigned *dmap;         /* pointer to IOASIC DMA Ptr. reg. */
    U32 *sir;
    U32 sirp, resetval;
    U32 *ioasicp;	/* pointer for the SCSI DMA engine register */

    switch( cpu )
      {
      case DS_3100:             /* sii base */
	printf("(sim_spurious_interrupt)(DS_3100) Unexpected interrupt on controller %d\n",
	       controller );
	sii_ds3100_spurious_interrupt( controller );
	break;
	
      case DS_5000:             /* asc base */
	printf("(sim_spurious_interrupt)(DS_5000) Unexpected interrupt on controller %d\n",
	       controller );
	break;
	
      case DS_5000_100:         /* asc base */
	printf("(sim_spurious_interrupt)(DS_5000_100) Unexpected interrupt on controller %d\n",
	       controller );
	ioasicp = (U32 *) PHYS_TO_K1( BASE_IOASIC );
	
	sir = (U32 *) ( (unsigned) ioasicp + SIR_O );
	
	resetval = 0xffffffff;
	resetval &= ~SCSI_DBPL;
	resetval &= ~SCSI_OERR;
	resetval &= ~SCSI_MERR;
	resetval &= ~SCSI_DRDY;
	resetval &= ~SCSI_C94;
	*sir = resetval;
	break;
	
      case DS_5100:             /* sii base */
	printf("(sim_spurious_interrupt)(DS_5100) Unexpected interrupt on controller %d\n",
	       controller );
	break;
	
	
      case DS_5400:             /* ? */
	printf("(sim_spurious_interrupt)(DS_5400) Unexpected interrupt on controller %d\n",
	       controller );
	break;
	
      case DS_5500:             /* ? */
	printf("(sim_spurious_interrupt)(DS_5500) Unexpected interrupt on controller %d\n",
	       controller );
	break;
	
      case DS_5800:             /* ? */
	printf("(sim_spurious_interrupt)(DS_5800) Unexpected interrupt on controller %d\n",
	       controller );
	break;
	
      default:
	printf("(sim_spurious_interrupt)(UNKNOWN PROCESSOR) Unexpected interrupt on controller %d\n",
	       controller );
	break;
      }
}
    
/*
 * We need to figure out the best way to get this... This symbol should only
 * be defined in kn01.c in machine/mips...
 */
#define KN01SII_ADDR  PHYS_TO_K1(0x1a000000)/* phys addr of sii registers */

/**
 * sii_ds3100_spurious_interrupt -
 *
 * FUNCTIONAL DESCRIPTION:
 * In the event of an interrupt from the SII chip before the CAM subsystem
 * has been initialized, reset the SII chip.
 *
 * FORMAL PARAMETERS:  		controller - Which SII controller.
 *
 * IMPLICIT INPUTS:     	NONE
 *
 * IMPLICIT OUTPUTS:		NONE
 *
 * RETURN VALUE:        	CAM_REQ_CMP
 *
 * SIDE EFFECTS:        	NONE
 *
 * ADDITIONAL INFORMATION:      NONE
 *
 **/
void
sii_ds3100_spurious_interrupt( int controller )
{
    SIMSII_REG *siireg;
    
    if (controller == 0)
      {
	siireg = (SIMSII_REG *) KN01SII_ADDR; /* Get address of SII CSR */
	
	/*
	 * Clear interrupt enable on SII to allow system to boot, by disabling
	 * further SII interrupts.
	 */
	siireg->csr = 0;
	
	PRINTD(NOBTL,NOBTL,NOBTL,CAMD_DMA_FLOW,
	       ("[%d/t/l] (sii_ds3100_spurious_interrupt) Interrupt received before subsystem initialized,", controller ) );
	PRINTD(NOBTL,NOBTL,NOBTL,CAMD_DMA_FLOW,
		("[%d/t/l] (sii_ds3100_spurious_interrupt) interrupt now disabled.\n",
		controller ))
	}
    else
      {
	PRINTD(NOBTL,NOBTL,NOBTL,CAMD_DMA_FLOW,
	       ("[%d/t/l] (sii_ds3100_spurious_interrupt) Interrupt received for unknown controller ",
		controller ) );
	PRINTD(NOBTL,NOBTL,NOBTL,CAMD_DMA_FLOW,
		("[%d/t/l] (sii_ds3100_spurious_interrupt) before subsystem initialized.\n",
		controller ));
	panic("CAM: Spurious interrupt for unknown controller\n");
	
      };
    return;
    
};    /* cam_sii_spurious_interrupt_before_initialization  */


sim_enable_interrupts(sc)
SIM_SOFTC *sc;
{
    struct controller attach;	/* used by tc_enable_option */
    struct controller *prb = (struct controller *)sc->um_probe;

    (&attach)->tcindx = prb->tcindx; /* used by tc_enable_option */

    switch( cpu )
    {
#ifdef DS5000
    case DS_5000:             /* asc base */
	tc_enable_option( &attach );
	break;
#endif /* DS5000 */

#ifdef DS5000_100
    case DS_5000_100:         /* asc base */
	tc_enable_option( &attach );
	break;
#endif /* DS5000_100 */
	    
#ifdef DS5000_300
    case DS_5000_300:         /* asc base */
	tc_enable_option( &attach );
	break;
#endif /* DS5000_300 */
	    
#ifdef DS3100
    case DS_3100:
	simsii_enable_interrupts((U32)0);
	break;
#endif /* DS3100 */
	    
#ifdef DSPERSONAL_DECSTATION
    case DS_MAXINE:         /* asc base */
	tc_enable_option( &attach );
	break;
#endif /* DSPERSONAL_DECSTATION */

    default:
	break;
	
    }
}

hba_default_probe()
{
    printf("Unable to determine SCSI host bus adapter type!\n");
    return(0);
}
hba_default_attach()
{
    printf("Unable to determine SCSI host bus adapter type!\n");
}
hba_default_chip_reset()
{
    printf("Unable to determine SCSI host bus adapter type!\n");
}
dme_default_attach()
{
    printf("Unable to determine SCSI host bus adapter type!\n");
}
dme_default_unload()
{
    printf("Unable to determine SCSI host bus adapter type!\n");
}

