;  DEC/CMS REPLACEMENT HISTORY, Element ASSEM.RSX
;  *3    18-AUG-1986 11:17:45 WORRALL "Complete HEX listing support for version 5.5 fieldtest"
;  *2    14-APR-1986 23:06:50 SYSTEM "Update 5.4 of MACRO-11"
;  *1    28-MAR-1986 02:33:34 SYSTEM "Load MACRO-11 sources from V5.3"
;  DEC/CMS REPLACEMENT HISTORY, Element ASSEM.RSX
	.NLIST							;Edit Level 00
	.ENABL	LC,GBL
	.LIST
	.TITLE	ASSEM - Random assembler initialization
	.SBTTL	ASSEM - Random assembler initialization
	.SBTTL
	.SBTTL		.IDENT	/V05.05/
	.SBTTL
	.IDENT	/V05.05/
;****************************************************************************
;*									    *
;*                   COPYRIGHT (c)  1983, 1986                              *
;*          BY DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.                *
;*                   ALL RIGHTS RESERVED.                                   *
;* 									    *
;*  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND  COPIED  *
;*  ONLY  IN  ACCORDANCE  WITH  THE  TERMS  OF  SUCH  LICENSE AND WITH THE  *
;*  INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR  ANY  OTHER  *
;*  COPIES  THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY  *
;*  OTHER PERSON.  NO TITLE TO AND OWNERSHIP OF  THE  SOFTWARE  IS  HEREBY  *
;*  TRANSFERRED.							    *
;* 									    *
;*  THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE  WITHOUT  NOTICE  *
;*  AND  SHOULD  NOT  BE  CONSTRUED  AS  A COMMITMENT BY DIGITAL EQUIPMENT  *
;*  CORPORATION.							    *
;* 									    *
;*  DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR  RELIABILITY  OF  ITS  *
;*  SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.		    *
;*									    *
;****************************************************************************


;++
;  Facility:	MACRO-11  The PDP-11 macro assembler for RT/RSX/VMS and RSTS/E
;
;    Author:	Too many people to list here
;
;   Created:	From the dust and dirt
;
;  Abstract:	ASSEM - Random assembler initialization
;
;     Externals	 Description
;     ---------	 -----------
;
;      Edit	Who	Date		Description of modification
;      ----	---	----		---------------------------
;--


	.PSECT	MIXED,D

LIMIT:	.LIMIT			;D-SPACE Task address limits

;+
;
; IMPURE/PASS DATA INITIALIZATION CODE
;
;-

	PURE	XCTPRG,I
XCTPRG::MOV	#IMPURE,R0	;++015 PUT ADDR OF IMPURE AREA IN R0
1$:	CLR	(R0)+		;++015 ZERO THE ENTIRE IMPURE P-SECTION
	CMP	#IMPURT,R0	;++015
	BHI	1$		;++015
	MOV	EDBITS,EDMBAK	;++015 SET .ENABL/.DSABL DEFAULTS
	MOV	LCBITS,LCSBAK+<LCMASK-LCSAVE>  ;++015 SET LISTING DEFAULTS
	INC	ENDVEC+6	;++015 DEFAULT TO NO '.END' VECTOR
	JMP	XCTPAS		;++015 NOW PERFORM PASS INITIALIZATION

	PURE	XCTPAS,I	;++017
XCTPAS::MOV	#IMPPAS,R0	;++015 PUT ADDR OF IMPURE PASS AREA IN R0
2$:	CLR	(R0)+		;++015 ZERO THE ENTIRE IMPURE PASS...
	CMP	#IMPPAT,R0	;++015 ...P-SECTION
	BHI	2$		;++015
	MOV	EDMBAK,EDMASK	;++015 SET .ENABL/.DSABL FLAGS
	MOV	#LCSBAK,R1	;++015 PREPARE TO SET THE ...
	MOV	#LCSAVE,R2	;++015 ... LISTING CONTROL INFO
	CALL	XMIT0-LCSAVL	;++015 TRANSFER THE INFORMATION
	MOV	#8.,CRADIX	;++015 SET CURRENT RADIX TO OCTAL
	COMB	OBJSEC		;++015 SET OBJECT PSECT LESS THAN 0
	MOV	LSYBAS,LSYBLK	;INIT POINTER TO NEXT FREE LOCAL SYM SLOT ;JR
;;;	CALL	SETHDR		;Set up default .TITLE for this pass
	JMP	XCTLIN		;++015 NOW PERFORM LINE INITIALIZATION

	PURE	PUREI,I		;++017


;+
; $OFVL  -- RECOVER FROM EXPRESSION STACK OVERFLOW
;
;	THIS CODE IS ENTERED BY THE EXPRESSION ANALYZER WHEN IT
;	HAS DETECTED AN OVERFLOW CONDITION.  TO RECOVER FROM THIS,
;	AN 'E' ERROR IS GENERATED, A QUESTION MARK IS INSERTED IN
;	THE LINE AT THE CURRENT POSITION, AND ALL GENERATED CODE
;	IS ELIMINATED.  THE SCAN IS THEN TERMINATED AND THE END-
;	OF-LINE ROUTINE IS ENTERED BY PERFORMING A DIRECT RETURN
;	TO THE BASIC MACRO ASSEMBLY LOOP (IN MODULE MAC11).
;-

$OFVL::	MOVB	#'?,@CHRPNT	;STORE QUESTION MARK IN SOURCE LINE
	ERROR	E		;SET AN 'E' ERROR
	MOV	$STKAD,R0	;GET RESTART STACK POINTER
	SUB	#3*2,R0		;POINT TO ASSEMBLY LOOP RETURN ADDR
	MOV	R0,SP		;RESET STACK POINTER
	ZAP	CODLST		;CLEAR ALL GENERATED CODE
	RETURN			;AND RETURN TO PROCESS END-OF-LINE


;+
; *-ASSEM-*- INITIALIZE ASSEMBLER DYNAMIC STORAGE
; IN THE RSX-11 ENVIRONMENT, THE AMOUNT OF DYNAMIC STORAGE WILL
; DEPEND UPON THE SIZE OF THE PARTITION IN WHICH THE ASSEMBLER
; IS RUNNING.  THIS SETS THE INITIAL DYNAMIC STORAGE POINTER
; TO THE WORD FOLLOWING THE MACRO-11 CODE PROPER.  ALL MEMORY
; BETWEEN THAT POINT AND THE END OF THE TASK'S ADDRESS SPACE
; WILL BE ALLOCATED TO DYNAMIC MEMORY.
;
;
; NOTE: THIS ROUTINE WILL ALLOCATE SPACE FROM DYNAMIC MEMORY TO THE FREE
; LIST FOR FILE STORAGE IF THE COUNT IN 'ACTFIL' INDICATES AN ADDITIONAL
; STORAGE BLOCK IS REQUIRED.  ALSO, THE VIRTUAL MEMORY LIST
; POINTERS ARE ALL INITIALIZED.
;+

ASSEM::				;++014
	MOV	LIMIT,R0	;GET LOWEST STACK ADDRESS	;**I/D**
	ADD	#140,R0		;SET ASIDE A 48-WORD BUFFER ZONE	;CD056
	MOV	R0,$STKGD	;SAVE AS STACK OVERFLOW GUARD		;**-1
	MOV	#$FRHD,R0	;++027 POINT R0 TO FREE MEMORY LISTHEAD
	CALL	$INIDM		;++027 CALC AMOUNT OF FREE MEMORY AVAIL
	MOV	R1,-(SP)	;++027 SAVE END OF TASK ADDRESS
	MOV	#$FRHD,R0	;++021 GET ADDR OF VIRT MEMORY LIST HEAD
	MOV	R0,-(SP)	;++021 SAVE LISTHEAD ADDR ON STACK
	CLR	FDBTBL+SRCCHN	;++022 USE FLOATING FDB FOR SOURCE FILE
	TST	@$NXFDB		;++022 LOOK AT REMAINING FDB ADDR
	BNE	12$		;++022 IF NE ONE REMAINS
	MOV	#S.FDB,R1	;++021 ELSE, GET SIZE TO ALLOCATE AN FDB
	CALL	$RQCB		;++021 ALLOCATE THE CORE BLOCK
	BCS	100$		;++021 IF CS FAILURE
	MOV	R0,@$NXFDB	;++022 USE BLOCK AS NEEDED FDB
	MOV	#<S.FDB/2>,R1	;++021 GET FDB SIZE IN WORDS
10$:	CLR	(R0)+		;++021 CLEAR THE ENTIRE FDB
	SOB	R1,10$		;++021
12$:				;++022

	.IF NDF	XCREF & RSX11M	;++022 RSX-11D MACRO WITH CREF

FSRALC=0			;++022 SET TO GENERATE FSR ALLOCN CODE
	TSTB	OBJFIL		;++022 WAS AN OBJECT FILE OPENED?
	BEQ	15$		;++022 IF EQ NO
	TSTB	CRFFIL		;++022 WAS A CRF FILE OPENED?
	BEQ	15$		;++022 IF EQ NO
	MOV	#512.+S.BFHD,R1	;++022 IF OBJ + LST + CRF FILES,
				;++022 NEED ANOTHER FSR FOR INPUT FILE
	.ENDC

	.IF DF	RSX11M		;++022 RSX-11M MACRO

FSRALC=0			;++022 SET TO GENERATE FSR ALLOCN CODE

	.IF DF	XCREF		;++022 RSX-11M MACRO WITHOUT CREF

	TSTB	OBJFIL		;++022 WAS AN OBJECT FILE OPENED?
	BEQ	15$		;++022 IF EQ NO
	TSTB	LSTFIL		;++022 WAS A LISTING FILE OPENED?
	BEQ	15$		;++022 IF EQ NO
	MOV	$LSTVZ,R1	;++022 IF OBJ + LST FILES THEN NEED
	ADD	#S.BFHD,R1	;++022 ANOTHER FSR (FOR LST FILE)

	.IFF			;++022 RSX-11M MACRO WITH CREF

	MOVB	OBJFIL,R0	;++022 PUT OBJECT FILE FLAG IN R0
	MOVB	LSTFIL,R1	;++022 PUT LST FILE FLAG INTO R1
	ADD	R1,R0		;++022 WILL BUMP FILE COUNT IF SET
	MOVB	CRFFIL,R1	;++022 PUT CRF FILE FLAG INTO R1
	ADD	R1,R0		;++022 WIL BUMP FILE COUNT IF SET
	SUB	#2,R0		;++022 DETERMINE IF MORE FSR'S ARE NEEDED
	BGE	120$		;IF GE ALLOCATE MORE FSR'S
	TSTB	IOFTBL+1+LSTCHN	;LISTING TO A SPOOLED DEVICE?
	BEQ	15$		;IF EQ NO
	CLR	R0		;ELSE, FORCE ALLOCATION OF ONE FSR
120$:				;
	MOV	$LSTVZ,R1	;++022 ELSE, ALLOCATE ONE FOR THE
	ADD	#S.BFHD,R1	;++022 LISTING FILE
	DEC	R0		;++022 SEE IF ANOTHER ONE IS NEEDED
	BLT	13$		;++022 IF LT NO
	ADD	#512.+S.BFHD,R1	;++022 ALLOC ONE FOR CRF FILE
13$:				;++022

	.ENDC			;++022

	.ENDC			;++022

	.IF DF	FSRALC		;++022

	MOV	R1,R4		;++021 SAVE THE NEEDED FSR SIZE
	MOV	(SP),R0		;++021 GET DYNAMIC MEMORY LISTHEAD ADDR
	CALL	$RQCB		;++021 ALLOCATE THE CORE BLOCK
	BCS	100$		;++021 IF CS FAILURE
	MOV	R0,R2		;++021 COPY ADDR OF THE BLOCK IN R2
	MOV	R4,R1		;++021 RESTORE THE FSR SIZE INTO R1
	MOV	.FSRPT,R0	;++021 GET ADDR OF FSR LIST HEAD
	CALL	$RLCB		;++014 LINK BLOCK INTO FSR2 FREE LIST

	.ENDC			;++017

15$:	MOV	#VM$LST,R1	;++021 GET NUMBER OF VIRT MEMORY LISTS
20$:	CLR	$LSBAS(R1)	;++021 CLEAR START OF LIST POINTER
	CLR	$LSTOP(R1)	;++021 CLEAR END OF LIST POINTER
	CLR	$LSCNT(R1)	;++021 CLEAR LIST ENTRY COUNT
	SUB	#2,R1		;MOVE DOWN A ROLL
	BGE	20$		;++021 REPEAT FOR ALL LISTS
				;REMOVED REF TO SUBLISTS		;JR
	MOV	@(SP)+,R0	;++021 POINT TO REAL MEMORY BLOCK
	MOV	(SP)+,R1	;++027 GET END OF TASK ADDRESS
	MOV	2(R0),$FRSIZ	;++027 SAVE SIZE OF AVAIL REAL MEMORY
	JMP	$INIVM		;++021 INIT VIRT MEMORY NOW AND EXIT

100$:	MOV	#VIRTM1,R3	;++021 SPECIFY ERROR MESSAGE (INSUFF
				;++021 DYNAMIC MEMORY)
	JMP	RESTRT		;++021 REPORT ERROR AND RESTART

MACP1::				;++011
	MOV	#LCSAVE,R1	;++011 PREPARE TO SAVE INITIAL...
	MOV	#LCSBAK,R2	;++011 ...LISTING CONTROL INFORMATION
	MOV	#XMIT0,-(SP)	;++011 ADDR OF MOVE VECTOR
	SUB	#LCSAVL,(SP)	;++011 CALC ENTRY POINT
	CALL	@(SP)+		;++011 SAVE THE BLOCK
	MOV	EDMASK,EDMBAK	;++011 SAVE ENABL/DSABL FLAGS
	CALL	XCTPAS		;++011 INIT PASS VARIABLES
	MOV	#LST.KB*400,R0	;SET ERROR SLOT
	TSTB	LSTFIL		;++014 IS THERE A LISTING FILE?
	BEQ	1$		;  NO
	BIS	#LST.KB!100200,R0	;YES, ASSUME TELETYPE
	BIT	#IO.TTY,IOFTBL+LSTCHN	;TRUE?
	BNE	1$		;  YES
	ADD	#<LST.LP-LST.KB>*401,R0	;NO, UPGRADE TO LP
1$:	MOV	R0,LSTDEV	;SET FLAGS
	CALL	SETHDR		;SET UP HEADER
	.IF NDF	XSML
	MOV	#MACP2F,-(SP)	;LIBLST SHOULD RETURN TO COMMON PASS CODE
	MOV	#LIBLST,R0	;RESERVE SLOT IN LIBLST FOR SML
	CLR	SYMBOL		;CLEAR FILE-ID FOR SML FILE
				;FIRST REF TO LIBRARY CAUSES A PARSE
	JMP	APPEND		;
				;ABOVE CODE IS INTENDED TO PREVENT LIBLST
				;FROM UNKNOWINGLY CAUSING AN FCS OVERLAY
				;TO OVERWRITE THIS CODE (BECAUSE SOME DISK
				;VIRTUAL MEMORY IS NEEDED) AND THEN RETURNING
				;TO THIS CODE.
	.IFF
	JMP	MACP2F		;JUMP TO COMMON PASS CODE
	.ENDC


	.END
