!
! DESCRIP.MMS - MMS description for building MACRO-11
!

.SILENT

! Define default MACRO-11 qualifiers

MFLAGS		= /LIST/OBJECT=$(MMS$TARGET_NAME)
CMSFLAGS	= /GEN=1+

! Define our own suffixes

.SUFFIXES
.SUFFIXES .EXE .TSK .SAV .STB .OLB .MLB .OBJ .OBP
.SUFFIXES .MAC .RSX .RT .RST .IAS .PRO
.SUFFIXES .CMD .ODL .COM .BLD
.SUFFIXES .MAC~ .RSX~ .RT~ .RST~ .IAS~ .PRO~
.SUFFIXES .CMD~ .ODL~ .COM~ .BLD~

!
! Allow fetching the new suffixes defined from CMS libraries
! by defining rules to FETCH the file from a CMS library for
! the MMS non-standard suffixes:
!
! .RSX,.RT,.RST,.IAS,.PRO,.CMD,.ODL and .BLD
!
! Any new non-standard suffixes which are added above and don't have a
! CMS FETCH rule pre-defined withen MMS should be added to this section.
!

.RSX~.RSX
	MMS$CMSLIB :== 'f$trnlnm("CMS$LIB")'
	IF "''MMS$CMSLIB'" .nes. "$(MMS$TARGET)" -
		THEN $(CMS) SET LIBRARY $(MMS$TARGET)
	$(CMS) FETCH $(MMS$SOURCE) $(CMSFLAGS) $(CMSCOMMENT)
	IF MMS$CMSLIB .EQS. "" THEN $(CMS) SET LIBRARY 1234
	IF MMS$CMSLIB .NES. "" .AND. MMS$CMSLIB .NES. "$(MMS$TARGET)" -
		THEN $(CMS) SET LIBRARY 'MMS$CMSLIB'
.RT~.RT
	MMS$CMSLIB :== 'f$trnlnm("CMS$LIB")'
	IF "''MMS$CMSLIB'" .nes. "$(MMS$TARGET)" -
		THEN $(CMS) SET LIBRARY $(MMS$TARGET)
	$(CMS) FETCH $(MMS$SOURCE) $(CMSFLAGS) $(CMSCOMMENT)
	IF MMS$CMSLIB .EQS. "" THEN $(CMS) SET LIBRARY 1234
	IF MMS$CMSLIB .NES. "" .AND. MMS$CMSLIB .NES. "$(MMS$TARGET)" -
		THEN $(CMS) SET LIBRARY 'MMS$CMSLIB'
.RST~.RST
	MMS$CMSLIB :== 'f$trnlnm("CMS$LIB")'
	IF "''MMS$CMSLIB'" .nes. "$(MMS$TARGET)" -
		THEN $(CMS) SET LIBRARY $(MMS$TARGET)
	$(CMS) FETCH $(MMS$SOURCE) $(CMSFLAGS) $(CMSCOMMENT)
	IF MMS$CMSLIB .EQS. "" THEN $(CMS) SET LIBRARY 1234
	IF MMS$CMSLIB .NES. "" .AND. MMS$CMSLIB .NES. "$(MMS$TARGET)" -
		THEN $(CMS) SET LIBRARY 'MMS$CMSLIB'
.IAS~.IAS
	MMS$CMSLIB :== 'f$trnlnm("CMS$LIB")'
	IF "''MMS$CMSLIB'" .nes. "$(MMS$TARGET)" -
		THEN $(CMS) SET LIBRARY $(MMS$TARGET)
	$(CMS) FETCH $(MMS$SOURCE) $(CMSFLAGS) $(CMSCOMMENT)
	IF MMS$CMSLIB .EQS. "" THEN $(CMS) SET LIBRARY 1234
	IF MMS$CMSLIB .NES. "" .AND. MMS$CMSLIB .NES. "$(MMS$TARGET)" -
		THEN $(CMS) SET LIBRARY 'MMS$CMSLIB'
.PRO~.PRO
	MMS$CMSLIB :== 'f$trnlnm("CMS$LIB")'
	IF "''MMS$CMSLIB'" .nes. "$(MMS$TARGET)" -
		THEN $(CMS) SET LIBRARY $(MMS$TARGET)
	$(CMS) FETCH $(MMS$SOURCE) $(CMSFLAGS) $(CMSCOMMENT)
	IF MMS$CMSLIB .EQS. "" THEN $(CMS) SET LIBRARY 1234
	IF MMS$CMSLIB .NES. "" .AND. MMS$CMSLIB .NES. "$(MMS$TARGET)" -
		THEN $(CMS) SET LIBRARY 'MMS$CMSLIB'
.CMD~.CMD
	MMS$CMSLIB :== 'f$trnlnm("CMS$LIB")'
	IF "''MMS$CMSLIB'" .nes. "$(MMS$TARGET)" -
		THEN $(CMS) SET LIBRARY $(MMS$TARGET)
	$(CMS) FETCH $(MMS$SOURCE) $(CMSFLAGS) $(CMSCOMMENT)
	IF MMS$CMSLIB .EQS. "" THEN $(CMS) SET LIBRARY 1234
	IF MMS$CMSLIB .NES. "" .AND. MMS$CMSLIB .NES. "$(MMS$TARGET)" -
		THEN $(CMS) SET LIBRARY 'MMS$CMSLIB'
.ODL~.ODL
	MMS$CMSLIB :== 'f$trnlnm("CMS$LIB")'
	IF "''MMS$CMSLIB'" .nes. "$(MMS$TARGET)" -
		THEN $(CMS) SET LIBRARY $(MMS$TARGET)
	$(CMS) FETCH $(MMS$SOURCE) $(CMSFLAGS) $(CMSCOMMENT)
	IF MMS$CMSLIB .EQS. "" THEN $(CMS) SET LIBRARY 1234
	IF MMS$CMSLIB .NES. "" .AND. MMS$CMSLIB .NES. "$(MMS$TARGET)" -
		THEN $(CMS) SET LIBRARY 'MMS$CMSLIB'
.BLD~.BLD
	MMS$CMSLIB :== 'f$trnlnm("CMS$LIB")'
	IF "''MMS$CMSLIB'" .nes. "$(MMS$TARGET)" -
		THEN $(CMS) SET LIBRARY $(MMS$TARGET)
	$(CMS) FETCH $(MMS$SOURCE) $(CMSFLAGS) $(CMSCOMMENT)
	IF MMS$CMSLIB .EQS. "" THEN $(CMS) SET LIBRARY 1234
	IF MMS$CMSLIB .NES. "" .AND. MMS$CMSLIB .NES. "$(MMS$TARGET)" -
		THEN $(CMS) SET LIBRARY 'MMS$CMSLIB'

DO_RSTS :
	SET DEFAULT [.RSTS]
	CREATE/DIRECTORY []
	OPEN/WRITE OUTPUT $(MMS$TARGET_NAME).COM
	WRITE OUTPUT "$ CMS SET LIBRARY ",F$TRNLNM("CMS$LIB")
	WRITE OUTPUT "$ SET NOON"
	WRITE OUTPUT "$ SET DEFAULT ",F$ENVIRONMENT("DEFAULT")
	WRITE OUTPUT "$! IF F$SEARCH(""DESCRIP.MMS"") .EQS """" THEN CMS FETCH DESCRIP.MMS """""
	WRITE OUTPUT "$ MMS/CMS/MACRO=(""RSTS=1"",""CMSFLAGS=$(CMSFLAGS)"") ALL"
	WRITE OUTPUT "$ EXIT"
	CLOSE OUTPUT
	SUBMIT/LOG=[]/NOPRINT/NOTIFY/QUE=CMODE$BATCH $(MMS$TARGET_NAME).COM
	SET DEFAULT [-]

.FIRST
	@DISK$SOURCE:[MACRO.COMMAND]SETUP

.IFDEF	RSTS

RSXCOM	= 1
PRE = RST

!
! Description for building RSTS assembler
!

ALL : -		! Build ALL RSTS
	MACRST.OLB	,-
	MACBLDINI	,-
	MACRSTBLD.CMD	,-
	MACRSTBLD.ODL	,-
	MACBLDEXE
	! ALL Build completed.

MACRSTBLD.CMD : -
	MACBLD.BLD	,-
	CALMACBLD.CMD
	MACBLD = 1
	
MACRSTBLD.ODL : -
	MACBLD.BLD	,-
	CALMACBLD.CMD
	MACBLD = 1
	
MACRST.OLB : -
	MAC.OBS
	LIBR/RSX11/CREATE/NOGLOBAL MACRST.OLB MAC.OBS


RSTMAC.MLB : -		! RSTS system macro library
	RSXMAC.RST
	LIBR/RSX11/MACRO/CREATE=(MODULES:700) RSTMAC.MLB RSXMAC.RST

.ENDIF	!RSTS

.IFDEF	RSXCOM

!
! RSXCOM - Components common to RSX type assemblers for
!          RSX-11M/PLUS, IAS, RSTS, P/OS and VAX-11 RSX
!

MACBLDINI :		!Init logical for build of .CMD/.ODL files
	MACBLD = 0
	
MACBLDEXE :		!Make .CMD/.ODL files if .BLD file updated
	IF MACBLD .NE. 0 THEN ICM @CALMACBLD.CMD

MAC.OBS : -		!Common RSX type objects
	MACRO.OBJ,MROOT.OBJ,ASSEM.OBJ,CNDTL.OBJ,CODHD.OBJ,CRFFIL.OBJ	,-
	CRFIO.OBJ,DATDR.OBJ,ENBDS.OBJ,ENDLN.OBJ,ENDPS.OBJ,EXPRS.OBJ	,-
	FLOAT.OBJ,GETLN.OBJ,GMARG.OBJ,HSHPST.OBJ,INFIL.OBJ,INIDM.OBJ	,-
	INIFL.OBJ,INIVM.OBJ,INOFL.OBJ,ISDMP.OBJ,LISTC.OBJ,LSTNG.OBJ	,-
	MACROC.OBJ,MACROD.OBJ,MACRS.OBJ,MCALL.OBJ,MLIBS.OBJ,MPUSH.OBJ	,-
	MSCDR.OBJ,NDRCT.OBJ,OPTERR.OBJ,PACKED.OBJ,PROCSI.OBJ,PROPC.OBJ	,-
	PROSW.OBJ,PST.OBJ,READ.OBJ,REPT.OBJ,ROLHD.OBJ,R5UNP.OBJ		,-
	SCNLIB.OBJ,SECTR.OBJ,SETDIR.OBJ,SETDN.OBJ,SETIMM.OBJ,SETMX.OBJ	,-
	SPACE.OBJ,STMNT.OBJ,SYMBL.OBJ,VMRES.OBJ,WORDB.OBJ,WRITE.OBJ	,-
	GTKNM.OBJ,DATSUB.OBJ,INCLIB.OBJ,MACINI.OBJ
	COPY/NOLOG/CONCAT *.OBJ MAC.OBS

! Common RSX type .OBJ files

MACRO.OBJ : -		! Assembler root module
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	MPARAM.RSX	,-
	MCIOCH.MAC	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	MACRO.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+MPARAM.RSX+MCIOCH-
			    +GENMC+FLGDF+MACRO

MROOT.OBJ : -		! Assembler overlay root module
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	MPARAM.RSX	,-
	MCIOCH.MAC	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	MROOT.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+MPARAM.RSX+MCIOCH-
			    +GENMC+FLGDF+MROOT

MACINI.OBJ : -		! Assembler initialization module
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	MACINI.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+GENMC+FLGDF+MACINI

INCLIB.OBJ : -		! .INCLUDE directive support
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	MPARAM.RSX	,-
	MCIOCH.MAC	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	INCLIB.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+MPARAM.RSX+MCIOCH-
			    +GENMC+FLGDF+INCLIB

ASSEM.OBJ : -		! Mainline assembly driver
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	MPARAM.RSX	,-
	MCIOCH.MAC	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	ASSEM.RSX
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+MPARAM.RSX+MCIOCH-
			    +GENMC+FLGDF+ASSEM.RSX

CNDTL.OBJ : -		! Conditional assembly driver
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	CNDTL.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+GENMC+FLGDF+CNDTL

CODHD.OBJ : -		! Generated code driver
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	MPARAM.RSX	,-
	MCIOCH.MAC	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	CODHD.RSX
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+MPARAM.RSX+MCIOCH-
			    +GENMC+FLGDF+CODHD.RSX

CRFFIL.OBJ : -		! CREF file formatting subroutines
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	MCIOCH.MAC	,-
	GENMC.MAC	,-
	CRFFIL.RSX
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+MCIOCH-
			    +GENMC+CRFFIL.RSX

CRFIO.OBJ : -		! CREF file I/O subroutines
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	MCIOCH.MAC	,-
	CRFIO.RSX
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+MCIOCH+CRFIO.RSX

DATDR.OBJ : -		! Data directive subroutines
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	DATDR.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+GENMC+FLGDF+DATDR

ENBDS.OBJ : -		! .ENABLE/.DISABLE directive subroutines
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	ENBDS.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+GENMC+FLGDF+ENBDS

ENDLN.OBJ : -		! End of source line subroutines
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	MPARAM.RSX	,-
	MCIOCH.MAC	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	ENDLN.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+MPARAM.RSX+MCIOCH-
			    +GENMC+FLGDF+ENDLN

ENDPS.OBJ : -		! End of PASS subroutines
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	MCIOCH.MAC	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	ENDPS.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+MCIOCH-
			    +GENMC+FLGDF+ENDPS

EXPRS.OBJ : -		! Expression evaluation subroutines
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	MPARAM.RSX	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	EXPRS.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+MPARAM.RSX-
			    +GENMC+FLGDF+EXPRS

FLOAT.OBJ : -		! Floating point directive subroutines
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	FLOAT.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+GENMC+FLGDF+FLOAT

GETLN.OBJ : -		! Get source line subroutines
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	MPARAM.RSX	,-
	MCIOCH.MAC	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	GETLN.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+MPARAM.RSX+MCIOCH-
			    +GENMC+FLGDF+GETLN

GMARG.OBJ : -		! Get MACRO type argument subroutines
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	GMARG.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+GENMC+FLGDF+GMARG

INFIL.OBJ : -		! Input file subroutines
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	MPARAM.RSX	,-
	MCIOCH.MAC	,-
	GENMC.MAC	,-
	INFIL.RSX
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+MPARAM.RSX+MCIOCH-
			    +GENMC+INFIL.RSX

INIFL.OBJ : -		! Initialize input file I/O subroutines
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	MPARAM.RSX	,-
	MCIOCH.MAC	,-
	GENMC.MAC	,-
	INIFL.RSX
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+MPARAM.RSX+MCIOCH-
			    +GENMC+INIFL.RSX

INOFL.OBJ : -		! Initialize output file I/O subroutines
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	MPARAM.RSX	,-
	MCIOCH.MAC	,-
	GENMC.MAC	,-
	INOFL.RSX
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+MPARAM.RSX+MCIOCH-
			    +GENMC+INOFL.RSX

ISDMP.OBJ : -		! ISD object code generator subroutines
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	MPARAM.RSX	,-
	MCIOCH.MAC	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	ISDMP.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+MPARAM.RSX+MCIOCH-
			    +GENMC+FLGDF+ISDMP

LISTC.OBJ : -		! List directive subroutines
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	LISTC.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+GENMC+FLGDF+LISTC

LSTNG.OBJ : -		! .LIST file producer subroutines
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	MPARAM.RSX	,-
	MCIOCH.MAC	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	LSTNG.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+MPARAM.RSX+MCIOCH-
			    +GENMC+FLGDF+LSTNG

MACROC.OBJ : -		! MACRO call subroutines
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	MPARAM.RSX	,-
	GENMC.MAC	,-
	MACROC.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+MPARAM.RSX-
			    +GENMC+MACROC

MACROD.OBJ : -		! ???
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	GENMC.MAC	,-
	MACROD.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+GENMC+MACROD

MACRS.OBJ : -		! ??
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	MPARAM.RSX	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	MACRS.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+MPARAM.RSX-
			    +GENMC+FLGDF+MACRS

MCALL.OBJ : -		! .MCALL directive subroutines
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	MPARAM.RSX	,-
	GENMC.MAC	,-
	MCALL.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+MPARAM.RSX-
			    +GENMC+MCALL

MLIBS.OBJ : -		! MACRO library subroutines
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	MPARAM.RSX	,-
	MCIOCH.MAC	,-
	MLIBS.RSX
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+MPARAM.RSX-
			    +MCIOCH+MLIBS.RSX

MPUSH.OBJ : -		! MACRO context subroutines
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	GENMC.MAC	,-
	MPUSH.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+GENMC+MPUSH

MSCDR.OBJ : -		! Misc directive subroutines
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	MPARAM.RSX	,-
	MCIOCH.MAC	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	MSCDR.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+MPARAM.RSX-
			    +MCIOCH+GENMC+FLGDF+MSCDR

NDRCT.OBJ : -		! Repeat directive subroutines
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	NDRCT.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+GENMC+FLGDF+NDRCT

OPTERR.OBJ : -		! Option error handling subroutines
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	MPARAM.RSX	,-
	MCIOCH.MAC	,-
	OPTERR.RSX
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+MPARAM.RSX-
			    +MCIOCH+OPTERR.RSX

PACKED.OBJ : -		! .PACKED directive support
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	MPARAM.RSX	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	PACKED.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+MPARAM.RSX-
			    +GENMC+FLGDF+PACKED

PROCSI.OBJ : -		! CSI command processor
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	MPARAM.RSX	,-
	PROCSI.RSX
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+MPARAM.RSX-
			    +PROCSI.RSX

PROPC.OBJ : -		! ???
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	MPARAM.RSX	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	PROPC.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+MPARAM.RSX-
			    +GENMC+FLGDF+PROPC

PROSW.OBJ : -		! Process CSI switch subroutine
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	PROSW.RSX
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+GENMC+FLGDF+PROSW.RSX

PST.OBJ : -		! Permanent symbol table
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	PST.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+PST

HSHPST.OBJ : -		! Hash permanent symbol table subroutines
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	HSHPST.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+HSHPST

READ.OBJ : -		! File read subroutines
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	MPARAM.RSX	,-
	READ.RSX
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+MPARAM.RSX+READ.RSX

REPT.OBJ : -		! Repeat directive support
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	MPARAM.RSX	,-
	GENMC.MAC	,-
	REPT.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+MPARAM.RSX-
			    +GENMC+REPT

ROLHD.OBJ : -		! ???
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	ROLHD.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+GENMC+FLGDF+ROLHD

R5UNP.OBJ : -		! RAD50 unpack routines
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	R5UNP.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+GENMC+FLGDF+R5UNP

SCNLIB.OBJ : -		! Scan macro library subroutines
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	MPARAM.RSX	,-
	MCIOCH.MAC	,-
	GENMC.MAC	,-
	SCNLIB.RSX
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+MPARAM.RSX-
			    +MCIOCH+GENMC+SCNLIB.RSX

SECTR.OBJ : -		! ???
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	SECTR.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+GENMC+FLGDF+SECTR

SETDIR.OBJ : -		! ???
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	MPARAM.RSX	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	SETDIR.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+MPARAM.RSX-
			    +GENMC+FLGDF+SETDIR

SETDN.OBJ : -		! End of assembly processing
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	MPARAM.RSX	,-
	MCIOCH.MAC	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	SETDN.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+MPARAM.RSX-
			    +MCIOCH+GENMC+FLGDF+SETDN

SETIMM.OBJ : -		! ???
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	SETIMM.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+GENMC+FLGDF+SETIMM

SETMX.OBJ : -		! ??
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	SETMX.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+GENMC+FLGDF+SETMX

SPACE.OBJ : -		! ???
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	MPARAM.RSX	,-
	GENMC.MAC	,-
	SPACE.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+MPARAM.RSX-
			    +GENMC+SPACE

STMNT.OBJ : -		! Statement processing support
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	MPARAM.RSX	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	STMNT.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+MPARAM.RSX-
			    +GENMC+FLGDF+STMNT

SYMBL.OBJ : -		! Symbol handling subroutines
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	SYMBL.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+GENMC+FLGDF+SYMBL

WORDB.OBJ : -		! .WORD/.BYTE directive support
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	GENMC.MAC	,-
	WORDB.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+GENMC+WORDB

WRITE.OBJ : -		! Write file subroutines
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	MPARAM.RSX	,-
	MCIOCH.MAC	,-
	WRITE.RSX
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+MPARAM.RSX-
			    +MCIOCH+WRITE.RSX

VMRES.OBJ : -		! Reserve virtual memory subroutines
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	VMRES.RSX
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+GENMC+FLGDF+VMRES.RSX

INIVM.OBJ : -		! Initialize virtual memory subroutines
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	INIVM.RSX
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+GENMC+FLGDF+INIVM.RSX

INIDM.OBJ : -		! Initialize dynamic memory subroutines
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	GENMC.MAC	,-
	FLGDF.MAC	,-
	INIDM.RSX
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+GENMC+FLGDF+INIDM.RSX

GTKNM.OBJ : -		! Get task name
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	GTKNM.RSX
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+GTKNM.RSX

DATSUB.OBJ : -		! Date/time subroutines
	$(PRE)MAC.MLB	,-
	RSXPAR.$(PRE)	,-
	DATSUB.MAC
	MACRO/RSX11$(MFLAGS) RSXPAR.$(PRE)+DATSUB

.ENDIF	!RSXCOM

