;  DEC/CMS REPLACEMENT HISTORY, Element OPTERR.RSX
;  *3    18-AUG-1986 11:25:12 WORRALL "Complete HEX listing support for version 5.5 fieldtest"
;  *2    14-APR-1986 23:37:33 SYSTEM "Update 5.4 of MACRO-11"
;  *1    28-MAR-1986 02:42:10 SYSTEM "Load MACRO-11 sources from V5.3"
;  DEC/CMS REPLACEMENT HISTORY, Element OPTERR.RSX
	.NLIST							;Edit Level 01
	.ENABL	LC,GBL
	.LIST
	.TITLE	OPTERR - Output error messages to console
	.SBTTL	OPTERR - Output error messages to console
	.SBTTL
	.SBTTL		.IDENT	/V05.05/
	.SBTTL
	.IDENT	/V05.05/
;****************************************************************************
;*									    *
;*                   COPYRIGHT (c)  1983, 1986                              *
;*          BY DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.                *
;*                   ALL RIGHTS RESERVED.                                   *
;* 									    *
;*  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND  COPIED  *
;*  ONLY  IN  ACCORDANCE  WITH  THE  TERMS  OF  SUCH  LICENSE AND WITH THE  *
;*  INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR  ANY  OTHER  *
;*  COPIES  THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY  *
;*  OTHER PERSON.  NO TITLE TO AND OWNERSHIP OF  THE  SOFTWARE  IS  HEREBY  *
;*  TRANSFERRED.							    *
;* 									    *
;*  THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE  WITHOUT  NOTICE  *
;*  AND  SHOULD  NOT  BE  CONSTRUED  AS  A COMMITMENT BY DIGITAL EQUIPMENT  *
;*  CORPORATION.							    *
;* 									    *
;*  DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR  RELIABILITY  OF  ITS  *
;*  SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.		    *
;*									    *
;****************************************************************************


;++
;  Facility:	MACRO-11  The PDP-11 macro assembler for RT/RSX/VMS and RSTS/E
;
;    Author:	Too many people to list here
;
;   Created:	From the dust and dirt
;
;  Abstract:	OPTERR - Output error messages to console
;
;     Externals	 Description
;     ---------	 -----------
;
;      Edit	Who	Date		Description of modification
;      ----	---	----		---------------------------
;	001	Jrw	13-Jun-83	Correct odd-address trap.
;--


;	System Library "MCALLS"

	.MCALL	CLOSE$

.IF NDF	RSX11M

	.MCALL	DELET$

.ENDC

.IF NDF	YQCMO

	.MCALL	PUT$

.ENDC


	PURE	PUREI,I


;+
;
; *-$ERMSG-*-OUTPUT ERROR MESSAGES, CLEANUP OPEN FILES, AND RESTART
;		(CALLED ONLY BY VIRTUAL MEMORY ROUTINES)
;
; INPUT:
;	R1=(LOW BYTE) ERROR MESSAGE NUMBER
;
; OUTPUT:
;	AS DESCRIBED FOR CALL TO '$OPTER' BELOW
;
;-

$ERMSG::MOV	#CONT,(SP)	;++021 CHANGE RETURN ADDR TO RESTART
	MOV	#VIRTM1,R3	;++021 ASSUME ERROR IS E$R4
	CMPB	#E$R4,R1	;++021 CHECK ERROR NUMBER
	BEQ	$OPTER		;++021 IF EQ RIGHT
	MOV	#VIRTM2,R3	;++021 ASSUME ERROR IS E$R73
	CMPB	#E$R73,R1	;++021 CHECK ERROR NUMBER
	BEQ	$OPTER		;++021 IF EQ RIGHT
	MOV	#VIRTM3,R3	;++021 ELSE, ERROR IS E$R76


;++018
;
; *-$OPTER-*-OUTPUT ERROR MESSAGES TO 'CMO' AND CLEANUP FILES
;
; INPUT:
;	R3=ADDR OF ERROR MESSAGE BYTE COUNT (PRECEEDING ACTUAL TEXT)
;
; OUTPUT:
;	R1,R2=LOST
;	R3=SAVED
;	R4=ADDR OF GCML BLOCK
;
;--018

$OPTER::MOV	R3,R1		;++018 COPY MESSAGE ADDR INTO R1
	MOV	#CMLBLK,R4	;++018 PUT GCML BLOCK ADDR IN R4
	CALL	OUTERM		;++018 PRINT ERROR MESSAGE AND CMD LINE


.IF NDF	RSX11M		;++018

	CALL	DELALL		;++018 DELETE OUTPUT FILES

.ENDC			;++018


	CALLR	CLSALL		;++021 CLOSE ALL OPEN FILES AND RETURN


;
; **-$CMDER-INPUT COMMAND I/O ERROR
;
; THIS ROUTINE IS CALLED TO REPORT THE COMMAND I/O ERROR
; BECAUSE STANDARD ERROR MESSAGE REPORTING ALSO PRINTS
; A COPY OF THE COMMAND LINE AUTOMATICALLY.
;
 
$CMDER::MOV	#CMLM2,R1	;GET MESSAGE ADDRESS
;;;	MOVB	(R1)+,R2	;SET MESSAGE LENGTH
	BR	OUTERR		;FINISH UP IN COMMON CODE
 
;++005
;
; **-OUTERM-SEND ERROR MESSAGE AND COMMAND LINE TO CMO DEVICE
;
; INPUTS:
;	R1=ADDR OF ERROR MESSAGE BYTE COUNT (PRECEEDING MESSAGE)
;	R4=ADDRESS OF GCML BLOCK
;
; OUTPUTS:
;	- REGISTER CONTENTS UNIMPORTANT AFTER THIS CALL
;	- MESSAGE TEXT MOVED INTO LINSAV BECAUSE THE TEXT IS IN A READ-ONLY
;	  PSECT AND THE CORRECT TASK NAME IS PREFIXED TO IT
;
;--005

OUTERM::MOV	#OUTCMD,-(SP)	;Stack next routine address
OUTERR:	MOVB	(R1)+,R2	;PUT MESSAGE LENGTH IN R2 (R1 POINTS TO TEXT)   ; CD100
	MOV	#LINSAV,R0	;PUT BUFFER ADDRESS IN R0                       ; CD100

.IF	DF,R$RSTS	;IF RSTS/E
	MOVB	#'?,(R0)+	;Start error message with an "?"
.ENDC;	DF,R$RSTS	;IF RSTS/E

	MOVB	$MACPR+2,(R0)+	;PUT FIRST CHAR OF TASK NAME INTO BUFFER
	MOVB	$MACPR+3,(R0)+	;AND SECOND CHAR
	MOVB	$MACPR+4,(R0)+	;AND THIRD CHAR
10$:	MOVB	(R1)+,(R0)+	;MOVE MESSAGE INTO OUTPUT BUFFER                ; CD100
	DEC	R2		;DECREMENT MESSAGE BYTE COUNT                   ; CD100
	BNE	10$		;IF NE MORE MESSAGE LEFT                        ; CD100
	MOV	#LINSAV,R1	;PUT BUFFER ADDRESS IN R1                       ; CD100
	MOV	R0,R2		;Copy final resting point of buffer pointer
	SUB	R1,R2		;R2 = # Characters to print from LINSAV
;;;	MOVB	@(SP)+,R2	;PUT BYTE COUNT IN R2                           ; CD100
	CALL	OUTMSG		;++013 SEND MESSAGE TO CMO                      ;**-2
	TSTB	$PRTLN		;Should we print the contents of LINBUF?
	BEQ	20$		;Branch if not.
	MOV	#LINBUF,R1	;R1 -> Buffer to print.
	MOV	R1,R2		;Copy string adderss
15$:	TSTB	(R2)+		;End of string?
	BNE	15$		;Branch if not, keep looking.
	DEC	R2		;Account for zero byte.
	SUB	R1,R2		;Form count in R2
	CALL	OUTMSG		;Output the line.
20$:	RETURN			;Return to the caller.

;+
; OUTCMD
; This routine simply prints the command line found
; in the .GCML command line buffer.
;
;	R4	-> .GCML command block
;
;	Command line printed.
;-

OUTCMD:	MOV	G.CMLD+2(R4),R1	;++013 GET ADDR OF CMD LINE IN R1
	MOV	G.CMLD(R4),R2	;++005 BYTE COUNT IN R2
OUTER1:				;REF LABEL
	MOV	#EX$SEV,$EXSTS	;SET SEVERE ERROR STATUS

OUTMSG::			;++018


	.IF DF YQCMO		;++018


	CALLR	$QCMO		;++021 QUEUE I/O TO 'CMO' AND RETURN

	.IFF			;++013

	PUT$	#CMOFDB,R1,R2	;++018 PUT LINE TO 'CMO' VIA FCS
	RETURN			;++021

	.ENDC			;++013 'YQCMO'



;+
;
; **-CLSALL-CLOSE ALL OPEN FILES
; **-DELALL-DELETE OUTPUT FILES
;
; INPUTS/OUTPUTS: NONE
;
;-

	PURE	DPURE,D

CLOLST:	.BYTE	SRCCHN		;++021 SOURCE FILE
	.BYTE	SMLCHN		;++021 MACRO LIBRARY FILE
	.IF NDF	YQCMO		;++021
	.BYTE	CMOCHN		;++021 COMMAND OUTPUT FILE
	.ENDC			;++021


DELLST:	.BYTE	LSTCHN		;++021 LISTING FILE
	.BYTE	BINCHN		;++021 OBJECT FILE

	.IF NDF	XCREF		;++022
	.BYTE	CRFCHN		;++022 CREF FILE
	.ENDC			;++022

	.BYTE	-1		;++021 END-OF-LIST

	.EVEN			;++021


	PURE	PUREI,I

	.ENABL	LSB		;++021

CLSALL::MOV	#CLOLST,R1	;++021 POINT R1 TO LIST OF FILES
10$:	MOVB	(R1)+,R0	;++021 PUT SOFTWARE CHANNEL # IN R0
	BLT	20$		;++021 IF NEGATIVE, ALL DONE
	CMPB	IOFTBL(R0),#IO.OPN  ;++021 TEST FOR FILE OPEN
	BNE	10$		;++021 NO, IGNORE (CAN'T ARBITRARILY ...
				;++021 ... CLOSE DUE TO OVERLAYS)
	CLRB	IOFTBL(R0)	;++021 SET CHANNEL CLOSED STATUS
	MOV	FDBTBL(R0),R0	;++021 GET FDB IN R0
	CLOSE$	R0		;++021 CLOSE THE FILE
	BR	10$		;++021 REPEAT FOR ALL OPEN FILES
20$:	CLOSE$	$WRKPT		;++021 CLOSE WORK FILE
25$:	RETURN			;++021


	.IF NDF	RSX11M		;++021

DELALL::MOV	#DELLST,R1	;++021 POINT R1 TO OUTPUT FILES LIST
30$:	MOVB	(R1)+,R0	;++021 PUT SOFTWARE CHANNEL # IN R0
	BLT	25$		;++021 IF NEGATIVE, THEN DONE
	CLRB	IOFTBL(R0)	;++021 SET CHANNEL CLOSED STATUS
	MOV	FDBTBL(R0),R0	;++021 GET FDB ADDR IN R0
	BEQ	30$		;++021 IF NULL, CHANNEL NOT USED
	DELET$	R0		;++021 DELETE THE FILE
	BR	30$		;++021 REPEAT FOR ALL OUTPUT FILES

	.ENDC			;++021


	.DSABL	LSB		;++021


	.END
