C RT-11 SYSTEM ERROR LOGGING REPORT GENERATOR TASK
C
C SD
C
C DECEMBER, 1976
C
C DEC-11-ORTSB-A
C
C COPYRIGHT(C) 1976
C
C DIGITAL EQUIPMENT CORPORATION
C MAYNARD, MASSACHUSETTS 01754
C
C THIS SOFTWARE IS FURNISHED UNDER A LICENSE FOR USE ONLY ON A
C SINGLE COMPUTER SYSTEM AND MAY  BE   COPIED  ONLY  WITH  THE
C INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE,  OR
C ANY OTHER COPIES THEREOF, MAY NOT BE PROVIDED  OR  OTHERWISE
C MADE AVAILABLE TO ANY OTHER PERSON   EXCEPT FOR  USE ON SUCH
C SYSTEM AND TO ONE WHO AGREES TO THESE LICENSE  TERMS.  TITLE
C TO AND OWNERSHIP OF THE SOFTWARE SHALL AT ALL  TIMES  REMAIN
C IN DEC.
C
C THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT
C NOTICE AND SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL
C EQUIPMENT CORPORATION.
C
C DEC ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF
C ITS SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DEC.
C
C
C	MODULE:		SEQHEA
C
C
C	THIS ROUTINE CHECKS FOR MISSING ENTRIES.  IF ANY HAVE
C	OCCURRED, A MESSAGE IS PRINTED STATING THE NUMBER
C	MISSING AND THE REASON WHY (IE-REGISTER BUFFER OVER-
C	WRITTEN OR SYE UNABLE TO PROCESS)
C
	SUBROUTINE SEQNUM
	INTEGER*4 MCRWL4(6)
	LOGICAL*1 STARS(60)
	INTEGER*2 RECORD(55),PREDAT(6),ENTNUM,NCOUNT(13),NSHARD(48)
	REAL MCRWLR(6)
	COMMON RECORD,NCOUNT,NSHARD,NPAGE,LEFT,NPRINT,LREP,STARS,
	1 MCRWLR,MCRWL4
	COMMON /SEQNU/LERSEQ,ENTNUM,LENTNO,PREDAT
C	FOR TWO LINES OF STARS FOR A PRINTED MESSAGE
	LSTAR=0
C	MAXIMUM NUMBER OF LINES FOR A MESSAGE
	NPRINT=8
	IF(ENTNUM.EQ.1) GO TO 150
C	CHECK TO SEE IF THE ERROR SEQUENCE NUMBER HAS BEEN
C	RE-INITIALIZED TO 1,  BY COMPARING THE DATE OF THE 
C	CURRENT ENTRY WITH THE DATE OF THE PREVIOUS ENTRY
	DO 100 I=1,6
	IF(PREDAT(I).NE.RECORD(I+2)) LERSEQ=1
100	CONTINUE
C	SAVE THE PREVIOUS DATE
150	DO 175 I=1,6
175	PREDAT(I)=RECORD(I+2)
C	DETERMINE THE NUMBER OF ENTRIES THAT SYE COULD NOT PROCESS,
C	IF ANY
	MSENTY=ENTNUM-LENTNO
C	DETERMINE THE NUMBER OF ENTRIES THAT ARE MISSING, IF ANY
	MSESEQ=RECORD(9)-LERSEQ
	IF(MSESEQ.LT.MSENTY) MSESEQ=MSENTY
C	ADD NUMBER OF MISSING ENTRIES, IF ANY, TO MISSING ENTRY
C	COUNT
	NCOUNT(2)=NCOUNT(2)+MSESEQ
	IF(LREP.EQ.0) GO TO 450
	IF(MSENTY.EQ.0) NPRINT=6
	IF(MSENTY.EQ.MSESEQ) NPRINT=NPRINT-1
C	RETURN, IF THERE ARE NO MISSING ENTRIES; OTHERWISE, PRINT
C	APPROPRIATE MESSAGE
	IF(NPRINT.EQ.5)  GO TO 450
	CALL LINE1
	WRITE(6,250)
250	FORMAT(1X//)
300	WRITE(6,350) STARS
350	FORMAT(1X,60A1)
	IF(LSTAR.EQ.1) GO TO 450
	WRITE(6,375) MSESEQ
375	FORMAT(' SOURCE FILE MISSING',I6,'.',1X,'RECORDS')
	IF(NPRINT.EQ.6) GO TO 430
	WRITE(6,425) LENTNO,ENTNUM-1,MSENTY
425	FORMAT(' ENTRY NUMBERS',I6,'.',1X,'THRU',I6,'.'/
	1 ' SYE COULD NOT PROCESS',I6,'.',' RECORDS')
	IF(NPRINT.NE.8) GO TO 445
430	WRITE(6,440) MSESEQ-MSENTY
440	FORMAT(' REGISTER BUFFER OVERWRITTEN OR LOCKED FOR',I6,
	1 '.',' RECORDS')
445	LSTAR=1
	GO TO 300
450	LERSEQ=RECORD(9)+1
	LENTNO=ENTNUM+1
	RETURN
	END
C	THIS ROUTINE PRINTS THE FIRST FOUR LINES IN THE HEADING OF
C	A REPORT.  THIS INCLUDES:
C	BLANK LINE
C	BLANK LINE
C	LINE OF STARS
C	LINE DESCRIBING ENTRY TYPE
C
	SUBROUTINE HEADNG
	INTEGER*4 MCRWL4(6)
	LOGICAL*1 STARS(60)
	INTEGER*2 DCLASS,RECORD(55),NCOUNT(13),NSHARD(48)
	REAL CLASS(2)
	DATA CLASS/'DISK','TAPE'/
	COMMON RECORD,NCOUNT,NSHARD,NPAGE,LEFT,NPRINT,LREP,STARS,
	1 MCRWLR,MCRWL4
	COMMON /HEA/DCLASS
	CALL LINE1
C	PRINT TWO BLANK LINES AND LINE OF STARS
	WRITE(6,300) STARS
300	FORMAT(1X//,1X,60A1)
C	DEPENDING ON ENTRY TYPE, GO TO PRINT APPROPRIATE MESSAGE ON
C	NEXT LINE
	GO TO (370,370,350,400,390) DCLASS
350	WRITE(6,360)
360	FORMAT(' MEMORY PARITY ERROR')
	GO TO 450
370	WRITE(6,380) CLASS(DCLASS)
380	FORMAT(1X,A4,' DEVICE ERROR')
	GO TO 450
390	WRITE(6,395)
395	FORMAT(' MEMORY STATISTICS')
	GO TO 450
400	WRITE(6,420)
420	FORMAT(' DEVICE STATISTICS')
450	RETURN
	END
C	THIS ROUTINE SAVES THE DATES OF THE FIRST AND LAST ENTRIES
C	AND PRINTS THE LAST THREE LINES IN THE HEADING OF A REPORT.
C	THIS INCLUDES:
C	LINE CONTAINING DD-MMM-YY HH:MM:SS THAT ENTRY WAS LOGGED
C	LINE CONTAINING ENTRY NUMBER
C	LINE OF STARS
C
	SUBROUTINE DATTIM
	INTEGER*4 MCRWL4(6)
	INTEGER*2 RECORD(55),HIGH(4),LOW(4),NDATE(16),NREC(2),ENTNUM,
	1 NCOUNT(13),NSHARD(48),ENTTYP,PREDAT(6)
	REAL MON(13),NMONTH(2),MONTH,MCRWLR(6),SUMRW(24)
	LOGICAL*1 STARS(60)
	DATA MON/'***-','JAN-','FEB-','MAR-','APR-','MAY-','JUN-',
	1 'JUL-','AUG-','SEP-','OCT-','NOV-','DEC-'/
	COMMON RECORD,NCOUNT,NSHARD,NPAGE,LEFT,NPRINT,LREP,STARS,
	1 MCRWLR,MCRWL4
	COMMON /NAM1/NDATE,NMONTH,NREC,IFLAG,JFLAG,LFLAG,
	1 ENTTYP,SUMRW
	COMMON /SEQNU/LERSEQ,ENTNUM,LENTNO,PREDAT
	COMMON /SEQNU1/KFLAG
C	GET ASCHII MONTH
	DO 390 I=1,13
	IF(RECORD(4).EQ.(I-1)) MONTH=MON(I)
390	CONTINUE
C	GET DAY, HOUR, MINUTE, SECOND, WITH LEADING ZEROS, IF ANY
	DO 400 I=5,8
	HIGH(I-4)=RECORD(I)/10
	LOW(I-4)=RECORD(I)-10*HIGH(I-4)
400	CONTINUE
	IF(IFLAG.NE.1.AND.IFLAG.NE.0) GO TO 407
C	COME HERE TO SAVE THE DATE AND TIME OF THE FIRST AND LAST
C	ENTRIES (FOR THE SUMMARY REPORT)
C	SAVE ASCHII MONTH
	NMONTH(IFLAG+1)=MONTH
C	SAVE YEAR
	NREC(IFLAG+1)=RECORD(3)
C	SAVE DAY, HOUR, MINUTE, SECOND
	DO 405 I=1,4
	NDATE(2*I-1+8*IFLAG)=HIGH(I)
405	NDATE(2*I+8*IFLAG)=LOW(I)
	IF(IFLAG.EQ.1) GO TO 420
	IF(IFLAG.EQ.0) IFLAG=2
	IF(KFLAG.EQ.1) GO TO 420
407	IF(LREP.EQ.0) GO TO 420
	WRITE(6,410) HIGH(1),LOW(1),MONTH,RECORD(3),
	1 (HIGH(I),LOW(I),I=2,4),ENTNUM,STARS
410	FORMAT(' LOGGED',1X,2I1,'-',A4,I2,1X,2I1,':',2I1,':',
	1 2I1/' ENTRY NUMBER',I6,'.'/1X,60A1)
420	RETURN
	END
                                    