
C	SYSGEN.FOR V02-07
C
C	COPYRIGHT (C) 1977,1978
C	DIGITAL EQUIPMENT CORPORATION
C
C	THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
C	ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE
C	INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER
C	COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO 
C	ANY OTHER PERSON.  NO TITLE TO  AND OWNERSHIP OF THE SOFTWARE IS
C	HEREBY TRANSFERRED.
C
C	THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE
C	AND SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT
C	CORPORATION.
C
C	DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
C	SOFTWARE  ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.
C
C	R. BEAN     23-JAN-78  9:17
C	MODELLED AFTER A PROGRAM BY HANK MAURER
C
C
C
	IMPLICIT INTEGER*2(A-Z)
	COMMON ANSWER,VAR,LINE,COND,INCLUD
	COMMON SUBNAM,VALUE,CARRY,SUBFLG
	COMMON PATERN,REPLAC,PATLEN,REPLEN
	COMMON LEVEL,NXTVAR,NUMSUB,LPTR
	COMMON VARLEN,NUMVAR,LNLENG,VIDX
	COMMON INSERT,FIRST,I,J,K,II,JJ,KK,III
	COMMON CMDS,FILE,IN,OUT,INS,LASTLN,LSTLEN
	LOGICAL*1 ANSWER(100,10),VAR(100,6),LINE(100),CMDS(6,17),FIRST,
     1  COND(11),INCLUD(11),SUBNAM(6),PATERN(5,30),REPLAC(5,30),
     1  FILE(12),INSERT,SUBFLG,CARRY,LASTLN(100)
	REAL VALUE(100)
	INTEGER PATLEN(5),REPLEN(5)
C
C	INITIALIZE THE VARIOUS DATA AND CONSTANT ARRAYS
C
	DATA LEVEL,NXTVAR,NUMSUB/1,1,0/
	DATA ANSWER,VAR,VALUE/1000*0,600*0,100*0./
	DATA IN,OUT,INS,LNLENG/1,2,3,1/
C	CHANGE FOLLOWING TO CHANGE SCRIPT FILE NAME.
	DATA FILE/'S','Y','S','G','E','N','.','C','N','D',0,0/
	DATA CMDS/
     1  'A','S','K',0,0,0,
     1  'C','A','L','L',0,0,
     1  'D','E','C','R',0,0,
     1  'E','N','D','C',0,0,
     1  'E','N','D','S',0,0,
     1  'E','X','I','T',0,0,
     1  'F','I','L','E',0,0,
     1  'I','F',0,0,0,0,
     1  'I','F','F',0,0,0,
     1  'I','F','G','T',0,0,
     1  'I','F','N',0,0,0,
     1  'I','F','T',0,0,0,
     1  'I','F','T','F',0,0,
     1  'N','A','M','E',0,0,
     1  'P','R','I','N','T',0,
     1  'S','E','T',0,0,0,
     1  'S','U','B','S',0,0/
	DATA SUBNAM/'*','N','O','N','E','*'/
	DATA INSERT,FIRST/.FALSE.,.TRUE./
	DATA INCLUD/.TRUE.,10*0/
	DATA COND/.TRUE.,10*0/
C
C	INITIALIZE OPERATING VARIABLES
C
	VARLEN=6			!NUMBER OF CHARACTERS IN VARIABLES
	NUMVAR=100			!NUMBER OF VARIABLES
C
C	OPEN THE SCRIPT FILE
C
	CALL ASSIGN(IN,FILE)
C
C	MAIN COMMAND LOOP
C	AFTER PRESERVING PREVIOUS LINE IN LASTLN,
C	IF NOT INSERTING FROM SECONDARY SCRIPT FILE,
C	READ LINE FROM PRIMARY SCRIPT FILE
C
100	DO 105 I=1,LNLENG
105	LASTLN(I)=LINE(I)		!PRESERVE PREVIOUS COMMAND LINE
	LSTLEN=LNLENG			!REMEMBER LENGTH OF PREV LINE
C
C	NOW READ FROM PRIMARY SCRIPT
C
	IF(.NOT.INSERT)
     1  READ(IN,80000,END=90000,ERR=91000)LNLENG,(LINE(I),I=1,LNLENG)
C
C	OTHERWISE READ FROM SECONDARY SCRIPT FILE
C
	IF(INSERT)READ(INS,80000,END=90010,ERR=91010)LNLENG,(LINE(I),I=1,LNLENG)
C
C	IF COMMENT LINE, IGNORE IT
C
	IF(LINE(1).EQ.';')GOTO 100
C
C	IF LINE BEGINS WITH A FORM FEED, IGNORE THE FORM FEED
C
	IF(LINE(1).NE."14)GOTO 200
	DO 110 I=2,LNLENG
110	LINE(I-1)=LINE(I)			!SLIDE CHARS UP, OVER FORMF
	LNLENG=LNLENG-1
C
C	IF SUBSTITUTION NOT ENABLED, PROCEED TO COMMAND DISPATCH
C
200	IF(NUMSUB.EQ.0)GOTO 350
C
C	SUBSTITUTION LOOP
C	PERFORM SUBSTITUTIONS BEFORE PROCESSING LINE
C
	DO 300 I=1,NUMSUB
	II=1
C
C	IF LINE SCAN FINISHED, PROCEED TO NEXT I
C
210	IF(II+PATLEN(I)-1.GT.LNLENG)GOTO 300
C
C	SCAN LINE FOR A PATTERN MATCH
C
	DO 220 J=1,PATLEN(I)
	III=II+J-1
	IF(LINE(III).NE.PATERN(I,J))GOTO 280
220	CONTINUE
	K=PATLEN(I)-REPLEN(I)			!K=LENGTH DIFF BETWEEN PATERN AND REPLACEMENT
C
C	DETERMINE IF THERE IS ENOUGH ROOM IN LINE FOR REPLACEMENT
C
	IF(K)230,240,250
C
C	IF REPLACEMENT LARGER THAN PATTERN, SLIDE LINE RIGHT TO MAKE ROOM
C
230	DO 235 J=1,LNLENG-III
235	LINE(LNLENG-K+1-J)=LINE(LNLENG+1-J)
240	IF(REPLEN(I).LE.0)GOTO 248		!IF REPLACEMENT NULL, JUST COLLAPSE LINE
C
C	OTHERWISE REPLACE PATTERN WITH REPLACEMENT
C
	DO 245 J=1,REPLEN(I)
245	LINE(II+J-1)=REPLAC(I,J)
248	LNLENG=LNLENG-K				!SHORTEN LINE LENGTH BY PATTERN/REPLACEMENT DIFFERENCE
	II=II+REPLEN(I)
	GOTO 290
C
C	COLLAPSE LINE TO MAKE PATTERN LENGTH=REPLACEMENT LENGTH
C
250	DO 255 J=III+1,LNLENG
255	LINE(J-K)=LINE(J)
	GOTO 240				!NOW REPLACE PATTERN
280	II=II+1					!START ONE CHAR TO RIGHT
290	IF(II.LE.LNLENG)GOTO 210		!AND LOOP
300	CONTINUE
350	LINE(LNLENG+1)=0				!MAKE SURE LINE STRING ZERO-TERMINATED
C
C	COMMAND DISPATCHER
C	IF LINE DOES NOT BEGIN WITH A <TAB>#, WRITE IT TO OUTPUT FILE
C
	IF(LINE(1).NE."11.OR.LINE(2).NE.'#')GOTO 450	!"11 IS A TAB
C
C	FIND THE COMMAND
C
	DO 410 I=1,17
	DO 400 J=1,6
	IF(CMDS(J,I).EQ.0.AND.(LINE(J+2).EQ.0.OR.LINE(J+2).EQ."11))  !"11 IS A TAB
     1  GOTO 500				!COMMAND FOUND - CALL COMMAND SUBROUTINE
	IF(LINE(J+2).NE.CMDS(J,I))GOTO 410
400	CONTINUE
410	CONTINUE
C
C	COMMAND NOT FOUND - PRINT ERROR MESSAGE
C
	CALL EPRINT(6)				!SYSGEN-F-UNDEFINED COMMAND
	GOTO 100
C
C	LINE NOT A COMMAND LINE - WRITE IT TO OUTPUT FILE
C
450	IF(INCLUD(LEVEL))WRITE(OUT,80010,END=90020,ERR=90020)(LINE(I),I=1,LNLENG)
	GOTO 100
C
C	COMMAND SUBROUTINE CALLS
C
500	GOTO(501,502,503,504,505,506,507,508,509,510,511,512,513,514,515,516,517)I
501	CALL ASK
	GOTO 100
502	CALL CALLF
	GOTO 100
503	CALL DECR
	GOTO 100
504	CALL ENDC
	GOTO 100
505	CALL ENDS
	GOTO 100
506	CALL EXITS
	GOTO 100
507	CALL FILES
	GOTO 100
508	CALL IF0
	GOTO 100
509	CALL IFF
	GOTO 100
510	CALL IFGT
	GOTO 100
511	CALL IFN
	GOTO 100
512	CALL IFT
	GOTO 100
513	CALL IFTF
	GOTO 100
514	CALL NAME
	GOTO 100
515	CALL PRINT0
	GOTO 100
516	CALL SET
	GOTO 100
517	CALL SUB
	GOTO 100
C
C	FORMAT STATEMENTS FOR COMMAND ROTUINE
C
80000	FORMAT(Q,100A1)			!FOR SCRIPT READS
80010	FORMAT(100A1)			!FOR OUTPUT WRITES
C
C	ERROR PROCESSING ROUTINES FOR I/O STATEMENTS
C
90000	CALL CLOSE(IN)			!EOF FOR PRIMARY INPUT FILE
	IF(.NOT.FIRST)CALL CLOSE(OUT)
	GOTO 99000
90010	INSERT=.FALSE.			!EOF FOR SECONDARY INPUT FILE
	CALL CLOSE(INS)
	GOTO 100
90020	CALL EPRINT(17)			!?SYSGEN-F-OUTPUT ERROR
	GOTO 99000
91000	CALL EPRINT(18)			!?SYSGEN-F-INPUT ERROR
	GOTO 99000
91010	CALL EPRINT(16)			!?SYSGEN-F-INSERT ERROR
99000	CALL EXIT
	END


	SUBROUTINE ASK
	IMPLICIT INTEGER*2(A-Z)
	COMMON ANSWER,VAR,LINE,COND,INCLUD
	COMMON SUBNAM,VALUE,CARRY,SUBFLG
	COMMON PATERN,REPLACE,PATLEN,REPLEN
	COMMON LEVEL,NXTVAR,NUMSUB,LPTR
	COMMON VARLEN,NUMVAR,LNLENG,VIDX
	COMMON INSERT,FIRST,I,J,K,II,JJ,KK,III
	COMMON CMDS,FILE,IN,OUT,INS,LASTLN,LSTLEN
	LOGICAL*1 ANSWER(100,10),VAR(100,6),LINE(100),CMDS(6,17),FIRST,
     1  COND(11),INCLUD(11),SUBNAM(6),PATERN(5,30),REPLAC(5,30),
     1  FILE(12),INSERT,SUBFLG,CARRY,LASTLN(100)
	REAL VALUE(100)
	INTEGER PATLEN(5),REPLEN(5)
	LOGICAL*1 HIVAL(10),LOWVAL(10),ALINE(80),YES(4),NO(3)
	REAL RTMP1
	DATA YES/'Y','E','S',0/,NO/'N','O',0/
C
C	ROUTINE TO PROCESS ASK COMMAND
C	<TAB>#ASK<TAB>QUESTION?VARIABLE/T=DEF[,LOWLIM[,HILIM]]
C
	IF(.NOT.INCLUD(LEVEL))GOTO 1000		!IF CONDITIONAL OFF, DON'T DO
C
C	FIND QUESTION MARK AT END OF QUESTION
C
5	DO 10 LPTR=7,LNLENG
	IF (LINE(LPTR).EQ.'?')GOTO 20
10	CONTINUE
15	CALL EPRINT(5)				!?SYSTEN-F-BAD #ASK IN
	GOTO 1000
C
C	TYPE THE QUESTION ON THE TERMINAL
C
20	I=7					!QUESTION STARTS IN CHAR POSITION 7
	IF(LINE(I).EQ.'-')I=I+1			!SKIP OVER CONTINUATION MARK IF PRESENT
	WRITE(5,80000)(LINE(J),J=I,LPTR),"40	!"40 IS A SPACE
	IF(LNLENG.EQ.LPTR)GOTO 15		!IF NO VARIABLE SPECIFIED
C
C	FIND THE VARIABLE INDEX
C
	LPTR=LPTR+1				!SPACE LPTR PAST ?
	CALL FNDVAR(0)				!SETS VIDX FOR VARIABLE, MOVES  LPTR TO CHAR FOLLOWING
	IF(CARRY.EQ.1)GOTO 1000
	VALUE(VIDX)=0				!SET VALUE TO 0
C
C	ENSURE ANSWER TYPE SPECIFIED
C
	IF(LINE(LPTR).NE.'/')GOTO 15
	LPTR=LPTR+1				!ADVANCE PAST "/"
C
C	SET FLAG DEPENDING ON ANSWER TYPE
C
	ATYPE=0
	IF(LINE(LPTR).EQ.'A')ATYPE=1		!DEVICE NAME ANSWER
	IF(LINE(LPTR).EQ.'O')ATYPE=2		!OCTAL ANSWER
	IF(LINE(LPTR).EQ.'D')ATYPE=3		!DECIMAL ANSWER
	IF(LINE(LPTR).EQ.'Y')ATYPE=4		!YES/NO ANSWER
	IF(ATYPE.EQ.0)GOTO 15			!ILLEGAL TYPE CODE
	LPTR=LPTR+1				!ADVANCE PAST TYPE CODE
C
C	ENSURE DEFAULT PRESENT
C
	IF(LINE(LPTR).NE.'=')GOTO 15
	LPTR=LPTR+1				!ADVANCE PAST "="
	IF(LINE(LPTR).EQ.0)GOTO 15		!NOTHING FOLLOWING "=" IS AN ERROR
C
C	COPY THE DEFAULT INTO ANSWER
C
	II=1
	DO 30 K=LPTR,LNLENG
	IF(LINE(K).EQ.',')GOTO 35
	IF(II.GT.9)GOTO 15			!DEFAULT TOO LONG
	ANSWER(VIDX,II)=LINE(K)
30	II=II+1
C
C	PARSE LOW LIMIT
C
35	LPTR=K
	LVCNT=0
	IF(LINE(LPTR).EQ.0)GOTO 100		!NO RANGE VALUES
	LPTR=LPTR+1				!STEP PAST COMMA
	IF(LINE(LPTR).EQ.',')GOTO 15		!NO LO VALUE IS AN ERROR
	DO 40 K=LPTR,LNLENG			!COPY LOWVAL
	IF(LINE(K).EQ.',')GOTO 45
	IF(LVCNT.GT.9)GOTO 15
	LVCNT=LVCNT+1
	LOWVAL(LVCNT)=LINE(K)
40	CONTINUE
C
C	PARSE HI LIMIT
C
45	HVCNT=0
	LPTR=LPTR+LVCNT
	IF(LINE(LPTR).EQ.0)GOTO 100		!NO HIGH VALUE
	LPTR=LPTR+1				!STEP PAST COMMA
C
C	COPY HIGH LIMIT TO HIVAL
C
	DO 50 K=LPTR,LNLENG
	IF(HVCNT.GT.9)GOTO 15
	HVCNT=HVCNT+1
	HIVAL(HVCNT)=LINE(K)
50	CONTINUE
C
C	GET USER'S ANSWER
C
100	READ(5,80010)ALLENG,(ALINE(K),K=1,ALLENG)
	ALINE(ALLENG+1)=0			!MAKE SURE ANSWER STRING 0 TERMINATED
C
C	IF NO RESPONSE, USE DEFAULT
C
	IF(ALLENG.EQ.0)GOTO 1000
	IF(ALLENG.GT.9)GOTO 400			!ANSWER TOO LONG
C
C	CHECK ANSWER FOR TYPE VALIDITY
C
	GOTO(200,250,300,350)ATYPE
C
C	ROUTINE TO CHECK ANSWER FOR ALPHA DEV NAME
C
200	IF(ALLENG.GT.3)GOTO 400			!ANSWER TOO LONG FOR DEV NAME
	DO 210,I=1,2
	IF(ALINE(I).LT.'A')GOTO 400
210	IF(ALINE(I).GT.'Z')GOTO 400
	IF(ALINE(3).EQ.0)GOTO 500
	IF(ALINE(3).LT.'0')GOTO 400
	IF(ALINE(3).GT.'7')GOTO 400
	GOTO 500
C
C	ROUTINE TO CHECK ANSWER FOR OCTAL VALUE
C
250	DO 260 I=1,9
	IF (ALINE(I).EQ.0)GOTO 450
	IF(ALINE(I).LT.'0')GOTO 400
260	IF(ALINE(I).GT.'7')GOTO 400
	GOTO 450
C
C	ROUTINE TO CHECK ANSWER FOR DECIMAL VALUE
C
300	DO 310 I=1,9
	IF (ALINE(I).EQ.0)GOTO 450
	IF(ALINE(I).LT.'0')GOTO 400
310	IF(ALINE(I).GT.'9')GOTO 400
	GOTO 450
C
C	ROUTINE TO CHECK ANSWER FOR YES/NO
C
350	DO 355 I=1,ALLENG			!TEST FOR N OR NO ANSWER
355	IF(ALINE(I).NE.NO(I))GOTO 360
	GOTO 500				!ANSWER WAS A VALID NO
360	DO 365 I=1,ALLENG			!TEST FOR Y OR YE OR YES ANSWER
365	IF(ALINE(I).NE.YES(I))GOTO 400
	GOTO 500				!ANSWER WAS A VALID YES
C
C	VALIDITY CHECK FAILED - TYPE ERROR MESSAGE
C	AND RETRY
C
400	CALL EPRINT(1)				!SYSGEN-F-INVALID ANSWER;RETRY
410	IF(LINE(7).NE.'-')GOTO 5		!IF NOT 2 LINE ASK,JUST REPROCESS COMMAND
	WRITE(5,80030)(LASTLN(J),J=9,LSTLEN)	!2 LINE ASK-ASSUME PREVIOUS LINE
C						!WAS A #PRINT AND REPRINT IT
	GOTO 5					!RESTART QUESTION
C
C	ROUTINE TO CHECK IF OCTAL OR DECIMAL ANSWER FALLS IN RANGE
C	AND STORE VALUE FOR VARIABLE
C
450	IF(LVCNT.EQ.0)GOTO 500			!NO LIMITS AVAILABLE
	DECODE(LVCNT,80020,LOWVAL)RTMP1		!LOW VALUE TO TEMPORARY
	DECODE(ALLENG,80020,ALINE)VALUE(VIDX)	!ANSWER VALUE
	IF(VALUE(VIDX)-RTMP1)455,460,460	!ANSWER - LOW LIMIT
455	CALL EPRINT(2)				!SYSGEN-F-ANSWER TOO SMALL
	GOTO 410				!RESTART QUESTION
460	IF(HVCNT.EQ.0)GOTO 500			!NO HILIMIT AVAL
	DECODE(HVCNT,80020,HIVAL)RTMP1		!HI VALUE CONVERSION
	IF(VALUE(VIDX)-RTMP1)500,500,465	!ANSWER - HI LIMIT
465	CALL EPRINT(3)				!SYSGEN-F-ANSWER TOO LARGE
	GOTO 410				!RETRY
C
C	ANSWER IS ACCEPTABLE - STORE IT FOR VARIABLE
C
500	DO 510 K=1,ALLENG
510	ANSWER(VIDX,K)=ALINE(K)
	ANSWER(VIDX,K+1)=0
C
C	ROUTINE FINISHED - RETURN
C
1000	RETURN
C
C	FORMAT STATEMENTS FOR ASK ROUTINE
C
80000	FORMAT('$',72A1)
80010	FORMAT(Q,80A1)
80020	FORMAT(F9.0)
80030	FORMAT(1X,100A1)
	END

	SUBROUTINE CALLF
	IMPLICIT INTEGER*2(A-Z)
	COMMON ANSWER,VAR,LINE,COND,INCLUD
	COMMON SUBNAM,VALUE,CARRY,SUBFLG
	COMMON PATERN,REPLAC,PATLEN,REPLEN
	COMMON LEVEL,NXTVAR,NUMSUB,LPTR
	COMMON VARLEN,NUMVAR,LNLENG,VIDX
	COMMON INSERT,FIRST,I,J,K,II,JJ,KK,III
	COMMON CMDS,FILE,IN,OUT,INS,LASTLN,LSTLEN
	LOGICAL*1 ANSWER(100,10),VAR(100,6),LINE(100),CMDS(6,17),FIRST,
     1  COND(11),INCLUD(11),SUBNAM(6),PATERN(5,30),REPLAC(5,30),
     1  FILE(12),INSERT,SUBFLG,CARRY,LASTLN(100)
	REAL VALUE(100)
	INTEGER PATLEN(5),REPLEN(5)
C
C	SUBROUTINE TO PROCESS CALL COMMAND
C	<TAB>#CALL<TAB>FILNAM.EXT
C
	IF(.NOT.INCLUD(LEVEL))GOTO 1000			!CONDITIONAL OFF
	IF(LNLENG.GE.10)GOTO 10
	CALL EPRINT(9)					!SYSGEN-W-MISSING FILE NAME
	GOTO 1000
10	IF(.NOT.INSERT)GOTO 20				!MAKE SURE NOT ALREADY IN SEC. SCRIPT
	CALL EPRINT(10)					!SYSGEN-W-NESTED #CALL?
	GOTO 1000
20	INSERT=.TRUE.
	CALL ASSIGN(INS,LINE(8))
C
C	COMMAND DONE
C
1000	RETURN
	END
	SUBROUTINE DECR
	IMPLICIT INTEGER*2(A-Z)
	COMMON ANSWER,VAR,LINE,COND,INCLUD
	COMMON SUBNAM,VALUE,CARRY,SUBFLG
	COMMON PATERN,REPLAC,PATLEN,REPLEN
	COMMON LEVEL,NXTVAR,NUMSUB,LPTR
	COMMON VARLEN,NUMVAR,LNLENG,VIDX
	COMMON INSERT,FIRST,I,J,K,II,JJ,KK,III
	COMMON CMDS,FILE,IN,OUT,INS,LASTLN,LSTLEN
	LOGICAL*1 ANSWER(100,10),VAR(100,6),LINE(100),CMDS(6,17),FIRST,
     1  COND(11),INCLUD(11),SUBNAM(6),PATERN(5,30),REPLAC(5,30),
     1  FILE(12),INSERT,SUBFLG,CARRY,LASTLN(100)
	REAL VALUE(100)
	INTEGER PATLEN(5),REPLEN(5)
C
C	SUBROUTINE TO PROCESS DECR COMMAND
C	<TAB>#DECR<TAB>VARIABLE
C
	IF(.NOT.INCLUD(LEVEL))GOTO 1000			!MAY BE CONDITIONALIZED OUT
	IF(LNLENG.GE.8)GOTO 10				!MAKE SURE CONDITIONAL NAMED
	CALL EPRINT(11)					!SYSGEN-W-MISSING CONDITIONAL IN
	GOTO 1000
10	LPTR=8
	CALL FNDVAR(1)					!FIND VARIABLE
	IF(CARRY.EQ.1)GOTO 1000				!VARIABLE NOT THERE
	VALUE(VIDX)=VALUE(VIDX)-1.			!DECREMENT VALUE
C
C	COMMAND DONE
C
1000	RETURN
	END
	SUBROUTINE ENDC
	IMPLICIT INTEGER*2(A-Z)
	COMMON ANSWER,VAR,LINE,COND,INCLUD
	COMMON SUBNAM,VALUE,CARRY,SUBFLG
	COMMON PATERN,REPLAC,PATLEN,REPLEN
	COMMON LEVEL,NXTVAR,NUMSUB,LPTR
	COMMON VARLEN,NUMVAR,LNLENG,VIDX
	COMMON INSERT,FIRST,I,J,K,II,JJ,KK,III
	COMMON CMDS,FILE,IN,OUT,INS,LASTLN,LSTLEN
	LOGICAL*1 ANSWER(100,10),VAR(100,6),LINE(100),CMDS(6,17),FIRST,
     1  COND(11),INCLUD(11),SUBNAM(6),PATERN(5,30),REPLAC(5,30),
     1  FILE(12),INSERT,SUBFLG,CARRY,LASTLN(100)
	REAL VALUE(100)
	INTEGER PATLEN(5),REPLEN(5)
C
C	SUBROUTINE TO PROCESS ENDC COMMAND
C	<TAB>#ENDC
C
	IF(LEVEL.GT.1)GOTO 10				!MAKE SURE NOT AT BOTTOM LEVEL
	CALL EPRINT(15)					!?SYSGEN-W-TOO MANY #ENDC'S
	GOTO 1000
10	LEVEL=LEVEL-1					!DROP CONDITIONAL LEVEL
C
C	DONE
C
1000	RETURN
	END
	SUBROUTINE ENDS
	IMPLICIT INTEGER*2(A-Z)
	COMMON ANSWER,VAR,LINE,COND,INCLUD
	COMMON SUBNAM,VALUE,CARRY,SUBFLG
	COMMON PATERN,REPLAC,PATLEN,REPLEN
	COMMON LEVEL,NXTVAR,NUMSUB,LPTR
	COMMON VARLEN,NUMVAR,LNLENG,VIDX
	COMMON INSERT,FIRST,I,J,K,II,JJ,KK,III
	COMMON CMDS,FILE,IN,OUT,INS,LASTLN,LSTLEN
	LOGICAL*1 ANSWER(100,10),VAR(100,6),LINE(100),CMDS(6,17),FIRST,
     1  COND(11),INCLUD(11),SUBNAM(6),PATERN(5,30),REPLAC(5,30),
     1  FILE(12),INSERT,SUBFLG,CARRY,LASTLN(100)
	REAL VALUE(100)
	INTEGER PATLEN(5),REPLEN(5)
C
C	SUBROUTINE TO PROCESS ENDS COMMAND
C	<TAB>#ENDS
C
	IF(INCLUD(LEVEL))NUMSUB=0			!IF NOT CONDITIONALIZED OUT, RESET FOR NO SUBS
	RETURN
	END
	SUBROUTINE EXITS
	IMPLICIT INTEGER*2(A-Z)
	COMMON ANSWER,VAR,LINE,COND,INCLUD
	COMMON SUBNAM,VALUE,CARRY,SUBFLG
	COMMON PATERN,REPLAC,PATLEN,REPLEN
	COMMON LEVEL,NXTVAR,NUMSUB,LPTR
	COMMON VARLEN,NUMVAR,LNLENG,VIDX
	COMMON INSERT,FIRST,I,J,K,II,JJ,KK,III
	COMMON CMDS,FILE,IN,OUT,INS,LASTLN,LSTLEN
	LOGICAL*1 ANSWER(100,10),VAR(100,6),LINE(100),CMDS(6,17),FIRST,
     1  COND(11),INCLUD(11),SUBNAM(6),PATERN(5,30),REPLAC(5,30),
     1  FILE(12),INSERT,SUBFLG,CARRY,LASTLN(100)
	REAL VALUE(100)
	INTEGER PATLEN(5),REPLEN(5)
C
C	SUBROUTINE TO PROCESS #EXIT COMMAND
C	<TAB>#EXIT
C
	IF(.NOT.INCLUD(LEVEL))GOTO 1000			!DON'T DO IF CONDITIONALIZED OUT
	CALL EXIT
1000	RETURN
	END
	SUBROUTINE FILES
	IMPLICIT INTEGER*2(A-Z)
	COMMON ANSWER,VAR,LINE,COND,INCLUD
	COMMON SUBNAM,VALUE,CARRY,SUBFLG
	COMMON PATERN,REPLAC,PATLEN,REPLEN
	COMMON LEVEL,NXTVAR,NUMSUB,LPTR
	COMMON VARLEN,NUMVAR,LNLENG,VIDX
	COMMON INSERT,FIRST,I,J,K,II,JJ,KK,III
	COMMON CMDS,FILE,IN,OUT,INS,LASTLN,LSTLEN
	LOGICAL*1 ANSWER(100,10),VAR(100,6),LINE(100),CMDS(6,17),FIRST,
     1  COND(11),INCLUD(11),SUBNAM(6),PATERN(5,30),REPLAC(5,30),
     1  FILE(12),INSERT,SUBFLG,CARRY,LASTLN(100)
	REAL VALUE(100)
	INTEGER PATLEN(5),REPLEN(5)
C
C	SUBROUTINE TO PROCESS #FILE COMMAND
C	<TAB>#FILE<TAB>FILNAM.EXT
C
	IF(.NOT.INCLUD(LEVEL))GOTO 1000
	IF(LNLENG.GE.8)GOTO 10				!MAKE SURE FILE NAME SPECIFIED
	CALL EPRINT(9)					!?SYSGEN-W-MISSING FILE NAME
	GOTO 1000
10	IF(.NOT.FIRST)CALL CLOSE(OUT)			!CLOSE PREVIOUS FILE
	FIRST=.FALSE.
	CALL ASSIGN(OUT,LINE(8))			!OPEN NEW OUTPUT FILE
C
C	DONE
C
1000	RETURN
	END
	SUBROUTINE IF0
	IMPLICIT INTEGER*2(A-Z)
	COMMON ANSWER,VAR,LINE,COND,INCLUD
	COMMON SUBNAM,VALUE,CARRY,SUBFLG
	COMMON PATERN,REPLAC,PATLEN,REPLEN
	COMMON LEVEL,NXTVAR,NUMSUB,LPTR
	COMMON VARLEN,NUMVAR,LNLENG,VIDX
	COMMON INSERT,FIRST,I,J,K,II,JJ,KK,III
	COMMON CMDS,FILE,IN,OUT,INS,LASTLN,LSTLEN
	LOGICAL*1 ANSWER(100,10),VAR(100,6),LINE(100),CMDS(6,17),FIRST,
     1  COND(11),INCLUD(11),SUBNAM(6),PATERN(5,30),REPLAC(5,30),
     1  FILE(12),INSERT,SUBFLG,CARRY,LASTLN(100)
	REAL VALUE(100)
	INTEGER PATLEN(5),REPLEN(5)
C
C	SUBROUTINE TO PROCESS #IF COMMAND
C	<TAB>#IF<TAB>VARIABLE
C
	IF(LEVEL.LT.11)GOTO 10
	CALL EPRINT(12)					!SYSGEN-W-TOO MANY NESTED IF'S
	GOTO 1000
10	IF(LNLENG.GE.6)GOTO 20				!CHECK FOR CONDITIONAL PRESENT
	CALL EPRINT(11)					!?SYSGEN-W-MISSING CONDITIONAL
	GOTO 1000
20	LPTR=6
	IF(.NOT.INCLUD(LEVEL))GOTO 30			!IF NOT ACTIVE,DON'T LOOKUP VARIABLE
	CALL FNDVAR(1)					!FIND VARIABLE
	IF(CARRY.EQ.1)GOTO 1000				!OPERATION FAILED
30	LEVEL=LEVEL+1					!NEW CONDITIONAL LEVEL
	COND(LEVEL)=ANSWER(VIDX,1).EQ.'Y'			!COND=TRUE IF ANSWER = Y
C	INCLUD TRUE IF PREVIOUS LEVEL TRUE
	INCLUD(LEVEL)=COND(LEVEL).AND.INCLUD(LEVEL-1)
C
C	DONE
C
1000	RETURN
	END

	SUBROUTINE IFF
	IMPLICIT INTEGER*2(A-Z)
	COMMON ANSWER,VAR,LINE,COND,INCLUD
	COMMON SUBNAM,VALUE,CARRY,SUBFLG
	COMMON PATERN,REPLAC,PATLEN,REPLEN
	COMMON LEVEL,NXTVAR,NUMSUB,LPTR
	COMMON VARLEN,NUMVAR,LNLENG,VIDX
	COMMON INSERT,FIRST,I,J,K,II,JJ,KK,III
	COMMON CMDS,FILE,IN,OUT,INS,LASTLN,LSTLEN
	LOGICAL*1 ANSWER(100,10),VAR(100,6),LINE(100),CMDS(6,17),FIRST,
     1  COND(11),INCLUD(11),SUBNAM(6),PATERN(5,30),REPLAC(5,30),
     1  FILE(12),INSERT,SUBFLG,CARRY,LASTLN(100)
	REAL VALUE(100)
	INTEGER PATLEN(5),REPLEN(5)
C
C	SUBROUTINE TO PROCESS THE #IFF COMMAND
C	<TAB>#IFF
C
	IF(LEVEL.GT.1)INCLUD(LEVEL)=.NOT.COND(LEVEL).AND.INCLUD(LEVEL-1)
	RETURN
	END

	SUBROUTINE IFGT
	IMPLICIT INTEGER*2(A-Z)
	COMMON ANSWER,VAR,LINE,COND,INCLUD
	COMMON SUBNAM,VALUE,CARRY,SUBFLG
	COMMON PATERN,REPLAC,PATLEN,REPLEN
	COMMON LEVEL,NXTVAR,NUMSUB,LPTR
	COMMON VARLEN,NUMVAR,LNLENG,VIDX
	COMMON INSERT,FIRST,I,J,K,II,JJ,KK,III
	COMMON CMDS,FILE,IN,OUT,INS,LASTLN,LSTLEN
	LOGICAL*1 ANSWER(100,10),VAR(100,6),LINE(100),CMDS(6,17),FIRST,
     1  COND(11),INCLUD(11),SUBNAM(6),PATERN(5,30),REPLAC(5,30),
     1  FILE(12),INSERT,SUBFLG,CARRY,LASTLN(100)
	REAL VALUE(100)
	INTEGER PATLEN(5),REPLEN(5)
C
C	SUBROUTINE TO PROCESS THE #IFGT COMMAND
C	<TAB>#IFGT<TAB>CONDITIONAL
C
	IF(LEVEL.LT.11)GOTO 10			!TEST NESTING DEPTH
	CALL EPRINT(12)				!?SYSGEN-W-TOO MANY NESTED CONDITIONALS
	GOTO 1000
10	IF(LNLENG.GE.8)GOTO 20			!TEST FOR CONDITIONAL PRESENSE
	CALL EPRINT(11)				!?SYSGEN-W-MISSING CONDITIONAL
	GOTO 1000
20	LPTR=8
	IF(.NOT.INCLUD(LEVEL))GOTO 30			!IF NOT ACTIVE,DON'T LOOKUP VARIABLE
	CALL FNDVAR(1)				!FIND THE VARIABLE
	IF(CARRY.EQ.1)GOTO 1000			!ERROR
30	LEVEL=LEVEL+1				!NEW CONDITIONAL LEVEL
	COND(LEVEL)=VALUE(VIDX).GT.0.		!CONDITION TRUE IF VALUE >0
C	INCLUDE TRUE IF PREVIOUS LEVEL TRUE
	INCLUD(LEVEL)=COND(LEVEL).AND.INCLUD(LEVEL-1)
C
C	DONE
C
1000	RETURN
	END


	SUBROUTINE IFN
	IMPLICIT INTEGER*2(A-Z)
	COMMON ANSWER,VAR,LINE,COND,INCLUD
	COMMON SUBNAM,VALUE,CARRY,SUBFLG
	COMMON PATERN,REPLAC,PATLEN,REPLEN
	COMMON LEVEL,NXTVAR,NUMSUB,LPTR
	COMMON VARLEN,NUMVAR,LNLENG,VIDX
	COMMON INSERT,FIRST,I,J,K,II,JJ,KK,III
	COMMON CMDS,FILE,IN,OUT,INS,LASTLN,LSTLEN
	LOGICAL*1 ANSWER(100,10),VAR(100,6),LINE(100),CMDS(6,17),FIRST,
     1  COND(11),INCLUD(11),SUBNAM(6),PATERN(5,30),REPLAC(5,30),
     1  FILE(12),INSERT,SUBFLG,CARRY,LASTLN(100)
	REAL VALUE(100)
	INTEGER PATLEN(5),REPLEN(5)
C
C	SUBROUTINE TO HANDLE #IFN COMMAND
C	<TAB>#IFN<TAB>VARIABLE
C
	IF(LEVEL.LT.11)GOTO 10			!?SYSGEN-W-TOO MANY CONDITIONALS
	CALL EPRINT(12)
	GOTO 1000
10	IF(LNLENG.GE.7)GOTO 20
	CALL EPRINT(11)				!?SYSGEN-W-MISSING CONDITIONALS
	GOTO 1000
20	LPTR=7
	IF(.NOT.INCLUD(LEVEL))GOTO 30			!IF NOT ACTIVE,DON'T LOOKUP VARIABLE
	CALL FNDVAR(1)				!FIND VARIABLE
	IF(CARRY.EQ.1)GOTO 1000			!VARIABLE NOT FOUND
30	LEVEL=LEVEL+1				!BUMP CONDITIONAL LEVEL
	COND(LEVEL)=ANSWER(VIDX,1).EQ.'N'		!COND TRUE IF VARIABLE="NO"
C	INCLUD TRUE ONLY IF PREVIOUS LEVEL TRUE
	INCLUD(LEVEL)=COND(LEVEL).AND.INCLUD(LEVEL-1)
C
C	DONE
C
1000	RETURN
	END

	SUBROUTINE IFT
	IMPLICIT INTEGER*2(A-Z)
	COMMON ANSWER,VAR,LINE,COND,INCLUD
	COMMON SUBNAM,VALUE,CARRY,SUBFLG
	COMMON PATERN,REPLAC,PATLEN,REPLEN
	COMMON LEVEL,NXTVAR,NUMSUB,LPTR
	COMMON VARLEN,NUMVAR,LNLENG,VIDX
	COMMON INSERT,FIRST,I,J,K,II,JJ,KK,III
	COMMON CMDS,FILE,IN,OUT,INS,LASTLN,LSTLEN
	LOGICAL*1 ANSWER(100,10),VAR(100,6),LINE(100),CMDS(6,17),FIRST,
     1  COND(11),INCLUD(11),SUBNAM(6),PATERN(5,30),REPLAC(5,30),
     1  FILE(12),INSERT,SUBFLG,CARRY,LASTLN(100)
	REAL VALUE(100)
	INTEGER PATLEN(5),REPLEN(5)
C
C	SUBROUTINE TO PROCESS #IFT COMMAND
C	<TAB>#IFT
C
	IF(LEVEL.GT.1)INCLUD(LEVEL)=COND(LEVEL).AND.INCLUD(LEVEL-1)
	RETURN
	END

	SUBROUTINE IFTF
	IMPLICIT INTEGER*2(A-Z)
	COMMON ANSWER,VAR,LINE,COND,INCLUD
	COMMON SUBNAM,VALUE,CARRY,SUBFLG
	COMMON PATERN,REPLAC,PATLEN,REPLEN
	COMMON LEVEL,NXTVAR,NUMSUB,LPTR
	COMMON VARLEN,NUMVAR,LNLENG,VIDX
	COMMON INSERT,FIRST,I,J,K,II,JJ,KK,III
	COMMON CMDS,FILE,IN,OUT,INS,LASTLN,LSTLEN
	LOGICAL*1 ANSWER(100,10),VAR(100,6),LINE(100),CMDS(6,17),FIRST,
     1  COND(11),INCLUD(11),SUBNAM(6),PATERN(5,30),REPLAC(5,30),
     1  FILE(12),INSERT,SUBFLG,CARRY,LASTLN(100)
	REAL VALUE(100)
	INTEGER PATLEN(5),REPLEN(5)
C
C	SUBROUTINE TO PROCESS #IFTF COMMAND
C	<TAB>#IFTF
C
	IF(LEVEL.GT.1)INCLUD(LEVEL)=INCLUD(LEVEL-1)
	RETURN
	END

	SUBROUTINE NAME
	IMPLICIT INTEGER*2(A-Z)
	COMMON ANSWER,VAR,LINE,COND,INCLUD
	COMMON SUBNAM,VALUE,CARRY,SUBFLG
	COMMON PATERN,REPLAC,PATLEN,REPLEN
	COMMON LEVEL,NXTVAR,NUMSUB,LPTR
	COMMON VARLEN,NUMVAR,LNLENG,VIDX
	COMMON INSERT,FIRST,I,J,K,II,JJ,KK,III
	COMMON CMDS,FILE,IN,OUT,INS,LASTLN,LSTLEN
	LOGICAL*1 ANSWER(100,10),VAR(100,6),LINE(100),CMDS(6,17),FIRST,
     1  COND(11),INCLUD(11),SUBNAM(6),PATERN(5,30),REPLAC(5,30),
     1  FILE(12),INSERT,SUBFLG,CARRY,LASTLN(100)
	REAL VALUE(100)
	INTEGER PATLEN(5),REPLEN(5)
C
C	SUBROUTINE TO PROCESS #NAME COMMAND
C	<TAB>#NAME<TAB>SECTION NAME
C
	IF(LEVEL.EQ.1)GOTO 10			!CHECK TO BE SURE AT BASE LEVEL
	CALL EPRINT(4)				!?SYSGEN-F-TOO FEW ENDC'S
10	LEVEL=1
	DO 20 KK=1,6
	K=LINE(KK+7)				!COPY NAME CHARS TO SUBNAME
	IF(KK+7.GT.LNLENG)K="40			!"40 IS A SPACE
20	SUBNAM(KK)=K
C
C	DONE
C
	RETURN
	END

	SUBROUTINE PRINT0
	IMPLICIT INTEGER*2(A-Z)
	COMMON ANSWER,VAR,LINE,COND,INCLUD
	COMMON SUBNAM,VALUE,CARRY,SUBFLG
	COMMON PATERN,REPLAC,PATLEN,REPLEN
	COMMON LEVEL,NXTVAR,NUMSUB,LPTR
	COMMON VARLEN,NUMVAR,LNLENG,VIDX
	COMMON INSERT,FIRST,I,J,K,II,JJ,KK,III
	COMMON CMDS,FILE,IN,OUT,INS,LASTLN,LSTLEN
	LOGICAL*1 ANSWER(100,10),VAR(100,6),LINE(100),CMDS(6,17),FIRST,
     1  COND(11),INCLUD(11),SUBNAM(6),PATERN(5,30),REPLAC(5,30),
     1  FILE(12),INSERT,SUBFLG,CARRY,LASTLN(100)
	REAL VALUE(100)
	INTEGER PATLEN(5),REPLEN(5)
C
C	SUBROUTINE TO PROCESS #PRINT COMMAND
C	<TAB>#PRINT<TAB>TEXT
C
	IF(INCLUD(LEVEL))WRITE(5,80000)(LINE(J),J=9,LNLENG)
	RETURN
80000	FORMAT(1X,100A1)
	END

	SUBROUTINE SET
	IMPLICIT INTEGER*2(A-Z)
	COMMON ANSWER,VAR,LINE,COND,INCLUD
	COMMON SUBNAM,VALUE,CARRY,SUBFLG
	COMMON PATERN,REPLAC,PATLEN,REPLEN
	COMMON LEVEL,NXTVAR,NUMSUB,LPTR
	COMMON VARLEN,NUMVAR,LNLENG,VIDX
	COMMON INSERT,FIRST,I,J,K,II,JJ,KK,III
	COMMON CMDS,FILE,IN,OUT,INS,LASTLN,LSTLEN
	LOGICAL*1 ANSWER(100,10),VAR(100,6),LINE(100),CMDS(6,17),FIRST,
     1  COND(11),INCLUD(11),SUBNAM(6),PATERN(5,30),REPLAC(5,30),
     1  FILE(12),INSERT,SUBFLG,CARRY,LASTLN(100)
	REAL VALUE(100)
	INTEGER PATLEN(5),REPLEN(5)
C
C	SUBROUTINE TO PROCESS #SET COMMAND
C	<TAB>#SET<TAB>VARIABLE=ANSWER
C
	IF(.NOT.INCLUD(LEVEL))GOTO 1000			!MAY BE CONDITIONALIZED OUT
	IF(LNLENG.GE.7)GOTO 10				!MAKE SURE VARIABLE PRESENT
	CALL EPRINT(11)					!?SYSGEN-F-MISSING CONDITIONAL IN
	GOTO 1000
10	LPTR=7
	CALL FNDVAR(0)					!FIND VARIABLE
	IF(CARRY.EQ.1)GOTO 1000				!FAILED
	IF(LINE(LPTR).EQ.'=')GOTO 20
15	CALL EPRINT(13)					!?SYSGEN-F-BAD SET IN
	GOTO 1000
20	IF((LNLENG-LPTR).GT.10)GOTO 15			!TOO MANY CHARS IN ANSWER
	DO 30 KK=LPTR+1,LNLENG
30	ANSWER(VIDX,KK-LPTR)=LINE(KK)
C
C	DONE
C
1000	RETURN
	END

	SUBROUTINE SUB
	IMPLICIT INTEGER*2(A-Z)
	COMMON ANSWER,VAR,LINE,COND,INCLUD
	COMMON SUBNAM,VALUE,CARRY,SUBFLG
	COMMON PATERN,REPLAC,PATLEN,REPLEN
	COMMON LEVEL,NXTVAR,NUMSUB,LPTR
	COMMON VARLEN,NUMVAR,LNLENG,VIDX
	COMMON INSERT,FIRST,I,J,K,II,JJ,KK,III
	COMMON CMDS,FILE,IN,OUT,INS,LASTLN,LSTLEN
	LOGICAL*1 ANSWER(100,10),VAR(100,6),LINE(100),CMDS(6,17),FIRST,
     1  COND(11),INCLUD(11),SUBNAM(6),PATERN(5,30),REPLAC(5,30),
     1  FILE(12),INSERT,SUBFLG,CARRY,LASTLN(100)
	REAL VALUE(100)
	INTEGER PATLEN(5),REPLEN(5)
C
C	SUBROUTINE TO PROCESS THE #SUBS COMMAND
C	<TAB>#SUBS<TAB>"PATTERN"VARIABLE
C
	IF(.NOT.INCLUD(LEVEL))GOTO 1000
	IF(NUMSUB.LT.5)GOTO 3				!CHECK # OF SUBS ACTIVE
	CALL EPRINT(12)					!?SUSGEN-F-TOO MANY NESTED SUBS
	GOTO 1000
3	IF(LINE(8).EQ.'"')GOTO 10
5	CALL EPRINT(14)					!?SYSGEN-F-BAD SUBSTITUTE PATTERN
	GOTO 1000
10	NUMSUB=NUMSUB+1
	DO 20 J=1,30
	PATERN(NUMSUB,J)=LINE(8+J)
	IF(LINE(8+J).EQ.'"')GOTO 30
20	CONTINUE
	NUMSUB=NUMSUB-1
	GOTO 5						!TOO MANY CHARS IN PATTERN
30	PATLEN(NUMSUB)=J-1
	LPTR=8+J+1					!POINTER TO START OF VARIABLE NAME
	CALL FNDVAR(1)					!FIND VARIABLE IN SYMBOL TABLE
	IF(CARRY.EQ.1)GOTO 1000
	DO 40 K=1,10
	REPLAC(NUMSUB,K)=ANSWER(VIDX,K)			!COPY ANSWER INTO REPLACE ARRAY
	IF(REPLAC(NUMSUB,K).NE.0)GOTO 40
	REPLEN(NUMSUB)=K-1
	GOTO 1000
40	CONTINUE
C
C	DONE
C
1000	RETURN
	END
	SUBROUTINE FNDVAR(OLD)
	IMPLICIT INTEGER*2(A-Z)
	COMMON ANSWER,VAR,LINE,COND,INCLUD
	COMMON SUBNAM,VALUE,CARRY,SUBFLG
	COMMON PATERN,REPLAC,PATLEN,REPLEN
	COMMON LEVEL,NXTVAR,NUMSUB,LPTR
	COMMON VARLEN,NUMVAR,LNLENG,VIDX
	COMMON INSERT,FIRST,I,J,K,II,JJ,KK,III
	COMMON CMDS,FILE,IN,OUT,INS,LASTLN,LSTLEN
	LOGICAL*1 ANSWER(100,10),VAR(100,6),LINE(100),CMDS(6,17),FIRST,
     1  COND(11),INCLUD(11),SUBNAM(6),PATERN(5,30),REPLAC(5,30),
     1  FILE(12),INSERT,SUBFLG,CARRY,LASTLN(100)
	REAL VALUE(100)
	INTEGER PATLEN(5),REPLEN(5)
C
C	SUBROUTINE TO FIND A VARIABLE NAME IN THE VARIABLE TABLE
C
C	INPUTS:-"LINE" ARRAY CONTAINS VARIABLE NAME
C		 LPTR POINTS TO VARIABLE NAME IN "LINE"
C		 VARIABLE NAME TERMINATED BY 0 OR "/" OR "="
C		 ARGUMENT "OLD"
C		 =0  MEANS IF VARIABLE NAME NOT IN TABLE,
C		     CREATE A NEW ENTRY
C		 =1  MEANS IF VARIABLE NAME NOT IN TABLE,
C		     PRINT ERROR MESSAGE
C	OUTPUTS:-VIDX CONTAINS INDEX TO VARIABLE IN SYMBOL TABLE
C		 COMMON FLAG "CARRY"
C		 =0 IF OPERATION SUCCESSFUL
C		 =1 IF OPERATION FAILED
C
C	CHECK FOR TABLE OVERFLOW
C
	IF(NXTVAR.LT.NUMVAR)GOTO 10
	CALL EPRINT(7)					!?SYSGEN-W-TOO MANY CONDITIONALS
	GOTO 1000					!FAILED
C
C	SEARCH TABLE FOR NAME
C
10	DO 20 KK=1,NXTVAR
	DO 15 JJ=0,VARLEN-1
	IF(LINE(LPTR+JJ).EQ.0.AND.VAR(KK,JJ+1).EQ.0.OR.
     1  LINE(LPTR+JJ).EQ.'/'.AND.VAR(KK,JJ+1).EQ.0.OR.
     1  LINE(LPTR+JJ).EQ.'='.AND.VAR(KK,JJ+1).EQ.0)GOTO 40
	IF(LINE(LPTR+JJ).NE.VAR(KK,JJ+1))GOTO 20
15	CONTINUE
	GOTO 40						!INNER LOOP COMPLETE MEANS VARIABLE MATCH
20	CONTINUE
C
C	IF WE GET HERE, SEARCH HAS FAILED
C
	IF(OLD.EQ.0)GOTO 30				!CREATE NEW ENTRY
	CALL EPRINT(8)					!?SYSGEN-W-UNDEFINED VARIABLE IN
	GOTO 1000					!FAILED
C
C	CREATE NEW ENTRY FROM VARIABLE NAME
C
30	DO 35 JJ=0,VARLEN-1
	IF(LINE(LPTR+JJ).EQ.0.OR.LINE(LPTR+JJ).EQ.'/'.OR.LINE(LPTR+JJ).EQ.'=')
     1  GOTO 37
35	VAR(NXTVAR,JJ+1)=LINE(LPTR+JJ)
37	VIDX=NXTVAR
	NXTVAR=NXTVAR+1
	GOTO 45						!SUCCESS
C
C	SEARCH SUCCEEDED
C
40	VIDX=KK
45	LPTR=LPTR+JJ
	GOTO 1010
C
C	RETURN AFTER SETTING FLAG
C
1000	CARRY=1						!OPERATION FAILED
	RETURN
1010	CARRY=0						!OPERATION FAILED
	RETURN
	END

	SUBROUTINE EPRINT(ERRNUM)
	IMPLICIT INTEGER*2(A-Z)
	COMMON ANSWER,VAR,LINE,COND,INCLUD
	COMMON SUBNAM,VALUE,CARRY,SUBFLG
	COMMON PATERN,REPLAC,PATLEN,REPLEN
	COMMON LEVEL,NXTVAR,NUMSUB,LPTR
	COMMON VARLEN,NUMVAR,LNLENG,VIDX
	COMMON INSERT,FIRST,I,J,K,II,JJ,KK,III
	COMMON CMDS,FILE,IN,OUT,INS,LASTLN,LSTLEN
	LOGICAL*1 ANSWER(100,10),VAR(100,6),LINE(100),CMDS(6,17),FIRST,
     1  COND(11),INCLUD(11),SUBNAM(6),PATERN(5,30),REPLAC(5,30),
     1  FILE(12),INSERT,SUBFLG,CARRY,LASTLN(100)
	REAL VALUE(100)
	INTEGER PATLEN(5),REPLEN(5)
C
C	SUBROUTINE TO PRINT AN ERROR MESSAGE
C	USES ERRNUM AS INDICATOR FOR WHICH
C	ERROR TO PRINT
	WRITE(5,10)
10	FORMAT (/,'$?SYSGEN-')
	GOTO(101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,
     1    117,118)ERRNUM
C
101	WRITE(5,201)
	GOTO 1000
201	FORMAT ('+F-Inappropriate answer',/)
C
102	WRITE(5,202)
	GOTO 1000
202	FORMAT ('+F-Answer value too small',/)
C
103	WRITE(5,203)
	GOTO 1000
203	FORMAT ('+F-Answer value too large',/)
C
104	WRITE(5,204)SUBNAM,(LINE(K),K=1,LNLENG)
	GOTO 1000
204	FORMAT ('+W-Too few #ENDC''s in ',6A1,/,1X,80A1)
C
105	WRITE(5,205)SUBNAM,(LINE(K),K=1,LNLENG)
	GOTO 1000
205	FORMAT ('+W-Bad #ASK in ',6A1,/,1X,80A1)
C
106	WRITE(5,206)SUBNAM,(LINE(K),K=1,LNLENG)
	GOTO 1000
206	FORMAT ('+W-Undefined command in ',6A1,/,1X,80A1)
C
107	WRITE(5,207)SUBNAM,(LINE(K),K=1,LNLENG)
	GOTO 1000
207	FORMAT ('+W-Too many variables in ',6A1,/,1X,80A1)
C
108	WRITE(5,208)SUBNAM,(LINE(K),K=1,LNLENG)
	GOTO 1000
208	FORMAT ('+W-Undefined variable in ',6A1,/,1X,80A1)
C
109	WRITE(5,209)SUBNAM,(LINE(K),K=1,LNLENG)
	GOTO 1000
209	FORMAT ('+W-Missing file name in ',6A1,/,1X,80A1)
C
110	WRITE(5,210)SUBNAM,(LINE(K),K=1,LNLENG)
	GOTO 1000
210	FORMAT ('+W-Nested #CALL in ',6A1,/,1X,80A1)
C
111	WRITE(5,211)SUBNAM,(LINE(K),K=1,LNLENG)
	GOTO 1000
211	FORMAT ('+W-Missing variable in ',6A1,/,1X,80A1)
C
112	WRITE(5,212)SUBNAM,(LINE(K),K=1,LNLENG)
	GOTO 1000
212	FORMAT ('+W-Too many nested #IFs or #SUBs in ',6A1,/,1X,80A1)
C
113	WRITE(5,213)SUBNAM,(LINE(K),K=1,LNLENG)
	GOTO 1000
213	FORMAT ('+W-Bad #SET in ',6A1,/,1X,80A1)
C
114	WRITE(5,214)SUBNAM,(LINE(K),K=1,LNLENG)
	GOTO 1000
214	FORMAT ('+W-Bad substitute pattern in ',6A1,/,1X,80A1)
C
115	WRITE(5,215)SUBNAM,(LINE(K),K=1,LNLENG)
	GOTO 1000
215	FORMAT ('+W-Too many #ENDC''s in ',6A1,/,1X,80A1)
C
116	WRITE(5,216)
	GOTO 1000
216	FORMAT ('+F-Insert error',/)
C
117	WRITE(5,217)
	GOTO 1000
217	FORMAT ('+F-Output error',/)
C
118	WRITE(5,218)
218	FORMAT ('+F-Input error',/)
C
C	DONE
C
1000	RETURN
	END
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        