	SUBROUTINE FUNBOX(LIST)
C
C	  SUBROUTINE FUNBOX ALLOWS FORTRAN ACCESS TO THE
C	  LK11 FUNCTION BOX.  THE ARRAY LIST IS 16 WORDS
C	  LONG; EACH ENTRY CORRESPONDS TO ONE BUTTON/LIGHT
C	  ON THE FUNCTION BOX AS FOLLOWS:
C		GFED
C		CBA9
C		8765
C		4321
C	  FOR EACH ENTRY, THE '1' BIT RETURNS THE CURRENT
C	  BUTTON STATUS; THE '2' BIT CONTROLS THE LAMP IF
C	  '4' BIT IS ALSO SET, OTHERWISE THE LAMP GOES ON
C	  AND OFF WITH THE BUTTON.
C
C	WRITTEN BY R. B. BARTLEIN -- AUGUST 30, 1978
C
C	  RE-WRITTEN BY MICHAEL LAMPI TO MAKE USE OF LOGICAL FORTRAN
C	  FUNCTIONS --  OCTOBER 11, 1978  --
C
	DIMENSION LIST(16), NBIT(16)
	DATA NBIT/"100000,"040000,"020000,"010000,"004000,
     X	  "002000,"001000,"000400,"000200,"000100,"000040,
     X	  "000020,"000010,"000004,"000002,"000001/
	DATA KBUTTN/"160062/, KLAMP/"160064/
	IBUTTN = IPEEK(KBUTTN)
	NWLAMP = 0
	DO 130 I=1,16
	IFLAG=0
	NCTRL=LIST(I).AND."6
	LIST(I)=LIST(I).AND."177770
	IF ((IBUTTN.AND.NBIT(I)) .NE. 0) IFLAG=1
	IF (NCTRL .LT. 4) NWLAMP=IBUTTN.AND.NBIT(I)+NWLAMP
	IF (NCTRL .EQ. 6) NWLAMP=NBIT(I)+NWLAMP
	LIST(I)=LIST(I)+NCTRL+IFLAG
130	CONTINUE
	CALL IPOKE(KLAMP,NWLAMP)
	END


C
C	THE FOLLOWING SUBROUTINES HAVE BECOME OBSOLETE DUE TO THE NEWER
C	MACRO-11 REPLACEMENTS THAT WERE WRITTEN TO SPEED THEM
C	UP A BIT. YOU MAY FIND THESE SUBROUTINES IN "FUNBXM.MAC"
C	(MICHAEL LAMPI	5/23/79)
C
C	SUBROUTINE DROUT(IOUTPT)
CC	  THIS ROUTINE DUMPS DATA TO THE DR-11 INTERFACE OUTPUT
CC
CC	  WRITTEN BY MICHAEL LAMPI     MAY 1979
CC
C	IMPLICIT INTEGER(A-Z)
C	DATA DROUT/"160064/
CC
CC	  DUMP DATA TO THE OUTPUT REGISTER
CC
C	CALL IPOKE(DROUT,IOUTPT)
C	RETURN
C	END
C
C	FUNCTION IDRIN(DUMMY)
CC	  THIS ROUTINE RECEIVES DATA FROM THE DR-11 INTERFACE INPUT
CC
CC	  WRITTEN BY MICHAEL LAMPI     MAY 1979
CC
C	IMPLICIT INTEGER(A-Z)
C	DATA DRIN/"160062/
CC
CC	  READ THE INPUT REGISTER
CC
C	IDRIN=IPEEK(DRIN)
C	RETURN
C	END
C
C
C
C	FUNCTION IDROUT(IDUMMY)
CC	  THIS FUNCTION READS THE 'OUTPUT' REGISTER OF THE DR-11
CC	  SO YOU CAN TELL WHAT IT IS CURRENTLY SET AT
CC	  THIS IS USEFUL FOR THE LK-11 BUTTON BOX LIGHTS IF YOU
CC	  DON'T KNOW WHAT LIGHTS ARE ALREADY LIT
CC
CC	  WRITTEN BY MICHAEL LAMPI     MAY 1979
CC
C	IDROUT=IPEEK("160064)
C	RETURN
C	END
C
C
C	SUBROUTINE DRIN(IVALUE)
CC	  THIS SUBROUTINE WRITES THE 'INPUT' REGISTER OF THE DR-11
CC	  SO YOU CAN INITIALIZE THE REGISTER TO WHATEVER VALUE
CC	  DESIRED. THIS IS USEFUL WHEN USING THE LK-11 BUTTON BOX
CC	  TO INITIALIZE THE STATE OF EACH LK-11 BUTTON TO EITHER
CC	  AN 'ON' OR 'OFF' STATE.
CC
CC	  WRITTEN BY MICHAEL LAMPI     MAY 1979
CC
C	CALL IPOKE("160062,IVALUE)
C	RETURN
C	END
