
#include libc.h
#include pals.def

char	bytes[16],	/** hex output record buffer **/
	checksum,
	nbytes,
	nibble;

unsigned
	ld_addr;

FILE	*codefile;

/*************************************************************
	hex output function converts binary to Intel Hex
  format.
	entry-	p1= flag;	0: initialize
				1: add p2 to record
				2: close out record
		p2= data nibble

**************************************************************/
hexout(flag, data)   int flag; char data;{
   int cnt;

   switch (flag){
      case 0:		/**  initialize  **/
         checksum = ld_addr = nbytes = 0;
         for (cnt = 0; cnt < 16; cnt++)   bytes[cnt] = 0;
         break;
      case 1:		/**  add data to output record  **/
         bytes[nbytes++] = data & 0x0f;
         if (nbytes == 16)   puthex(0);		/**  write record  **/
         break;
      case 2:
         puthex(1);	/**  close record  **/
         break;
      }
   }


/**************************************************************

	put Hex record in 'bytes[]' to output file.
	entry -	p1= flag;	0: only output record
				/0: output any remaining record &
				    output EOF record.

*******************************************************************/
puthex(flag)   int flag;{
   register int cnt;

   putc(':', codefile);
   putbyte(nbytes);
   if (nbytes == 0)   ld_addr = 0;
   putbyte(ld_addr >> 8);
   putbyte(ld_addr);
   if (nbytes == 0)   putbyte(1);
   else   putbyte(0);
   for (cnt = 0; cnt < nbytes; cnt++)   putbyte(bytes[cnt]);
   putbyte(-checksum & 0xff);
   putc(0x0d, codefile);   putc(0x0a, codefile);   /**  CR-LF  **/
   ld_addr += nbytes;
   nbytes = checksum = 0;
   for (cnt = 0; cnt < 16; cnt++)   bytes[cnt] = 0;
   if (flag)   puthex(0);
   }


/*************************************************************
	putbyte outputs a byte of data as 2 ascii-hex nibbles
**************************************************************/
putbyte(data)   int data;{

   data &= 0xff;
   putnib(data >> 4);
   putnib(data & 0x0f);
   checksum += data;
   }


/***************************************************************
	put nibble converts a data nibble to ascii-hex &
  outputs it to codefile.
****************************************************************/
putnib(data)   int data;{

   data &= 0x0f;
   if (data > 9)   data += 7;
   data += '0';
   putc(data, codefile);
   }

