/*********************************************************************
	Code output module
**********************************************************************/
#include	libc.h
#include	palsw.inc
#include	pals.def

	/***   globals   ***/
extern
unsigned options;		/**  options var  **/

extern
  int	nfuses,
	mxterms;

extern
char	pal_letter,		/**  pal letter in pal number  **/
	fuses[max_terms][max_inputs];	/**  the fuse array  **/

extern
FILE	*listfile,
	*codefile;

	/***   locals   ***/
static	int 	prod_line;
static	char	temp[max_inputs];
static	char	code_msg[] = {"Code Generation.."};



/**********************************************************************
	binary output function
***********************************************************************/
binr(){

   fprintf(stdout,"Binary not implemented yet!");
   }


/************************************************************************
	hex function
   The hex function outputs PAL programming data in intel HEX format.
*************************************************************************/
hex(){
   register int	block, cnt;

   fprintf(stdout,"%s", code_msg);
   hexout(0,0);		/**  init hex record vars  **/

   for (block = 0; block < (mxterms / 32); block++){
      for (prod_line = 0; prod_line < 7; prod_line += 2){
         get_fuses(block * 32);
         for (cnt = 0; cnt < (nfuses * 2); cnt++)   hexout(1, temp[cnt]);
         }
      }
   hexout(2,0);	/**  close hex file  **/
   }


/***********************************************************************

	Map function outputs a Hex map of the fuses

************************************************************************/
map(){
   unsigned	addr;
   int	block, cnt;

   header("HEX Map");
   fprintf(listfile,         "\t\t\t\t\t  1 1 1 1 1 1 1 1  1 1 1 1 1 1 1 1\n\
        0 1 2 3 4 5 6 7  8 9 a b c d e f  0 1 2 3 4 5 6 7  8 9 a b c d e f\n");
   addr = 0;

   for (block = 0; block < (mxterms / 32); block++){
      for (prod_line = 0; prod_line < 7; prod_line += 2){
         get_fuses(block * 32);
         for (cnt = 0; cnt < 64; cnt++, addr++){
            if ((cnt % 32) == 0)   fprintf(listfile,"\n%4x: ", addr);
            if ((cnt % 8) == 0)   fprintf(listfile," ");
            fprintf(listfile," %1x", temp[cnt] & 0xf);
            }
         }
      }
   fprintf(listfile,"\n");
   if (pal_letter != 'H')
      fprintf(listfile, "\n**** WARNING!  Invert the PAL data. ****\n");
   }


/***********************************************************************

	get fuses function accumulates 64 nibbles of fuse data in temp[]

***********************************************************************/
static get_fuses(blk)   int blk;{
   int		cnt, input_line;
   char		hex_val;

   for (cnt = 0; cnt < 2; cnt++){
      for (input_line = 0; input_line < nfuses; input_line++){
         hex_val = 0;
         if (fuses[prod_line + cnt + blk][input_line])       hex_val += 1;
         if (fuses[prod_line + cnt + blk + 8][input_line])   hex_val += 2;
         if (fuses[prod_line + cnt + blk + 16][input_line])  hex_val += 4;
         if (fuses[prod_line + cnt + blk + 24][input_line])  hex_val += 8;
         temp[input_line + 32 * cnt] = hex_val;
         }
      }
   }


