/*********************************************************************

	This module performs the fuse blowing per the equations

**********************************************************************/

#include	libc.h
#include	paltokes.inc
#include	pals.def

	/***   global externals   ***/

int	incr(),
	parse();		/**  input parser returns token  **/
char	*getline();		/**  gets a line of source file  **/

extern
int	pal_type,
	fuses_blown,
	pal_outputs,	/**  number of output pins from pal #  **/
	pal_inputs,	/**  number of input pins from pal #  **/
	nfuses,		/**  number of fuses in PAL  **/
	mxterms,	/**  max number of PAL terms  **/
	npins;		/**  max number of pins in this PAL  **/

extern
char	pal_letter,		/**  pal type letter  **/
	cur_phase,		/**  inversion flag for current pin name  **/
	pin_phase[max_pins],	/**  pin inversion flags  **/
	fuses[max_terms][max_inputs],	/**  the fuse array  **/
	pterm_used[max_inputs],	/**  flags for product term used flags  **/
	*errors[],		/**  common error message ptr array  **/
	*cptr,
	src_line[82];		/**  source file input storage  **/


	/***   local vars   ***/
static
  int	out_pin;	/**  output pin being worked on  **/

#define	pre_eof	errors[2]
#define	skip	TRUE



/**************************************************************
	Fuse burner main
***************************************************************/
int doit(){
   static int	end,		/**  end of assy flag  **/
		condition,	/**  conditional specified flag  **/
		x_out,
		term_cnt,
		nprods,
		prod_grp,
		prod_line,
		term,
		xor_used,	/**  flag to limit xor terms to 2  **/
		cnt;		/**  scratch counter  **/

   static char	tprods[76],
		if_save[40],	/**  conditional product fuses  **/
		differnt;

   if (npins > 20)   return -1;	/***   abort for now   ***/

   token = parse();		/**  prefetch the token  **/
   condition = FALSE;		/**  preset the conditional flag  **/
   blowall(TRUE, if_save);	/**  assume output allways 'on'  **/

   while (TRUE){

	/***   if end of file then stop   ***/
      if (token == -1)   break;

	/***   if FUNCTION TABLE or DESCRIPTION then echo input to output  ***/
      if (token == func || token == desc){
         while (*(getline(src_line)) != '\0')   {}
         break;
         }

	/***   set up pin phase   ***/
      if (token == invert){
         cur_phase = TRUE;
         token = parse();
         }
      else   cur_phase = FALSE;

	/***   if not 'IF' or output pin then err   ***/
      if (token < 1 || (token > 98 && token != IF)){
         ierr(" Expected Conditional or Output Pin", token);
         }

	/***   if conditional tri-state then go save terms   ***/
      if (token == IF){
         if (!is_tri(npins - 1))
            ierr("No Conditionals allowed for this PAL");

         token = parse();
         if (token != openb)   ierr("'(' Missing");
         condition = TRUE;

         nprods = get_prods(if_save);

         if (nprods < 1)   ierr("No product");
         if (token != closeb)   ierr("Expected ')'");
         token = parse();	/**  skip bracket for main to work on  **/
         }

	/***   must be output pin   ***/
      else{
         out_pin = token;
         xor_used = FALSE;

         if (!is_out(out_pin)){
            ierr(" Not an output pin", out_pin);
            }

	/***	check for valid polarity	***/
         differnt = (pin_phase[out_pin -1] ^ cur_phase);
         if ((pal_letter == 'H' && differnt) ||
              pal_letter != 'H' && pal_letter != 'C' && !differnt)
            ierr("Output polarity");

	/***	select product line base from output pin   ***/
         prod_grp = (npins - out_pin - 1) * 8;

	/*** 	start PAL16c1 on product line 24   ***/
         if (pal_letter == 'C')   prod_grp = 24;

         token = parse();
         if (token != equal && token != replace)   ierr("Expected '='");

	/***   select max terms allowed   ***/
         term_cnt = ((ixlate(out_pin) / 100) % 10);
         if (is_tri(out_pin))   term_cnt++;	/**  add in tri_state  **/

	/***   now that we know the product group, do the tri-state   ***/
         if (condition && !is_tri(out_pin))
               ierr("Not a valid tri-state pin");

         term = 0;		/**  start at base of group  **/

         if (is_tri(out_pin)){
            condition = FALSE;
            for (cnt = 0; cnt < nfuses; cnt++){
                fuses[prod_grp][cnt] = if_save[cnt];
                if (if_save[cnt]){
                   fuses_blown++;
                   if ( ! pterm_used[prod_grp])   pterm_used[prod_grp] = TRUE;
                   }
                }
            blowall(TRUE, if_save);	/**  conditional to all blown  **/
            term = 1;			/**  use next term for output  **/
            }

	/***   do each term   ***/
         for ( ; term < term_cnt; term++){
            prod_line = prod_grp + term;
            pterm_used[prod_line] = TRUE;

            nprods = get_prods(tprods);
            if (nprods < 1)   ierr("Expression");

            for (cnt = 0; cnt < nfuses; cnt++){
               if (tprods[cnt])   fuses_blown++;
               fuses[prod_line][cnt] = tprods[cnt];
               }

	/***   do xor term if used   ***/
            if (token == xor){
               if (pal_letter != 'X')   ierr("Not XOR PAL");
               if (! is_xor(out_pin))   ierr("Not an XOR pin");
               if (xor_used)   ierr("Only 2 xor terms allowed");
               xor_used = TRUE;		/**  limit to 2 xor terms  **/
               prod_grp += term_cnt;	/**  bump to new xor term group  **/
               term = -1;		/**  -1 offsets term++ of for loop  **/
               }

	/***   if not a '+' then stop   ***/
            else if (token != sumch)   break;
            }

	/***   check for too many terms used   ***/
         if (term >= term_cnt)   ierr("Too many product terms");
         }
      }
   }


/**********************************************************************
	get products function
	entry -	p1= ptr to 32 element char array to store fuses for
		    products.
	exit  -	returns # products specified
***********************************************************************/
int get_prods(fuses)   char *fuses;{
   static int	cnt,
		token2,
		prods,
		input_line;
   static char	inmsg[] = {" Not a valid input pin"};

	/***   blow them all   ***/
   blowall(TRUE, fuses);

	/***   now get possible saves   ***/

   for (prods = 0, token = prodch; prods < (nfuses / 2) && token == prodch;
        prods++){
      token = parse();		/**  get name  **/
      cur_phase = FALSE;		/**  assume no invert  **/
      if (token == invert){	/**  if '/' then set inversion flag &  **/
         cur_phase = TRUE;
         token = parse();	/**  get pin name  **/
         }

	/***   if 'GND' then use pin 10 or 12   ***/
      if (token == GND)   token = npins / 2;

	/***   if 'VCC' then use last pin   ***/
      if (token == VCC)   token = npins;

	/***   check for fixed symbol   ***/
      if (token == openb){
         fixsym(fuses);
         prods += 2;
         }

      else{
         if ((token < 1 ) || token > npins || !inpin(token)){
            ierr(inmsg, token);
            }

         token2 = token;	/**  save this token & pre-fetch the next  **/
         token = parse();

	/***   if valid input pin then restore input fuse   ***/
         input_line = ixlate(token2);
         if (input_line == -1 || (input_line > 99 && (input_line % 100) < 2)){
            ierr(inmsg, token);
            }

         if (input_line >= 0)   fuses[input_line % 100] = FALSE;
         else if (input_line == GND){
            blowall(FALSE, fuses);
            prods++;
            break;
            }
         else if (input_line == VCC){
            blowall(TRUE, fuses);
            prods++;
            break;
            }
         }
      }
   if (prods == (nfuses / 2) && token == prodch)
      ierr("Too many terms in product");
   return prods;
   }


/********************************************************************
	blow or restore all fuses function
	entry -	p1= TRUE or FALSE
		p2= ptr to fuse array [32]
*********************************************************************/
blowall(flag, fptr)   int flag; char *fptr;{
   int	cnt;

   for (cnt = 0; cnt < nfuses; cnt++)   fptr[cnt] = flag;
   }


/***********************************************************************
	input pin test returns TRUE if pin is valid input pin for PAL
otherwise returns FALSE.
************************************************************************/
int inpin(pin)   int pin;{
   int temp;

   temp = ixlate(pin);
   if ((temp < 100 && temp != -1) || (temp < 4000 && (temp % 100) > 1))
      return TRUE;
   else return FALSE;
   }


/**************************************************************************
	function ixlate
   This function finds a match between the input pin number and the input
line number for a specific PAL. Add 1 to the input line number if the pin
is a complement.
	entry -	p1= pin number to translate
	exit  -	boii
		^^^^__ input product line number {0..99}
		||____ number of output terms {1..9} (0 :: not an output pin)
		|_____ digit bits defined as:
			1 :: tri-state output
			2 :: xor i/o pin
			4 :: arithmetic feedback PAL pin
		--- special cases ---
		-1:  not a valid programmable pin for this PAL
		-10: gnd
		-20: Vcc
***************************************************************************/
int ixlate(pin_num)   int pin_num;{
   int	input_line;
	/***   the following table contains the pin data as defined above.
		it is arranged as a table of pal_types elements each containing
		max PAL pins number of elements.   ***/
   static int itable[][24] = {
/**  1  **/
{2,0,4,8,12,16,20,24,28,-10,30,200,200,200,200,200,200,200,200,-20,-1,-1,-1,-1},
/**  2  **/
{2,0,4,8,12,16,20,24,28,-10,30,26,400,200,200,200,200,400,6,-20,-1,-1,-1,-1},
/**  3  **/
{2,0,4,8,12,16,20,24,28,-10,30,26,22,400,400,400,400,10,6,-20,-1,-1,-1,-1},
/**  4  **/
{2,0,4,8,12,16,20,24,28,-10,30,26,22,18,800,800,14,10,6,-20,-1,-1,-1,-1},
/**  5  **/
{2,0,4,8,12,16,20,24,28,-10,30,1700,1726,1722,1718,1714,1710,1706,1700,-20,-1,-1,-1,-1},
/**  6  **/
{-1,0,4,8,12,16,20,24,28,-10,-1,830,826,822,818,814,810,806,802,-20,-1,-1,-1,-1},
/**  7  **/
{-1,0,4,8,12,16,20,24,28,-10,-1,1730,826,822,818,814,810,806,1702,-20,-1,-1,-1,-1},
/**  8  **/
{-1,0,4,8,12,16,20,24,28,-10,-1,1730,1726,822,818,814,810,1706,1702,-20,-1,-1,-1,-1},
/**  9  **/
{2,0,4,8,12,16,20,24,28,-10,30,26,22,18,801,801,14,10,06,-20,-1,-1,-1,-1},
/**  10  **/
{-1,0,4,6008,6012,6016,6020,24,28,-10,-1,1730,1726,6420,6416,6412,6408,1706,1702,-20,-1,-1,-1,-1},
/**  11  **/
{2,0,4,8,12,16,20,24,28,32,36,-10,38,200,200,200,200,200,200,200,200,200,200,-20},
/**  12  **/
{2,0,4,8,12,16,20,24,28,32,36,-10,38,34,400,200,200,200,200,200,200,400,06,-20},
/**  13  **/
{2,0,4,8,12,16,20,24,28,32,36,-10,38,34,30,400,400,200,200,400,400,10,06,-20},
/**  14  **/
{2,0,4,8,12,16,20,24,28,32,36,-10,38,34,30,26,600,400,400,600,14,10,06,-20},
/**  15  **/
{2,0,4,8,12,16,20,24,28,32,36,-10,38,34,30,26,22,800,800,18,14,10,06,-20},
/**  16  **/
{2,0,4,8,12,16,20,24,28,32,36,-10,38,34,30,26,22,801,801,18,14,10,06,-20},
/**  17  **/
{2,0,4,8,12,16,20,24,28,32,36,-10,38,1300,1334,1330,1326,1322,1318,1314,1310,1306,1300,-20},
/**  18  **/
{-1,0,4,8,12,16,20,24,28,32,36,-10,-1,2238,2234,2230,2226,2222,2218,2214,2210,2206,2202,-20},
/**  19  **/
{-1,0,4,8,12,16,20,24,28,32,36,-10,-1,1338,2234,2230,2226,2222,2218,2214,2210,2206,1302,-20},
/**  20  **/
{-1,0,4,8,12,16,20,24,28,32,36,-10,-1,1338,1334,1330,2226,2222,2218,2214,1310,1306,1302,-20},

      };

	/***   check bounds first   ***/
   if (pin_num > 24 || pal_type > 20)   return -1;

   input_line = itable[pal_type - 1][pin_num - 1];
   if (((input_line >= 0 && input_line < 100) ||
        (input_line < 4000 && (input_line % 100) != 0)) &&
       (pin_phase[pin_num - 1] ^ cur_phase))   input_line += 1;

   return input_line;
   }


/************************************************************************
	check for valid output pin function
	exit -	FALSE= not valid output pin for this PAL
		TRUE= valid output pin
************************************************************************/
int is_out(pin)   int pin;{
   int temp;

   temp = ixlate(pin);
   return ((((temp / 100) % 10) != 0) && temp != -1) ? TRUE : FALSE;
   }


/*************************************************************************
	check for valid tri-state PAL function
  If a pin value of npins -1 is used, the pin check will allways be true
*************************************************************************/
int is_tri(pin)   int pin;{
   int temp;

   temp = ixlate(pin);
   return (((temp / 1000) & 1) && temp != -1) ? TRUE : FALSE;
   }


/*************************************************************************
	check for valid xor output pin
 Returns TRUE if valid, FALSE if not.
**************************************************************************/
int is_xor(pin)   int pin;{
   int temp;

   temp = ixlate(pin);
   return (((temp / 1000) & 2) && temp != -1) ? TRUE : FALSE;
   }


/************************************************************************
	check for valid fixed symbol pin
 Returns TRUE if valid, FALSE if not
************************************************************************/
int is_fixed(pin)   int pin;{
   int temp;

   temp = ixlate(pin);
   return (((temp / 1000) & 4) && temp != -1) ? TRUE : FALSE;
   }



/************************************************************************
	fixsym function
   Function fixsym evaluates the fixed symbols found in the PAL16X4 and
PAL16A4.
	entry-	p1= ptr to char fuse array
	exit -	number of fuses blown
*************************************************************************/
int fixsym(fuses)   char *fuses;{
   register int cnt;
   int	a_phase,	/**  a term inversion boolean  **/
	b_phase,	/**  b term inversion boolean  **/
	op,		/**  fixed symbol operator token  **/
	temp,
	indx,
	map,		/**  bit map for fuses  **/
	in_grp;		/**  fuse input product group  **/
   char	a_char,		/**  a term char ('A' or 'B')  **/
	b_char;		/**  b term char  **/

   static char	bits[][4] = {{3, 0xc, 0xa, 5},	/**  a or b  **/
			     {0xb,0xe,7,0xd},	/**  +  **/
			     {2, 8, 1, 4},	/**  *  **/
			     {9, -1, -1, -1},	/**  :+:  **/
			     {6, -1, -1, -1}	/**  :*:  **/
			     };

   if (pal_type != 10)   ierr("Fixed symbols not allowed for this PAL");

	/***   get 1st term (or only term)   ***/
   token = parse();
   in_grp = get_fixed(&a_phase, &a_char);

	/***   get any operator   ***/
   token = parse();
   switch (token){
      case sumch:
      case prodch:
      case xor:
      case xnor:
      case closeb:
         break;
      default:
         ierr(" Illegal fixed symbol operator", token);
         break;
      }

	/***   got operator so get 2nd term of equation   ***/
   if (token != closeb){
      op = token;		/**  save operator  **/

      token = parse();
      temp = get_fixed(&b_phase, &b_char);

	/***   check for close paren   ***/
      token = parse();
      if (token != closeb)   ierr(" Expected right paren", token);

	/***   now do some checking for syntax   ***/
      if (temp != in_grp)   ierr("Number mismatch");
      if (a_char >= b_char)   ierr("Output must be first");
      }

	/***   no operator so set up accordingly   ***/
   else
      op = 0;

	/***   everything seems ok so set up array index   ***/
   indx = (a_phase) ? 1 : 0;
   if (op == 0)   indx += (a_char == 'A') ? 0 : 2;
   else indx += (b_phase) ? 2 : 0;

	/***   select array from operator   ***/
   switch (op){
      case 0:
         map = bits[0][indx];
         break;

      case sumch:
         map = bits[1][indx];
         break;

      case prodch:
         map = bits[2][indx];
         break;

      case xor:
         map = bits[3][indx];
         break;

      case xnor:
         map = bits[4][indx];
         break;
      }

	/***   check for valid operation   ***/
   if (map == 255){
      fprintf(stdout,"\n%d %d %d %d %d ",a_phase,b_phase,op,token,in_grp);
      ierr("Fixed expression");
      }

	/***   unblow the fuses according to bits in map   ***/
   for (map &= 0xf, cnt = 0; cnt < 4; cnt++, map = map >> 1)
      if (!(map & 1))   fuses[in_grp + cnt] = FALSE;

	/***   fetch next token for caller   ***/
   token = parse();
   }


/***********************************************************************
	get fixed symbol function
	entry-	p1= ptr to place to put phase
		p2= ptr to place char of An form (0: not An form)
	exit -	input group base number

************************************************************************/
int get_fixed(phase, ch)   int *phase; char *ch;{
   char	c;

	/***   check for inversion   ***/
   if (token == invert){
      *phase = TRUE;
      token = parse();
      }
   else *phase = FALSE;

	/***   check for fixed 'An' form   ***/
   if (token == 0 && (*cptr == 'A' || *cptr == 'B')){
      *ch = *cptr;	/**  save char for single operand determination  **/

	/***   get term number   ***/
      if (incr(skip) < 0)   ierr(pre_eof);
      c = *cptr;
      if (c < '0' || c > '3')   ierr("Illegal term number");
      incr(skip);		/**  position to next field  **/

	/***   convert term number to input group number   ***/
      return ((c - '0') * 4) + 8;
      }

	/***   check for symbol form   ***/
   else if (token >= 1 && token <= npins){
      if (is_fixed(token)){

	/***   set char to 'B' if output pin symbol   ***/
         *ch = (((ixlate(token) / 100 ) % 10) == 0) ? 'B' : 'A';

	/***   set phase if current phase not equal to pin phase   ***/
         *phase = *phase ^ pin_phase[token -1];

	/***   compute input group base number   ***/
         return ixlate(token) % 100;	/**  return input group base  **/
         }
      }

	/***   non of the proper forms   ***/
   else ierr("not a valid fixed symbol");
   }

