;DMA TEST.  FILLS MEMORY WITH FF'S (OR ZEROES) AND READS IN THE OPPOSITE
;  AND CHECKS TO SEE IF THERE HAVE BEEN ANY CHANGES.
;  JULY 15, 1977
BDOS	EQU	0005H
SADR	EQU	400H
	ORG	100H
START:
	LXI	SP,100H
	XRA	A
	LXI  	H,100H
	MVI	B,03		;NUMBER OF 100H BYTES FOR CHECKSUM TO READ
XL:	ADD	M
	INR	L
	JNZ	XL
	INR	H
	DCR	B
	JNZ	XL
	PUSH	PSW
	MVI	C,9
	LXI	D,CKMSG		;PRINT OUT CHECKSUM MESSAGE
	CALL	BDOS
	POP	PSW
	CALL	PRHEX
	CALL	CRLF
	MVI	C,9
	LXI	D,FMSG		;PRINT OUT WRITTING FF'S MESSAGE
	CALL	BDOS
LOOP1:
	LDA	0007H			;EQUALS THE START OF THE BDOS
	STA	TOP
	LXI	D,BUFF
	CALL	SETDMA
	LXI	D,FCB1
	CALL	WRITEF		;WRITES OUT A FILE OF ZEROS (OR FF'S IF
				; THE BUFFER CONTENTS HAVE BEEN CHANGED)
	LDA	TPAT
	MOV	C,A
	CALL	FILL
	LXI	H,SADR
ML2:	SHLD	DMAD
	XCHG			;D&E GET THE DMA ADDRESS
	CALL	SETDMA
	LXI	D,FCB1
	CALL	READF		;READ THE BLOCK
	LHLD	DMAD
	CALL	FILLS
	LDA	TPAT
	MOV	C,A 
	CALL	COMP
	LHLD	DMAD
	LXI	D,128
	DAD	D
	LDA	TOP
	CMP	H
	JNZ	ML2
	LDA	TPAT
	CPI	0
	JZ	DONE
SECOND:
	MVI	C,9
	LXI	D,ZMSG
	CALL	BDOS
	XRA	A		;ZERO A
	STA	TPAT		;SET UP TEST TO RUN WITH ZEROES IN MEMORY
	STA	FCB1+32		;PREPARE TO RE-RIGHT THE TEST RECORD
	LXI	H,BUFF
	MVI	A,0FFH		;SET UP BUFFER SO IT HAS FF'S IN IT
	MOV	C,A
	MVI	A,04H		;PUT FF'S TO 400H TO BE SAFE
	CALL	FL1
	JMP	LOOP1		;GO RUN TEST AGAIN 
DONE:
	MVI	C,9
	LXI	D,SUCCMSG
	CALL	BDOS
	JMP	REBOOT
TPAT:	DB	0FFH
TOP:	DB	3EH
DMAD:	DW	0
FILL:	LXI	H,SADR	;FILL MEMORY WITH (C)
	LDA	TOP
FL1:	MOV	M,C
	INX	H
	CMP	H
	JNZ	FL1
	RET
;
;
COMP:	LXI	H,SADR	;COMPARE MEM WITH (C)
CL1:	MOV	A,C
	CMP	M
	CNZ	ERR
	INX	H
	LDA	TOP
	CMP	H
	JNZ	CL1
	RET
;
FILLS:	MVI	B,80H	;COMPLEMENT SECTOR AREA
FS1:	MOV	A,M
	CMA
	MOV	M,A
	INX	H
	DCR	B
	JNZ	FS1
	RET
;
ERR:
	CALL	GOODBAD
    	MOV	A,M	;ERROR LIST
	PUSH	B
	CALL	PRHEX
	PUSH	H
	CALL	ADDRESS
	CALL	PHL
	CALL	DMAADR
	LHLD	DMAD
	CALL	PHL
	POP	H
	LDA	TPAT
	MOV	M,A
	CALL	CRLF
	POP	B
	RET
;
PHL:	MOV	A,H
	CALL	PRHEX
	MOV	A,L
	CALL	PRHEX
	RET
;
PRHEX:	PUSH	PSW
	CALL	PA
	POP	PSW
	RRC
	RRC
	RRC
	RRC
	CALL	PA
	MVI	C,' '
	CALL	CONOUT
	RET
;
PA:	RRC
	RRC
	RRC
	RRC
	ANI	0FH
	ADI	30H
	CPI	3AH
	JC	POUT
	ADI	7
POUT:	MOV	C,A
	CALL	CONOUT
	RET
CRLF:	MVI	C,0DH
	CALL	CONOUT
	MVI	C,0AH
	CALL	CONOUT
	RET
GOODBAD:			;PRINTS THE GB PART OF THE LINE
	PUSH B! PUSH D! PUSH H
	MVI	C,9
	LXI	D,GBMSG
	CALL	BDOS
	LDA	TPAT
	CALL	PRHEX		
	POP H! POP D! POP B
	RET
ADDRESS:               		;PRINTS ADDRESS PART OF ERROR LINE
	PUSH B! PUSH D! PUSH H
	MVI	C,9
	LXI	D,ADMSG
	CALL	BDOS
	POP H! POP D! POP B
	RET
DMAADR:				;PRINTS THE DMA PART OF ERROR LINE
	PUSH B! PUSH D! PUSH H
	MVI	C,9
	LXI	D,DMAMSG
	CALL	BDOS
	POP H! POP D! POP B
	RET
CONOUT:
	PUSH B! PUSH D! PUSH H
	MOV	E,C
	MVI	C,2
	CALL	BDOS
	POP H! POP D! POP B
	RET
SETDMA:
	MVI	C,26
	CALL	BDOS
	RET
READF:
	XRA	A
	STA	FCB1+32
	MVI	C,20
	CALL	BDOS
	ORI	0
	RZ
	LXI	D,READERR
	MVI	C,9
	CALL	BDOS
	JMP	REBOOT
WRITEF:
	MVI	C,21
	CALL	BDOS
	ORI	0
	RZ
	LXI	D,WRITERR
	MVI	C,9
	CALL	BDOS
	JMP	REBOOT
REBOOT:	JMP	0
FCB1	DB	0
	DB	'DMATST$$$$$'
	DW	0,0,0,0,0
	DW	0,0,0,0,0
	DW	0
CKMSG	DB	'CHECKSUM = ','$'
FMSG	DB	'WRITING: FF',0DH,0AH,'$'
ZMSG	DB	'WRITING: 00',0DH,0AH,'$'
GBMSG	DB	'GB = ','$'
ADMSG	DB	' A = ','$'
DMAMSG	DB	' DMA ADDRESS = ','$'
SUCCMSG	DB	'TEST FINISHED',0DH,0AH,'$'
READERR	DB	'READ ERROR',0DH,0AH,'$'
WRITERR	DB	'WRITE ERROR',0DH,0AH,'$'
BUFF:
	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	END	START
