;THIS IS A VARIENT OF <<VDM DISPLAY DRIVER>>
;VERSION 3.0    APRIL 12, 1976   S.DOMPIER
;MODIFIED BY TOM CRAWFORD   OCT 1977
;
;
	ORG	0A00H	;TEMP
	PUSH	H
	PUSH	D
	PUSH	B
	PUSH	PSW
	CALL	SCREEN	;GO TO HEART OF PROGRAM
	POP	PSW	;RESTORE
	POP	B
	POP	D
	POP	H
	RET
;
;
SCREEN	MOV	A,B	;GET CHAR
	ANI	7FH	;DROP PARITY BIT
	CPI	7FH	;CHECK FOR RUBOUT
	RZ		;JUST IGNORE
	CPI	0AH	;ALSO LINEFEED
	RZ
	CPI	5FH	;BACKSPACE?   (SHIFT O)
	JZ	BKSPA
	CPI	'['	;CLEAR SCREEN?  (SHIFT K)
	JZ	CLR
	CPI	']'	;CURSOR CONTROL?  (SHIFT M)
	JZ	CURTG
	CPI	'\'	;SPPED CONTROL?   (SHIFT L)
	JZ	SETSP
	CPI	0DH	;CARRIAGE RETURN?
	JZ	CHOT2
;
;
TIMER	PUSH	PSW	;SAVE CHAR
	LDA	SPEED	;DELAY COUNTER
	MOV	H,A	;INTO H
	MVI	L,80H
	CALL	STATUS	;ANYBODY% RAJqhPJRJrXT2	;NO,CONT     <-----
	CALL	INPUT	;YES..SEE WHO
	CALL	NUMCK
	JMP	NEXT
;
;CHECK FOR TIME CONTROL VALUE
;
NUMCK	CPI	'9'+1	;CHECK IF ASCII NUMBER 1-9
	JNC	WAIT	;TOO BIG
	CPI	'1'
	JC	WAIT	;TOO SMALL
	ANI	0FH	;OK..REMOVE ASCII BIAS
	MOV	C,A	;SAVE DELAY NUMBER
	XRA	A	;CLEAR ACCUM
	STC		;INIT DELAY BIT IN CARRY
LESS	DCR	C	;DECREMENT DELAY NUMBER
	JZ	FOUND	;STOP ROTATING DELAY BIT
	RAL		;SHIFT DELAY BIT LEFT
	JMP	LESS	;NEXT ROUND
FOUND	STA	SPEED	;STORE DELAY TIME
	RET
;
NEXT	DCX	H	;DELAY MINUS ONE
NEXT2	MOV	A,H	;GET HIGH ORDER BITS OF DLAY COUNT
	ORA	A	;IS IT ZERO?
	JNZ	NEXT	;NO,,DELAY SOME MORE
	POP	PSW	;GET CHAR BACK
	JMP	CHOUT	;AND DO IT....FINALLY!!!!!!!!
;
;
WAIT	CPI	20H	;SPACE BAR?
	RNZ		;NO
WAIT2	CALL	STATUS	;WAIT FOR INPUT
	JZ	WAIT2	;<-------
	RET
;SET DELAY SPEED
;
SETSP	CALL	CHOT2
	LXI	H,MSG	;SPEED MESSAGE
SET1	MOV	A,M
	CPI	'X'	;MESSAGE TERMINATIOR
	JZ	SET2
	PUSH	H
	CALL	CHOUT	;MESSAGE TO SCREEN
	POP	H
	INX	H
	JMP	SET1
SET2	CALL	STATUS	;GET NEW SPPEED
	JZ	SET2	;WAIT FOR IT	<-----
	CALL	INPUT	;GET NUMBER
	CPI	'9'+1
	JNC	OPPS	;TOO BIG
	CPI	'1'
	JC	OPPS	;TOO SMALL
	PUSH	PSW	;SAVE IT
	CALL	CHOUT	;DISPLAY IT
	CALL	CHOT2
	POP	PSW
	JMP	NUMCK
OPPS	LXI	H,MSG+18	;PRINT "?"
	JMP	SET1
MSG	DB	' NEW SPEED (1-9)?  $!'
;
;
;
;CLEAR SCREEN AND ITIT CURSOR
;
CLR	LXI	H,VDMBASE
	MOV	A,H
	ADI	4
CLR2	MVI	M,' '	;CLEAR SCREEN TO  
	INX	H
	CMP	H
	JNZ	CLR2
	XRA	A
	STA	BOSL	;BEGINNING SCREEN LINE
	STA	BOTL	;BEGINNING TEXT LINE
	STA	CCP	;CURRENT CURSOR POINTER
	CMA
	STA	CURF	;CURSOR FLAG
	MVI	A,15
	STA	CLN	;CURSOR LINE NUMBER (AT BOTTOM)
	CALL	VDMOT	;SET VDM
	RET
;
;OUTPUT BOSL AND BOTL TO VDM
;
VDMOT	LDA	BOSL	;INIT VDM
	RLC
	RLC
	RLC
	RLC
	LXI	H,BOTL
	ORA	M
	OUT	VDMDEV	;VDM PORT NUMBER
	RET
;
;
;STORE CHAR INTO VDM MEMORY
;
CHOUT	MOV	C,A	;CHAR TO C REG
	LDA	CCP	;CURREN CURSOR POINTER
	MOV	B,A
	LDA	CLN	;GET LINE NUMBER
	CALL	CLNA	;CONVERT TO ADDRESS
	MOV	M,C	;PUT CHAR ON SCREEN
	LDA	CCP	;ADVANCE CURSOR
	INR	A
	CPI	64	;WRAP AROUND+
	JNZ	CHOT1
CHOT2	LDA	CCP	;OVERFLOW ONTO NEXT LINE
	MOV	B,A
	LDA	CLN
	CALL	CCUR	;CLEAR CURSOR
	CALL	SCRL	;SCROLL UP
	SUB	A	;SET CURSOR TOLEFT MARGIN
CHOT1	STA	CCP
	MOV	B,A
	LDA	CLN
	JMP	SCUR	;SET CURSOR ON/OFF
;
;
;BACKSPACE AND ERASE LAST CHAR
;
BKSPA	LDA	CCP	;GET CURSOR POINTER
	MOV	B,A
	LDA	CLN
	CALL	CCUR	;CLREA CURSOR
	DCX	H
	MVI	M,' '	;REMOVE CHAR
	DCR	B
	LDA	CLN
	JMP	SCUR	;SET CURSOR
;
;
;CURSOR DISPLAY (ON-OFF)
;
CURTG	LDA	CURF	;GET CURSUR FLAG
	CMA	
	STA	CURF	;SWITCH IT
	LDA	CCP
	MOV	B,A
	LDA	CLN	;CURRENT LINE NUMBER
	JMP	SCUR	;CURSOR ON/OFF
;
;SCROLL	SCREEN UP
;
SCRL	LXI	H,BOTL
	PUSH	H
	MOV	A,M
	INR	M
	SUB	M
	LXI	B,0
	CALL	CLNA
	LXI	B,2040H
SCRL2	MOV	M,B	;CLEAR BOTTON LINE
	INR	L
	DCR	C
	JNZ	SCRL2
	POP	H
	MOV	A,M
	ANI	0FH
	MOV	M,A
	JMP	VDMOT
;
;
;CONVERT LINE NUMBER IN REG A AND CHR
;POSITION IN REG B TO ADRS IN HL
;
CLNA	MOV	L,A
	LDA	BOTL	;LOAD OFFSET FOR LINE ZERO
	ADD	L	;REG A LOW 4 BITS IS LINE NUMBER
	RRC
	RRC
	MOV	L,A
	ANI	3
	ADI	VDMPAGE
	MOV	H,A
	MOV	A,L
	ANI	0C0H
	ADD	B
	MOV	L,A
	RET
;
;
;
;SET CURSOR TO LINE IN REG A AND CHAR POST IN REG B
;
SCUR	ANI	0FH
	STA	CLN
	CALL	CLNA
	MOV	A,B
	STA	CCP
	LDA	CURF
	ORA	A
	MOV	A,M
	JZ	CCUR2
	ORI	80H
	MOV	M,A
	RET
CCUR2	ANI	7FH
	MOV	M,A
	RET
;
;
CCUR	CALL	CLNA
	MOV	A,M
	ANI	7FH
	MOV	M,A
	RET
;
;
STATUS	IN	STAT
	ANI	DAV
	RET
;
INPUT	IN	DATA
	ANI	7FH
	RET
;
;
;RAM STORAGE
;
CLN	DB	0	;CURRENT LINE NUMBER
CCP	DB	0	;CURRENT CURSOR POSITION
CURF	DB	1	;CURSOR DISPLAY FLAG
BOSL	DB	0	;BEGINNING OF SCREEN LINE
BOTL	DB	0	;BEGONNING OF TEXT LINE
SPEED	DB	6	;DELAY BYTE
;
VDMBASE	EQU	0CC00H	;MEMORY ADRS<-----
VDMDEV	EQU	0C8H	;IO PORT<-----
VDMPAGE	EQU	VDMBASE/256	;<------
;
STAT	EQU	0	;STAT PORT<----
DATA	EQU	1	;DATA PORT<-----
TBE	EQU	2	;XMIT BUFFER EMPTY
DAV	EQU	1	;DATA AVAIL<-------
	END
HL