;-----------------------------------------------;
;						;
;	CP/M 8080 UTILITY PACKAGE		;
;						;
;-----------------------------------------------;
;						;
;	REV 0	12-JULY-77	MGL		;
;						;
;-----------------------------------------------;
;	EJECT
;
;	JUMP TABLE
;
	ORG	103H		;FOR CP/M LOAD VIA DDT
	JMP	WLINE		;WRITE LINE ON LIST DEVICE
	JMP	WMSG		;WRITE LINE ON CONSOLE DEVICE
	JMP	DSKSEL		;SELECT DISK
	JMP	OPNFIL		;OPEN FILE
	JMP	CLSFIL		;CLOSE FILE
	JMP	DELFIL		;DELETE FILE
	JMP	DREAD		;DISK READ (USING CP/M)
	JMP	DWRITE		;DISK WRITE(USING CP/M)
	JMP	CREFIL		;CREATE FILE
	JMP	DMASET		;SET DMA ADDRESS
	JMP	MOVE		;MOVE BYTES
	JMP	CMPCHR		;COMPARE BYTES  
	JMP	CMPHD		;COMPARE HL : DE
	JMP	MUL16		;HL <= HL * DE (16 BITS ONLY)
	JMP	GNB	;GET NEXT BYTE (1K BUFFERING) (USING FCB1)
	JMP	WNB		;WRITE NEXT BYTE (USING FCB1)
	JMP	GNB2		;GET NEXT BYTE (USING FCB2)
	JMP	WNB2		;WRITE NEXT BYTE (USING FCB2)
	JMP	CNV2HX		;CONVERT A REG TO HEX IN BUFFER (HL)
;	EJECT
;-----------------------------------------------;
;						;
;	COMMUNICATIONS AREA			;
;						;
;-----------------------------------------------;
;
FCB1	DB	0	;FILE CONTROL BLOCK #1
	DS	32	;REMAINING AREA
FCB2	DB	0	;FILE CONTROL BLOCK #2
	DS	32
IBP	DS	2	;INPUT BUFFER POINTER (FCB1)
IBP2	DS	1	;INPUT BUFFER POINTER (FCB2)
OBP	DS	1	;OUTPUT BUFFER POINTER (FCB1)
OBP2	DS	1	;OUTPUT BUFFER POINTER (FCB2)
IBUF	DW	INBUF	;INPUT BUFFER ADDRESS
OBUF	DW	OUTBUF	;OUTPUT BUFFER ADDRESS
IBUF2	DW	INBUF2	;INPUT BUFFER ADDRESS (FCB2)
OBUF2	DW	OUTBF2	;OUTPUT BUFFER ADDRESS (FCB2)
INBUF	DS	1024	;1K BUFFER FOR GNB (TO SPEED UP INPUT STREAM)
OUTBUF	DS	128	;I/O BUFFERS
INBUF2	DS	128
OUTBF2	DS	128
;
;	CP/M EQUATES
;
BDOS	EQU	5
BOOT	EQU	0
;
;	EJECT
;
;	ENTRY - USED TO CALL BDOS - SAVES AND RESTORES REGISTERS
;
ENTRY	EQU	$
	PUSH B ! PUSH D ! PUSH H
	CALL	BDOS
	POP H ! POP D ! POP B
	RET
;	EJECT
;
;	WLINE - WRITE LINE TO LIST DEVICE
;	HL -> BUFFER, TERM = 0AH
;
WLINE	EQU	$
	MOV A,M
	MOV E,A ! MVI C,5 ! CALL ENTRY
	MOV A,M ! CPI 0AH ! RZ
	INX H
	JMP WLINE
;	EJECT
;
;	WMSG - WRITE MESSAGE TO CONSOLE
;
;	DE -> MSG, TERM-'$'
;
WMSG	EQU	$
	MVI C,9 ! CALL ENTRY
	RET
;	EJECT
;
;	DSKSEL - SELECT DISK
;	DRIVE NUMBER IN A REG
;
DSKSEL	EQU	$
	MOV E,A ! MVI C,14 ! CALL ENTRY
	RET
;	EJECT
;
;	OPNFIL - OPEN FILE CONTROL BLOCK
;	REEL # AND NR ARE SET TO 00H
;	DE -> FCB
;	Z=0 SUCCESS, Z=1 FAILURE
;
OPNFIL	EQU	$
	PUSH H ! LXI H,12 ! DAD D ! MVI M,0 ;ZERO REEL #
	MVI C,15 ! PUSH D ! CALL ENTRY
	POP D
	CPI 255 ! POP H ! RZ ! PUSH H
	LXI H,32 ! DAD D ! MVI M,0 ; ZERO NR
	POP H
	RET
;	EJECT
;
;	CLSFIL - CLOSE FILE CONTROL BLOCK
;	DE -> FCB
;	Z=1 ERROR, Z=0 SUCCESS
;
CLSFIL	EQU	$
	MVI C,16 ! CALL ENTRY 
	CPI 255
	RET
;	EJECT
;
;	DELFIL - DELETE FILE
;	DE -> FCB
;	Z=1 ERROR, Z=0 SUCCESS
;
DELFIL	EQU	$
	MVI C,19 ! CALL ENTRY
	CPI 255
	RET
;	EJECT
;
;	DREAD - READ DISK SECTOR
;	DE -> FCB
;	Z=0 ERROR OR EOF, Z=1 NORMAL
;
DREAD	EQU	$
	MVI C,20 ! CALL ENTRY
	CPI 0
	RET
;	EJECT
;
;	DWRITE - WRITE DISK SECTOR
;	DE -> FCB
;	Z=0 ERROR, Z=1 NORMAL
;
DWRITE	EQU	$
	MVI C,21 ! CALL ENTRY
	CPI 0
	RET
;	EJECT
;
;	CREFIL - CREATE FILE
;
;	REEL # ASSUMMED TO BE SET
;
;	DE -> FCB
;	Z=0 NORMAL, Z=1 ERROR
;
CREFIL	EQU	$
	MVI C,22 ! CALL ENTRY
	CPI 255
	RET
;	EJECT
;
;	DMASET - SET DMA ADDRESS
;
;	BUFFER ADDRESS IN DE
;
DMASET	EQU	$
	MVI C,26 ! CALL ENTRY
	RET
;	EJECT
;
;	MOVE (HL) <= (DE) LEN IN BC
;
MOVE	EQU	$
	XCHG ! MOV A,M ! STAX D ! INX H ! INX D ;REPLACE 2 LINES BY EB,B0
	DCX B ! MOV A,B ! ORA C ! JNZ $-7 ;IF Z80 CPU
	XCHG		;PUT REGS BACK FOR CALLING ROUTINES SAKE
	RET
;	EJECT
;
;	CMPCHR - COMPARE STRINGS (HL) : (DE) LEN IN B
;
CMPCHR	EQU	$
	PUSH H ! PUSH D ! PUSH B ;SAVE REGS
	LDAX D ! CMP M ! JNZ CMPCH1
	INX H ! INX D ! DCR B ! JNZ CMPCHR+3
CMPCH1	POP B ! POP D ! POP H ;RESTORE REGS
	RET
;	EJECT
;
;	MUL16 - HL <= HL * DE (16 BITS ONLY)
;
MUL16	EQU	$
	PUSH B ! PUSH D ! POP B ! PUSH D
	XCHG
	LXI H,0
MUL16A	EQU	$
	MOV A,C ! ORA B ! JNZ MUL16B
	POP D ! POP B
	RET
;
MUL16B	DAD D ! DCX B ! JMP MUL16A
;	EJECT
;
;	CMPHD - COMPARE HL:DE
;
CMPHD	EQU	$
	MOV A,H ! CMP D ! RNZ
	MOV A,L ! CMP E ! RET
;	EJECT
;
;	GNB - GET NEXT BYTE (FCB1)
;
GNB	EQU	$
	PUSH H ! PUSH D
	LHLD IBP ! LXI D,INBUF+1024 ! CALL CMPHD ;SEE IF END OF BUFFER
	POP D ! POP H
	JNZ GNB0 ;BRANCH IF NOT AT END OF BUFFER
	PUSH H ! PUSH D ! PUSH B ;GET 1K BLOCK FROM DISK
	LXI H,INBUF ! SHLD GNBPTR ;SET UP POINTER FOR DMASET
	MVI B,8 ;NUMBER OF 128 BYTE SECTORS IN 1K BUFFER
GNB0A	PUSH B
	LHLD GNBPTR ! XCHG ! CALL DMASET ;SET UP DMA ADDRESS
	LXI D,FCB1 ! CALL DREAD ;GO READ A SECTOR
	LHLD GNBPTR ! LXI D,128 ! DAD D ! SHLD GNBPTR ;UPDATE POINTER
	POP B
	DCR B ! JNZ GNB0A ;BRANCH BACK IF MORE TO DO
	POP B ! POP D ;RESTORE REGS
	LXI H,INBUF ! SHLD IBP ! POP H ;SET UP NEXT DATA POINTER
GNB0	EQU	$
	PUSH H ! LHLD IBP ! MOV A,M ! INX H ! SHLD IBP ! POP H ;GET BYTE
	RET
GNBPTR	DS	2	;TEMP POINTER FOR BUFFERING
;	EJECT
;
;	GNB2 - GET NEXT BYTE (FCB2)
;
GNB2	EQU	$
	PUSH D 
	LDA IBP2 ! CPI 80H ! JNZ GNB20
	PUSH H ! PUSH B
	LXI D,INBUF2 ! CALL DMASET
	LXI D,FCB2 ! CALL DREAD
	POP B ! POP H
	XRA A
GNB20	EQU	$
	MOV E,A ! MVI D,0 ! INR A ! STA IBP2
	PUSH H ! LXI H,INBUF ! DAD D ! MOV A,M ! POP H
	POP D
	RET
;	EJECT
;
;	WNB - WRITE NEXT BYTE (FCB1)
;	BYTE IN A REG
;
WNB	EQU	$
	PUSH H ! PUSH D ! PUSH PSW
	LDA OBP ! CPI 80H ! JNZ WNB0
	LXI D,OUTBUF ! CALL DMASET
	LXI D,FCB1 ! CALL DWRITE ! JZ WNB00 ;BRANCH IF OK
	LXI D,WNBERR ! CALL WMSG ! JMP BOOT
WNB00	EQU	$
	XRA A
WNB0	EQU	$
	MOV E,A ! MVI D,0 ! INR A ! STA OBP  
	LXI H,OUTBUF ! DAD D ! POP PSW ! MOV M,A
	POP D ! POP H
	RET
;
WNBERR	DB	13,10,'OUTPUT FILE WRITE ERROR (DISK MAY BE FULL)',13,10,'$'
;	EJECT
;
;	WNB2 - WRITE NEXT BYTE (FCB2)
;
WNB2	EQU	$
	PUSH H ! PUSH D ! PUSH PSW
	LDA OBP2 ! CPI 80H ! JNZ WNB20
	LXI D,OUTBF2 ! CALL DMASET
	LXI D,FCB2 ! CALL DWRITE ! JZ WNB200 ;BRANCH IF ALL OK
	LXI D,WNBERR ! CALL WMSG ! JMP BOOT
WNB200	EQU	$
	XRA A
WNB20	EQU	$
	MOV E,A ! MVI D,0 ! INR A ! STA OBP2
	LXI H,OUTBF2 ! DAD D ! POP PSW ! MOV M,A 
	POP D ! POP H
	RET
;	EJECT
;
;	CNV2HX - CONVERT CONTENTS OF A REG TO HEX CHARACTERS
;	AND PLACE IN BUFFER POINTED TO BY HL
;
CNV2HX	EQU	$
	PUSH B
	MOV B,A 
	 RRC ! RRC ! RRC ! RRC ! ANI 0FH
	CALL CNV2H
	MOV A,B ! POP B
	ANI 0FH
CNV2H	EQU	$
	CPI 0AH ! JC CNV2H1 ! ADI 7
CNV2H1	ADI '0' ! MOV M,A ! INX H
	RET
;	EJECT
