;	
;  			W O R M T E S T	

; A serious flaw exists in most memory test routines
; when applied to Z-80 systems. A board can be tested for 
; hours	and never drop a bit, then when it's loaded with a 
; program fail instantly. The problem is that access timing 
; on a Z-80 instruction fetch (the M-1 cycle) is
; significantly more critical than on a simple read cycle. 
; No matter how	fancy a normal memory test gets, it never 
; makes demands	on memory speed that an actual program does. 
; The only way to check this memory for full speed operation 
; is to actually run a program in it. Wormtest does just that.
;   				vide The M-1 Worm. P.C. July 73
;
;	The first few lines relocate the program down to
; low memory There are two parts to the test program. The 
; larger portion consists of service routines, but the Worm
; itself consists of a short 12 byte routine that upon 
; initialization breaks away from the main body and crawls 
; up through memory space giving a running travelogue as he 
; goes. If he stops talking, you know something bad happened, 
; and where.
;
;	The Worm acts as the main program loop. It manipulates
; two test bytes and calls two subroutines. One of the 
; subroutines reports the location of the worm and detects
; and reports any errors in the test bytes. The other sub-
; routine shifts the Worm up in memory one location and 
; adjusts the return to begin execution for another loop.
;
;	There are seven instruction fetches per loop, with 
; the data manipulation instructions in complementary pairs
; to ensure full speed testing on both ones and zeroes.
; The instruction RST 7 is embedded in the Worm in non-
; executable locations as traps in case a memory error
; causes the program counter to get out of sync. The Worm
; leaves behind a slime-trail of FF's as it travels. Any
; execution of a trap is reported and the trap subroutine
; attempts to return execution back to the worm.
;
;	The error reports indicate which data byte was bad 
; and what the erroneous value was. A "D" indicates that 
; bits 	were dropped, while a "P" indicates that bits were
; picked. A trap error is flagged by a "T" followed by
; the address. Upon execution the Worm will immediately
; start reporting its location (by address) Bad memory 
; will trash the program or else trigger the error reports.
; No memory looks like a string of FF's and a sequential 
; string of traps will be reported.
;
;	When ROM is hit, execution of the ROM program will 
; begin, so if you have the Morrow Disk Controller you will 
; know 	your memory is ok when the system re-boots.
; 
;
	ORG	0100H
;
; Move routine relocates WORM program down to 08H
;
START:	LXI	D,DEST		;Destination address
	LXI	H,SOURCE	;Source address
	MVI	B,PEND-SOURCE+1	;Number of bytes to move
LOOP:	MOV	A,M		;Get byte
	STAX	D		;Put byte
	INX	H		;Bump up source adr.
	INX	D		;Bump up destination adr.
	DCR	B		;Decrease byte count
	JNZ	LOOP		;Do again if not zero count
	LHLD	1		;GET CBIOS START
	MOV	A,H		;HIGH ORDER
	LXI	H,PEND+1	;CLEAR FROM END TO CBIOS START
LOOP2:	MVI	M,00
	INX	H
	CMP	H
	JNZ	LOOP2
	dcx	h		;RST 7 at end of NOPs
	mvi	m,0FFh
;
	LXI	SP,STACK	;Set up stack pointer
	LXI	B,0		;Set up data pointer
	XRA	A		;VALUE = 0
	STAX	B
	MVI	A,0FFH		;RESTART 7
	STA	1		;FOR RE-ENTRY
	JMP	WORM		;START TEST
;
DEST	EQU	08H		;destination
;
SOURCE	EQU	$
OFFSET	EQU	DEST-SOURCE	;reloc amount
;
;	org	08h		;Start of relocated code
MOVWRM:	EQU	$+OFFSET
	POP	H		;Get address of worm + 1
	LDA	2		;GET CBIOS START
	CMP	H		;SEE IF MATCH
	JZ	STOP		;STOP TEST IF SO
	MOV	D,H		;Duplicate address in d
	MOV	E,L		;and e regs.
	DCX	D		;Set DE to last address of worm
	MVI	B,0CH		;Set length of worm

GETWRM:	EQU	$+OFFSET
	LDAX	D		;;Get byte of worm 
	MOV	M,A		;Move it up one location
	DCX	D		;Adjust pointers
	DCX	H
	DCR	B
	JNZ	GETWRM
	LXI	B,0		;Restore data pointer
	INX	H		;HL to start of worm
	INX	H
	PCHL			;Return to worm

	RST	7		;FILL OUT WITH RESTART 7'S
	RST	7

STOP:	EQU	$+OFFSET
	jmp	0E000h		; try to get to XMON
;
;	STARTS AT RESTART 5
RPTADR:	EQU	$+OFFSET
	CPI	0FFH		;Check for dropped bit error
	JNZ	ERRDRP
	MOV	A,B
	ORA	A		;Check for picked bit error
	JNZ	ERRPIK
	JMP	RPTAD2		;Show the address
	RST	7
	RST	7
	RST	7		;Trap
;
;	STARTS AT RESTART 7
TRAP:	EQU	$+OFFSET
	CALL	CRLF
	MVI	A,'T'		;Print a "T"
	CALL	OUTPUT
	POP	H		;Recover address
	DCX	H		;Adjust address
	CALL	ADOUT		;Print the address
	INX	H		;Adjust address
	CALL	CRLF
	PCHL			;Return
;
;
RPTAD2:	EQU	$+OFFSET
	POP	H		;Recover address
;
;	NOP THIS IF YOU HAVE A SLOW TERMINAL
;
	CALL	ADOUT		;Print address
	CALL	CR		;AND RETURN
;
;	UNLESS YOU REALLY LIKE SEEING THAT ADDRESS !!
;
	INX	H		;Adjust return address
	INX	H
	INX	H
	PCHL			;Return
;
;
ERRDRP:	EQU	$+OFFSET
	MVI	B,'D'		;Show it's dropped bit(s)
	JMP	ERRPRT		;Print error message
;
;
ERRPIK:	EQU	$+OFFSET
	MVI	B,'P'		;Show it's picked bit(s)
ERRPRT:	EQU	$+OFFSET
	MOV	C,A		;Save error data
	MVI	A,0DH		;LINE FEED
	CALL	OUTPUT
	MVI	A,'*'		;Print "*"
	CALL	OUTPUT
	MVI	A,' '		;Print " "
	CALL	OUTPUT
	MOV	A,B		;Print type of error
	CALL	OUTPUT
	MVI	A,' '		;Print " "
	CALL	OUTPUT
	MOV	A,C		;Get error data
	CALL	BOWCL		;Print and end line
	JMP	RPTAD2		;Now try for address and return
;
;
BOWCL:	EQU	$+OFFSET
	CALL	BYTOUT
CRLF:	EQU	$+OFFSET
	MVI	A,0AH		;LINE FEED
	CALL	OUTPUT
CR:	EQU	$+OFFSET
	MVI	A,0DH		;C/R
	JMP	OUTPUT
;
;
ADOUT:	EQU	$+OFFSET
	MVI	A,' '		;XMIT A SPACE
	CALL	OUTPUT
	MOV	A,H
	CALL	BYTOUT		;Its nybble time
	MOV	A,L
BYTOUT:	EQU	$+OFFSET
	PUSH	PSW		;Save A
	RRC			;Shift nybble
	RRC
	RRC
	RRC
	CALL	NYBOUT		;Nybble out 1
	POP	PSW		;Restore A
NYBOUT:	EQU	$+OFFSET
	ANI	0FH		;Strip high nibble
	ADI	30H		;ADD ASCII BIAS FOR NUMBERS
	CPI	3AH		;SEE IF NUMERIC
	JC	OUTPUT		;XMIT IF SO
	ADI	7		;ADD HEX OFFSET
;
;	************************************************
;	* Insert Your DIRECT Console Output Call Here  *
;	* unless you want to use cp/m calls till crash *
;	************************************************
;
OUTPUT:	EQU	$+OFFSET
	PUSH	H
	PUSH	B
	MOV	C,A
	CALL	COC
	POP	B
	POP	H
	RET
;
COC:	EQU	$+OFFSET
	LHLD	1		;GET CBIOS START
	MVI	L,0CH		;ADD CONOUT OFFSET
	PCHL			;JUMP TO CONSOLE OUTPUT
;
;
	DS	64
STACK:	EQU	$+OFFSET-1	;BE CAREFUL TO ALLOW ENOUGH STACK AREA 
				;FOR CBIOS
;
;
WORM:	EQU	$+OFFSET
	RST	7		;Trap
	LDAX	B		;Move data to A; start of worm
	PUSH	PSW		;Push test data onto stack
	MVI	A,0FFH		;Move second test byte to A
	POP	B		;Pop first test byte into B
	RST	5		;call "rptadr"
	RST	7		;Trap
	RST	7
	RST	7
	NOP			;"rptadr" return location
	RST	1		;call "movwrm"
;
PEND:	EQU	$		;program end
;
