;
;TITLE	'Extended Sorted Directory for CP/M'
;++ ****************************************
;		(revised 7/4/80)
;
;$$ XD  	WRITTEN BY:	S.J.SINGER
;		MODIFIED BY:	H.R.MORAN JR.
;		MODIFIED BY:	R.M.GLUECK
;		MODIFIED BY:	K.B.PETERSEN, W8SDZ
;		MODIFIED BY:	JOHN C. ROSSMANN
;
; XD is a CP/M utility that displays the disk
; directory in a more readable form than DIR.
; It does all directory functions with standard
; BDOS calls (no direct track and sector reads).
; The directory is read from the specified drive,
; sorted, then displayed in up to four columns.
; Both the file names and file sizes (which are
; rounded up if 2k groups are used) agree with the
; information given by the CP/M STAT utility.
; This program will work with either standard CP/M
; (100H TPA) or ALTERNATE CP/M (4300H TPA, for Heath
; H8 or TRS-80 model I).
;
;	COMMAND FORMAT
;
; XD		DISPLAY DIRECTORY OF LOGGED DISK
; XD [<DRIVE>:][<AMBIGUOUS FILE NAME>]
;
; WHERE ITEMS ENCLOSED IN BRACKETS ARE OPTIONAL AND
; ITEMS ENCLOSED IN <> ARE CLASSES.
;
;
; EXAMPLES:
;	XD ?ABC*.COM
;
; INCLUDE ALL FILES WHOSE TYPE IS .COM AND
; WHOSE SECOND,THIRD AND FOURTH CHARACTERS
; OF THEIR NAMES ARE A,B,C RESPECTIVELY.
;
;	XD B:
;
; INCLUDE ALL FILES ON DRIVE B.
;
;	XD B:*.ASM
;
; INCLUDE ALL FILES ON DRIVE B WHOSE TYPE
; IS .ASM.
;
;-- ****************************************
;
; HISTORY:
;
; ORIGINAL FILE WAS XDIR BY S.J.SINGER CPMUG VOL 24
;
; REWRITE FOR GENERALITY AND MAJOR IMPROVEMENTS IN
; DOCUMENTATION BY H.R.MORAN JR AS XSDIR.
; 
; MODIFIED FOR MICROPOLIS MOD II BY R.M.GLUECK 3/29/80.
; AND RENAMED XD.
;
; MODIFICATIONS 7, 8, 9, 10, 11, 12, 13, 14 BY KEITH PETERSEN,
; W8SDZ, JUNE 2, 1980.
;
; MODIFICATION 15 BY JOHN C. ROSSMANN, JULY 4, 1980
;
; MODIFICATIONS:
;	1) ALLOW SPECIFICATION OF AMBIGUOUS FILE NAMES.
;	2) COUNT REMAINING SPACE CORRECTLY EVEN IF NOT
;	   ALL FILES ARE DISPLAYABLE.
;	3) MADE USEABLE FOR 32 SECTOR MICROPOLIS DISKETTES.
;	4) FOUR COLUMN FORMAT INSTEAD OF THREE.
;	5) SHOW INDICATION OF THE NUMBER OF DIRECTORY ENTRIES USED.
;	6) COMMENT MORE THOROUGHLY TO EASE FURTHER MODIFICATION.
;	7) MAKE COMPATABLE WITH CP/M 1.4 AND CP/M 2.x.
;	8) EXPAND MACROS SO MAC ASSEMBLER NOT REQUIRED, AND TO
;	   ALLOW EASY MODIFICATION OF ALL CODE. NOW WORKS WITH ANY
;	   CP/M SYSTEM, NOT JUST MICROPOLIS.
;	9) ALLOW OPERATOR ABORT BY PRESSING ANY KEY.
;      10) ADD EIGHT MORE NAMES TO MAXIMUM PRINTABLE ON A PAGE.
;      11) ELIMINATE PRINTING OF 'FENCE' CHARACTER TO RIGHT OF
;	   LAST COLUMN PRINTED.
;      12) ADD 'k' AFTER PRINTING FILE SIZE.
;      13) ADD 'NOT FOUND' MESSAGE FOR NO MATCH.
;      14) ALLOW CONDITIONAL ASSEMBLY FOR 1k/2k GROUPS.
;      15) MAKE ADDRESSING RELATIVE TO 'BASE' AND ADD
;	   CONDITIONALS FOR STANDARD OR ALTERNATE CP/M.
;
FALSE	EQU	0
TRUE	EQU	NOT FALSE
;
; PARAMETER DEFINITIONS
;
;----- HARDWARE SPECIFIC PARAMETERS -----
;
;  CONDITIONAL FOR STANDARD CP/M OR ALTERNATE CP/M
;  FOR H8 OR TRS-80 MODEL I.
;
STDCPM	EQU	TRUE	;TRUE IF STANDARD CP/M
ALTCPM	EQU	FALSE	;TRUE IF ALTERNATE CP/M
;
	IF	STDCPM
BASE	EQU	0000H
	ENDIF
;
	IF	ALTCPM
BASE	EQU	4200H
	ENDIF
;
SMALL	EQU	TRUE 	;TRUE IF 64 WIDE CRT
CRTLEN	EQU	16	;NUMBER OF PHYSICAL LINES ON CONSOLE DEVICE
DSKSIZ	EQU	241	;NUMBER OF KILOBYTES ON A DISK
DBLGRP	EQU	FALSE	;TRUE IF 2K GROUP SIZE
;
;----- END HARDWARE SPECIFIC  PARAMETERS -----
;
LINES	EQU	CRTLEN-2 ;LINES PER PAGE ON DISPLAY
ENTRIES	EQU	128	;MAX NUMBER OF DIRECTORY ENTRIES
MULTUSR EQU	FALSE	;TRUE IF MULTIPLE USERS ON CP/M-2
;
TBUFF	EQU	BASE + 80H	;TRANSIENT BUFFER
TFCB	EQU	BASE + 5CH	;TRANSIENT FCB
BDOS	EQU	BASE + 5H	;ENTRY TO BASIC DISK OPERATING SYSTEM
CR	EQU	0DH		;CARRIAGE RETURN
LF	EQU	0AH		;LINE FEED
;
; MAKE SURE WE CAN'T POINT PAST THE DIRECTORY POINTER TABLE
;
DIRLEN	EQU	2*(ENTRIES+1)	;POINTER TABLE LENGTH
;
;
	ORG	BASE + 100H	;CP/M COMPATIBLE ORIGIN
;
XD:	EQU	$
BEGIN:	LXI	H,0
	DAD	SP	;SAVE CCP STACK-POINTER
	SHLD	CCPSTK
	LXI	SP,LCLSTK ;INIT LOCAL STACK-POINTER
;
DIR:	LDA	TFCB+1	;1'ST CHAR OF AMBIGUOUS FILE NAME
	STA	ALLF	;SAVE AS A FLAG FOR THE
			;BYTECOUNT PRINT FORMAT ROUTINE
	CPI	' '	;WAS A NAME MATCH SPECIFIED ?
	JNZ	ADDED	;YES, SKIP MATCH ANYTHING ROUTINE
;
;NO, MAKE A MATCH ANYTHING FCB BY FILLING WITH '?'
	LXI	H,TFCB+1
	MVI	C,11	;LENGTH OF FCB NAME.TYPE
;
DIR2:	MVI	M,'?'	;PUT '?' INTO MEMORY
	INX	H	;POINT AHEAD
	DCR	C	;ONE LESS COUNT
	JNZ	DIR2	;NOT DONE, DO MORE
;
ADDED:	MVI	A,'?'
	STA	TFCB+12	;FORCE MATCH OF ALL EXTENTS
	LDA	TFCB	;A=DRIVE SPECIFIER
	ORA	A	;WAS DRIVE EXPLICITLY SPECIFIED ?
	JNZ	SPECDV	;YES, SKIP INTERROGATE DISK REQUEST
;
;NO,USE THE DEFAULT DRIVE
	MVI	C,25	;INTERROGATE DISK FUNCTION
	CALL	BDOS	;FIND OUT WHICH DISK WE'RE ON
	INR	A	;MAKE A: = 1
;
SPECDV:	ADI	'A'-1	;MAKE IT ASCII.
	STA	DRIVEID	;SAVE THE ASCII DRIVE ID.
	CALL	CRLF	;TURN UP A NEW LINE
	XRA	A
	STA	COUNT	;COUNT OF DIRECTORY ENTRIES=0
;
;INITIALIZE POINTERS
	LXI	H,DIRBUF ;HL=.(DIRECTORY BUFFER)
	SHLD	OUTBPTR	 ;OUTBPTR=.(DIRECTORY BUFFER)
	LXI	H,PDIR	 ;HL=.(POINTER TABLE)
	SHLD	IPOINT	 ;IPOINT=.(POINTER TABLE)
;
;ZERO THE POINTER TABLE (HL ALREADY = PDIR)
	LXI	B,DIRLEN+1 ;LENGTH OF TABLE
	MVI	E,0
;
ZTABLE:	MOV	M,E	;PUT 0 INTO MEMORY
	INX	H	;POINT AHEAD
	DCX	B	;ONE LESS COUNT
	MOV	A,C	;CHECK TO SEE...
	ORA	B	;...IF COUNT = 0
	JNZ	ZTABLE	;NOT DONE, DO MORE
;
; READ THE SPECIFIED PORTION OF THE
; DIRECTORY INTO A BUFFER. IF THE EXTENT
; IS NON-ZERO THEN REPLACE THE CURRENT
; ENTRY IN THE BUFFER THEREBY ADDING TO ITS
; ALLOCATION COUNT.
;
;SEARCH FOR FIRST MATCH IN DIRECTORY
	LXI	D,TFCB
	MVI	C,17	;SEARCH FIRST FUNCTION
	CALL	BDOS
	CPI	255	;WAS A MATCH FOUND?
	JNZ	DIR6	;YES, CONTINUE
	CALL	ERXIT	;NO, EXIT WITH MSG:
	DB	'++NOT FOUND$'
;
;SEARCH FOR NEXT MATCH IN DIRECTORY
DIR4:	LXI	D,TFCB
	MVI	C,18	;SEARCH NEXT FUNCTION
	CALL	BDOS
	CPI	255	;WAS ANOTHER MATCHING ENTRY FOUND?
	JZ	SORT	;NO, GO SORT AND PRINT
;
DIR6:	ANI	3
	LHLD	OUTBPTR
	XCHG		;DE=DESTINATION POINTER
	LXI	H,TBUFF	;CALCULATE POINTER TO ENTRY IN TBUFF
	ADD	A
	ADD	A
	ADD	A
	ADD	A
	ADD	A	;MULTIPLY BYTE POINTER BY ENTRY SIZE (32)
	ADD	L	;CONSTRUCT POINTER TO ENTRY
	MOV	L,A
	JNC	DIR8
	INR	H
;
DIR8:	SHLD	INBPTR	;SAVE POINTER TO ENTRY
	INX	H	;BYPASS 1'ST BYTE (0 OR 0E5H)
	PUSH	H
	PUSH	B
	CALL	CLEFCB	;CLEAR FCB OF FILE ATTRIBUTES
	POP	B
	POP	H
	PUSH	H
	PUSH	D
	LXI	D,11
	DAD	D	;HL=.(EXTENT BYTE)
	MOV	A,M	;A=EXTENT BYTE
	ORA	A
	JZ	DIR10	;IS THIS THE ZEROTH EXTENT ?
	LXI	H,0	;NO, SEARCH FOR SAME NAME AND 'SWITCH' ENTRIES
	SHLD	J	;J=0 (INITIALIZE INDEX)
;
DIR9:	LHLD	J
	LXI	D,PDIR
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
	MOV	A,H	;IS THE TABLE EMPTY?
	ORA	L
	JZ	DIR10	;YES, EXIT
	XCHG		;NO,SEARCH FOR A MATCH WITH CURRENT ENTRY
	LHLD	INBPTR	;HL=.(CURRENT ENTRY)
	PUSH	D
	PUSH	H
	INX	H	;BYPASS DRIVE ID
;
;COMPARE NAME AND TYPE (11 CHARS)
;
	MVI	C,11	;NUMBER OF CHARACTERS
	CALL	MATCH	;DO THEY MATCH?
	POP	H
	POP	D
	JZ	SWITCH	;NO, COMPARE WITH NEXT SAVED ENTRY
;J=J+2 (BYTES I.E. 1 ENTRY)
	LHLD	J
	LXI	D,2
	DAD	D
	SHLD	J
	JMP	DIR9
;
MATCH:	INR	C
;
MATCH2:	DCR	C
	RZ
	LDAX	D
	SUB	M
	RNZ
	INX	H
	INX	D
	JMP	MATCH2
;
SWITCH:	INX	H	;BYPASS DRIVE ID
;
;OVERWRITE THE OLD SAVED ENTRY
	LXI	B,15
	CALL	MOVE
	POP	H
	JMP	DIR4	;READ ANOTHER ENTRY FROM DISK DIRECTORY
;
;MOVE (BC) BYTES FROM (HL) TO (DE)
;
MOVE:	MOV	A,B
	ORA	C
	RZ
	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCX	B
	JMP	MOVE
;
DIR10:	POP	D
	POP	H
;
;SAVE THE CURRENT ENTRY
	LXI	B,15
	CALL	MOVE
	LDA	COUNT
	INR	A
	STA	COUNT	;COUNT=COUNT+1
	LHLD	OUTBPTR
;
;UPDATE POINTER TABLE TO REFLECT NEW ENTRY
	PUSH	H
	LHLD	IPOINT
	XCHG
	LXI	H,0
	DAD	D
	POP	D
	MOV	M,E
	INX	H
	MOV	M,D
;
;OUTBPTR=OUTBPTR+16 (BYTES  I.E. 1 ENTRY)
	LHLD	OUTBPTR
	LXI	D,16
	DAD	D
	SHLD	OUTBPTR
;
;IPOINT=IPOINT+2 (BYTES I.E. 1 ENTRY)
	LHLD	IPOINT
	LXI	D,2
	DAD	D
	SHLD	IPOINT
      	JMP	DIR4	;READ ANOTHER ENTRY FROM DISK DIRECTORY
;
; THIS ROUTINE PRINTS THE DIRECTORY
; IN 4 COLUMNS. THE NUMBER OF LINES
; PRINTED IS CONTROLLED BY THE VARIABLE LINES.
; ALL MATCHED DIRECTORY NAMES ARE PRESENT
; IN THE TABLE BUT ONLY A MAXIMUM OF
; 4 TIMES LINES WILL BE PRINTED.
;
DIR14:	LXI	H,0
	SHLD	W	;INITIALIZE THE COUNT OF KBYTES ON DISK.
	SHLD	I	;INITIALIZE THE POINTER INDEX
;
;POINTER TO COLUMN 1
DIR16:	LHLD	I
	LXI	D,PDIR+LINES*0
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
;
;EXIT IF POINTER IS ZERO (I.E. EMPTY)
	MOV	A,H
	ORA	L
	JZ	ENDFIL
	CALL	DIR20	;PRINT COLUMN 1 ENTRY
;
;POINTER TO COLUMN 2
	LHLD	I
	LXI	D,PDIR+LINES*2
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
;
;BYPASS IF POINTER IS ZERO (I.E. EMPTY)
	MOV	A,H
	ORA	L
	JZ	DIR18
	CALL	DIR20F	;PRINT COLUMN 2 ENTRY W/FENCE
;
;POINTER TO COLUMN 3
	LHLD	I
	LXI	D,PDIR+LINES*4
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
;
;BYPASS IF POINTER IS ZERO (I.E. EMPTY)
	MOV	A,H
	ORA	L
	JZ	DIR18
	CALL	DIR20F	;PRINT COLUMN 3 ENTRY W/FENCE
;
;POINTER TO COLUMN 4
	LHLD	I
	LXI	D,PDIR+LINES*6
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
;
;BYPASS IF POINTER IS ZERO (I.E. EMPTY)
	MOV	A,H
	ORA	L
	JZ	DIR18
	CALL	DIR20F	;PRINT COLUMN 4 ENTRY W/FENCE
;
DIR18:	CALL	CRLF	;TURN UP NEW LINE
;
;I=I+2 (BYTES I.E. 1 ENTRY)
	LHLD	I
	LXI	D,2
	DAD	D
	SHLD	I
	LXI	D,LINES*2 ;CHECK INDEX LIMIT
	MOV	A,H
	CMP	D
	JNZ	DIR18A
	MOV	A,L
	CMP	E
;
DIR18A:	JNZ	DIR16	;IS CONSOLE SCREEN FULL ?
	MVI	A,1	;YES, SET SCREEN FULL FLAG
	STA	SFF	;SFF=1
;
;NO, ADD IN SIZES OF REMAINING FILES
;
DIR19:	LHLD	I
	LXI	D,PDIR+LINES*6
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
	MOV	A,H
	ORA	L
	JZ	ENDFIL
	CALL	DIR20A
;
;INDEX	I,2
	LHLD	I
	LXI	D,2
	DAD	D
	SHLD	I
	LXI	D,2*ENTRIES
	MOV	A,H
	CMP	D
	JNZ	DIR19A
	MOV	A,L
	CMP	E
;
DIR19A:	JNZ	DIR19	;MAX ENTRIES EXCEEDED ?
	JMP	ENDFIL	;YES, FINISH UP AND EXIT
;
;
; SUBROUTINE TO PRINT A SINGLE
;	DIRECTORY ENTRY
;
DIR20F:	CALL	ILPRT	;PRINT:
	DB	' | ',0	;FENCE CHARACTER AND SPACES
;
DIR20:	MVI	C,8	;C=NAME LENGTH
	CALL	TYPEM	;TYPE FROM MEMORY
;
	IF	NOT SMALL
	MVI	A,'.'
	CALL	TYPE	;PRINT PERIOD BETWEEN NAME AND TYPE
	ENDIF
;
	MVI	C,3	;PRINT FILE TYPE
	CALL	TYPEM
	JMP	DIR24	;GO PRINT FILE SIZE
;
; ADD IN SIZES OF FILES WHICH WON'T FIT ON SCREEN
;
DIR20A:	LXI	B,11
	DAD	B	;HL=.(EXTENT BYTE)
;
; ACCUMULATE THE FILE SIZE IN KBYTES
;
DIR24:	MOV	A,M	;A=EXTENT BYTE
	XCHG		;DE=.(ENTRY)
	MVI	H,0
	MOV	L,A	;HL=EXTENT BYTE
	LDA	FCBCNT
	ADD	L
	INR	A
	STA	FCBCNT
	DAD	H
	DAD	H
	DAD	H
	DAD	H	;HL=HL*16 KBYTES PER EXTENT
	INX	D
	INX	D
  	INX	D	;DE=.(NUMBER OF RECORDS BYTE)
	LDAX	D	;A=NUMBER OF RECORDS IN FINAL EXTENT
	RRC
	RRC
	RRC		;A=A/8 RECORDS PER KBYTE
	PUSH	PSW
	ANI	1FH	;ROUND UP IF THERE IS A FRACTIONAL KBYTE
	ADD	L	;(NOTE: NO CARRYS ARE POSSIBLE)
	MOV	L,A	;HL=# OF FULL KBYTES IN FILE
	POP	PSW
	ANI	0E0H	;A=NUMBER OF RECORDS MOD 8
	JZ	DIR26	;DOES FINAL EXTENT CONTAIN A PARTIAL KBYTE ?
	INX	H	;YES, ADD ONE KBYTE FOR THE PARTIAL ONE
;
DIR26:	MOV	A,L
;
	IF	DBLGRP	;IF 2K GROUP SIZE
	CALL	CORFCT	;CORRECT FILE COUNT
	ENDIF		;DBLGRP
;
	LDA	SFF	;A=SCREEN FULL FLAG
	ORA	A
	JNZ	DIR30A	;IS THE CONSOLE SCREEN FULL ?
			;NO, CONTINUE DISPLAYING
;
;PRINT SPACING BASED ON HOW MANY DIGITS IN THE KBYTE COUNT
;
	PUSH	H
	LXI	D,100
	MOV	A,H
	CMP	D
	JNZ	DIR26A
	MOV	A,L
	CMP	E
;
DIR26A:	JM	DIR27
	MVI	A,' '	; 3 DIGITS = 1 SPACE
	CALL	TYPE
	JMP	DIR30
;
DIR27:	POP	H
	PUSH	H
	LXI	D,10
	MOV	A,H
	CMP	D
	JNZ	DIR27A
	MOV	A,L
	CMP	E
;
DIR27A:	JM	DIR28
	CALL	ILPRT	;PRINT:
	DB	'  ',0	; 2 DIGITS = 2 SPACES
	JMP	DIR30
;
DIR28:	CALL	ILPRT	;PRINT:
	DB	'   ',0	; 1 DIGIT  = 3 SPACES
;
; ADD KBYTES IN THIS FILE TO TOTAL KBYTES COUNTED
;
DIR30:	POP	H
	PUSH	H
	XCHG
	LHLD	W
	DAD	D
	SHLD	W	;W=W + KBYTES IN THIS FILE
	POP	H
;
;PRINT THE NUMBER OF KBYTES IN THIS FILE AS DECIMAL
;
	CALL	DECOUT
	MVI	A,'k'	;PRINT 'k' AFTER FILE SIZE
	CALL	TYPE
	RET
;
DIR30A:	PUSH	H
	XCHG
	LHLD	W
	DAD	D
	SHLD	W	;W=W + KBYTES IN THIS FILE
	POP	H
	RET
;
;THIS IS THE EXIT POINT FROM THE PROGRAM.
;PRINT THE NUMBER OF FILES AND THE SPACE REMAINING.
;RESTORE THE CCP STACK POINTER AND RETURN TO CCP.
;
ENDFIL:	CALL	ILPRT	;PRINT:
	DB	'Drive ',0
;
;PRINT ASCII OF SPECIFIED OR DEFAULT DISK
	LDA	DRIVEID
	CALL	TYPE
	CALL	ILPRT	;PRINT:
	DB	': - ',0
;
;PRINT COUNT OF FILES
	LHLD	COUNT
	CALL	DECOUT
	CALL	ILPRT	;PRINT:
	DB	' Files (',0
;
;PRINT NUMBER OF ENTRIES
	LHLD	FCBCNT
	CALL	DECOUT
	CALL	ILPRT	;PRINT:
	DB	' entries) ',0
;
	LHLD	W
	LDA	ALLF
	CPI	' '	;WERE ALL FILES PRINTED?
;
	IF	MULTUSR
	JMP	SOME
	ENDIF
;
        IF	NOT MULTUSR
	JNZ	SOME
	ENDIF
;
	LXI	B,DSKSIZ ;YES, CALCULATE REMAINING SPACE
	MOV	A,C
	SUB	L
 	MOV	L,A
	MOV	A,B
	SBB	H
	MOV	H,A
;
;PRINT EITHER SUM OF FILES MATCHED OR REMAINING SPACE
SOME:	CALL	DECOUT
	LDA	ALLF
	CPI	' '	;WERE ALL FILES PRINTED?
;
	IF	MULTUSR
	JMP	SOME2
	ENDIF
;
	IF	NOT MULTUSR
	JNZ	SOME2
	ENDIF
;
;YES, SHOW THE SPACE REMAINING ON DISK.
;
	CALL	ILPRT	;PRINT:
;
	IF	SMALL
	DB	'k bytes remaining',0
	ENDIF
;
	IF	NOT SMALL
	DB	'k bytes remaining on disk',0
	ENDIF
;
	JMP	EF1	;DONE, EXIT
;
;SHOW SUM OF FILES PRINTED IF NOT ALL FILES WERE PRINTED
;
SOME2:	CALL	ILPRT	;PRINT:
;
	IF	SMALL
	DB	'k bytes matched',0
	ENDIF
;
	IF	NOT SMALL
	DB	'k bytes in the matched files',0
	ENDIF
;
	JMP	EF1	;DONE, EXIT
;
;ERROR EXIT
;
ERXIT:	POP	D	;GET MSG
	MVI	C,9	;PRINT FUNCTION
	JMP	CALLB	;PRINT MSG, EXIT
;
;ABORT - READ CHAR ENTERED
;
ABORT:	LXI	SP,LCLSTK ;ASSURE VALID STACK-POINTER
	MVI	C,1	;READ CONSOLE CHARACTER FUNCTION
;
CALLB:	CALL	BDOS	;DELETE THE CHAR, FALL INTO EXIT
;
;EXIT - ALL DONE , RESTORE STACK
;
EF1:	LHLD	CCPSTK
	SPHL		;RESTORE THE CCP STACK-POINTER
	RET		;RETURN TO CCP WITHOUT REBOOT.
;
;
;THIS SECTION DOES THE ACTUAL SORTING
;OF THE DIRECTORY. DURING THE
;INPUT OF THE DIRECTORY NAMES,
;A TABLE OF ADDRESS POINTERS PDIR
;WAS CONSTRUCTED. THE SORT ROUTINE
;SORTS THE ADDRESS POINTERS
;RATHER THAN THE ACTUAL DIRECTORY. 
;THIS IS AN IMPLEMENTATION OF
;C. A. R. HOARE'S QUICKSORT ALGORITHM.
;THE ALGORITHM IS VERY FAST AND GENERALLY
;USEFUL, HOWEVER CAUTION
;SHOULD BE USED WITH LARGE FILES.
;THE ALGORITHM IS RECURSIVE AND
;THE STACK SPACE REQUIRED IS PROPORTIONAL
;TO THE NUMBER OF ITEMS TO BE SORTED.
;
SORT:	LDA	COUNT	;A=NUMBER OF ENTRIES FOUND
	ORA	A
	JZ	ENDFIL	;WERE ANY ENTRIES FOUND ?
	DCR	A	;YES, A=NUMBER OF ENTRIES-1
	LXI	H,0
	MOV	L,A
	DAD	H	;HL=2*(NUMBER OF ENTRIES-1)
	SHLD	LAST	;END OF ARRAY IS HL
	LXI	H,0
	SHLD	FIRST	;START OF ARRAY IS ZERO
	LXI	H,-1
	PUSH	H	;FLAG STACK AS BEING EMPTY
	LHLD	FIRST
	PUSH	H
	LHLD	LAST
	PUSH	H	;STACK CONTAINS FIRST AND LAST INDICES
;
;POP STACK AND RECURSIVELY CALL SPLIT UNTIL STACK IS EMPTY
;
SORT2:	POP	H
	MOV	A,H
	CPI	0FFH
	JZ	DIR14	;IS STACK EMPTY ?
	SHLD	J	;NO, CONTINUE SORTING
	SHLD	LAST	;J=LAST=HL
	POP	H	;HL=STACK
	SHLD	I
	SHLD	FIRST	;I=FIRST=HL
	CALL	SPLIT
	LHLD	I
	XCHG		;DE=I
	LHLD	FIRST	;HL=FIRST
	MOV	A,H
	CMP	D
	JNZ	SORT2A
	MOV	A,L
	CMP	E
;
SORT2A:	JZ	SORT4	;IS I=FIRST ?
	PUSH	H	;NO, STACK NEW I
	DCX	D
	DCX	D
	PUSH	D	;STACK NEW J
;
SORT4:	LHLD	J
	XCHG		;DE=J
	LHLD	LAST	;HL=LAST
	MOV	A,H
	CMP	D
	JNZ	SORT5
	MOV	A,L
	CMP	E
;
SORT5:	JZ	SORT8	;IS J=LAST ?
	INX	D	;NO
	INX	D
	PUSH	D	;STACK NEW I
	PUSH	H	;STACK NEW J
;
SORT8:	JMP	SORT2
;
;SPLIT SUBROUTINE DOES A SINGLE
;PARTITION ON AN ARRAY OF POINTERS
;
SPLIT:	LHLD	I	;LAB100
	CALL	HALF
	XCHG		;DE=I/2
;
;HALF J (HL=J/2)
	LHLD	J
	CALL	HALF
	DAD	D	;HL=(I+J)/2
	MOV	A,L
	ANI	0FEH
	MOV	L,A
	SHLD	K	;K=(I+J)/2 FORCED TO EVEN NUMBER
	LXI	D,PDIR
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
	SHLD	W	;W=PDIR(K)
;
SPLIT2:	LHLD	I
	LXI	D,PDIR
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
	XCHG		;DE=PDIR(I)
	LHLD	W	;HL=.(PARTITION ELEMENT) I.E. PDIR(K)
;
;COMPARE KEYS
	MVI	C,11	;NUMBER OF CHARACTERS TO MATCH
	CALL	MATCH
	JP	SPLIT4	;IS DIRBUF(PDIR(I)) < DIRBUF(PDIR(K)) ?
;
;I=I+2 (BYTES I.E. 1 ELEMENT)
	LHLD	I
	LXI	D,2
	DAD	D
	SHLD	I
	JMP	SPLIT2
;
SPLIT4:	LHLD	J
	LXI	D,PDIR
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
	XCHG		;DE=PDIR(J)
	LHLD	W	;HL=.(PARTITION ELEMENT) I.E. PDIR(K)
	XCHG		;SWAP DE WITH HL
;
;COMPARE KEYS
	MVI	C,11	;NUMBER OF CHARACTERS TO MATCH
	CALL	MATCH
	JP	SPLIT6	;IS DIRBUF(PDIR(K) < DIRBUF(PDIR(K)) ?
;
;J=J-2 (BYTES I.E. 1 ELEMENT)
	LHLD	J
	LXI	D,-2
	DAD	D
	SHLD	J
	JMP	SPLIT4
;
SPLIT6:	LHLD	I
	XCHG		;DE=I
	LHLD	J	;HL=J
	MOV	A,H
	CMP	D
	JNZ	SPLT6A
	MOV	A,L
	CMP	E
;
SPLT6A:	RZ		;IS I=J ?
;
;NO, SWITCH POINTERS
	LHLD	I
	LXI	D,PDIR
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
	PUSH	H
	LHLD	J
	LXI	D,PDIR
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
;
;PDIR(J)=PDIR(J)
	PUSH	H
	LHLD	I
	XCHG
	LXI	H,PDIR
	DAD	D
	POP	D
	MOV	M,E
	INX	H
	MOV	M,D
	POP	H
;
;AND VICE VERSA
	PUSH	H
	LHLD	J
	XCHG
	LXI	H,PDIR
	DAD	D
	POP	D
	MOV	M,E
	INX	H
	MOV	M,D
	JMP	SPLIT2
;
HALF:	XRA	A
	MOV	A,H
	RAR
	MOV	H,A
	MOV	A,L
	RAR
	MOV	L,A
	RET
;
;THIS ROUTINE CORRECTS FOR 2k GROUP FILE SIZES
;
CORFCT:	ANI	0FH
	CPI	1
	JZ	CORFC1
	CPI	3
	JZ	CORFC1
	CPI	5
	JZ	CORFC1
	CPI	7
	JZ	CORFC1
	CPI	9
	JZ	CORFC1
	CPI	11
	JZ	CORFC1
	CPI	13
	JZ	CORFC1
	CPI	15
	JZ	CORFC1
	RET
;
CORFC1: INR	L	;ADD IN 1K MORE TO SIZE
	RET
;
;TYPE (C) CHARACTERS FROM MEMORY
;
TYPEM:	MOV	A,M	;CHARACTER TO A
	CALL	TYPE
	INX	H
	DCR	C	;ONE LESS CHARACTER
	RZ		;DONE, RETURN
	JMP	TYPEM	;GO PRINT ANOTHER
;
;ILPRT - INLINE PRINT OF MSG.
;THE CALL TO ILPRT IS FOLLOWED BY A MESSAGE,
;BINARY 0 AS THE END.
;
ILPRT:	XTHL		;SAVE HL, GET HL=MSG
;
ILPLP:	MOV	A,M	;GET CHAR
	ORA	A	;END OF MSG?
	JZ	ILPRET	;..YES, RETURN
	CALL	TYPE	;TYPE THE MSG
	INX	H	;TO NEXT CHAR
	JMP	ILPLP	;LOOP
;
ILPRET:	XTHL		;RESTORE HL
	RET		;PAST MSG
;
CRLF:	CALL	ILPRT	;PRINT:
	DB	CR,LF,0
	RET
;
TYPE:	PUSH	B
	PUSH	D
	PUSH	H
	MOV	E,A	;CHARACTER TO E FOR CP/M
	MVI	C,2	;WRITE CONSOLE FUNCTION
	CALL	BDOS
	MVI	C,11	;CONSOLE STATUS FUNCTION
	CALL	BDOS
	ORA	A	;ANY KEY PRESSED?
	JNZ	ABORT	;YES, ABORT
	POP	H
	POP	D
	POP	B
	RET
;
;DECIMAL OUTPUT ROUTINE
;
DECOUT:	PUSH	B
	PUSH	D
	PUSH	H
	LXI	B,-10
	LXI	D,-1
;
DECOU2:	DAD	B
	INX	D
	JC	DECOU2
	LXI	B,10
	DAD	B
	XCHG
	MOV	A,H
	ORA	L
	CNZ	DECOUT
	MOV	A,E
	ADI	'0'
	CALL	TYPE
	POP	H
	POP	D
	POP	B
	RET
;
;THIS ROUTINE CLEARS THE HIGH-ORDER BIT OF EACH CHARACTER
;IN THE FILENAME AND FILETYPE TO PREVENT CPM-2'S FILE
;ATTRIBUTES FROM AFFECTING THE ALPHABETICAL SORT.
;
CLEFCB:	MVI	B,11	;NUMBER OF CHARACTERS
;
CLEFC2:	MOV	A,M	;GET CHARACTER
	ANI	7FH	;STRIP ATTRIBUTE BIT
	MOV	M,A	;RESTORE CHARACTER
	DCR	B
	RZ		;DONE, RETURN
	INX	H	;POINT AHEAD
	JMP	CLEFC2	;DO ANOTHER CHARACTER
;
;
; DATA AREA
;
DRIVEID: DS	1	;ASCII DRIVE ID
ALLF:	DS	1	;ALL FILES PRINTED FLAG
SFF:	DB	0	;SCREEN FULL FLAG (INIT TO 0 I.E. FALSE)
I:	DW	0	;PSEUDO INDEX REGISTER
J:	DW	0	;PSEUDO INDEX REGISTER
K:	DW	0	;PSEUDO INDEX REGISTER
FIRST:	DW	0	;START OF ARRAY
LAST:	DW	0	;END OF ARRAY
W:	DW	0	;STORAGE FOR PARTITION INDEX
LINE:	DW	0	;LINE NUMBER FOR LISTING
IPOINT:	DW	0	;VARIABLE BUFFER POINTER
COUNT:	DW	0	;COUNT OF DIRECTORY ENTRIES
FCBCNT:	DW	0	;COUNT OF DIRECTORY ENTRIES USED
INBPTR:	DW	0	;POINTER TO INPUT BUFFER
OUTBPTR: DW	0	;POINTER TO DIRECTORY BUFFER
CCPSTK:	DW	0	;SAVED CCP STACK POINTER
;
ENDSTK:	DS	ENTRIES*20+20	;LOCAL STACK AREA
LCLSTK:	EQU	$	;LOCAL TOP OF STACK (INITIAL)
;
PDIR:	DS	DIRLEN	;POINTER TABLE TO DIRECTORY BUFFER
;
DIRBUF:	DS	ENTRIES*16	;DIRECTORY BUFFER
;
	END	BEGIN
