hex.h
#include "stdio.h"
#include "ctype.h"

#define	RECSIZ	16
#define RECMARK  ':'

#define	ishex(c)	((c>='0'&&c<='9')||(c>='a'&&c<='f')||(c>='A'&&c<='F'))
/*  #define isspace(c)	(c == '\t' || c == ' ')
    #define isalnum(c)	(c>='a'&&c<='z'||c>='A'&&c<='Z'||c=='_')
*/

char space;

char data[RECSIZ];
int reclen;                             /* record length */
int rectyp;	                             /* record type */
unsigned laddr,      	                /* load address */
	base,
	oaddr;

unsigned Corg,
	Dorg,
	Cend,
	Dend;

int in;
FILE *out;

hx.c
#include "hex.h"

main(ac,av)
char **av;
{
	base = 0x100;
	init (ac, av);

	if (base != Corg) {       /* eg, base = 0x100, Corg = 0x103 */
		laddr = base;
		dobase();
	} else                   /* eg, base = 0, Corg = 0 */
		laddr = Corg;
	doseg (Corg, Cend);
	doseg (Dorg, Dend);
	puteof();
}

dobase()
{
	read (in, data, 3);
	reclen = 3;
	putrec();
}

doseg (org, end)
unsigned org, end;
{
	register int i;
	int siz;
	char buf[1024], *sp, *dp = data;

	oaddr = org;
	lseek (in, (long)(org - base), 0);

	while ( (siz = read (in, buf, sizeof(buf))) > 0) {
		sp = buf;
		for (i=0; inseg(end) && i < siz; oaddr++, sp++, i++)  {  
			*dp++ = *sp;             /* save byte */
			reclen++;
			if (reclen == RECSIZ) {
				putrec();
				dp = data;
			}
		}
		if (i<siz)  {   /* i.e., inseg(end) is false */
			break;
		} 
	}
	if (reclen > 0)
		putrec();
}

inseg(end)
unsigned end;
{
	if (end >= oaddr)
		return 1;
	return 0;
}

putrec()      /* ":llaaaattdddd...ddddccCRLF" */
{
	aputc (RECMARK, out);
	puth (reclen, 1, out);
	puth (laddr, 2, out);
	puth (rectyp, 1, out);

	putdata( data, reclen );

	puth ( check (data, reclen), 1 , out);
	aputc( '\n', out );

	laddr += reclen;
	reclen = 0;
}

puteof()
{
	aputc (RECMARK, out);
	puth(0, 1, out);
	puth(0, 2, out);
	puth(1, 1, out);
	puth(255, 1, out);
	return;
}

check(buf, size)                       /* compute checksum */
char *buf;
{
	int c = 0;
	while (size--)  {
		c += *buf++;
	}
	c += reclen + laddr + rectyp;      /* laddr is unsigned */
	return((0-c) & 0xff);
}

putdata(dbuf, done)
char *dbuf;
{
	while (done--) {
		puth(*dbuf++, 1, out);
	}
}


init.c
#include "hex.h"
#include "fcntl.h"

init(argc, argv)
char **argv;
{
	char filename[20], *cp, *xp;
	FILE *fopen();

	if (argc < 2)  {
		printf("usage: hx infile [outfile] [-options]\n");
		exit(1);
	}

	while (--argc)  {
		if (**++argv == '.' || **argv == '-')
			setopt(*argv);
		else if (in == 0)  {
			xp = *argv;
			if ((in = open(*argv, O_RDONLY)) == -1)  {
				printf("hx: can't open input file!\n");
				exit(1);
			}
		} else if (out == NULL)  {
			if ((out = fopen(*argv, "w")) == NULL)  {
				printf("hx: can't open output file!\n");
				exit(1);
			}
		} else  {
			printf("hx: bad arg\n");
			exit(1);
		}
	}

	cp = filename;
	while (*xp != '.' && *xp)
		*cp++ = *xp++;
	*cp = '\0';

	if (out == NULL)  {
		strcat(filename, ".hex");
#ifdef DEBUG
	printf("out: %s\n", filename);
#endif
		if ((out = fopen(filename, "w")) == NULL)  {
			printf("hx: can't open output file!\n");
			exit(1);
		}
	}

	if (Cend == 0) {
		*cp = '\0';
		strcat(filename, ".sym");
		getparam(filename);  
	}
	printf("Base: %4x  Corg: %4x  Cend: %4x  Dorg: %4x  Dend: %4x\n",
					base, Corg, Cend, Dorg, Dend);
}

setopt.c
#include "hex.h"

setopt(str)
char *str;
{
	char buf[20];
	char *xp;

	while (*str)  {
		switch (*str) {
			case '.':
				out = stdout;
				break;
			case '-': case ' ':
				break;
			case 'b':
			case 'B':
				str = getval(&base, ++str);
				break;
			case 's':
			case 'S':
				space = 1;
				break;
			case 't': case 'T':
				xp = buf;
				str++;
				while (isalnum(*str) || *str == '.')  {
					*xp = *str++;
					xp++;
				}
				str--;
				*xp = '\0';
				getparam(buf);
				break;
			case '?':
				puts("b -- set base address");
				puts("s -- spaced format for legibility");
				puts("t -- specify symbol table file");
				puts("x -- exit this program");
				puts(". -- send output to stdout");
				printf("options: ");
				setopt(gets(buf));
				break;
			case 'x': case 'X':
				exit (0);
			default:
				printf("hx: invalid option letter!\n");
				break;
		}
		str++;
	}
}

puth.c
#include "hex.h"
#define	STRSIZ	10

puth(val, width, fil)
unsigned val;
FILE *fil;
{
	char *convert();
	char str[STRSIZ];
	char *s = str + STRSIZ - 1;   /* end of str */
	int i;

	if (space == 1)
		putc(' ', fil);
	if (width == 1)
		val &= 0xff;

	*(s) = '\0';
	s = convert(val, 16, s);
	if ((i = s - (str + STRSIZ - 1 - 2 * width)) > 0)
		while (i--)
			aputc('0', fil);
	while (*s) 
		aputc(*s++, fil);
}

static char digits[]="0123456789abcdef";

char *
convert(n, base, s)
register int base; register char *s; register unsigned n;
{
	do {
		*--s = digits[(int)(n%base)];
	} while ( (n /= base) != 0 );
	return s;
}

getp.c
#include "hex.h"

getparam(fname)
char *fname;
{
	FILE *fopen(), *fp;
	char sym[10], buf[20];
	char *getval();

	if ((fp = fopen(fname, "r")) == NULL)  {
		printf("hx:  can't open symbol table file, %s\n", fname);
		exit(1);
	}
	while (fgets(buf, sizeof(buf), fp))  {
		getsym(sym, buf);
		if (Cend == 0 || Dend == 0)  {
			if (strcmp(sym, "_Corg_") == 0)
				getval(&Corg, buf);
			else if (strcmp(sym, "_Cend_") == 0)
				getval(&Cend, buf);
			else if (strcmp(sym, "_Dorg_") == 0)
				getval(&Dorg, buf);
			else if (strcmp(sym, "_Dend_") == 0)
				getval(&Dend, buf);
		}
		else
			break;
	}
}

getsym(d,s)
char *s, *d;
{
	while (ishex(*s))
		s++;
	while (isspace(*s))
		s++;
	while (isalnum(*s))
		*d++ = *s++;
	*d = '\0';
}

getv.c
#include "hex.h"

getval(ip,s)
int *ip;
char *s;
{
	int val, i, j;
	int dig = 1;

	val = i = 0;

	while ( ishex(*s) )  {
		s++;
		i++;
	}
	for (j = i; j; j--)  {
		val += dig * htoi((int)*--s);
		dig *= 16;
	}
	*ip = val;
	return (s + i - 1);
}

htoi(c)
int c;
{
	if (isdigit(c))
		return(c  - '0');
	c = tolower(c);
	return(10 + c - 'a');
}



(), *fp;
	char sym[10], buf[20];
	char *getval();

	if ((fp = fopen(fname, "r")) == NULL)  {
		printf("hx:  can't open symbol t