/*******************************************************\
*							*
*                 CLOSE OUT RESERVATION			*
*							*
\*******************************************************/
#define BYEAR 1981
#define BDAY     4
#define TRUE  1
#define FALSE 0
struct  t1  {
   char name[20];
   int room;
   int mm,dd,yy;
   int rate;
   int persons;
   int lstay;
   int atime;
   int aphone,pphone,cphone;
   char mname[20];
   char addr[40];
   int msgnum;
   int dmmm,dmdd,dmyy;
   int mtime;
   char inital[2];
   char free[14];
}  res;
struct s1  {
   int room_index[10];
   int msg_num;
   int mdays[12];
   int bit_start;
   int bit_week;
   int bit_year;
   char free0[76];
}  var;
struct s2  {
   int num;
   char text[126];
}  rcomm;

int julian, date,week,nyear;
int fid,fid1,rnum[80];
char names[80][20],rooms[80][4];
char pname[20],proom[4];
char bmap[80][104];
char room_def[96][4];
char room_des[10][12];
int month,day,year;

main()
{
 int fid2,temp;
 int i,j,k,flag;
 int disp,lweek,lyear;
 char trec[128];
 char fname[7],fname2[7];

   fid = open("BMAP",2);
   read(fid,&bmap[0][0],65);
   read(fid,var,1);
   read(fid,room_def,3);
   read(fid,trec,1);
   for(i=0; i<10; i++)
      for(j=0; j<12; room_des[i][j] = trec[i*12+j++]);

   cdate();
   fdate();
   sprintf(fname,"W%dY%d",week,nyear-1900);
   if((fid1=open(fname,2)) == -1)   /* Open current weeks file */
      fid1 = creat(fname);
   if(var.bit_week != week)  {
      printf("Updating files, please wait\n");
      var.bit_start = (var.bit_start + 1) % 104;
      lyear = nyear - 1900;
      lweek = var.bit_week;   
      var.bit_week = (var.bit_week + 1) % 52;
      if(var.bit_week == 0)
         var.bit_year += 1;
      if(lweek > week)
         lyear -= 1;
      sprintf(fname2,"W%dY%d",lweek,lyear);
      if((fid2=open(fname2,2)) != -1)  {
         while(read(fid1,res,1) == 1);
         while(read(fid2,res,1) == 1)
            if(res.name[0] != '\0')
               if(write(fid1,res,1) != 1)
                  printf("error in file write\n");
         close(fid2);
         unlink(fname2);
         close(fid1);
         fid1 = open(fname,2);
      }
   }
   printf("\nRoom number (cr if unknown) ? ");
   def(proom,4);
   printf("Persons name ? ");
   def(pname,20);
   do  {
      k=j= 0;
      for(i=0; i<80; names[i++][0] = ' ');
      do  {
         temp = read(fid1,res,1);
         if(temp != 1)
            flag = search();
         else  {
            flag = FALSE;
            if(res.yy > year)
               flag = TRUE;
            else
               if(res.yy == year)
                  if(res.mm > month)
                     flag = TRUE;
                  else
                     if(res.mm == month)
                        if(res.dd > day)
                           flag = TRUE;
            if(flag == FALSE)  {
               for(i=0; i<20; names[j][i] = res.name[i++]);
               for(i=0; i<4; rooms[j][i] = room_def[res.room][i++]);
               rnum[j++] = k;
               for(i=0; i<4; i++)
                  if(proom[i] != room_def[res.room][i])
                     flag = TRUE;
               for(i=0; i<20; i++)
                  if(res.name[i] != pname[i])
                     flag = TRUE;
            }
            k += 1;
         }
      }
      while(flag);

      if(res.msgnum != 0)  {
         fid2 = open("MSG",2);
         do  {
            if(read(fid2,rcomm,1) != 1)  {
               printf("No entry in message file\n");
               break;
            }
         }
         while(rcomm.num != res.msgnum);
      }
      prec();
      printf("\n\nDo you wish to delete this reservation (Y/N) ? ");
      if((flag=toupper(getchar())) == 'N')  {
         seek(fid1,0,0);
         proom[0] = ' ';        /*  force a mismatch  */
         pname[0] = ' ';
      }
   }
   while(flag == 'N');
   putchar('\n');
   if(res.msgnum != 0)  {
      rcomm.num = 0;
      seek(fid2,-1,1);
      write(fid2,rcomm,1);
      close(fid2);
   }
   month = res.mm;
   day = res.dd;
   year = res.yy;
   fdate();
   disp = (week - var.bit_week + var.bit_start + 52*(var.bit_year - nyear) + 104) % 104;
   for(temp=date,i=0; i<res.lstay; temp++,i++)  {
      if(temp > 6)  {
         temp = 0;
         disp = (disp + 1) % 104;
      }
      bmap[res.room][disp] = bmap[res.room][disp] & (0xBF >> temp);
   }
   seek(fid,0,0);
   write(fid,bmap,65);
   write(fid,var,1);
   close(fid);

   if((fid=open("OLDRES",2)) == -1)
      fid = creat("OLDRES");
   else
      while(read(fid,trec,1) == 1);
   write(fid,res,1);
   close(fid);
   for(i=0; i<128; res.name[i++]='\0');
   seek(fid1,-1,1);
   write(fid1,res,1);
   close(fid1);
   exec("EXEC");
}

search()
{
 int j,i,flag;

   printf("\n\nThe following are the reservations on or before ");
   printf("%d-%d-%d\n\n",month,day,year-1900);
   for(j=0; names[j][0] != ' '; j++)  {
      for(i=0; i<20; putchar(names[j][i++]));
      for(i=0; i<4; putchar(rooms[j][i++]));
      if((j+1) % 3 == 0)
         putchar('\n');
      else
         printf("  ");
   }
   do  {
      if(pname[0] == ' ')  {
         printf("\n\nEnter name (cr to exit) ? ");
         def(pname,20);
         if(pname[0] == ' ')
            exec("EXEC");
      }
      if(proom[0] == ' ')  {
         printf("\nEnter room (cr to exit) ? ");
         def(proom,4);
         if(proom[0] == ' ')
            exec("EXEC");
      }
      for(j=0,flag=TRUE; flag==TRUE  &&  names[j][0]!=' '  &&  j<80; j++)  {
         for(i=0,flag=FALSE; i<20; i++)
            if(names[j][i] != pname[i])
               flag = TRUE;
         for(i=0; i<4; i++)
            if(rooms[j][i] != proom[i])
               flag = TRUE;
      }
      if(flag == TRUE)  {
         pname[0] = ' ';
         proom[0] = ' ';
      }
   }
   while(flag);
   seek(fid1,rnum[j-1],0);
   read(fid1,res,1);
   return(FALSE);
}

/*******************************************************\
*							*
*			date routine			*
*							*
*    enter with						*
*							*
*	month:	month of year				*
*	day:	day of month				*
*	year:	the year				*
*							*
*     return with the above values and			*
*							*
*	julian:	julian date				*
*	date:	day of week				*
*	week:	adjusted week				*
*	nyear	adjusted year				*
*							*
\*******************************************************/
fdate()
{
int i,ydiff,fday;
   for(julian=i=0; i<month-1; i++)
      julian += var.mdays[i];
   julian += day;
   if( month > 2)
      julian += leap(year);
   ydiff = year - BYEAR;
   for(fday = BDAY; ydiff != 0; fday +=1+leap(BYEAR+(--ydiff)));
   date = (julian + fday -1) % 7;
   week = (julian + fday -1)/7;
   if(week == 0)  {
      nyear = year - 1;
      week = 52;
   }
   else
      nyear = year;
}

leap(year)
int year;
{
   if(year %4 == 0  &&  year %100 != 0  ||  year %400 == 0)
      return(1);
   else
      return(0);
}

cdate()
{
/*   day = 1;
   month = 7;
   year = 1981;  */

   day = peek(0x45);
   month = peek(0x44);
   year = peek(0x46)+1900;
}

def(pt,len)
char pt[];
int len;
{
 char buf[128];
 int i;

   buf[0] = '\0';
   scanf("%s",buf);
   for(i=0; i<len  &&  buf[i] != '\0'; pt[i] = toupper(buf[i++]));
   for(; i<len; pt[i++] = ' ');
}

prec()
{
 int i;

   printf("\n\n\n\n\n\n");
   printf("                                                   ");
   printf("No. IN  LENGTH   ARIVAL\n");
   printf("          NAME           ROOM      DATE      RATE   PARTY");
   printf("  OF STAY   TIME\n");
   printf("          ----           ----      ----      ----  ------  ");
   printf("------   ------\n");
   for(i=0; i<20; putchar(res.name[i++]));
   printf("     ");
   for(i=0; i<4;putchar(room_def[res.room][i++]));
   printf("    %2d-%2d-%2d    %4d   %3d",res.mm,res.dd,res.yy-1900,res.rate,res.persons);
   printf("     %3d       %4d\n\n",res.lstay,res.atime);
   printf(" PHONE No.        ADDRESS                                     MAKERS NAME\n");
   printf(" ---------        -------                                     -----------\n");
   printf("%3d-%3d-%4d   ",res.aphone,res.pphone,res.cphone);
   printf("   ");
   for(i=0; i<40; putchar(res.addr[i++]));
   printf("    ");
   for(i=0; i<20; putchar(res.mname[i++]));
   printf("\n\n    DATE      TIME     OPERATORS\n");
   printf("    MADE      MADE      INITIALS\n");
   printf("    ----      ----     ---------\n");
   printf("  %2d-%2d-%2d    %4d",res.dmmm,res.dmdd,res.dmyy-1900,res.mtime);
   printf("        %c%c\n\n\n",res.inital[0],res.inital[1]);
   if(res.msgnum != 0)  {
      printf("   MESSAGE\n   -------\n");
      for(i=0; i<126; putchar(rcomm.text[i++]));
      putchar('\n');
   }
}
