/*******************************************************\
*							*
*                INITIALIZATION PROGRAM                 *
*							*
\*******************************************************/
#define BYEAR 1981
#define BDAY     4
struct t1  {
   int room_index[10];
   int msg_num;
   int mdays[12];
   int bit_start;
   int bit_week;
   int bit_year;
   char free1[76];
}  var;

main()
{
char trec[128];
char bmap[80][104];
char room_def[96][4],room_des[10][12];
char opt;
int idx,fid,i,k,j,l;
   printf("This program allows the user to tailor the reservation program\n");
   printf("to a particular set of rooms.  After all the rooms are defined\n");
   printf("the reservation system is ready to run.  This program may also\n");
   printf("be used to change most room parameters at any time.\n\n");
   printf("   To install type an  'I'\n   To change a value type a  'C'\n\n");
   printf("Option ? ");
   opt = toupper(getchar());
   do  {
      if(opt != 'I')  {
         if(opt == 'C')   {
            if((fid=open("BMAP",2)) == -1)  {
               printf("\nFile BMAP not on this disk.\n");
               exit();
            }
            read(fid,&bmap[0][0],65);
            read(fid,var,1);
            read(fid,room_def,3);
            read(fid,trec,1);
            for(i=0; i<10; i++)
               for(j=0; j<12; room_des[i][j] = trec[i*12+j++]);
            seek(fid,0,0);
         }
         putchar('\n');
         printf("Room type descriptions         1\n");
         printf("Number of rooms for each type  2\n");
         printf("Room number definitions        3\n");
         printf("\nWhich do you want to change  ?");
         scanf("%d",&idx);
      }
      else  {
         printf("\nCreating bmap file\n");
         if((fid=creat("BMAP")) == -1)  {
            printf("***Error in file creation***\n");
            exit();
         }
         for(i=0; i<80; i++)
            for(j=0; j<104; bmap[i][j++] = '\0');
         var.msg_num = 0;
         var.bit_start = 0;
         var.mdays[0] = 31;   var.mdays[1] = 28;
         var.mdays[2] = 31;   var.mdays[3] = 30;
         var.mdays[4] = 31;   var.mdays[5] = 30;
         var.mdays[6] = 31;   var.mdays[7] = 31;
         var.mdays[8] = 30;   var.mdays[9] = 31;
         var.mdays[10] = 30;  var.mdays[11] = 31;
         for(j=0; j<10; j++)
            for(k=0; k<12; room_des[j][k++] = '\0');
         for(j=0; j<4; j++)
            for(k=0; k<97; room_def[k++][j] = ' ');
         idx = 1;
         for(j=0; j<10; var.room_index[j++] = -1);
         var.bit_week = week();
         var.bit_year = peek(0x46) + 1900;
      }

      switch (idx)  {

         case 1:
            printf("Up to 10 types of rooms may be defined.  For each type\n");
            printf("of room enter a description of up to 12 characters.\n");
            printf("Type a carriage return to skip, or a '.' to stop when\n");
            printf("all the rooms have been defined.\n\n");
            j = 0;
            while(j < 10  &&  def(&room_des[j++][0],12));
            if(opt == 'C'  ||  opt == 'Y')
               break;

         case 2:
            printf("\nEnter the number of rooms for each type, carriage\n");
            printf("return to skip\n");
            printf(" type    number\n ----    ------\n");
            for(j=0; j<10  &&  room_des[j][0] != '\0'; j++)  {
               for(i=0; i<12; putchar(room_des[j][i++]));
               if(var.room_index[j] == -1)
                  k = 0;
               else  {
                  if(j == 0)
                     k = var.room_index[0] + 1;
                  else
                     k = var.room_index[j] - var.room_index[j-1];
               }
               printf("%d   ? ",k);
               scanf("%d",&k);
               if(j == 0)
                  var.room_index[0] = k-1;
               else
                  var.room_index[j] = var.room_index[j-1] + k;
            }  
            if(opt == 'C'  ||  opt == 'Y')
               break;

         case 3:
            printf("\nEnter the room numbers for each of the types of rooms \n");
            printf("Up to four characters per room, carriage return to skip");
            printf(" '.' to stop\n");
            for(j=0; j<12  &&  room_des[j][0] != '\0'; j++)  {
               if(j == 0)  {
                  l = 0;
                  k = var.room_index[0];
               }
               else  {
                  l = var.room_index[j-1] + 1;
                  k = var.room_index[j];
               }
               putchar('\n');
               for(i=0; i<12; putchar(room_des[j][i++]));
               printf("  %d rooms\n",k-l+1);
               printf("Do you wish to define/change these rooms (Y/N)? ");
               if(toupper(getchar()) == 'Y')  {
                  putchar('\n');
                  while(l <= k  &&  def(&room_def[l++][0],4));
               }
            }
            break;
    
         default:
            printf("\n****INVALID RESPONSE****\n");
      }
      printf("\nDo you wish to go back and change any values (Y/N) ?");
      opt = toupper(getchar());
      putchar('\n');
   }
   while(opt == 'Y');
   printf("\nThe modified file will be saved unless you enter a 'NO' ?");
   scanf("%s",trec);
   if(toupper(trec[0]) == 'N'  &&  toupper(trec[1]) == 'O')  {
      printf("Abandon modified file (Y/N) ?");
      if(toupper(getchar()) == 'Y')
         exit();
      else
         putchar('\n');
   }
   write(fid,&bmap[0][0],65);
   write(fid,var,1);
   write(fid,room_def,3);
   write(fid,room_des,1);
   close(fid);
}

def(pt,len)
char pt[];
int len;
{
 char buf[20];
 int i;
   if(pt[0] != '\0')
      for(i=0; i<len; putchar(pt[i++]),buf[i]=' ');
   buf[0] = '\0';
   printf("  ? ");
   scanf("%s",buf);
   if(buf[0] != '\0')  {
      if(buf[0] == '.'  && buf[1] == '\0')
         return(0);
      for(i=0; buf[i] != '\0'; pt[i]=toupper(buf[i++]));
      for(; i<len; pt[i++]=' ');
   }
}

week()
{
 int i,ydiff,fday,tjulian;
 int ctime,cday,cmonth,cweek,cyear;
/*   ctime = 800;
   cday = 1;
   cweek = 26;
   cmonth = 7;
   cyear = 1981;   */

   ctime = peek(0x43) * 100 + peek(0x42);
   cday = peek(0x45);
   cmonth = peek(0x44);
   cyear = peek(0x46) + 1900;
   for(tjulian=i=0; i<cmonth-1; i++)
      tjulian += var.mdays[i];
   tjulian += cday;
   if( cmonth > 2)
      tjulian += leap(cyear);
   ydiff = cyear - BYEAR;
   for(fday = BDAY; ydiff != 0; fday +=1+leap(BYEAR+(--ydiff)));
   cweek = (tjulian + fday -1)/7;
   if(cweek == 0)  {
      cyear = cyear - 1;
      cweek = 52;
   }
   return(cweek);
}

leap(year)
int year;
{
   if(year %4 == 0  &&  year %100 != 0  ||  year %400 == 0)
      return(1);
   else
      return(0);
}
