;	BOOTSTRAP LOADER
;VERSION 4.1
;FOR USE WITH THE FDC-3 CONTROLLER BOARD IN EITHER SINGLE OR DOUBLE
;DENSITY ON THE DSC-2 COMPUTER SYSTEMS.
;
;SET THE VALUE DOUBLE ACCORDINGLY IF ASSEMBLING THIS FOR A
;SINGLE DENSITY SYSTEM

	
TRUE	EQU	0FFFH
FALSE	EQU	NOT TRUE
;
;
;
DOUBLE	EQU	FALSE	;THIS SHOULD BE FALSE FOR SINGLE DENSITY
;
	ORG	00H
;
MSIZE	EQU	63
BIAS	EQU	2900H+(MSIZE-16)*1024
CPMB	EQU	000H+BIAS
LOADP	EQU	CPMB-80H	;LOAD POINT
BCP	EQU	CPMB+1500H	;MONITOR
PORT	EQU	4AH
LAST	EQU	26	;LAST SECTOR ON TRK1 TO LOAD
SKIP	EQU	1	;NUMBER OF SECTORS TO SKIP
;
INIT0	EQU	((SKIP+1) SHL 8) OR 0	;INITIAL TRACK,SECTOR
END0	EQU	(0 SHL 7) OR 27	;END OF FIRST TRK
INIT1	EQU	(129 SHL 8) OR 1	;TRACK,SECT ON TRK 1
END1	EQU	(1 SHL 7) OR LAST+1	;LAST POSITION ON TRK 1
ERR	EQU	0F0H	;ERROR CONDITIONS
IOF	EQU	08H	;IO FINISH
;
;
T76	EQU	04H	;TOWARD 76
STT	EQU	02H	;STEP TRACK
DOUT	EQU	80H	;DISK OUTPUT PORT
DINP	EQU	80H	;DISK INPUT PORT
DMAH	EQU	81H	;HIGH ORDER DMA ADDRESS
DMAL	EQU	82H	;LOW ORDER DMA ADDRESS
COMMAND2 EQU	83H	;SECOND COMMAND PORT
RDS	EQU	040H	;READ SECTOR
;RS232 PORTS
DATA	EQU	40H
STATUS	EQU	41H
STATUS1	EQU	49H
STATUS2	EQU	51H
;
;
	NOP		;SOME DYNAMIC MEMORIES PROHIBIT USE OF
			;THIS BYTE IN THE BOOTSTRAP
;	INITIALIZE TRK/SEC AND DMA ADDRESS
START:
	LXI	D,INIT0
	LXI	H,LOADP-3
;
READL:	;READ LOOP
	SPHL		;SET THE STACK POINTER
;	SEND DMA ADDRESS
	MOV	A,H
	OUT	DMAH
	MOV	A,L
	OUT	DMAL
;
;	SET UP TRACK AND SECTOR
	;
	MOV	L,E	;TRACK TO L
	MOV	A,D	;SECTOR TO A
	ANI	7FH	;CLEAR HIGH BIT
	MOV	H,A	;SECTOR TO H
	XTHL		;SET TRK AND SECTOR
	INX	SP	;ADJUST STACK POINTER
	POP	B
;	PERFORM THE READ
	MVI	A,RDS
	OUT	DOUT
;
WRD:	IN	DINP
	ANI	ERR
	JZ	NERROR
;
;	ERROR, REBOOT
;A HLT DOES A REBOOT AUTOMATICALLY ON DSC-2
	HLT
;
;
NERROR:	;NO ERROR SO FAR
	IN	DINP
	ANI	IOF
	JZ	WRD	;GO BACK AND WAIT
;
;	I/O FINISH,
;	REPLACE DATA BYTES
	PUSH	B	;REPLACE 1 BYTE
	INX	SP	;ADJUST STACK POINTER
	PUSH	H	;REPLACE 2 BYTES
;
;	ADD 128 TO DMA ADDRESS
	LXI	H,128
	DAD	SP
;
;	INC TRACK/SECTOR
	INR	D
	MOV	A,D
	CPI	END0	;END OF TRACK 0?
	JNZ	CMP1
;
;	STEP TRACK TO TRACK 1
	MVI	A,T76
	OUT	DOUT
	ORI	STT
	OUT	DOUT
	MVI	A,T76
	OUT	DOUT
WST:	;WAIT FOR STEP AND HEAD SETTLE
	MVI	A,18D
WST0:
	MVI	C,0AAH	;ONE MILLISECOND TIMING
WST2:
	DCR	C
	JNZ	WST2
	DCR	A
	JNZ	WST0
;
;		TRACK STEPPED
	IF DOUBLE
;NOW CHANGE DENSITY
	MVI	 A,8
	OUT	COMMAND2
	ENDIF
;
	LXI	D,INIT1
	MOV	A,D
CMP1:	CPI	END1	;END OF TRACK 1?
	JNZ	READL	;GO BACK FOR MORE
;
;	END OF LOAD
	LXI	H,PORT
;
	IF DOUBLE
;INIT FOR DOUBLE DENSITY
	MVI	M,8
	INX	H
	MVI	M,8
	INX	H	;POINT TO DENSITY SELECT
	MVI	M,0FH	;DOUBLE DENSITY
	ENDIF
;
	IF NOT DOUBLE
	MOV	M,H	;H IS 0
	INX	H
	MOV	M,H
	INX	H	;POINT TO DENSITY SELECT
	MVI	M,00	;SINGLE DENSITY
	ENDIF
;
;SET LOC 4 TO CONTAIN ACTIVE DRIVE = 0
	MVI	L,4
	MOV	M,H
;
;INITIALIZE THE USARTS
	MVI	A,0CEH
	OUT	STATUS
	OUT	STATUS1
	OUT	STATUS2
	MVI	A,27H
	OUT	STATUS
	OUT	STATUS1
	OUT	STATUS2
	IN	DATA
	JMP	LOADP	;GO DO MORE INITIALIZATION
;
	ORG	7FH
	DB	0CH	;FOR SOME DYNAMIC MEMORIES
	END
