;NEW SINGLE DENSITY FORMAT PROGRAM FOR MICROMATION DOUBLER
;
;		FEB 1, 1979
;
CONTROLLER	EQU	0F800H

STEPTIME	EQU	CONTROLLER+410H

WRCONT		EQU	CONTROLLER+600H
RDSTAT		EQU	WRCONT
RDMARK		EQU	WRCONT+5
RDDATA		EQU	WRCONT+6
WRCLK		EQU	WRCONT+1
WRMRKCRC	EQU	WRCONT+4
WRMARK		EQU	WRCONT+5
WRDATA		EQU	WRCONT+6
WRCRC		EQU	WRCONT+7


BOOT		EQU	0
BDOS		EQU	5

HEADSETTLE	EQU	35D
STEPSETTLE	EQU	10D
LF		EQU	0AH
CR		EQU	0DH


	ORG	100H

	LXI	SP,100H
	CALL	HELLO
	CALL	GETDRIVE
	STA	DRIVE
REPEAT	CALL	INDISK
	CALL	SELDSK
	CALL	READY
	CALL	PROTECT
	CALL	HOME
				;READY TO START FORMATTING
	MVI	C,0		;TRACK NUMBER
LOOP	CALL	SDFORM
	CALL	STEPIN
	INR	C
	MOV	A,C
	CPI	2
	JNZ	LOOP

BYE	MVI	C,9
	LXI	D,LOGOFF
	CALL	BDOS
BYE1	CALL	CONIN
	CPI	'R'
	JZ	REPEAT
	CPI	CR
	JNZ	BYE1
	JMP	BOOT

LOGOFF	DB	LF,'TYPE R TO REPEAT',CR,LF
	DB	'TYPE RETURN TO REBOOT'
	DB	CR,LF,'$'


CONTROL	DB	0FFH
ABOVE43	DB	10H


;	SUBROUTINES FOLLOW


CONIN	LHLD	1
	MVI	L,9
	PCHL


HELLO	MVI	C,9
	LXI	D,LOGON
	CALL	BDOS
	RET

LOGON	DB	'This program formats only the system tracks '
	DB	'(0 and 1) for a '
	DB	CONTROLLER/1000H + 37H
	DB	CONTROLLER/100H MOD 10H + 30H
	DB	'00 based system.'
	DB	CR,LF,'$'


GETDRIVE LXI	H,80H
GD1	INX	H
	MOV	A,M
	CPI	0
	JZ	PROMPT
	CPI	'A'
	JC	GD1
	CPI	'E'
	JNC	GD1
	RET

PROMPT	MVI	C,9
	LXI	D,PRMSG
	CALL	BDOS
NOGOOD	CALL	CONIN
	CPI	'A'
	JC	NOGOOD
	CPI	'E'
	JNC	NOGOOD
	RET

PRMSG	DB	'Which drive to format;  A, B, C or D ?'
	DB	CR,LF,'$'


INDISK	MVI	C,9
	LXI	D,INMSG
	CALL	BDOS
INWAIT	CALL	CONIN
	CPI	CR
	JNZ	INWAIT
	RET

INMSG	DB	'Insert the diskette to be formatted in drive '
DRIVE	DB	0,CR,LF
	DB	'Then press RETURN'
	DB	CR,LF,'$'


SELDSK	LDA	DRIVE
	SUI	40H
	MOV	C,A
	MVI	A,7FH
SEL1	RRC
	DCR	C
	JNZ	SEL1
	STA	CONTROL
	STA	WRCONT
	LDA	RDMARK
	MVI	B,HEADSETTLE
	CALL	DELAY
	RET


DELAY			;DELAYS (B) MILLISECONDS
	LDA	CONTROL
	ORI	4
	STA	WRCONT
DL1	MVI	L,31D
DL2	LDA	RDDATA
	DCR	L
	JNZ	DL2
	DCR	B
	JNZ	DL1
	RET


READY	LDA	RDSTAT
	ANI	80H
	RZ
	MVI	C,9
	LXI	D,RDYMSG
	CALL	BDOS
RDY1	LDA	RDMARK
	LDA	RDSTAT
	ANI	80H
	JNZ	RDY1
	RET

RDYMSG	DB	'DRIVE NOT READY'
	DB	CR,LF,'$'


PROTECT	LDA	RDSTAT
	ANI	4
	RNZ
	MVI	C,9
	LXI	D,PROTMSG
	CALL	BDOS
	POP	B		;THROW AWAY RETURN ADDRESS
	JMP	BYE

PROTMSG	DB	'DISK IS WRITE PROTECTED'
	DB	CR,LF,'$'


HOME	LDA	RDSTAT
	ANI	2
	JZ	HOME1
	CALL	STEPOUT
	JMP	HOME
HOME1	MVI	B,STEPSETTLE
	CALL	DELAY
	RET


STEPOUT	LDA	CONTROL
	ORI	2
	JMP	STEP

STEPIN	LDA	CONTROL
	ANI	0FDH

STEP	LXI	D,WRCONT
	STAX	D
	DCR	A
	STAX	D
	INR	A
	STAX	D
	LDA	RDMARK
	LDA	STEPTIME
	MOV	B,A
	CALL	DELAY
	RET



SDFORM	LDA	CONTROL
	STA	WRCONT
	LDA	ABOVE43
	STA	WRCLK
	MVI	B,0		;SECTOR NUMBER
	LXI	D,WRDATA
	MVI	L,72D
S2	LDA	RDSTAT
	ANI	10H		;WAIT FOR NO INDEX
	JZ	S2
S3	LDA	RDSTAT
	ANI	10H		;NOW WAIT FOR LEADING EDGE OF INDEX
	JNZ	S3
	MVI	A,0FFH
S4	STAX	D		;73 FF'S
	DCR	L
	JNZ	S4
	STAX	D
SECTOR	XRA	A
	STAX	D		;6 00'S
	INR	B		;INCREMENT SECTOR NUMBER
	STAX	D
	XCHG
	MVI	E,0
	MOV	M,E
	LDA	ABOVE43
	MOV	M,E
	ORI	80H
	STA	WRCLK
	MOV	M,E
	XRA	A
	XCHG
	STAX	D
	MVI	A,0FEH
	STA	WRMRKCRC	;ID MARK
	MOV	A,C
	STAX	D		;TRACK
	XRA	A
	STAX	D		;00
	MOV	A,B
	STAX	D		;SECTOR
	XRA	A
	STAX	D		;00
	MVI	A,0FFH
	STA	WRCRC		;CRC
	STA	WRCRC		;CRC
	MVI	L,10D
S5	STAX	D		;11 FF'S
	DCR	L
	JNZ	S5
	STAX	D
	XRA	A
	STAX	D		;6 00'S
	STAX	D
	LDA	ABOVE43
	STA	WRCLK		;SET UP FOR DATA MARK
	XRA	A
	STAX	D
	STAX	D
	STAX	D
	STAX	D
	MVI	A,0FBH
	STA	WRMRKCRC	;DATA MARK
	MVI	L,7FH
	MVI	A,0E5H
S6	STAX	D		;128 E5'S
	DCR	L
	JNZ	S6
	STAX	D
	MVI	A,0FFH
	STA	WRCRC		;CRC
	MVI	L,25D
	STA	WRCRC		;CRC
S7	STAX	D		;27 FF'S
	DCR	L
	JNZ	S7
	STAX	D
	MOV	A,B
	CPI	26D		;LAST SECTOR?
	MVI	A,0FFH
	STAX	D
	JNZ	SECTOR
S8	STAX	D		;INSERT FF'S UNTIL INDEX
	LDA	RDSTAT
	ANI	10H
	MVI	A,0FFH
	STAX	D
	JNZ	S8
	XRA	A
	STA	WRCLK
	MVI	B,1
	CALL	DELAY
	RET

