.title "Modify the BIOS baudrate"
	.sbttl "SETBAUD"
version	==	1
revision==	2
patch   ==	' '
;
	.pabs
	.phex	
	.loc	100h
;
;		Program: SETBAUD 
; SETBAUD is used to change rs 232 baud rates. 
; All commands are received from the command line.
;
; Output from SETBAUD takes three forms.
;
; 1. If a user types "SETBAUD P n" where P is a port
; number from 0 to 3 and n is an acceptable baud rate,
; a carriage return is made followed by a warm boot.
; 
; 2. If an error is made, the first incorrect 
; character is pointed to (by an arrow), and a 
; summary of instructions are displayed followed
; by a warm boot.
;
; 3. If only "SETBAUD" is typed in, a summary of 
; instructions are displayed, followed by a warmboot.
;
; Data is entered through the command line. The
; length of the command line is at 80h.  The command
; itself begins at 81h. DSC 3/4 baud rate change
; addresses are 30h,31h,32h. 32h is the address for 
; ports 2 and port 3.  To change a port to a specific
; baud rate, the following bytes must be sent to the
; port's address.
;
; BAUD RATE		  BYTES
; ---------		---------
;   9600		 45h,13
;   4800		 45h,26
;   2400		 45h,52
;   1800		 45h,69
;   1200		 45h,104
;    600	         45h,208
;    300		 05h,52
;    110		 05h,142
.page
 revisio :  Modifie progra s  use cannot 
;              modify baud rate of PORT 1 while
;	       connected to HiNet. 9/18.81 DB
;	       Corrected the CTC constant for 600 baud.
;	       D B 2/18/82
; revision 2:  Corrected problem in printing version
;	       number.  07/23/82  DB
.page
;------------------
; Get the number of command line characters in numchr
; Jump to 'prtinf' if no command line
	lxi	sp,stack; set stack pointer
	lhld	cmdlin
	xchg
	ldax	D
	sta	numchr	; save number of com chrs
	cpi 	0
	jz	prtinf	; print help if no comm line
	cpi	1
	jz	prtinf	; print help if only carr ret
;----------------
; Call 'getchr' and fetch a non-blank character.
; Test if port 1 is to be modified.  If yes, do not
; allow modification if connected to HiNet.
; Test for port 0,1,2,or 3 (proper port selects).
; Jump to 'error' if unacceptable entry is found.
getPORT:
..1:	call	getchr
	cpi	' '	; is it a blank?
	jrz	..1	; loop until chr found
 	cpi	'1'  	; if port1 is to be changed
	jnz 	..2	;perform following test.
	push	PSW	;save port # on stack
	lda	47h	;load HiNet user number
	cpi	0ffh	;compare to 255, if equal
	jz	..3	;not connected to
	lxi	D,errnet ;HiNet, else print error
	mvi	c,prtstrg ;CP/M 9, Print String
	call	BDOS
	jmp	exit	;message and exit
..3:    pop     PSW     ;replace port # in accum
..2:	cpi	'0'
	jrz	getBAUD
	cpi	'1'
	jrz	getBAUD
	cpi	'2'
	jrz	getBAUD
	cpi	'3'
	jrz	getBAUD
	jmp	error	; all tests failed
.page
;------------------
; Call 'getchr' to fetch the next non-blank character.
; Jump to error if unacceptable entry found.
GETBAUD:
	sui	'0'	; convert ascii to number
	sta	port	; store port number
..1:	call	getchr	; get next command chr
	cpi	' '	; loop until first non-blank
	jrz	..1	; character found
	cpi	'9'	; possible 9600 baud
	jrnz	..2
	call	getchr
	cpi	'6'
	jnz	error
	call	eat00	; eat the remaining '00'
	mvi	H,45h
	mvi	L,13	; 9600 baud code
	jmpr	setBAUD
	
..2:	cpi	'4'	; possible 4800 baud
	jrnz	..3
	call	getchr
	cpi	'8'
	jnz	error
	call	eat00	; eat the remaining '00'
	mvi	H,45h
	mvi	L,26	; 4800 baud code
	jmpr	setBAUD
..3:	cpi	'2'	; possible 2400 baud
	jrnz	..4
	call	getchr
	cpi	'4'
	jnz	error
	call	eat00	; eat the remaining '00'
	mvi	H,45h
	mvi	L,52	; 2400 baud code
	jmpr	setBAUD
..4:	cpi	'1'	; possible 1800 or 1200 or 110
	jrnz	..7
	call	getchr
	cpi	'8'	; 1800 baud?
	jrnz	..5
	call	eat00
	mvi	H,45h
	mvi	L,69
	jmpr	setBAUD	; Select 1800 baud
..5:	cpi	'2'	; 1200 baud?
	jrnz	..6
	call	eat00
	mvi	H,45h
	mvi	L,104
	jmpr	setBAUD	; Select 1200 baud
.page 
..6:	cpi	'1'	; 110 baud?
	jrnz	..7
	call	getchr
	cpi	'0'
	mvi	H,05h
	mvi	L,142
	jmpr	setBAUD	; Select 110 baud
..7:	cpi	'6'	; possible 600 baud
	jrnz	..8
	call	eat00
	mvi	H,45h
	mvi	L,208
	jmpr	setBAUD	; Select 600 baud
..8:	cpi	'3'	; possible 300 baud
	jnz	error	; bad entry
	call	eat00
	mvi	H,05h
	mvi	L,52	; fall thru to setbaud
;---------------
setBAUD:
	lda	port
	cpi	0
	jrz	setP0
	cpi	1
	jrz	setP1
	cpi	2
	jrz	setP2
	cpi	3
	jrz	setP3
	jmp	error	; bad port number got through
;
setP0:	mov	A,H
	out	port0
	mov	A,L
	out	port0	; port 0 baud rate set
	jmpr	exit	; and exit
setp1:	mov	A,H
	out	port1
	mov	A,L
	out	port1	; port 1 baud rate set
	jmpr	exit	; and exit
setp2:	mov	A,H
	out	port2
	mov	A,L
	out	port2	; port 2 baud rate set
	jmpr	exit	; and exit
setp3:	mov	A,H
	out	port3
	mov	A,L
	out	port3	; port 3 baud rate set
	jmpr	exit	; and exit
.page
;---------------
;An error has been found.  Print an arrow under it
ERROR:	
	lda	chrcnt	; get num of chrs read
	adi	8	; increment past 'SETBAUD '
	push	PSW	; save space-over count 
arrow:	mvi	E,' '
	mvi	C,2
	call	BDOS	; print a space
        pop	PSW
	sbi	1
	cpi	0
	push	PSW
	jrnz	arrow	; repeat until under error
	pop	PSW
	mvi	E,'^'
	mvi	C,2
	call	BDOS	; print arrow under error
	lxi	D,errmsg; print SYNTAX error
	mvi	C,prtstrg ;CP/M 9, Print String
	call	BDOS
;--------------
prtinf:	lxi	D,logmsg ;login msg printed here to
	mvi	C,prtstrg ;avoid conflict with arrow
	call	BDOS	; in error routine
        lxi	D,infmsg
	mvi	C,prtstrg ;CP/M 9, Print String
	call	BDOS	
	jmp	WBOOT
;---------------
EXIT:	lxi	D,logmsg ;version printed here to
	mvi	C,prtstrg ;avoid problems with the
	call	BDOS	; arrow in error routine
	lxi	D,crlf	; line feed addr in HL
	mvi	C,prtstrg ;CP/M 9, Print String
	call	BDOS	 
	jmp	WBOOT	; wboot
.page
.sbttl 'SUBROUTINES'
;------------------
; Subroutine getchr: read character in command line
; Regs in: none     
; Regs out: A (next command chr)
; Increment to next command line character
; Test for reading past last character. If true exit
; read next non-blank character, incrementing chrcnt
getchr:		
	lxi	H,cmdlin
	inr	M	; increment to next byte
	lxi	H,chrcnt
	inr	M	; increment chr counter

	lda	numchr
	adi	1
	cmp	M	; compare with chrcnt
	jz	error	; abort if last chr read
	lhld	cmdlin	; read the command char
	xchg
	ldax	D	; now its in reg A
	ret		; got the chr now go back
;---------------
; Subroutine eat00: Evaluate the 00 in command line
; Regs  in: none
; Regs out: none
;
EAT00:
	call	getchr	; eat a '0'
	cpi	'0'
	jnz	error
	call	getchr	; eat a '0'
	cpi	'0'
	jnz	error
	ret
;---------------
.page
.sbttl 'CONSTANTS'
;------------------
; Data addressing and variable definition
;
WBOOT	==      0	; wboot address
BDOS	==	5	; console in/out entry point
port0	==	30h
port1	==	31h
port2	==	32h
port3	==	32h
cr	==	0Dh	; carriage return
lf	==	0Ah	; line feed
prtstrg ==	9h      ; CP/M 9, Print String
port:	.byte	0	; selected port number
cmdlin:	.word	80h	; beginning of command line
chrcnt:	.byte	0	; command character counter
numchr:	.byte	0	; num of command characters read
.page
.sbttl 'CRT MESSAGES'
;---------------
;data for console output
;
LOGmsg: .ascii	[cr][lf]'SETBAUD VERSION '
	.byte	version+'0','.'	;convert to ascii
	.byte	revision/10+'0',revision@10+'0'
	.byte	patch
	.ascii  [cr][lf]'Set the serial port '
        .ascii          'baud rate.$'
infmsg:	.ascii	[cr][lf][lf]'The general form of the '
	.asciz          'SETBAUD command is:'
	.ascii	[cr][lf]'SETBAUD portnumber baudrate'
	.ascii	[cr][lf]'where  portnumber  = '
        .asciz          '0, 1, 2, 3'
	.ascii	[cr][lf]'and possible baudrates are:'
	.ascii	[cr][lf]'     9600, 4800, 2400, 1800'
	.ascii	[cr][lf]'     1200,  600,  300,  110'
	.ascii  [cr][lf]
	.ascii	[cr][lf]'For example, the command '
 	.asciz          '"SETBAUD 3 300" will'
	.ascii	[cr][lf]'assign port number 3'
  	.asciz          ' a baud rate of 300.'
	.ascii  [cr][lf]
	.ascii	[cr][lf]'NOTE: Ports 2 and 3 have'
        .asciz          ' interlocked baud rates.'
	.ascii	[cr][lf]'See the DSC-3/4 User'                    
        .asciz          ' Manual for details.'
	.ascii  [cr][lf]'Do not modify PORT1 baudrate '
	.asciz          'while connected to HiNet.' 
crlf:	.asciz	[cr][lf]'$'
errnet: .ascii  [cr][lf]'When connected to HiNet, '
	.ascii  [cr][lf]'PORT1 baud rate cannot '
	.ascii          'be modifed.'
        .ascii  [cr][lf]'$'
errmsg:	.ascii	[cr][lf]'*** SYNTAX ERROR ***'
	.asciz	[cr][lf]'$'
;
	.blkb	30	; room for stack
stack:			; stack location
	.end

