.RADIX 8
.PABS
.XLINK
.XSYM
.SALL
CONFIG=	\"Config <1/z,2pol,3/cpml,4/cpmh>?- "
Z80=	\"Z80 <y1/n0>?- "
MONCLK=	\"Clock <1comptek/2computime>?- "
;
.ife z80,[RSTINT=1]
.ife z80-1,[RSTINT=0]
;
.IFE CONFIG-2,[
POL88=1
EXTLOC=	^H1800
PARAM=	^H5200
$COM=	^H5000
BEGIN=	^H2000]
;
.IFE CONFIG-3,[
EXTLOC=	^H400
PARAM=	^H3400
$COM=	^H100
BEGIN=	^H1000]
;
.IFE CONFIG-4,[
EXTLOC=	^H0A400
PARAM=	^H400
$COM=	^H100
BEGIN=	^H8000]
;
PRINIT=BEGIN+^D12
;
KRET=	^H0C9
KINP=	^H0DB
;
.IFNDEF CALEN,[
CALEN=	0]
;
.IFE MONCLK-1,[
CLKBAS=	250]
;
.IFE MONCLK-2,[
CALEN=	2
CLKBAS=	^H50
]
;
COMMON=1
;
;****** boiler plate starts *******
	.XLIST
$$SAE=	^D1
$$SAS=	^D2
$$SWA=	^D3
$$SRB=	^D4
$$SER=	^D5
$$SLK=	^D6
$$RXQ=	^D7
$$SGT=	^D8
$$SXX=	^D9
$$RQQ=	^D10
$$SNQ=	^D11
$$SRA=	^D12
$$RVA=	^D13
$$SHK=	^D14
$$SPK=	^D15
$$SLF=	^D16
$$RNA=	^D17
$$RNH=	^D18
$$SAT=	^D19
$$SFA=	^D20
$$SDS=	^D21
$$SDD=	^D22
$$SWS=	^D23
$$SAN=	^D24
$$SFS=	^D25
$$SGV=	^D26
$$SSB=	^D27
$$SPA=	^D28
$$SRQ=	^D29
$$SPL=	^D30
$$RAC=	^D31
$$RAD=	^D32
$$RAY=	^D33
$$RAZ=	^D34
$$STO=	^D35
$$STI=	^D36
$$STL=	^D37
$$SPR=	^D38
$$SHR=	^D39
$$SGQ=	^D40
$$SXB=	^D41
$$SXC=	^D42
$$SUP=	^D43
$$SMN=	^D44
$$SDV=	^D45
$$SUB=	^D46
$$SPO=	^D47
$$SRI=	^D48
$$SXL=	^D49
$$SLD=	^D50
;[DEUQ]
;
.SYN	RC,JRQC
.SYN	RZ,JRQZ
.SYN	RNC,JRQNC
.SYN	RNZ,JRQNZ
.SYN	RM,JRQM
;
;
;[DEUM]
;
.DEFINE LINKJ[ADR]=
[	JMP	$COM+3*ADR]
;
.DEFINE LINKC[ADR]=
[	CALL	$COM+3*ADR]
;
.DEFINE SKIP1=
[	.BYTE	376]
.DEFINE .T[A,B,C,ADR]=
[.WORD	((B&7)<15)+((C&37)<10)+((A&37)<2)+((B&30)>3)
.IFNDEF ADR,[
	.WORD	0]
.IFDEF ADR,[
	.WORD	ADR]
 ]
.DEFINE MTAB[TAB]=
[	LXI	H,TAB]
.DEFINE TTAB[M1,M2,ADR]=
[	.BYTE	(M1 & N137) 
	.BYTE	(M2 & N137) 
	.WORD	ADR]
.DEFINE DINX[REG]=
[	INX	REG
	INX	REG]
.DEFINE DDCX[REG]=
[	DCX	REG
	DCX	REG]
.DEFINE JCLA=
[	XRA	A]
.DEFINE DSUB[SBT]=
[	XCHG
	LHLD	SBT
	CALL	MSUB]
.DEFINE TSTA=
[	ORA	A]
.DEFINE MJST2[PTR]=
[	LHLD	PTR+2
	XCHG
	LHLD	PTR
	CALL	MST2]
.DEFINE MBTEST[TEMP]=
[	LDA	TEMP
	TSTA]
.DEFINE MMOVE[PTR]=
[	LHLD	PTR+2
	XCHG
	LHLD	PTR]
.DEFINE SKIP2[REG]=
[.BYTE	001!(((REG)&6)<3)]
;
.DEFINE MJSSR[TO,FRM,FRME]=;def
[	LHLD	FRM
	MOV	B,H
	MOV	C,L
	LHLD	TO
	XCHG
	LHLD	FRME
	CALL	MSHR
	SHLD	FRME]
;
;
;[DEUZ1]
;
.SYN RET,JRQ
.IFE Z80,[
.SYN JMP,.JMPR
.SYN JNC,.JRNC
.SYN JC,.JRC
.SYN JNZ,.JRNZ
.SYN JZ,.JRZ
;
.DEFINE MJSSA[FROM,TO,LNGTH]=
[	LXI	B,LNGTH
	LXI	H,FROM
	LXI	D,TO
;
	CALL	MSSA]
.DEFINE .DJNZ[ADR]=
[	DCR	B
	JNZ	ADR]
;
.DEFINE MDSBCD=
[	MOV	A,L
	SUB	E
	MOV	L,A
	MOV	A,H
	SBB	D
	MOV	H,A]
 ]
;
;
.IFG Z80,[
.SYN JMPR,.JMPR
.SYN JRNC,.JRNC
.SYN JRC,.JRC
.SYN JRNZ,.JRNZ
.SYN JRZ,.JRZ
;
.DEFINE MJSSA[FROM,TO,LNGTH]=
[	LXI	B,LNGTH
	LXI	H,FROM
	LXI	D,TO
	LDIR]
.DEFINE .DJNZ[ADR]=
[	DJNZ	ADR]
.DEFINE MDSBCD=
[	JCLA
	DSBC	D]
 ]
;
;
P=PARAM
VAR1=	P+14
BOOT=	P+15
MSCI=	P+17
MSRI=	P+22
MSCO=	P+25
MSPO=	P+30
MSLO=	P+33
mscsts=	P+36
MSCHK=	P+41
MSSET=	P+44
MSMCK=	P+47
MSBDOS=	P+52
PSEsym=	P+55
PUIsym=	P+57
PUOsym=	P+61
PULsym=	P+63
TAMsym=	P+65
POAsym=	P+67
POBsym=	P+71
POCsym=	P+73
PODsym=	P+75
PSWsym=	P+77
PSYsym=	P+101
PWAsym=	P+103
tr=	P+105
te=	P+106
RIX=	P+107
BIX=	P+110
MCH=	P+111
TCE=	P+112
CE=	P+114
INPsym=	P+116
OUTsym=	P+120
SPRW3=	P+122
LDRCNL=	P+123
LDRCNH=	P+124
RUBOT=	P+125
RUBO1=	P+126
RUBO2=	P+127
NULCH=	P+130
NULCT=	P+131
PLIN=	P+132
KYN1=	P+133
KYN2=	P+134
CWSAF=	P+135
CWSNF=	P+136
CWSEF=	P+137
CWSPF=	P+140
CWMBF=	P+141
CWMAF=	P+142
CWMNF=	P+143
CWCAS=	P+144
CWCQC=	P+145
CWUNP=	P+146
CWBP1=	P+147
CWEP1=	P+150
CWBP2=	P+151
CWEP2=	P+152
CWBMF=	P+153
CWEMF=	P+154
ENDWC=	P+155
FUTUR0=	P+156
FUTUR1=	P+157
SYN=	P+161
CPCM=	P+167
SYN1=	P+171
SYNR=	P+173
SYNR1=	P+175
CPRP=	P+177
SCEK=	P+204
S1=	P+211
S2=	P+212
S3=	P+213
DSYS1=	P+215
DSYS2=	P+217
DSYS3=	P+221
DSYS4=	P+223
DEXT=	P+225
JMP1TS=	P+230
JMP2TS=	P+231
TAEsym=	P+232
TAHsym=	P+234
TALsym=	P+236
PWR=	P+240
PAE=	P+242
PEL=	P+244
PFL=	P+246
ZERO=	P+250
EXFLG=	P+251
PG1=	P+252
PG1A=	P+253
PG2=	P+254
PG2A=	P+255
BASE=	P+256
LT=	P+257
CH=	P+261
PFI=	P+262
PFF=	P+264
PFN=	P+266
PFT=	P+270
T1=	P+272
T2=	P+274
T3=	P+276
PAL2=	P+300
PAN2=	P+302
PAL=	P+304
PAN=	P+306
PALPL=	P+310
PANPN=	P+312
T4=	P+314
T5=	P+316
T6=	P+320
T7=	P+322
T8=	P+324
T9=	P+326
ADS32=	P+330
ADS33=	P+332
RAND=	P+334
CHA1=	P+336
CHA2=	P+340
PAL21=	P+342
SMSW=	P+344
NULF=	P+345
PNF=	P+346
PNFI=	P+347
ARG1=	P+350
ARG2=	P+352
ARG3=	P+354
TM1=	P+356
MOQOV=	P+357
PCNT=	P+362
ZCNT=	P+363
IOBYT=	P+421
SAMBYT=	P+422
KTRAK=	P+423
DISK1=	P+425
DISK2=	P+427
DISK3=	P+431
DISK4=	P+433
DISK5=	P+435
DISK6=	P+437
DISK7=	P+441
CALDA=	P+443
SAMJM1=	P+446
JMP1AD=	P+447
QWSD0=	P+451
PLTNX=	P+454
PLTNY=	P+456
PLTQD=	P+460
PLTPN=	P+462
PLTCM=	P+463
PLTSX=	P+464
PLTSY=	P+465
PLTWL=	P+466
PLTWR=	P+470
PLTVM=	P+472
TM2=	P+473
TC3=	P+475
TCECT=	P+477
TCEAN=	P+501
SERFLG=	P+502
PKFLG=	P+503
RSTHLD=	P+504
USER1=	P+513
USER1A=	P+514
USER2=	P+515
USER2A=	P+516
USER3=	P+517
USER3A=	P+520
USER4=	P+521
USER4A=	P+522
REGSAV=	P+523
;[CONSTANTS]
;
N10=10
N11=11
N12=12
N13=13
N14=14
N15=15
N16=16
N17=17
N20=20
N21=21
N24=24
N30=30
N34=34
N37=37
N40=40
N50=50
N51=51
N60=60
N70=70
N74=74
N76=76
N77=77
N100=100
N110=110
N137=137
N144=144
N133=133
N135=135
N177=177
N200=200
N202=202
N277=277
N300=300
N340=340
N34=34
N377=377
N1K=1000
N1750=1750
N10K=10000
N100K=100000
N2342=23420
;
K400K=200
K500K=240
K600K=300
K700K=340
;
KABM=	K600K<N10
KABN=	K700K<N10
KABF=	K400K<N10
KACM=	K500K<N10
;
N400=400
N47=47
;
KCRLF=4215
;
;[DEU2]
;
.IFE RSTINT,[
.DEFINE JSLK=
[	RST	6]
.DEFINE JSER=
[	RST	5]
.DEFINE JSWA=
[	RST	3]
.DEFINE JSAS=
[	RST	2]
.DEFINE JSRB=
[	RST	4]
.DEFINE JSAE=
[	RST	1]
]
;
.IFG RSTINT,[
.DEFINE JSAE=
[	CALL	MSAE]
.DEFINE JSAS=
[	CALL	MSAS]
.DEFINE JSWA=
[	CALL	MSWA]
.DEFINE JSRB=
[	CALL	MSRB]
.DEFINE JSER=
[	CALL	MSER]
.DEFINE JSLK=
[	CALL	MSLK]
]
;
;
;
.IFDEF COMMON,[
MSAE=	$COM+3*$$SAE
MSAS=	$COM+3*$$SAS
MSWA=	$COM+3*$$SWA
MSRB=	$COM+3*$$SRB
MSER=	$COM+3*$$SER
MSLK=	$COM+3*$$SLK
 ]
;
;
CCNUL=	0
CCSOH=	1
CCSTX=	2
CCETX=	3
CCEOT=	4
CCENQ=	5
CCACK=	6
CCBEL=	7
CCBS=	10
CCHT=	11
CCLF=	12
CCVT=	13
CCFF=	14
CCCR=	15
CCSO=	16
CCSI=	17
;
CCDLE=	20
CCDC1=	21
CCDC2=	22
CCDC3=	23
CCDC4=	24
CCNAK=	25
CCSYN=	26
CCETB=	27
CCCAN=	30
CCEM=	31
CCSUB=	32
CCESC=	33
CCFS=	34
CCGS=	35
CCRS=	36
CCUS=	37
;
	.LIST
;******** boiler plate ends *******
	.LOC	EXTLOC
;
;
EXTTAB:
.T "E","X","T",EXTQQ; extended functions
;
;[$271/XU]
;
$271:	MTAB	XUTABQ
SPKSUB:	LINKC	$$SPK
	RC
	PCHL
;
XULF:	MTAB	XUTABQ
	LINKJ	$$SLF
;
XUTABQ:	.BYTE	(XUTABE - XUTABB) / 4
XUTABB:
.T "D","M"," ",XUDM;	Duplicate Memory "fill"
.T "D","T"," ",XUDT;	"X" base Define Text
.T "F","M"," ",XUFM;	Fetch Memory
.T "F","T"," ",XUFT;	"X" base Fetch Text
.T "L","F"," ",XULF;	List "XU" functions
.T "M","M"," ",XUMM;	Move Memory
.T "R","C","V",XURCV;	Receive
.T "R","L"," ",XURL;	Read Labelled location
.T "S","U","M",XUSUM;	Sum Memory
.T "T","M"," ",XUTM;	Type Memory
.T "V","M"," ",XUVM;	Verify Memory
.T "W","L"," ",XUWL;	Write in Labelled location
.T "X","M","T",XUXMT;	X"trans"mit
XUTABE:
;[XURL]
XURL:	LINKC	$$SXL
	MOV	A,M
	INX	H
	MOV	H,M
	MOV	L,A
	LINKJ	$$SXC;h&l
;
;
;[XUDT]
XUDT:	LINKC	$$SFA
	.JRC	XUDT1
	LINKC	$$SDD
XUDT1:	LINKC	$$SPL
	PUSH	H
	MOV	L,A
	MOV	H,A
XUDT2:	LINKC	$$SAE
	.JRC	XUDT3
	INX	H
	JSAS
	.jmpr	XUDT2
;
XUDT3:	SHLD	PAN
	POP	H
	SHLD	PAL
	MVI	A,200
	LINKC	$$SDS
XUDT4:	LINKC	$$SNQ
	PUSH	H
	LINKC	$$SXX
	POP	H
	INX	H
	MOV	M,C
	.jmpr	XUDT4
;
;
;[XUFT]
XUFT:	LINKC	$$SFA
	RC;jrqc
	JSER
	JSAS
XUFT1:	JSRB
	RC;jrqc
	LINKC	$$SAT
	LINKC	$$SXB;c
	.jmpr	XUFT1
;
;
;[XUFM]
XUFM:	JSER
	call	FROMT2
;
XUFM1:	LINKC	$$SAT
	MOV	C,M
	LINKC	$$SXB;c
	call	HILOQ
	.jmpr	XUFM1
;
;
;[XUSUM]
XUSUM:	call	FROMT2
	JCLA
XUSUM1:	ADD	M
	MOV	C,A
	call	HILOT
	MOV	A,C
	.JRC	XUSUM1
	LINKJ	$$SXB;c
;
;
HILOQ:	call	HILOT
	RC
	POP	D
	RET
HILOT:	MOV	A,L
	SUB	E
	MOV	A,H
	SBB	D
	INX	H
	RET
;
;
NUDSET:	MVI	A,2
	STA	NULF
;
FROMT2:	LINKC	$$SXX
	PUSH	H
	LINKC	$$SXX
	XCHG
	POP	H
	RET
;
FROMT3:	call	FROMT2
	PUSH	H
	LINKC	$$SXX
	POP	H
	RET
;
;[XUDM]
XUDM:	call	FROMT3
;
XUDM1:	MOV	M,C
	call	HILOQ
	.jmpr	XUDM1
;
;
;[XUMM]
XUMM:	call	FROMT3
;
XUMM1:	MOV	A,M
	STAX	B
	call	HILOQ
	INX	B
	.jmpr	XUMM1
;
;
;[XUTM]
XUTM:	CALL	NUDSET
;
XUTM1:
.IFNDEF TRS80,[
	CALL	DOTCHK]
;
.IFDEF TRS80,[
DOTCHK:	PUSH	B
	MOV	A,M
	MVI	C,"."
	ANI	177
	CPI	41
	.JRC	DOTCH1
	CPI	177
	.JRZ	DOTCH1
	MOV	C,A
DOTCH1:	jswa
	POP	B]
;
	CALL	HILOQ
	.jmpr	XUTM1
;
;
;[XUWL]
XUWL:	LINKC	$$SXL
	XCHG
	LINKC	$$SXX
	XCHG
	MOV	M,C
	INX	H
	MOV	M,B
	jrq;ret
;
;
;[XUVM]
XUVM:	JSER
	call	FROMT3
;
XUVM1:	LDAX	B
	CMP	M
	.JRZ	XUVM2
	PUSH	B
	LINKC	$$SAT
	LINKC	$$SXC;h&l
	POP	B
XUVM2:	call	HILOQ
	INX	B
	.jmpr	XUVM1
;
;
EXTQQ:	.BYTE	(EXTQE - EXTQB) / 4
EXTQB:
.T "C","W","C",$250;	Change Warning Character
.T "D","A"," ",$259;	Date
.T "S","D","A",$260;	Set Date
.T "S","E","M",$199;	Set Echoplex Mode
.T "S","T","I",$257;	Set Time
.T "T","I"," ",$258;	Time
.T "T","R","S",$TRS;	TRS functions
.T "X","U"," ",$271;	Xperimental User function
EXTQE:
;[$199/SEM]
$199:	.JRZ	$1991
	INR	A
$1991:	STA	TE
	RET
;
;
;[$196/QFC]
.IFDEF QFC196,[
$196:	LHLD	NULCT
	MOV	H,A
	LINKJ	$$RVA]
;
;
;[$204/QRO]
.IFDEF QRO204,[
$204:	LXI	H,RUBOT
	MOV	C,M
	JSWA
	INX	H
	MOV	C,M
	JSWA
	INX	H
	MOV	C,M
	JSWA
	jrq;ret]
;
;
;[$249/ETB]
.IFDEF ETB249,[
$249:	JSAS
	LHLD	PAL
	PUSH	H
	MOV	D,H
	MOV	E,L
$2491:	DCX	D
	LDAX	D
	MOV	C,A
	DCX	D
	LDAX	D
	MOV	B,A
	ANI	K700K
	.JRNZ	$2494
$2492:	DCX	H
	MOV	M,C
	DCX	H
	MOV	M,B
	MOV	A,C
	CPI	N12
	.JRZ	$2493
	CPI	N15
	.JRNZ	$2491
$2493:	DCX	D
	LDAX	D
	MOV	C,A
	DCX	D
	LDAX	D
	MOV	B,A
	ANI	K700K
	.JRNZ	$2494
	MOV	A,C
	CPI	N40
	.JRZ	$2493
	.jmpr	$2492
$2494:	DDCX	H
	SHLD	PAL
	POP	D
	PUSH	H
	LINKC	$$SUB
	DDCX	H
	LINKC	$$SDV
	SHLD	PAN
	XCHG
	POP	H
	MOV	A,B
	ANI	K700K
	ORA	D
	MOV	M,A
	INX	H
	MOV	M,E
	LINKJ	$$RAD]
;
;
;[$250/CWC]
$250:	MTAB	CWSAF
$2501:	LINKC	$$SRA
	.JRC	$2502
	MOV	M,C
	INX	H
	MOV	A,M
	TSTA
	.JRZ	$2501
;
$2502:	LDA	CWSAF
	STA	SYN+1
	STA	SYN1+1
	LDA	CWSEF
	STA	CPRP+1
	STA	CPRP+3
	LDA	CWCAS
	STA	CPCM+1
	RET
;
;
;[$259/DA]
;
.IFE CALEN,[
$259:	JSER
	LXI	H,CALDA
	MVI	B,3
;
$2591:	LINKC	$$SAT
	MOV	A,M
	INX	H
	STA	PAN2
	LINKC	$$SGV
	.DJNZ	$2591
	jrq;ret]
;
;
;[$260/SDA]
;
.IFE CALEN,[
$260:	LXI	H,CALDA
	MVI	D,3
	;
$2601:	PUSH	H
	LINKC	$$SGT
	POP	H
	MOV	M,C
	INX	H
	DCR	D
	.JRNZ	$2601
	jrq;ret]
;
;
;[$258/TI]
;[$257/STI]
;
;[COMPTEK]
;monclk=1
.IFE MONCLK-1,[
$258:	JSER
.IFE Z80,[
	MVI	A,KINP
	STA	ADS32
	MVI	A,KRET
	STA	ADS32+2]
;
;
	MVI	C,CLKBAS+10
	LXI	H,CLKTAB-1
	MVI	B,10
;
CLKGET:	INX	H
	MOV	A,M
	TSTA
	.JRZ	CLKSEP
	ADD	C
	MOV	C,A
.IFG Z80,[
	INP	A]
.IFE Z80,[
	STA	ADS32+1
	CALL	ADS32]
	ANI	N17
	ADI	N60
	PUSH	B
	MOV	C,A
	JSWA
	POP	B
CLKNXT:	.djnz	CLKGET
	jrq;retQ
;
CLKSEP:	PUSH	H
	LINKC	$$SAT
	POP	H
	.jmpr	CLKNXT
;
CLKTAB:	.BYTE	-1
	.BYTE	-1
	.BYTE	0
	.BYTE	-1
	.BYTE	-4
	.BYTE	0
	.BYTE	1
	.BYTE	1]
;
.IFE MONCLK-1,[
$257:	LXI	H,T4
	MVI	M,0
	INX	H
	MVI	M,0
	MVI	B,6
;
CLKTI:	INX	H
	LINKC	$$SAE
	.JRC	CLKT0
	PUSH	B
	LINKC	$$SRA
	MOV	A,C
	POP	B
	SUI	60
CLKT0:	MOV	M,A
	.djnz	CLKTI
;
CLKSM2:	LXI	H,T4
	.jmpr	CLKSEC
CLKSM3:	MVI	A,4
	OUT	CLKBAS+1
;
CLKSL1:	IN	CLKBAS+7
	CMP	M
	.JRNZ	CLKSL1
	INX	H
;
CLKSL2:	IN	CLKBAS+6
	CMP	M
	.JRNZ	CLKSL2
	INX	H
;
CLKSL3:	IN	CLKBAS+5
	CMP	M
	.JRNZ	CLKSL3
	INX	H
;
CLKSL4:	IN	CLKBAS+1
	CMP	M
	.JRNZ	CLKSL4
	INX	H
;
CLKSEC:	MVI	A,2
	OUT	CLKBAS+1
;
CLKSL5:	IN	CLKBAS+2
	CMP	M
	.JRNZ	CLKSL5
	INX	H
;
CLKSL6:	IN	CLKBAS+3
	CMP	M
	.JRNZ	CLKSL6
	INX	H
;
	JCLA
	OUT	CLKBAS+1
	CMP	B
	RNZ
	INR	B
	.jmpr	CLKSM3]
;
;
;[COMPUTIME]
;Port assignments
;
.IFE MONCLK-2,[
PCAD=	CLKBAS+0
PCAC=	CLKBAS+1
PCBD=	CLKBAS+2
PCBC=	CLKBAS+3
;
PTAD=	CLKBAS+4
PTAC=	CLKBAS+5
PTBD=	CLKBAS+6
PTBC=	CLKBAS+7
;
K3030=	^H3030]
;
;[$259/DA]
;
.IFE CALEN-2,[
$259:	CALL	READ4
;
	LINKC	$$SAT
	LHLD	CALDA
	LINKJ	$$RVA]
;
;
;[$260/SDA]
;
;	%sda,MMDD,year/
;
.IFE CALEN-2,[
$260:	CALL	CLKRES
;
SDAT:	MVI	A,^H57
	CALL	SETDIG
;
	MVI	A,^H77
	CALL	SETDIG
;
	JSAS
	LINKC	$$SNQ
	LINKC	$$SGT
	SHLD	CALDA
;
	RET]
;
;
.IFE MONCLK-2,[
$258:	MVI	A,^H40
	CALL	READ4
	LINKC	$$SAT
	CALL	RSDIG
RSDIG:	CALL	RDIGIT
	MOV	C,A
	JSWA
	MOV	A,D
	ADI	^H10
	MOV	D,A
	RET]
;
;
.IFE MONCLK-2,[
$257:	.JRNZ	ZERSEC
	CALL	CLKRES
;
STIME:	MVI	A,^H76
	CALL	SETDIG
;
	MVI	A,^H56
	CALL	SETDIG
;
STIDON:	MVI	A,^H40
	OUT	PTBD
	RET
;
ZERSEC:	MVI	A,^H56
	OUT	PTBD
	.JMPR	STIDON]
;
;
.IFE MONCLK-2,[
;[RDIGIT]
;
RDABT:	LINKC	$$SHK
RDIGIT:	MOV	A,D
	OUT	PTAD
	IN	PTAD
;
RDWAIT:	IN	PTAC
	RAL
	.JRNC	RDWAIT
	IN	PTAD
	ANI	^H0F
	ORI	^H30
	RET
;
;
;[READ4]
;
READ4:	PUSH	PSW
	JSER
	CALL	CLKINT
	POP	PSW
	OUT	PTBD
	MVI	D,0
READ4A:	CALL	RDIGIT
	CALL	RSDIG
	MOV	A,D
	CPI	^H20
	.JRNZ	READ4S
	LINKC	$$SAT
	MOV	A,D
READ4S:	CPI	^H40
	RZ
	.JMPR	READ4A
;
;
;[SETDIG]
;
SETDIG:	OUT	PTBD
	MOV	E,A
;
	CALL	GETTWO
;
SETTST:	MOV	A,E
;
	ANI	^H20
	MVI	D,0
	.JRNZ	SETCAL
	MVI	D,^H20
SETCAL:	IN	PTBD
SETWAI:	IN	PTBC
	RAL
	.JRNC	SETWAI
	CALL	RDABT
	CMP	H
	.JRNZ	SETCAL
	MVI	A,^H10
	ADD	D
	MOV	D,A
	CALL	RDABT
	CMP	L
	.JRNZ	SETTST
	MVI	A,^H46
	OUT	PTBD
	RET
;
;
;[CLKRES]
;
CLKRES:	OUT	PTAC
	OUT	PTBC
;
CLKINT:	IN	PTAD
	CPI	^H0FF
	JZ	$COM+3*$$RNA
	MVI	A,^H70
	OUT	PTAD
	MVI	A,^H77
	OUT	PTBD
	MVI	A,^H14
	OUT	PTAC
	MVI	A,^H04
	OUT	PTBC
;
	RET
;
;
GETTWO:	JSAE
	RC
	LINKC	$$SRA
	JSAE
	RC
	MOV	H,C
	LINKC	$$SRA
	JSAE
	RC
	MOV	L,C
	RET]
;
;
.SBTTL /Check Summed Adressed Loader/
;
;	Modes: (stored in "SWLOC")
;  1	On - from remote source
;  1	Off - Local source
;
;	Format:
; SOH	start of header (hex 1)
; del	control byte
; byt	number of data bytes
; lad	low address load point
; had	high address
; ...	data
; ...	data
; lcs	low byte check sum
; hcs	high byte check sum
;
;
; 170	end of file header
; lad	low address jump to
; had	high address jump to
;
;
;[XURCV]
;
XURCV:	CALL	GETARG
	MVI	C,CCCR
	LINKC	$$spo;let us go
	CALL	XMODE1
	.JRZ	SNDACK
RCVENT:	LINKC	$$sri;input
	.JRC	RCVENT
	CPI	CCENQ
	.JRNZ	RCVENT
SNDACK:	MVI	C,CCACK
	LINKC	$$spo;output
;
	.JMPR	GETLDR
;
GETFIN:	CALL	GETAD
	MOV	A,L
	ORA	H
	RZ
	PCHL;	all done
;
GETTRS:	CPI	^H3C
	.JRZ	LDR377
;
GETLDR:	CALL	GETBY
GETLDX:	CPI	170
	.JRZ	GETFIN
	CPI	CCETB
	RZ
	MOV	C,A
	CALL	XMODE2
	MOV	A,C
	.JRNZ	GETTRS
	CPI	CCSOH
	.JRNZ	GETLDR
	CALL	GETBY
	CPI	377
	.JRNZ	GETLDX
;
LDR377:	CALL	GETBY
	PUSH	PSW
	LXI	D,0
	CALL	GETAD
	PUSH	H
	POP	B
	LHLD	USER1
	DAD	B
;
RCVHL:	LDA	USER3
	ANI	4
	.JRZ	RCVHL1
;
	LINKC	$$spr
	LINKC	$$sxc;h&l
	LINKC	$$spr
RCVHL1:	POP	PSW
	MOV	B,A
;
LOAD:	CALL	GETBY
;
RCVOK:	CALL	PUTCHR
	INX	H
;
	.DJNZ	LOAD
;
	CALL	XMODE2
	.JRNZ	TRSPAR
	PUSH	D
	CALL	GETBY
	POP	D
	CMP	D
	.JRNZ	PARTS1
TRSPAR:	PUSH	D
	CALL	GETBY
	POP	D
	CMP	E
PARTS1:	CALL	NOTIFY
	.JMPR	GETLDR
;
;
;[PUTCHR]
;
PUTCHR:	MOV	M,A
	CMP	M
	.JRNZ	MEMERR
RCVDI:	LDA	USER3
	ANI	4
	RZ
;
DOTCHK:	PUSH	B
	MOV	A,M
	MVI	C,"."
	ANI	177
	CPI	41
	.JRC	DOTCH1
	CPI	177
	.JRZ	DOTCH1
	MOV	C,A
DOTCH1:	jswa
	POP	B
	RET
;
;
;[GETAD]
;
GETAD:	CALL	GETBY
	MOV	L,A
	CALL	GETBY
	MOV	H,A
	RET
;
;
;[GETBY]
;
GETBY:	LINKC	$$sri;input
	.JRC	GETNAK
	PUSH	PSW
	ADD	E
	MOV	E,A
	.JRNC	GETBYR
	INR	D
GETBYR:	POP	PSW
	RET
;
;
GETNAK:	CALL	XMODE1
	.JRZ	TIMERR
;
	MVI	C,CCNAK
	LINKC	$$spo;output
	JMP	GETLDR
;
;
;[NOTIFY]
;
NOTIFY:	.JRNZ	NOTNAK
	CALL	XMODE1
	RZ
	MVI	C,CCACK
	.JMPR	NOTOUT
;
NOTNAK:	CALL	XMODE1
	.JRZ	PARERR
NOTINP:	MVI	C,CCNAK
NOTOUT:	LINKC	$$sri;input
	ANI	177
	CPI	CCENQ
	.JRNZ	NOTOUT
	LINKC	$$spo;output
	RET
;
;
;[ERRORS]
;
MEMERR:	MVI	C,"M"
	SKIP2	D
PARERR:	MVI	C,"P"
	SKIP2	D
TIMERR:	MVI	C,"T"
;
EREXIT:	jswa
	LINKJ	$$RNA
;
;
;[GETARG]
;
; USER4 is start address
; USER3 is mode
; USER3+1 is channel control
; USER1 is from or offset
; USER2 is to or reloc
; B & C is desired count
; H & L memory location
;
GETARG:	CALL	NUDSET
	MOV	A,L
	ANI	7
	STA	USER3
	XCHG
	SHLD	USER4
	CALL	FROMT2
	SHLD	USER1
	XCHG
	SHLD	USER2
;
	MDSBCD
	MOV	B,H
	MOV	C,L
	XCHG
;lxi d,0
	INX	B
	RET
;
;
XMODE1:	LDA	USER3
	ANI	1
	RET
;
;
XMODE2:	LDA	USER3
	ANI	2
	RET
;
;
;[XUXMT]
;
.IFG Z80,[
XUXMT:	CALL	GETARG
	EXX
;
XMTENT:	CALL	XMODE1
	.JRZ	XMT377
	MVI	C,CCENQ
	LINKC	$$spo;output
XMTST2:	LINKC	$$sri;input
	.JRC	XMTENT
	CPI	CCACK
	.JRNZ	XMTST2
;
;
XMT377:	MVI	C,CCCR
	LINKC	$$spo;output
	EXX
;
XMTSOH:	PUSH	B
	CALL	LEADER
	MVI	C,^H3C
	CALL	XMODE2
	.JRNZ	XMTTRS
	MVI	C,CCSOH
	LINKC	$$spo;output
	MVI	C,377
XMTTRS:	LINKC	$$spo;output
	POP	B
	XRA	A
	MOV	E,A
	MOV	D,A
	CMP	B
	.JRNZ	XMTNXT
	CMP	C
	.JRZ	XMTDON
	MOV	A,C
XMTNXT:	PUSH	B
	MOV	C,A
	LINKC	$$spo;output
	MOV	B,C	; bytes this block
	MOV	C,L
	LINKC	$$spo;output
	MOV	C,H
	LINKC	$$spo;output
	PUSH	H	; save for rexmt
	EXX
	POP	H
	POP	B
	PUSH	B
	EXX
	MOV	A,H
	ADC	L
	MOV	E,A
	.JRNC	XMTLP1
	INR	D
;
XMTLP1:	MOV	C,M
	LINKC	$$spo;output
	INX	H
	MOV	A,E
	ADC	C
	MOV	E,A
	.JRNC	XMTLP2
	INR	D
XMTLP2:	.DJNZ	XMTLP1
;
	MOV	C,E
	LINKC	$$spo;output
	CALL	XMODE2
	.JRNZ	XMTPAR
	MOV	C,D
	LINKC	$$spo;output
;
XMTPAR:	CALL	XMODE1
	.JRNZ	XMTCK
;
XMTOK:	POP	B
	ADD	B
XMTOK1:	.JRZ	XMTDON
	DCR	B
XMTOK2:	.JMPR	XMTSOH
;
;
XMTCK:	MVI	C,CCENQ
	LINKC	$$spo;output
	MVI	B,20
XMTCK1:	LINKC	$$sri;input
	CPI	CCACK
	.JRZ	XMTOK
	CPI	CCNAK
	.JRZ	XMTNOK
	.DJNZ	XMTCK1
	JMP	TIMERR
;
XMTNOK:	POP	B
	EXX
	PUSH	B
	PUSH	H
	EXX
	POP	H
	POP	B
	.JMPR	XMTOK2
;
;
XMTDON:	MVI	C,170
	LINKC	$$spo;output
	LHLD	USER4
	MOV	C,L
	LINKC	$$spo;output
	MOV	C,H
	LINKC	$$spo;output
	MVI	C,CCETB
	LINKC	$$spo;output
	CALL	LEADER
;
	RET
;
;
;[LEADER]
;
LEADER:	MVI	A,200
;
LEADX:	PUSH	B
	MOV	C,A
	MVI	B,20
;
LEAD1:	LINKC	$$spo;output
	.DJNZ	LEAD1
	POP	B
	RET]
;
;
	.END
;
:	MVI	A,200
;
LEADX:	PUSH	B
	MOV	C,A
	MVI	B,20
;
LEAD1:	LINKC	$$spo;output
	.DJNZ	LEAD1
	P