;	Dw	length	;Library length
	org	100h

	;-------------------------------------------
	;----	    Library for Janus		----
	;---- Copyright 1981,1982		----
	;---- RR Software, Madison WI		----
	;---- This source code may not be	----
	;---- distributed without permission.	----
	;---- However, code generated from this	----
	;---- library file is not protected.	----
	;---- (608) 244-6436			----
	;---- Last Modified 2/ 2/82		----
	;-------------------------------------------

	;-----------------------------
	;---- Initialization Code ----
	;-----------------------------

	;**** I M P O R T A N T   N O T E ****
	;The Code from this point until the beginning of Negate2 cannot
	;be modified without modifying the compiler internally.

start:	lhld	0006h
	lxi	d,-16	;Start 16 bytes below the OS for safety
	dad	d
	sphl		;Initialize stack pointer
	shld	PchainPtr	;Start of Dynamic Chain {Used for walkbacks and
				;exception handling} (= Current SP)
	lxi	h,0h	;0 = End of Data Section(Will Be Patched by the linker)
	shld	Heap$Ptr;Initialize the Heap Pointer
	lxi	h,0
	shld	RetList	;Set the Return List Pointer to Null
	shld	RetEnd	;End of Return Chain = Null
	push	h	;Nil = End of the dynamic Chain
	push	h	;Line Number of call of main program = 0
	push	h	;Nil = Ret End pointer
	;The code for RST 4 setup should be NOP'ed if RST 4 is used by your
	;system
	;---- Start RST 4 setup
	lxi	h,020h	;Set up Reset 4 Vector
	mvi	m,JMP	;Mov Jump Opcode into memory
	lxi	d,Decode
	inx	h
	mov	m,e	;Move Decode procedure address into memory
	inx	h
	mov	m,d	;Jmp Decode whenever RST 4 is used
	;---- End RST 4 setup
	lxi	h,main$name
	push	h	;Name of Main Procedure
	jmp	0h	;Jump to start of main program
			;(To be patched by linker or compiler)

	;Note: if above section is changed, addresses in Sem3rt ##59 and
	;      Pack_head must be changed
RetList: dw	0	;Current Return List Pointer (Used for return values
			;larger than can fit in a register)
RetEnd: dw	0	;This pointer marks the end of the return chain.
			;Values on the chain beyond this point must be saved.
Heap$Ptr: dw	0	;Current Heap Pointer
dispstart: dw	0,0,0,0,0,0,0,0,0,0,0	;Display 'registers' (0 and 1 not used)
LineNo:	dw	0	;Current Line Number (Set by LnoCode)
PchainPtr: dw	0	;Current Dynamic Chain Pointer

	;-----------------------------------------
	;---- Decode Procedure - 	      ----
	;---- Decodes Lib call using byte     ----
	;---- following call as opcode number ----
	;-----------------------------------------
Decode:	xthl
	mov	c,m	;Get Opcode Byte
	inx	h
	xthl
	push	h
	mvi	b,00	;Clear Upper Byte
	lxi	h,Jump$Table ;Get address of Jump Table
	dad	b
	dad	b
	dad	b	;Add the offset Three times
	xthl		;Put jump table address as Return address,
			; and restore HL
	ret		;Jump to location in Jump Table
Jump$Table:
	jmp	Halt	;0
	jmp	Negate2	;1
	jmp	Sub2	;2
	jmp	Mul2	;3
	jmp	Div2	;4
	jmp	Rem2	;5
	jmp	Mod2	;6
	jmp	Lt1	;7
	jmp	Le1	;8
	jmp	Eq1	;9
	jmp	Neq1	;10
	jmp	Ge1	;11
	jmp	Gt1	;12
	jmp	Lt2	;13
	jmp	Le2	;14
	jmp	Eq2	;15
	jmp	Neq2	;16
	jmp	Ge2	;17
	jmp	Gt2	;18
	jmp	Member1	;19
	jmp	Member2	;20
	jmp	SMember1;21
	jmp	SMember2;22
	jmp	Getaddr	;23
	jmp	Getact1	;24
	jmp	Getact2	;25
	jmp	Putact1	;26
	jmp	Putact2	;27
	jmp	BlkMove	;28
	jmp	BlkCmp	;29
	jmp	LnoCode	;30
	jmp	Sour$Err;31
	jmp	Range1	;32
	jmp	Range2	;33
	jmp	SRange1	;34
	jmp	SRange2	;35
	jmp	Err$Exit;36
	jmp	Null$Ptr;37
	jmp	Str$Bound;38
	jmp	CaseErr	;39
	jmp	GetInt	;40
	jmp	EPut$Str;41
	jmp	0	;42
	jmp	0	;43
	jmp	0	;44
	jmp	EPutInt	;45
	jmp	Puthex	;46
	jmp	EPutIntw;47
	jmp	EPutEnum;48
	jmp	EPutEnumW;49
	jmp	0	;50
	jmp	ProcInit;51
	jmp	ProcFin	;52
	jmp	Exp2	;53
	jmp	Abs2	;54
	jmp	SLt	;55
	jmp	SLe	;56
	jmp	SEq	;57
	jmp	SNeq	;58
	jmp	SGe	;59
	jmp	SGt	;60
	jmp	Sassign	;61
	jmp	Concat	;62
	jmp	EVWrite	;63
	jmp	ERead	;64
	jmp	EWrite	;65
	jmp	New$Line;66
	jmp	0	;67 Skip$Line
	jmp	Func$Release;68
	jmp	Func$Ret;69
	jmp	File$Name ;70
	jmp	New$Ptr	;71
	jmp	NullRng1;72
	jmp	NullRng2;73
	jmp	SNullRng1;74
	jmp	SNullRng2;75


	;-----------------------------
	;---- Range for Byte Type ----
	;-----------------------------
Byte$Range: dw	0,255	;Used in type conversions

	;-----------------------------------------------------
	;---- Default I/O files for Get, Put and New_Line ----
	;-----------------------------------------------------
Input:  db 1,1	;Console, R/O
Output: db 1,2	;Console, W/O	Note that the rest of the files are not used
		;Also note that these should be inplemented as pointers

	;---------------------------------------
	;---- Enumeration Table for Boolean ----
	;---------------------------------------
Bool$Tab: dw F1,T1
F1:	db	5,'FALSE'
T1:	db	4,'TRUE'

	;--------------------------------------
	;---- Integer, Boolean, and Relops ----
	;--------------------------------------

	;Negate HL
	;*** Entry Point ***
negate2: mov	a,h
	cma		;complement high bits
	mov	h,a
	mov	a,l
	cma		;complement low bits
	mov	l,a
	inx	h	;1's comp. goes to 2's comp.
	ret

	;Absolute Value of HL
	;*** Entry Point ***
abs2:	mov	a,h
	ora	a	;set the flags
	jm	negate2 ;Negate it if its negative (negate does the return)
	ret

	;Subtract HL - DE
	;*** Entry Point ***
sub2:   mov	a,l
	sub	e
	mov	l,a
	mov	a,h
	sbb	d
	mov	h,a
	ret

	;Multiply HL * DE
	;Kills All
	;*** Entry Point ***
mul2:	mov	b,d
	mov	c,e
	lxi	d,0000h	;Clear DE - result goes here
	mov	a,c
mbyte:  mov	c,b	;Rotate the bytes of the multiplier
	mvi	b,08h	;Load count of number of bytes
mloop:	rar		;Put lowest bit in Carry
	jnc	mskip	;Bit is off
	xchg
	dad	d	;Add value in HL to result
	xchg
mskip:	dad	h	;Double Multiplcand
	dcr	b	;lower counter
	jnz	mloop
	mov	a,c	;Get next byte of Multiplacand
	ana	a	;Stop if zero
	jnz	mbyte	;Note - there is a trick here. The counter in B, which
			;now holds 0, will be rotated into C, thereby causing
			;termination.  This also stops a multiplaction if the
			;upper byte is 0
	xchg		;Put result into HL
	ret

	;16x16 Bit Divide Procedure
	;Dividend in HL, Divisor in DE (HL/DE)
	;Returns Remainder in HL, Quotient in DE
	;See June 1981 BYTE for description of Division Algorithms (P. 395)
	;Kills All
sign:	ds	1	;0 if sign of result is pos, 0ffh otherwise
divide: xra	a
	sta	sign	;sign starts as positive
	mov	a,d
	ora	a	;set status flags
	jp	posop
	xchg
	call	negate2	;make divisor positive
	xchg
	mvi	a,0ffh
	sta	sign	;sign is now negative
posop:  mov	a,h
	ora	a	;set status flags
	jp	posop2
	call	negate2	;make dividend positive
	lda	sign	;Flip sign flag
	cma
	sta	sign
	;HL - Remainder, DE - Dividend & Quotient, BC - Divisor
	;L - Counter (Or top of stack)
posop2: mov	a,d	;Start the division
	ora	e
	jz	dzero	;Divisor = 0?
	mov	b,d	;Move divisor into BC
	mov	c,e
	xchg		;Move Dividend into DE
	mvi	l,16	;Set Counter to 16 (bits)
	push	h	;Put the counter on the stack
	lxi	h,0	;Set Remainder to Zero
	xchg
	dad	h	;Shift Dividend Left, Setting Carry
	xchg
DivLoop:jc	dskip
	dad	h	;Shift Remainder Left, Adding Carry if Necessary
	jmp	dskip2  ;This is a Z80 ADC HL inst
dskip:  dad	h
	inx	h
dskip2: push	h	;Save Remainder during trial subtraction
	mov	a,l	;Subtract HL-BC
	sub	c
	mov	l,a
	mov	a,h
	sbb	b
	mov	h,a
	jp	DivIt	;If Remainder is positive, the subtraction stays
	pop	h
	xchg
	dad	h	;Shift Dividend Left, Shifting in New Quotient of 0,
	xchg		;and setting Carry, if necessary
	jmp	dskip3
DivIt:	inx	sp	;Take old remainder off of stack
	inx	sp
	xchg
	dad	h	;Shift Dividend Left, Shifting in New Quotient of 1,
	inx	h	;and Setting Carry if necessary
	xchg
dskip3: xthl		;Exchange Top of stack with HL
	dcr	l
	jz	DivDone	;Counter Ran Out
	xthl		;Get remainder Back
	jmp	DivLoop
DivDone:pop	h	;Get remainder back
	;Remainder in HL, Quotient in DE
	ret
	;Divide by Zero Error
Dzero:  lxi	h,Str4
	call	wstr	;'Divide By Zero Detected'
	jmp	Err$Exit
Str4:	db	26,'** Divide By Zero Detected'

	;Integer Divide
	;Dividend in HL, Divisor in DE (HL/DE)
	;Result in HL
	;Kills All
	;*** Entry Point ***
Div2:	Call	Divide	;Quotient is in DE
	xchg
	lda	sign
	ora	a
	rz		;Quotient is positive
	jmp	negate2	;Negate Result

	;Integer Modulus
	;Dividend in HL, Divisor in DE (HL MOD DE)
	;Result in HL
	;Kills All
	;*** Entry Point ***
Mod2:	push	d
	call	Rem2	;Remainder is in HL
	pop	d
	lda	sign
	ora	a
	rz		;Done if sign is positive
	mov	a,h
	ora	l	;Done if result is zero
	rz
	dad	d	;Add divisor to Remainder
	ret

	;Integer Remainder
	;Dividend in HL, Divisor in DE (HL REM DE)
	;Result in HL
	;Kills All
	;*** Entry Point ***
Rem2:	mov	a,h
	ora	a
	jm	Rneg
	xra	a	;Clear sign flag
Rneg:	push	psw	;A <> 0 if HL is negative
	Call	Divide	;Remainder is in HL
	pop	psw
	ora	a
	rz		;Done if positive
	jmp	negate2	;Negate result
	
	;Integer - Integer Exponetiation Routine
	;HL ** DE (Error if DE < 0)
	;Result in HL
	;Kills All
	;*** Entry Point ***
Exp2:	Mov	a,d
	Ana	a	;Test for negative operand
	Jm	BadExp
	Mov	b,d
	Mov	c,e	;Move DE to BC
	xchg		;Put HL into DE
	Lxi	h,1	;Start value = 1
ExpLoop: Mov	a,b
	Ora	c
	Rz		;Done when exponent = 0
	Dcx	b	;One less loop to go
	Push	B
	Push	D	;Save value being expo'd
	Call	Mul2
	Pop	D
	Pop	B
	Jmp	ExpLoop
BadExp: Push	d
	lxi	h,ExpMess
	call	Wstr
	Pop	h
	call	Wint
	Jmp	Err$Exit
ExpMess:db	45,'** Cannot Exponentiate by a negative value = '

	;Library Routine (sort of)
istr:   mvi	a,01h  ;put 1 for true in A
	ret
isfa:	xra	a	;put 0 for false in A
	ret

	;Compare Bytes for equality
	;*** Entry Point ***
eq1:	cmp	b
	jz	istr
	xra	a	;put 0 for false in A
	ret

	;Compare Bytes for inequality
	;*** Entry Point ***
neq1:	cmp	b
	jnz	istr
	xra	a
	ret

	;Compare Bytes for A > B
	;*** Entry Point ***
gt1:	cmp	b
	jc	isfa
	jnz	istr
	xra	a
	ret

	;Compare Bytes for A >= B
	;*** Entry Point ***
ge1:	cmp	b
	jnc	istr
	xra	a
	ret

	;Compare bytes for A <= B
	;*** Entry Point ***
le1:	cmp	b
	jc	istr
	jz	istr
	xra	a
	ret

	;Compare bytes for A < B
	;*** Entry Point ***
lt1:	cmp	b
	jc	istr
	xra	a
	ret

	;Compare words for HL = DE
	;*** Entry Point ***
eq2:	mov	a,e
	sub	l
	jnz	isfa	;Not equal
	mov	a,d
	sbb	h
	jz	istr	;Equal
	xra	a
	ret

	;Compare words for HL /= DE
	;*** Entry Point ***
neq2:	mov	a,e
	sub	l
	jnz	istr
	mov	a,d
	sbb	h
	jnz	istr
	xra	a
	ret
	
	;Compare words for HL > DE
	;*** Entry Point ***
gt2:	mov	a,h
	xra	d
	jm	geq	;Signs Different?
	mov	a,e
	sub	l
	mov	a,d
	sbb	h
	jc	istr	;Simulated subtract
	xra	a	;False
	ret
geq:	ana	h	;HL positive?
	jp	istr
	xra	a	;False
	ret

	;Compare words for HL >= DE
	;*** Entry Point ***
ge2:	mov	a,h
	xra	d
	jm	geq	;Signs Different? Use same routine as last
	mov	a,l
	sub	e
	mov	a,h
	sbb	d	;Simulated subtract
	jp	istr
	xra	a	;False
	ret

	;Compare words for HL <= DE
	;*** Entry Point ***
le2:	xchg
	jmp	ge2

	;Compare words for HL < DE
	;*** Entry Point ***
lt2:	xchg
	jmp	gt2

	;---------------------------------------
	;---- Comparision tests for strings ----
	;---------------------------------------

	;Compare the strings pointed at by DE and HL for equality
	;*** Entry Point ***
Seq:	ldax	d	;get D's length byte
	cmp	m	;compare H's to it
	jnz	isfa	;Not equal if length's are different
	mov	b,a
	inr	b
Seqloop:dcr	b
	jz	istr	;If the length is down to zero, then the strings
			; are equal
	inx	d
	inx	h	;Now look at the next bytes
	ldax	d	;Get D's char
	cmp	m	;Compare H's to it
	jz	SeqLoop	;Don't know yet, do it again
	xra	a	;Return False if characters are different
	ret

	;Compare the strings pointed at by DE and HL for inequality
	;*** Entry Point ***
SNeq:	Call	Seq	;Equality Test
	sui	2
	cma		;And negate
	ret
	
	;Compare the strings pointed at by DE and HL
	;Return 0 if equal, 1 if HL > DE, -1 (255) otherwise
StrCmp: ldax	d
	cmp	m
	jc	strcmp2
	jz	strcmp3
	;If strings equal, return value stored in C (which is longer)
	mvi	c,255	;HL is shorter
	mov	b,m	;Get the length of the shorter string
	jmp	strcmp4
strcmp2:mvi	c,1	;HL is longer
	mov	b,a	;Get the length of the shorter string
	jmp	strcmp4
strcmp3:mvi	c,0	;Same length
	mov	b,a	;Get the length of the strings
strcmp4:inr	b	;Back up count
strloop:dcr	b	;Decrease count
	jz	strdone ;Done (Strings equal to end of shorter one) if cnt = 0
	inx	h
	inx	d	;Bump pointers
	ldax	d
	cmp	m
	jc	strdone2;HL > DE
	jz	strloop	;Equal so far, go around again
	mvi	a,255	;HL < DE
	ret
strdone2: mvi	a,1	;HL > DE
	ret
strdone: mov	a,c	;Get the value in C (which is longer)
	ret		;and return it
	
	;Compare the strings pointed at by DE and HL for HL < DE
	;*** Entry Point ***
SLt:	Call	StrCmp
	cpi	255	;LT if A=255
	jz	istr
	xra	a	;Return False
	ret

	;Compare the strings pointed at by DE and HL for HL <= DE
	;*** Entry Point ***
SLe:	Call	StrCmp
	cpi	1	;GT if A=1
	jz	isfa
	mvi	a,1
	ret		;Return true

	;Compare the strings pointed at by DE and HL for HL > DE
	;*** Entry Point ***
SGt:	Call	StrCmp
	cpi	1	;GT if A=1
	jz	istr
	xra	a	;Return False
	ret

	;Compare the strings pointed at by DE and HL for HL >= DE
	;*** Entry Point ***
SGe:	Call	StrCmp
	cpi	255	;LT if A=255
	jz	isfa
	mvi	a,1	;Return true
	ret

	;String Assignment
	;Source - HL, Dest - DE, Max Dest Length - Param
	;Kills All;
	;*** Entry Point ***
Sassign: xthl		;Get Length of Destination variable
	mov	c,m
	inx	h
	xthl
	mov	a,m	;Get length of source string
	cmp	c
	jc	StrOK	;String will fit
	jz	StrOK	;String will fit (exactly)
	Push	psw	;Save string length
	Lxi	H,Str12 ;String is too long
	call	wstr
	Pop	psw
	mvi	h,0
	mov	l,a	;Make an integer out of the length
	call	wint
	jmp	Err$Exit
Str12:  db	42,'** String Too Long for Variable, Length = '
StrOK:	mvi	b,0
	mov	c,a	;Move string length + 1 characters from HL to DE
	inx	b	;Just in case the length is 255 (FF hex) (not Inr C)
	jmp	BlkMove

	;Test string bounds to see if indexed character exists
	;Kills BC & A
	;HL - index value; DE - String address; String Var Length - Param
Str$Bound:
	xthl
	mov	c,m
	inx	h	;Get string variable length
	xthl
	xra	a	;Clear A
	cmp	h	;Is the index between 0 and 255?
	jnz	rng$err	;Range error handler
	mov	a,c	;Is the index in the variable?
	cmp	l
	jc	rng$err	;Range error handler
	ldax	d	;Get the string's length
	cmp	l
	rnc		;No error - string is long enough
	Push	h
	Push	psw
	Lxi	h,str13
	Call	wstr
	Call	wcrlf
	Lxi	h,str14
	Call	wstr
	pop	psw	;Get string length
	mvi	h,0
	mov	l,a
	Call	wint	;And print it
	Lxi	h,str15
	Call	wstr
	pop	h	;Get index in error
	Call	wint	;And print it
	jmp	Err$Exit
Str13:	db	57,'** Attempt to Access a Character outside of String Bounds'
Str14:	db	24,'Current String Length = '
Str15:	db	20,'  Character Index = '
Rng$err:push	h
	jmp	r2err	;In the range checks

	;String Concat
	;**** Entry Point ****
	;The address of the left hand string is in HL, and the address
	;of the right hand string is in DE.  The address of the returned
	;string (which is allocated on the heap by Func$Ret) is in HL
	;upon return
Concat: ldax	d	;Get the string length (of string two)
	add	m	;Add the length of the second string
	jc	conerr	;String is longer than 256 characters
	push	d	;Save address of string2
	push	h
	push	psw	;Save the good registers
	;Get the return slot - A bytes long
	mov	e,a
	mvi	d,0	;Get the size to allocate into DE
	inx	d	;Add room for length byte
	call	Cat$Entry ;Concat entry into Func$Ret to allocate the block
	;Store the length byte
	pop	psw
	push	h	;Save the start address
	mov	m,a
	inx	h
	xchg		;New string write address in DE
	pop	h	;Get address of result
	xthl		;Get address of first string, and save result
	mov	b,m	;Get the length byte of the first string
	inx	h
	inr	b
CLoop:	dcr	b	;Next character
	jz	CStr2	;Done copying these chars
	mov	a,m
	stax	d
	inx	h
	inx	d
	Jmp	Cloop
CStr2:	pop	H	;Get address of result
	xthl		;Get addres of the second string, and save result
	mov	b,m	;Get the length byte
	inx	h
	inr	b
Cloop2:	dcr	b	;Next char
	jz	CDone
	mov	a,m
	stax	d
	inx	h
	inx	d
	jmp	Cloop2
Cdone:	pop	h	;Get result address
	ret
Conerr: lxi	h,Str16
	call	wstr
	jmp	Err$Exit
Str16:	db	26,'Strings too long to Concat'

	;----------------------------------------------
	;---- Range Tests and Membership Operators ----
	;----------------------------------------------

	;Test the Value in A for Inrange
	;The range is at the address in HL
Trange1: push	psw	;Save A for later
	mov	b,m	;load b - Low range
	call	ge1
	cpi	0
	jz	terr1	;error if False
	pop	b	;Get value again
	inx	h
	mov	a,m
	call	ge1
	ret		;Return the result of second test
Terr1:	pop	b	;Return the False already in A
	ret

	;Test the Value on top of the stack for Inrange
	;The range is at the address in HL, the value is on top of the stack
Trange2:mov	e,m
	inx	h
	mov	d,m	;Get the low value in the range
	inx	h
	mov	b,h	;Put current addr in BC
	mov	c,l
	pop	h
	call	ge2	;Ge2 does not destory DE or HL
	cpi	0
	rz		;Return if False
	ldax	b
	mov	e,a
	inx	b
	ldax	b
	mov	d,a	;Get High Value
	call	le2
	ret		;Return result of second test

	;Membership Ops Range Test for Bytes
	;Kills All - Returns Boolean in A
	;Args Follow Call dw - Offset; db - level
	;*** Entry Point ***
Member1:xthl
	mov	c,m
	inx	h
	mov	b,m
	inx	h
	mov	e,m
	inx	h
	xthl
	call	calcaddr
	jmp	Trange1

	;Membership Ops Range Test for Integers
	;Kills All - Returns Boolean in A
	;Args Follow Call dw - Offset; db - level
	;*** Entry Point ***
Member2:xthl
	mov	c,m
	inx	h
	mov	b,m
	inx	h
	mov	e,m
	inx	h
	xthl
	push	h	;TRange2 expects the value on the stack
	call	calcaddr;Get the address of the range
	jmp	Trange2

	;Membership Ops Static Range Test for Bytes
	;Kills All - Returns Boolean in A
	;Arg Follows Call - dw - Address
	;*** Entry Point ***
SMember1: xthl
	mov	e,m
	inx	h
	mov	d,m
	inx	h
	xthl
	xchg
	jmp	Trange1

	;Membership Ops Static Range Test for Integer
	;Kills All - Returns Boolean in A
	;Arg Follows Call - dw - Address of Range
	;*** Entry Point ***
SMember2: xthl
	mov	e,m
	inx	h
	mov	d,m
	inx	h
	xthl
	push	h	;Put the value on the stack
	xchg
	jmp	Trange2

	;Test a range for no members
	;Kills All - Returns Boolean in A
	;Args Follow Call dw - Offset; db - level
	;*** Entry Point ***
	;SNullRng1 is for static ranges
SNullRng1:
	xthl
	mov	e,m
	inx	h
	mov	d,m
	inx	h
	xthl
	xchg
	jmp	Null1Test
NullRng1:
	xthl
	mov	c,m
	inx	h
	mov	b,m
	inx	h
	mov	e,m
	inx	h
	xthl		;Get the parameters
	;BC - Offset, E - Level
	call	calcaddr ;Get the address of the range
Null1Test:	;Address in HL
	mov	a,m	;Get the low value
	inx	h
	cmp	m	;Compare the high value
	jc	isfa
	jnz	istr
	xra	a
	ret		;Return false on =

	;Test a range for no members
	;Kills All - Returns Boolean in A
	;Args Follow Call dw - Offset; db - level
	;*** Entry Point ***
	;SNullRng2 is for static ranges
SNullRng2:
	xthl
	mov	e,m
	inx	h
	mov	d,m
	inx	h
	xthl
	xchg		;Get address in HL
	Jmp	Null2Test
NullRng2:
	xthl
	mov	c,m
	inx	h
	mov	b,m
	inx	h
	mov	e,m
	inx	h
	xthl		;Get the parameters
	call	calcaddr ;Get the address of the range
Null2Test:	;Address in HL
	mov	e,m
	inx	h
	mov	d,m	;Get lower word
	inx	h
	inx	h	;Get high byte of high word
	mov	a,m
	xra	d
	jm	Null2a	;Signs different?
	dcx	h
	mov	a,m
	sub	e	;Simulated subtract
	inx	h	;Does not effect the flags
	mov	a,m
	sbb	d		
	jc	istr
	xra	a	;Return False otherwise
	ret
Null2a: ana	d	;DE (low) positive?
	jp	istr
	xra	a
	ret		;Return False is high is positive

	;----------------------------
	;---- JANUS Program Exit ----
	;----------------------------

	;Halt program
	;*** Entry Point ***
	;This entry point is provided in case some actions need to be performed
	;on a program stop.  In a customized, ROM based environment, it might
	;be necessary to turn certain devices off on a Halt, or simply to start
	;the program over in a dedicated controller.
Halt:	jmp	0000h	;Jump to CP/M to stop

	;-------------------------------------------
	;---- Procedure Entry and Exit Routines ----
	;---- (Set up of Stack)			----
	;-------------------------------------------

	;	|    Activation Record i-1		|
	;	|					| <-- Disp_Val[i-1]
	;	|---------------------------------------|
	;	|					|
	;	|  In Progress Expressions (optional)	|
	;	|					|
	;	|---------------------------------------|
	;	|					|
	;	|  Parameters (optional)		|
	;	|					|
	;	|---------------------------------------|
	;	|  Return Address (Word)		|
	;	|---------------------------------------|
	;	|  Old Display Pointer (Word)		|
	;	|---------------------------------------|
	;	|					|
	;	|					|
	;	|  Activation Record for i		|
	;	|					|
	;	|					|
	;	|---------------------------------------| <--  Disp_Val[i]
	;	| Dynamic Chain Pointer = Disp_Val[i-1]	|
	;	|---------------------------------------|
	;	| Line Number of Proc/Func Call		|
	;	|---------------------------------------|
	;	| Old Return End			|
	;	|---------------------------------------|
	;	| Proc/Func Name Pointer (Word)		|
	;	| Also Exception Handler Pointer	|
	;	|---------------------------------------| <-- SP

	;Initialize of Procedure (Proc Entry)
	;SP is also in HL upon Entry
	;*** Entry Point ***
ProcInit: xchg
	lhld	PchainPtr	;Get the chain address of the last proc
	xthl		;Get the return address off the stack,
			;and put the chain address on the stack
	xchg
	shld	PchainPtr ;Save Old Sp as current chain Pointer
	lhld	LineNo	;Save line number of call
	push	h
	lhld	RetEnd	;Save old Return End
	push	h
	lhld	RetList
	shld	RetEnd
	push	d	;Save return address
	jmp	StkOver	;Check for stack overflow

	;Finalize Proc
	;Kills DE and HL
	;*** Entry Point ***
ProcFin: pop	h	;Get return address
	xchg
	pop	h	;Junk proc name ptr
	pop	h	;Get Old Return Chain End
	shld	RetEnd	;And Restore it
	pop	h	;Get Line Number of Call
	shld	LineNo	;Restore LineNo
	pop	h
	shld	PchainPtr ;Restore PchainPtr
	xchg
	pchl		;Return (Addr is in HL)

	;-------------------------------------------------------
	;---- Variable Activation Record Accessing Routines ----
	;-------------------------------------------------------

	;Calc. stack addr
	;Level-E  Off-BC
	;Kills DE and HL
calcaddr: lxi	h,dispstart
	mvi	d,0
	dad	d
	dad	d	;now have display reg. addr
	mov	e,m	;lower order byte
	inx	h
	mov	d,m	;upper order byte
	xchg		;put addr of act. reg in HL
	dad	b	;address of whatever
	ret

	;get a word from activation record
	;Returns value in HL
	;Kills all
	;args follow call- dw offset  db level
	;*** Entry Point ***
getact2: xthl
	mov	c,m
	inx	h
	mov	b,m	;offset
	inx	h
	mov	e,m	;level
	inx	h
	xthl
	call	calcaddr
	mov	e,m	;low byte
	inx	h
	mov	d,m	;high byte
	xchg
	ret

	;put the word in HL into act. rec.
	;Kills all but HL
	;args follow call - dw offset  db level
	;*** Entry Point ***
putact2:xthl
	mov	c,m
	inx	h
	mov	b,m	;offset
	inx	h
	mov	e,m	;level
	inx	h
	xthl
	push	h	;save value
	call	calcaddr
	pop	d	;put value into reg
	mov	m,e	;put low byte
	inx	h
	mov	m,d	;put high byte
	xchg		;restore the HL register
	ret

	;Returns value in A
	;Kills all
	;args follow call - dw offset  db level
	;*** Entry Point ***
getact1:xthl
	mov	c,m
	inx	h
	mov	b,m	;offset
	inx	h
	mov	e,m	;level
	inx	h
	xthl
	call	calcaddr
	mov	a,m	;get data
	ret

	;put the byte in A into act. rec.
	;Kills all but A
	;args follow call - dw offset  db level
	;*** Entry Point ***
putact1:xthl
	mov	c,m
	inx	h
	mov	b,m	;offset
	inx	h
	mov	e,m	;level
	inx	h
	xthl
	call	calcaddr
	mov	m,a	;put byte
	ret

	;Get the address of the activation record object into HL
	;parameters follow the call
	;Kills all
	;*** Entry Point ***
getaddr:xthl
	mov	c,m
	inx	h
	mov	b,m	;offset
	inx	h
	mov	e,m	;level
	inx	h
	xthl
	call	calcaddr
	ret		;address is now in HL

	;Block Move
	;Count - BC Dest - DE Source - HL
	;Kills All
	;Same as Z80 inst LDIR
	;*** Entry Point ***
BlkMove: mov	a,m
	stax	d	;Move a byte
	inx	h
	inx	d
	dcx	b
	mov	a,c
	ora	b	;Is count zero?
	jnz	BlkMove
	ret

	;Block Comparision
	;Count - BC Dest - DE Source - HL
	;Returns True or False in the A register
	;Kills All
	;*** Entry Point ***
BlkCmp: ldax	d
	cmp	m
	jnz	bfalse
	inx	h
	inx	d
	dcx	b
	mov	a,c
	ora	b	;Is count zero?
	jnz	BlkCmp
	mvi	a,01H	;Load True
	ret
Bfalse: xra	a
	ret

	;-----------------------------------
	;----	Access Type Allocators	----
	;-----------------------------------

	;Allocate space for a access object, and check for heap overflow
	;Returns the new pointer in HL
	;Kills All
New$Ptr:xthl
	mov	c,m
	inx	h
	mov	b,m	;Get the number of characters to allocate
	inx	h
	xthl
Fun$All:;An Entry for Func$Ret the blocks
	lhld	Heap$Ptr
	mov	d,h!mov	e,l	;Copy the HL reg into DE
	dad	b
	shld	Heap$Ptr
	mov	a,h		;Save high byte
	lxi	h,0		;Clear HL
	dad	sp		;Get the Stack Pointer
	xchg			;Get the return value into HL
	cmp	d		;Compare the High Bytes of the SP and HP
	rc			;Alright if Carry
	lxi	h,Str11
	call	wstr	;'Heap Overflow'
	jmp	Err$Exit
Str11:	db	16,'** Heap Overflow'

	;-------------------------------------------
	;---- Return of large objects routines	----
	;---- These entries allocate and	----
	;---- release space on the return list, ----
	;---- used for returing objects larger	----
	;---- than 2 bytes.			----
	;-------------------------------------------

	;Allocate a block of param byes long for a return
	;Link it into the return list.
	;The result pointer is in HL
	;Kills A and HL
	;**** Entry Point ****
	;The format of a return block is:
	; | Size (2 Bytes) | <- Address in RetList
	; |----------------|
	; | Next Blk (2 B) |
	; |----------------|
	; | Return Data    | <- Address returned to user
Func$Ret: Xchg		;Save the value in DE
	Xthl
	Mov	e,m	;Get Parameter
	Inx	h
	Mov	d,m
	Inx	h
	Xthl		;Put the return value back on the stack
Cat$Entry: ;Entry for concat
	Push B!Push H	;Save BC and DE, in case they hold good information
			;(DE's value is in HL)
	Mov b,d!Mov c,e	;Get the number of bytes to allocate into BC
	Inx	b	;Allocate 4 Extra Bytes (for system use)
	Inx	b
	Inx	b
	Inx	b
	Push	b	;Save the number of bytes allocated
	Call	Fun$All	;A special entry in Allocate just for this purpose
	Pop	b	;Get the number of bytes back
	Xchg
	Lhld	RetList	;Get the old Return Chain Address
	Xchg
	Shld	RetList	;Set the Head of the return list to the new pointer
	mov	m,c	;Store the size and old pointer into the block
	inx	h	;and return a pointer 4 greater than the one
	mov	m,b	;returned by New$Ptr
	inx	h
	mov	m,e
	inx	h
	mov	m,d
	inx	h
	Pop D!Pop B	;Restore the registers
	Ret

	;Free the blocks on the Return List.
	;Kills All
	;**** Entry Point ****
Func$Release:
	;Loop
	;    If RetList = RetEnd Then
	;	Return;
	;    Elsif Heap$Ptr = RetList + RetList.Size Then
	;	Heap$Ptr := RetList;
	;	RetList := RetList.ptr;
	;    Else
	;	temp := RetList;
	;	RetList := RetList.ptr;
	;	Dispose(temp);
	;    End If;
	;End Loop;
	Lhld	RetEnd
	Xchg		;Test for RetEnd = RetList
	Lhld	RetList
	mov	a,h
	cmp	d
	jnz	Func$St
	mov	a,l
	cmp	e
	rz		;Done if Equal
	;Get RetList.Size
Func$St: mov	e,m
	inx	h
	mov	d,m
	dcx	h
	dad	d	;RetList + RetList.size = HL
	xchg
	lhld	Heap$Ptr
	;Now compare DE to HL
	mov	a,h
	cmp	d
	jnz	NotTop
	mov	a,l
	cmp	e
	jnz	NotTop
	;Heap = ret + ret.size
	;	Heap$Ptr := RetList;
	;	RetList := RetList.ptr;
	Lhld	RetList
	Shld	Heap$Ptr	;Pull the Heap$Ptr back
	Inx	H!Inx	H	;Get the .ptr field
	mov	e,m
	inx	h
	mov	d,m
	xchg			;Get RetList.Ptr into HL
	Shld	RetList
	Jmp	Func$Release	;And do it all again
NotTop:	;Block is not at the top of the Heap
	;Since Dispose is not implemented, just throw the blocks away
	;This can only happen in expressions like
	;aproc(New Rec,"acd" & "etuiw");
	lxi	h,0	;Put Null into RetList
	Shld	RetList
	Ret


	;------------------------------------------------
	;----         Console I/O Routines           ----
	;---- Includes Conversion for Standard Types ----
	;---- Many of these routines are used only   ----
	;---- internally by the library.	     ----
	;------------------------------------------------

	;Writes Char in A
	;Kills All
Writech: mov	e,a
	mvi	c,2
	call	0005h	;Call Sys
	ret

	;Write String to Console
	;The address of the string is in HL
	;Kills All
	;This procedure is maintained only for error message writing
Wstr:	lxi	d,Output	;Set the file to standard output
	jmp	Put$Str		;Put$Str will write the string (and return)

	;Write Integer (Wint) will be found in Get/Put section

	;Write Cr-Lf to console
	;Kills All
	;This procedure is maintained only for error message writing
Wcrlf:	mvi	e,13
	mvi	c,2
	call	0005h	;Call Sys
	mvi	e,10	;LF
	mvi	c,2
	call	0005h	;Call Sys
	ret

	;Reads a char into A
	;Kills All
Readch: mvi	c,1
	call	0005h	;Call Sys
	ret

	;-------------------------------------------
	;---- Byte (binary) file I/O procedures ----
	;---- These are used by the text I/O    ----
	;---- procedures below them		----
	;-------------------------------------------

	;Get an object, BC bytes in length, from the file pointed at by DE,
	;and put it into the memory pointed at by HL
	;Kills All
	;*** Entry Point ***
Read:	xchg		;Get file in HL, ptr in DE
	jmp	RRead
ERead:	;Compiler entry	(Length in BC, Memory ptr in HL, File on stack)
	xchg		;Put ptr into DE
	pop	h	;Get return address
	xthl		;Put return address back on stack, getting file address
RRead:	;File - HL, ptr - DE, bytes - BC
	inx	h
	mov	a,m	;Get the file mode
	dcx	h
	ani	01H	;First bit indicates read access
	jz	mode$err2;No access
	mov	a,m	;Get the file type
	cpi	0
	jz	Rdisk
	;Don't need (?) the file anymore if it is a device
	push	b	;Save the byte count
	push	d	;Save object's address
	mvi d,0! mov e,a ;Put the device code in DE
	mov h,d!mov l,e	;Copy the code
	dad	h
	dad	d	;And multiply it by 3
	lxi	d,Rtab-3;Table starts at one
	dad	d
	xchg		;Put it back in DE (Jump table address)
	pop	h	;Put the object's address in HL
Rloop5: pop	b	;Get the cnt off the stack
	mov	a,c
	ora	b
	rz		;Done when byte count = 0
	dcx	b
	push	b
	push	h
	push	d
	xchg		;Get Jump Address into HL
	pchl		;Jump to device handler
Rtab:	jmp	Rcon	;1
	jmp	Rrdr	;2
	jmp	Mode$Err;3 (can't read from the punch)
	jmp	Mode$Err;4 (can't read fron the printer)
	jmp	Rkbd	;5
	;Read from console (CON:) device
Rcon:	mvi	c,1	;CP/M opcode
	call	0005	;Call CP/M
	pop	d
	pop	h
	mov	m,a	;Store the char away
	inx	h
	jmp	Rloop5	;Go around again
	;Read from the Reader (RDR:) device
Rrdr:	mvi	c,3	;CP/M opcode
	call	0005	;Call CP/M
	pop	d
	pop	h
	mov	m,a	;Store the byte away
	inx	h
	jmp	Rloop5	;Go around again
Rkbd:	;Must go around CP/M to do this - may not work on all systems
	;Note: some CP/M compatible systems have an entry point to do
	;this.  It should be used instead of the following mess.
	lhld	0001	;Get the base address of the BIOS section
	lxi	d,0006	;Add 6 to get CONIN entry
	dad	d	;Got address of CONIN.  Note: This operation is done
			;this way rather than by simply replacing the lower
			;byte by 09H (as in most compilers) so as be compatible
			;with those CP/M like systems which do not configure
			;the BIOS on a page boundary.  (I.e. IMDOS 2.05)
	lxi	d,$+5	;Make up the return address
;*** Obviously, $ does not work like it is documented.  It is the address of
;    of the beginning of the lxi instruction
	push	d	;and put it on the stack
	pchl		;Go to CONIN, should return here
	pop	d
	pop	h	;Note that return address (above) was removed from the
			;stack by CONIN
	mov	m,a	;Store the byte away
	inx	h
	jmp	Rloop5	;Go around again
Rdisk:  ;File address - HL, Value Address - DE, Bytes to transfer - BC
	push d!push b	;Save Val. addr and length
	;End of File?
	push	h	;Duplicate File address
	lxi	d,165	;Get EOF flag (in file)
	dad	d
	mov	a,m
	cpi	0
	jnz	RdEOF	;EOF no I/O done (Set IOresult when this can be done)
	pop	h
	push	h	;Save file address, but will use copy in HL
	lxi	d,35	;Buffer offset
	dad	d	;Add offset
	xchg
	mvi	c,26	;Set buffer address
	call	0005
	pop	h	;Duplicate file address again
	push	h
	lxi	d,163	;Get buff ptr offset
	dad	d
	mov	a,m	;Get the buffer pointer
	pop	h	;file addr
	pop	b	;Bytes to transfer
	pop	d	;Place to move
Rloop9:	;Here A=buf pointer; BC=Byte count; DE=Location; HL=File address
	;Buf pointer points at the last byte read in the file buffer
	push	psw	;Save buf ptr
	mov	a,b
	ora	c	;Is count 0?
	jz	Rdone	;Then done
	pop	psw
	cpi	127	;Is buffer empty? (read all bytes in it)
	jz	Rsect
	inr	a	;on to next byte
GetByte:push	psw
	adi	35	;Add sector buffer offset
	push	h
	push	d	;Save address of object and file
	mov	e,a
	mvi	d,0	;Set up buffer offset
	dad	d
	pop	d	;Get object address back
	mov	a,m	;Get byte from buffer
	stax	d	;Put it into the output variable
	pop	h	;Get saved values back
	pop	psw
	dcx	b
	inx	d	;bump pointers
	jmp	Rloop9	;and do it all again
Rsect:	;Read a sector (same register values as upon entrance to Rloop9)
	;Read sector buffer address already set
	push b!push d!push h	;Save values (CP/M calls clobber all)
	xchg		;Get file address in DE
	inx d!inx d	;Get FCB address (file address + 2)
	mvi	c,20	;Read opcode
	call	0005
	cpi	1	;Test for EOF error
	jz	Reof
	pop h!pop d!pop b
	xra	a	;Clear buffer point (start at zero)
	jmp	GetByte
Reof:	;End of File Error
	Pop H!pop d!pop b ;Get values off of the stack
	lxi	d,165
	dad	d
	mov	m,a	;Set EOF flag
			;A contains 1, since that's how we got here
	ret
RdEOF:	;Already at EOF
	pop h!pop d!pop b ;Clear the stack
	;Set IOresult in the future
	ret
Rdone:	;Normal Disk Read Exit
	;Restore buffer pointer in FCB
	pop	psw
	lxi	d,163
	dad	d
	mov	m,a	;Put A into the pointer
	ret


	;Put the object pointed at by HL into the file pointed at by DE.
	;The number of bytes to transfer is in BC
	;Kills All
	;*** Entry Point ***
Write:	xchg		;Get the file address in HL, and the ptr into DE
	jmp	WWrite
EWrite: ;Compiler Entry Point
	xchg		;Put ptr into DE
	pop	h	;Get return addr
	xthl		;Get the file address, put return addr back
WWrite:	;File - HL, Ptr - DE, Bytes - BC
	inx	h
	mov	a,m	;Get the file mode
	dcx	h
	ani	02H	;Second bit indicates write access
	jz	mode$err2;No access
	mov	a,m	;Get the file type
	cpi	0
	jz	Wdisk
	;Don't need the file anymore if it is a device
	push	b	;Save the byte count
	push	d	;Save object's address
	mvi d,0! mov e,a ;Put the device code in DE
	mov h,d!mov l,e	;Copy the code
	dad	h
	dad	d	;And multiply it by 3
	lxi	d,Wtab-3;Table starts at one
	dad	d	;Got Jump Offset
	xchg		;Put it back in DE
Wloop5: pop	h	;Get the address off of the stack
	pop	b	;Get the cnt off the stack
	mov	a,c
	ora	b
	rz		;Done when byte count = 0
	dcx	b
	push	b
	mov	a,m	;Put value to write in A
	inx	h
	push	h
	push	d
	xchg		;Get jump offset into HL
	pchl		;Jump to device handler
Wtab:	jmp	wcon	;1
	jmp	Mode$Err;2 (can't write to the reader)
	jmp	wpun	;3
	jmp	wlst	;4
	jmp	Mode$Err;5 (can't write to the keyboard)
	;Write to console (CON:) device
Wcon:	mov	e,a	;Put value in E
	mvi	c,2	;CP/M opcode
	call	0005	;Call CP/M
	pop	d
	jmp	wloop5	;Go around again
	;Write to punch (PUN:) device
Wpun:	mov	e,a	;Put value in E
	mvi	c,4	;CP/M opcode
	call	0005	;Call CP/M
	pop	d
	jmp	wloop5	;Go around again
Wlst:	mov	e,a	;Put value in E
	mvi	c,5	;CP/M opcode
	call	0005	;Call CP/M
	pop	d
	jmp	wloop5	;Go around again
	;Disk File Output
Wdisk:  ;File address - HL, Value Address - DE, Bytes to transfer - BC
	push d!push b	;Save Val. addr and length
	push	h	;Save file address, but will use copy in HL
	lxi	d,35	;Buffer offset
	dad	d	;Add offset
	xchg
	mvi	c,26	;Set buffer address
	call	0005
	pop	h	;Duplicate file address again
	push	h
	lxi	d,163	;Get buff ptr offset
	dad	d
	mov	a,m	;Get the buffer pointer
	pop	h	;file addr
	pop	b	;Bytes to transfer
	pop	d	;Place to move
Wloop9:	;Here A=buf pointer; BC=Byte count; DE=Location; HL=File address
	;Buf ptr points at the first empty byte in the file buffer
	push	psw	;Save buf ptr
	mov	a,b
	ora	c	;Is count 0?
	jz	Wdone	;Then done
	pop	psw	;Duplicate buff ptr
	push	psw
	adi	35	;Add sector buffer offset
	push	h
	push	d	;Save address of object and file
	mov	e,a
	mvi	d,0	;Set up buffer offset
	dad	d
	pop	d	;Get object address back
	ldax	d	;Get byte from parameter
	mov	m,a	;Put it into the buffer
	pop	h	;Get saved values back
	pop	psw
	dcx	b
	inx	d	;bump pointers
	inr	a	;inc buf index
	cpi	128	;Is buffer full?
	jnz	Wloop9	;do it all again if sector not full
Wsect:	;Write a sector (same register values as upon entrance to Wloop9)
	;Write sector buffer address already set
	push b!push d!push h	;Save values (CP/M calls clobber all)
	xchg		;Get file address in DE
	inx d!inx d	;Get FCB address (file address + 2)
	mvi	c,21	;Write opcode
	call	0005
	cpi	0	;Test for Disk/Directory Full error
	jnz	Werr
	pop h!pop d!pop b
	xra	a	;Clear buffer point (start at zero)
	jmp	Wloop9	;do it all again
Werr:	;Disk/Directory Full Error
	Pop H!pop d!pop b ;Get values off of the stack
	lxi	d,165
	dad	d
	mvi	m,1	;Set EOF flag (means Disk/Dir Full Error on write)
	;Should set IOresult instead
	ret
Wdone:	;Normal Disk Write Exit
	;Restore buffer pointer in FCB
	pop	psw
	lxi	d,163
	dad	d
	mov	m,a	;Put A into the pointer
	ret

	;Value write - write the value in HL or A to the file on the stack
	;File in DE, Bytes to transfer in BC
	;Kills All except Data Value
	;*** Entry Point ***
EVWrite:;Compiler entry point (File on stack)
	xchg
	pop	h	;Get ret addr
	xthl		;Put ret addr, get file addr
	xchg
VWrite: push	psw	;Save value in A, if any
	mvi	a,1
	cmp	c	;Byte or Word?
	jz	wbyte
	pop	psw	;Remove value from stack
	push	h	;Word - Put it on the stack
	lxi	h,0
	dad	sp
	call	Write	;Got its address in HL now
	pop	h	;Get it off of the stack (Value has been written now)
	ret
Wbyte:	lxi	h,1	;Offset SP by one (Value already on stack)
	dad	sp
	call	Write	;Got the byte's address in HL now
	pop	psw	;Get it off the stack
	ret

	;Illegal mode for file
Mode$Err: lxi	h,Mstr
	call	wstr
	Jmp	err$exit
Mstr:	db	18,'File access denied'
	;Have file name
Mode$Err2: push	h
	lxi	h,Mstr2
	call	wstr
	pop	h
	call	file$name
	call	wstr
	Jmp	err$exit
Mstr2:  db	21,'File access denied - '

	;Make a string out of the file name
	;File address is in HL, return the string address in HL
	;*** Entry Point ***
File$Name: mov	a,m	;Get file type
	push	h
	mov	e,a
	mvi	d,0	;Make offset
	lxi	h,Ftab
	dad d!dad d!dad d ;Add offset three times
	pchl		;Go to it
Ftab:	jmp	fdisk	;0
	jmp	fcon	;1
	jmp	frdr	;2
	jmp	fpun	;3
	jmp	flst	;4
	jmp	fkbd	;5
Fkbd:	pop	h
	lxi	h,Nkbd
	ret
Flst:	pop	h
	lxi	h,NLst
	ret
Fpun:	pop	h
	lxi	h,Npun
	ret
Frdr:	pop	h
	lxi	h,Nrdr
	ret
Fcon:	pop	h
	lxi	h,Ncon
	ret
Fdisk:  pop	h
	inx	h
	inx	h	;Get FCB address
	lxi	d,Ndisk	;Output buffer address
	xchg
	ldax	d	;Get disk number
	inx	d
	cpi	0
	jz	nodisk
	adi	'@'	;Change to ASCII
	mvi	m,14	;Length of string
	inx	h
	mov	m,a	;Disk Name
	inx	h
	mvi	m,':'
	inx	h
	jmp	dname
nodisk:	mvi	m,12	;Length of string
	inx	h
dname:	mvi	b,8	;Load counter
dloop:  ldax	d
	mov	m,a
	inx	h
	inx	d
	dcr	b
	jnz	dloop	;Move next 8 chars into string
	mvi	m,'.'
	inx	h
	mvi	b,3	;Load counter
dloop2: ldax	d
	mov	m,a
	inx	h
	inx	d
	dcr	b
	jnz	dloop2
	lxi	h,Ndisk
	ret		;And thats all there is to it

Ncon:	db	4,'CON:'
Nrdr:	db	4,'RDR:'
Npun:	db	4,'PUN:'
Nlst:	db	4,'LST:'
Nkbd:	db	4,'KBD:'
Ndisk:	ds	20	;In data segment

	;------------------------------------
	;---- Get and Put Text I/O Calls ----
	;------------------------------------

	;Put the string in HL to the file in DE
	;Kills All
	;*** Entry Point ***
EPut$Str:;Compiler Entry Point (File on stack, string in HL)
	xchg
	pop	h
	xthl		;Get file address, put return address back
	xchg
Put$Str:mov	c,m	;Byte string length byte as length to transfer
	mvi	b,0
	inx	h
	jmp	Write	;Write the string (Write returns for Put$Str)

	;Write the integer in HL in decimal, with sign
	;File in DE; width in BC
	;Kills All
	;*** Entry Points ***
EPutInt: ;Entry from compiler
	pop	h	;Return address
	pop	d	;Value
	xthl		;File Address, put return address back on the stack
	xchg		;Get file in DE, address in HL
	jmp	PutInt
EPutIntW: ;Entry from compiler
	pop	h	;Return address
	pop	b	;Get width
	pop	d	;Get Value
	xthl		;Get File address, put return address back on the stack
	xchg		;Get file in DE, address in HL
	jmp	PutIntW
Wint:	;(For console write operations in the library [errors])
	Lxi	d,Output	;Set the output file
PutInt: Lxi	b,0		;Field Width is zero (expanded as needed)
PutIntW:	;Integer output routine
	mov	a,b	;Check if width is negative
	ora	a
	jp	PIskip
	mvi	b,0
	mvi	c,0	;Width is zero if it was negative
PIskip:	Push D!Push B	;Save file and width
	xra	a
	sta	Isign	;Sign is positive
	mov	a,h
	ora	a
	jp	wpos	;Sign is positive
	mvi	a,255
	sta	Isign	;Set sign flag
	call	negate2	;Make the value positive
wpos:	mov	a,h
	ora	l
	jz	wzero	;If the value is zero
	xchg
	lxi	h,bufend ;Right End of output buffer
	mvi	b,0	;Character Counter
Wiloop: push h!push b
	lxi	h,10	;Divide by 10
	xchg
	call	divide	;Quotient in DE, Remainder in HL
	mov	a,l
	adi	'0'	;Make a character out of the remainder
	pop b!pop h
	mov	m,a	;Put in the buffer
	inr	b
	dcx	h	;Count the number of characters to write
	mov	a,d
	ora	e
	jnz	Wiloop	;Stop if quotient is zero
	lda	Isign	;Get the sign
	cpi	0
	jz	WrtInt	;Do nothing if sign is positive
	mvi	m,'-'
	inr	b
	dcx	h
WrtInt: ;Character Count in B, Buffer Address in HL
	pop	d	;Get field width
	mov	a,b	;Put the char count into A
	pop	b	;Get the file address
	push	h	;Save Buffer Address
	mov h,b!mov l,c	;Get file address into HL
	xchg
	;File Address in DE, Field Width in HL, Char. Count in A
Wid$Loop:	;Generate the field width
	cmp	l	;Is the field width less than the width of the
			; output value?
	jnc	Width$Done
	push	psw	;Save char count
	push	d	;Save file address
	push	h	;Save current field width
	mvi	a,' '	;Write a blank to the file in HL
	lxi	b,1	;Write one byte
	call	VWrite	;Value Write
	pop	h
	pop	d
	pop	psw	;Restore registers
	dcx	h	;Decrease width count by one
	jmp	Wid$Loop ;Go around again
Width$Done:
	pop	h	;Get buffer address
	inx	h	;Make it point at the first character to write
	mov	c,a	;Put character count into BC
	mvi	b,0
	jmp	Write	;Write it, and let write return
WZero:	;Write a single 0 for zero
	lxi	h,Bufend ;Get right end of buffer
	mvi	b,1	;Load character count (1)
	mvi	m,'0'	;Put the character zero into the buffer
	dcx	h
	jmp	WrtInt	;Remember to set up the field width
	;DSEG when implemented
	ds	10	;Character Buffer
Bufend: ds	1
Isign:  ds	1	;Integer Sign

	;Write the integer in HL in Hex, File in DE
	;Kills All
	;*** Entry Point ***
PutHex:	mov	a,h	;High nybble
	ani	0F0h	;Mask it off
	rrc!rrc!rrc!rrc	;get in the lower bits
	call	Putch	;Write hex char
	mov	a,h	;Low nybble
	ani	0fh
	call	Putch
	mov	a,l
	ani	0f0h
	rrc!rrc!rrc!rrc
	call	Putch
	mov	a,l
	ani	0fh
	;Fall thru to Putch, then return from there
	;Write the Hex char for value in A (0-15)
	;Trick code from 8080A assembly programming, pg. 7-3
Putch:	adi	90h	;BCD add to hex digit
	daa		;9x if <10; 0x if >9 w/ Carry
	aci	40h	;Add w/Carry BCD - Bumps lower bits if >9 (Sets 10 = A)
	daa		;3x if <10; 4x+1 if >9  Wow-it works!!
	lxi	b,1	;Length to write
	push h!push d
	call	VWrite	;Have value write write this value out
	pop d!pop h
	ret

	;Get a text integer from the file on the stack,
	;and put in into the var. pointed at by HL
	;Kills All
	;*** Entry Point ***
IntSign:ds	1	;Sign of the result
GetInt: pop	d	;Return address
	pop	b	;File address
	push	d	;Put Return address on stack
	push	h	;Put var address on stack
	push	b	;Put file address on stack
SkipB:	xra	a
	sta	IntSign	;Sign Is Positive
	Call	Igetch	;Read a character
	;Skip leading spaces, tabs, commas, LFs, and CRs
	cpi	' '
	jz	SkipB ;Get another if it's a space
	cpi	09h
	jz	SkipB ;Get another if it's a tab
	cpi	','
	jz	SkipB ;Get another if it's a comma
	cpi	0Ah
	jz	SkipB ;Get another if it's a LF
	cpi	0Dh
	jz	SkipB ;Get another if it's a CR
	cpi	'+'
	jz	NextCh	;Sign - Read the next character
	cpi	'-'
	jnz	GetInit
	sta	IntSign ;Sign is negative
NextCh:	call	Igetch	;Get the next character
GetInit: lxi	h,0	;Result = 0
GetLoop: cpi	'0'
	jc	intdone
	cpi	'9'+1
	jnc	intdone
	lxi	d,10	;Multiply Result by 10
	push	psw	;Mul kills A
	call	Mul2
	pop	psw
	sui	'0'	;Make into a binary number
	mov	e,a
	mvi	d,0	;Clear upper byte
	dad	d
	Call	Igetch	;Get The next character
	jmp	GetLoop
IntDone: pop	d	;Get file address
	push	h	;Save value
	xchg		;Get file into HL
	call	RplcByte;Put byte back into file
	pop	h	;Get value
	lda	IntSign	;Integer read and translated
	cpi	0
	jz	SkipN
	call	negate2	;Value is negative
SkipN:  xchg		;Put value in HL
	pop	h	;Get Var. address
	mov	m,e	;Store value into var
	inx	h
	mov	m,d
	ret

	;Get at character into charbuf, and into A
CharBuf:ds	1	;Character just read from the file
Igetch:	pop	b	;Get return address
	pop	d	;Get file address
	push	d	;Shove these back onto the stack
	push	b
	push	h	;Save the value in HL
	lxi	b,1	;Get one byte
	lxi	h,CharBuf ;Var address
	Call	Read	;Get the byte
	pop	h	;Get the value in HL
	lda	CharBuf	;Get the character into A
	ret

	;Put the enumeration type
	;Kills All
	;Base of Table in HL
	;Enum Value in A
	;File in DE, Field Width in BC
	;*** Entry Point ***
EPutEnumW: ;Compiler entry Point
	   ;Table Lo in HL, rest on stack
	pop	d	;Return Address
	pop	b	;Field Width
	pop	psw	;Item to write
	xchg
	xthl		;Get file into HL, replace return address
	xchg
	Jmp	PutEnum
EPutEnum: ;Compiler entry point
	  ;Table Loc in HL, rest on stack
	pop	d	;Return Address
	pop	psw	;Item to write
	xchg
	xthl		;Get the file into HL, replace return address
	xchg
	lxi	b,0	;Set field width to 0
	;Value in A, Width in BC, File in DE ,Table in HL
PutEnum: push	b	;Save width
	push	d	;Save file
	mov	e,a
	mvi	d,0	;Find correct entry
	dad	d
	dad	d	;Address of word contains string address in HL
	mov	e,m
	inx	h	;Get String Offset
	mov	d,m
	xchg		;Address of string in HL
	pop	d	;Get the file address
	push	d	;And save it again
	mov	a,m	;Get string length
	push	psw	;And save it
	Call	Put$Str	;And write the string
	pop	psw
	pop	d
	pop	b
	;Have A-chars already written; BC - field width; DE - File
	;Trailing Blanks for enumerations with field width
PEnumLoop:
	cmp	c
	rnc		;Return when chars written >= field width
	push	psw
	push	b
	push	d
	lxi	b,1	;Write one character, the space
	mvi	a,' '
	Call	VWrite
	pop	d
	pop	b
	pop	psw
	inr	a	;One more character written
	jmp	PEnumLoop
	
	;Put an <CR> <LF> into the file pointed at by HL
	;Kills All
	;*** Entry Point ***
New$Line: xchg		;Put the file in DE for write
	lxi	b,2	;Object of length 2
	lxi	h,CrLf	;Address of object
	jmp	Write	;call write to write it (Write returns for New$Line)
CrLf:	db	13,10

	;Replace character into file (Backup)
	;Usually used to put back a look-ahead character
	;Used by GetInt and Skip_Line
	;File is in HL, Kills All
RplcByte: mov	a,m	;Get file type
	cpi	0
	rnz		;Cannot back up a device
	lxi	d,163	;Get the buffer pointer address
	dad	d
	mov	a,m
	dcr	a
	mov	m,a	;Back up the pointer
	ret

	;----------------------------------
	;----  Error Handling Routines ----
	;----------------------------------

	;Load the value following the call into the current Lineno location
	;Kills None
	;*** Entry Point ***
LnoCode:xthl		;Get Address of Data
	push	d	;Save the value of DE
	mov	e,m	;Get the data
	inx	h
	mov	d,m
	inx	h
	xchg
	shld	LineNo	;Store the line number in LineNo
	xchg
	pop	d
	xthl		;Restore Registers and Return Address
	ret

	;Checks for Stack Overflow
	;Kills All
StkOver:lda	Heap$Ptr + 1 ;Get the high order byte of the heap pointer
	lxi	h,0	;Clear HL
	dad	sp	;Get the Stack Pointer
	cmp	h	;Compare the High Bytes
	rc		;Alright if Carry
	lxi	h,Str5
	call	wstr	;'Recursion Stack Overflow'
	call	wcrlf
	lxi	h,Str6
	call	wstr	;'From Procedure/Function Call on Line Number'
	;Got an error, now fix up stack (We're in a proc entry)
	;to make it look like we're inside if a subprogram
	pop	h	;Junk the return address (An abort is coming up)
	pop	h	;Junk the old return chain address
	pop	h	;Get the Call line number
	call	wint
			;Call Walk$Back with the chain pointer on the stack
	jmp	Walk$Back ;Start in the walk_back loop of Err$Exit
Str5:	db	27,'** Recursion Stack Overflow'
Str6:	db	44,'From Procedure/Function Call on Line Number '

	;Error in source language exit
	;*** Entry Point ***
Sour$Err:lxi	h,Str7
	call	wstr	;'Error in Source Language'
	jmp	Err$Exit
Str7:	db	27,'** Error in Source Language'

	;Case Table Error
	;*** Entry Point ***
CaseErr:push	h
	lxi	h,Str8
	call	wstr	;'No limb for case value, pos of error value = '
	pop	h
	call	wint	;Write Integer
	jmp	err$exit
Str8:	db	48,'** No limb for case value, pos of error value = '

	;Null Pointer Test
	;*** Entry Point ***
	;The pointer is in HL.  Kills A.
Null$Ptr:
	mov	a,l
	ora	h
	rnz		;Pointer is not null if it does not equal 0
	lxi	h,Str10
	call	wstr	;'Attempt to reference thru Null pointer'
	jmp	err$exit
Str10:	db	41,'** Attempt to reference thru Null pointer'

	;Single Byte Range Test
	;Kills All except A (Never returns if error)
	;Args follow call - dw Offset; db level
	;*** Entry Point ***
Range1: xthl
	mov	c,m
	inx	h
	mov	b,m	;Offset
	inx	h
	mov	e,m	;Level
	inx	h
	xthl
	push	psw	;Save value to be tested
	call	calcaddr;Get the address of the range
	call	Trange1
	cpi	0	;Error if False
	jz	r1err
	pop	psw	;Restore value - It's alright
	ret
r1err:	lxi	h,str9
	call	wstr	;'Subscript or Subrange out of bounds'
	pop	psw	;Get value back
	mov	l,a
	mvi	h,0	;Make an integer out of the byte
	call	wint
	jmp	err$exit
Str9:	db	62,'** Subscript or Subrange Out of Bounds - Pos of Error Value = '

	;Single Byte Static Range Test
	;Kills All except A (Never returns if error)
	;Args follow call - dw Address of Range
	;*** Entry Point ***
SRange1: xthl
	mov	e,m
	inx	h
	mov	d,m	;Address
	inx	h
	xthl
	xchg
	push	psw	;Save value to be tested
	call	Trange1
	cpi	0
	jz	r1err
	pop	psw	;Restore value - It's alright
	ret

	;Word (Integer) Range Test
	;Kills All except HL (If no error - never returns if error)
	;Args follow call - dw Offset; db level
	;*** Entry Point ***
Range2: xthl
	mov	c,m
	inx	h
	mov	b,m	;Offset
	inx	h
	mov	e,m	;Level
	inx	h
	xthl
	push	h	;Save value to be tested
	call	calcaddr;Get the address of the range
	pop	d	;Get the value, (Into DE)
	push	d	;And push it back on the stack
	call	TTTrange2
	cpi	0
	jz	r2err
	pop	h	;Restore value - It is alright
	ret
r2err:	lxi	h,Str9	;Message is above, in Range1
	call	wstr	;'Subscript or Subrange Out of Bounds'
	pop	h	;Get value back
	call	wint	;Write out the error value
	jmp	err$exit
TTTrange2: ;Value in DE, Range Address in HL
	push	d	;Put the value on the stack for TRange2
	jmp	TRange2	;TRange2 will return to the call above

	;Word (Integer) Static Range Test
	;Kills All except HL (If no error - never returns if error)
	;Args follow call - dw Address of Range
	;*** Entry Point ***
SRange2: xthl
	mov	e,m
	inx	h
	mov	d,m	;Address
	inx	h
	xthl
	push	h	;Save value to be tested
	call	TTrange2
	cpi	0
	jz	r2err
	pop	h	;Restore value - It is alright
	ret
TTrange2: push	h
	xchg		;Set up for Trange2
	jmp	Trange2 ;Will return to the call above

	;Error Exit for crashes
	;Error message should be printed prior to entry
Err$Exit:call   Wcrlf
	lxi	h,Str1
	call	Wstr	;'On Line Number '
	lhld	LineNo
	call	Wint
	lhld	PchainPtr
	push	h	;Save chain pointer
Walk$Back: lxi	h,Str2
	Call	Wstr	;' In '
	pop	h
	dcx	h
	mov	d,m
	dcx	h
	mov	e,m
	push	d	;Get Chain Address and Save it
	dcx	h
	mov	d,m
	dcx	h
	mov	e,m
	push	d	;Get Line Number of Call and Save It
	dcx	h
	dcx	h	;Skip Over the RetEnd Pointer
	dcx	h
	mov	d,m
	dcx	h
	mov	e,m	;Get the location of the name
	xchg
	inx	h
	inx	h	;Skip the pointer at the exception handler
	call	Wstr	;Write the Proc. name
	call	Wcrlf
	pop	h	;Get the Line Number
	mov	a,h
	ora	l
	jz	halt	;Done if the line number is zero
	push	h	;Save line number
	lxi	h,Str3
	call	Wstr	;'Called from line number'
	pop	h
	call	Wint	;Write the line number
			;New chain address is still on the stack
	jmp	Walk$Back
Str1:	db	15,'On Line Number '
Str2:	db	4,' In '
Str3:	db	24,'Called from line number '

main$name: db	0,0	;{End of the walkback chain}
main:
length equ main - 100h
