	;Red (Version 1.5)
	ORG 100H
IFCB	EQU	5CH
IBUF	EQU	80H
	LHLD	0006H	;GET TOP OF MEM ADDR
	DCX	H
	DCX	H
	SPHL		;SET SP TO TOP OF MEM
	JMP START

	;COMPARE HL TO DE  (EFFECT = DE - HL)
CMPHLDE:MOV A,D!CMP H!RNZ!MOV A,E!CMP L!RET
	;COMPARE HL TO BC
CMPHLBC:MOV A,B!CMP H!RNZ!MOV A,C!CMP L!RET
	;Z-80 BLOCK MOVE
LDIR:	MOV A,M!STAX D
	INX H!INX D!DCX B
	MOV A,C
	ORA B
	JNZ LDIR
	RET
	;Z-80 BLOCK MOVE
LDDR:	MOV A,M!STAX D
	DCX H!DCX D!DCX B
	MOV A,C
 	ORA B
	JNZ LDDR
	RET
	;SUBTRACT BC FROM HL
SUBB:	PUSH	B
	MOV	A,B
	CMA
	MOV	B,A	;NEGATE BC
	MOV	A,C
	CMA
	MOV	C,A
	INX	B	;2-COMP
	DAD	B
	POP	B
	RET
	;Z80 Block Search
	;Increments Registers before returning, On True or False
	;Therefore, HL points one character beyond the desired character
CPIR:	MOV	E,A	;BLOCK SEARCH
CPIRL:	MOV	A,M
	INX H!DCX B
	CMP	E
	RZ
	MOV	A,B
	ORA	C
	JNZ	CPIRL
	INR	A	;SET Z FLAG OFF
	RET
;RED JANUS Version 1.5 (11/16/81)

	;Write out a CR-LF
crlf:	PUSH B!PUSH D
	MVI C,9!LXI D,crlf2!PUSH H!CALL 0005H!POP H	;Print this message
	POP D!POP B
	ret
crlf2:	db  13,10,'$'

;The RED text editor
;written by Randall Brukardt and Stephen Conn
;version 1.1 - Spring 1980
;for Computer Science 699 - Prof. Desautels
;version 1.2 - June 1980
;version 1.3 - July 1980  Print Spooling, and WP output
;version 1.4 - August 1980 Centering, and Formatting Blocks
;version 1.5 - October 1981 New control keys, and correct scrolling
;Last modified by RR Software, 11/16/81

;RED is a screen oriented text editor for serial terminals
;It runs under CP/M on any 8080/Z80 based system.
;This is the TeleVideo 912 Version.  Versions for other terminals may
;vary

FCB	EQU	5CH	;THE DEFAULT FILE CONTROL BUFFER
BUF	EQU	80H	;THE DEFAULT FILE DATA BUFFER
EOS	EQU	0	;THE END OF STRING MARKER
ESC	EQU	27	;ESCAPE CHAR.
	;TeleVideo 912 control chars
CLEAR:	DB	26,EOS,0	;CLEAR SCREEN = CTRL-Z
UP:	DB	11,EOS,0	;CURSOR UP = CTRL-K
DOWN:	DB	10,EOS,0	;CURSOR DOWN = CTRL-J
LEFT:	DB	08,EOS,0	;CURSOR LEFT = CTRL-H
RIGHT:	DB	12,EOS,0	;CURSOR RIGHT = CTRL-L
HOME:	DB	30,EOS,0	;HOME CURSOR = CTRL-~ (30)
SCDWN:	DB	05,00,0;ESC,'E',EOS	;INSERT LINE = ESC E
				;REVERSE LINE FEED Can be used if
				;It scrolls the terminal
CEOL:	DB	21,0,0;ESC,'T',EOS	;CLEAR TO END-OF-LINE = ESC T
NFILE:	DB	'NEW FILE',13,10,'$'
SIGNIN:	DB	'RED Version 1.5 - October 1981',13,10,'$'
SIGNIN2:DB	'TeleVideo 912 Version',13,10,'$'
CPLINE	EQU	80	;NO. OF CHARS PER LINE ON THE SCREEN
LPSCR	EQU	23	;NO. OF LINES PER SCREEN - 1

	;SUBROUTINE WRITECTRL - WRITES OUT A ONE OR TWO CHAR
	;CONTROL CHAR SEQUENCE
WRITECTRL: MOV	E,M	;GET CHAR OUTPUT
	INX	H
	MVI	A,EOS	;HAS THE END OF THE SEQUENCE BEEN REACHED?
	CMP	E
	RZ
	call writech	;OUTPUT CHAR
	JMP	WRITECTRL


	;READCHAR = SYSTEM READ CHAR COMMAND W/O CONSOLE ECHO
READCHAR: PUSH	H
	PUSH	D
	PUSH	B	;SAVE REGISTERS
loop44:	call	prtout	;print if not ready
	call ready
	jz	loop44
;I suggest that you remove the general case code below and replace it with
;something like CALL	0EA09h (The BIOS driver address).  This also goes
;for most of the CP/M system calls for device I/O below
	Lhld	0001	;Get the BIOS address (This will be a constant on
			;			most CP/M systems)
	Lxi	d,6	;Offset it by 9
	Dad	d
	;The address $ is here
	Lxi	d,$+5	;Put a return address on the stack
	Push	d
	Pchl		;Go to the I/O routine
	POP	B
	POP	D
	POP	H	;RESTORE REGISTERS
	RET

	;WRITECH - write out character in E while spooling
writech: push h!push b!push d
loop49:	call	prtout	;print a character if printer is ready
	Call Pready
	jz	loop49	;go try to print another char
	pop	d!push	d
	mvi	c,2
	call	0005	;CP/M write console command
	pop d!pop b!pop h
	ret

	;LIST - Write the character in A to the List Device
list:	mvi c,5
	mov	e,a
	Call	0005	;CP/M write List command
	ret

	;PREADY - Console Output Ready (True = Z flag = 0, False Z = 1)
	;Always returns true - If you know how to implement such a function,
	;it can be used to improve performance of the print spooling package
	;Must save all registers except A
Pready: Xra	a	;Clear the Accumlator
	Inr	a	;reset Z flag
	ret

	;READY - Console Input Ready (True = Z flag = 0, False Z = 1)
	;Must save all registers except A
Ready:	
	Push H!Push D!Push B
	;Should replace this with a constant
	Lhld	0001	;Get the BIOS address (This will be a constant on
			;			most CP/M systems)
	Lxi	d,3	;Offset it by 6
	Dad	d
	;The address $ is here
	Lxi	d,$+5	;Put a return address on the stack
	Push	d
	Pchl		;Go to the I/O routine
	Pop B!Pop D!Pop H
	Cpi	0
	Ret

	;LREADY - List Device Ready (True = Z flag = 0, False Z = 1)
	;Always returns true - Spooling performance will be improved by
	;implementing such a function
	;This function is available in many CP/M 2.2 BIOSs
	;Must Save all registers except A
Lready: Xra	a	;Clear the Accumlator
	Inr	a
	ret		;Reset Z flag

	;READM = SYSTEM READ BUFFER COMMAND W/ CTRL-H IMPLEMENTED
READM:	MOV	E,M	;save buffer length
	SHLD	COUNTLOC
	INX	H
SOVER:	MVI	B,0	;CLEAR B
	INX	H	;SET POINTER TO START OF BUFFER
LOOP30:	CALL READCHAR
	CPI	07FH
	JZ	BACKSP	;DO A BACKSPACE
	CPI	08H	;CTRL-H
	JZ	BACKSP
	CPI	24	;CTRL-X
	JZ	STARTOVER
	CPI	13	;RETURN
	JZ	ALMDONE
	CPI	32
	JC	ECTRL
	MOV	D,A	;SAVE CHAR
	XRA A	;Clear A
	CMP	C	;IS CAPITALIZATION FLAG ON?
	CNZ	CAPITAL
	MOV	A,D	;PUT CHAR BACK IN A
	MOV	M,A
	INX	H
	INR	B
	PUSH	H
	PUSH D!MOV E,A	;Write the character in A
	call writech
	POP D
	POP	H
	DCR	E	;test for full buffer
	JZ	ALMDONE
	JMP	LOOP30	;AGAIN
BACKSP:	XRA A	;Clear A
	CMP	B
	JZ	LOOP30
	DCR	B
	DCX	H	;MOVE POINTERS BACK
	INR	E	;one more space in buffer
	PUSH H!LXI H,LEFT	;Write the control character named
	PUSH B!PUSH D!CALL WRITECTRL!POP D!POP B
	POP H
	JMP	LOOP30
STARTOVER: PUSH	B	;save cap. flag
	MVI	E,'#'!call writech
	call crlf
	POP	B
	LHLD	COUNTLOC
	MOV	E,M
	INX	H
	JMP	SOVER
ECTRL:	MOV	M,A
	PUSH B!PUSH D!MVI	E,'^'!call writech!POP D!POP B
	MOV	A,M
	INX	H
	INR	B
	ADI	'A'
	DCR	A
	DCR	E
	PUSH D!MOV E,A	;Write the character in A
	call writech
	POP D
	JMP	LOOP30
ALMDONE: LHLD	COUNTLOC
	INX	H
	MOV	M,B	;SAVE COUNT
	call crlf
	RET
COUNTLOC: DW	0	;ADDR OF COUNT FIELD
	;CAPITAL - TRANSLATES CHAR IN D TO UPPER CASE
CAPITAL:MOV	A,D
	ANI	060H	;GET TWO BIT W/ CAUSE LOWER CASE
	CPI	060H
	RNZ		;DONE IF NOT LOWER CASE
	MOV	A,D
	ANI	05FH	;CLEAR BIT NO. 5
	MOV	D,A
	RET

START:	LXI	D,-40H	;CALC. TOP OF WORKSPACE PTR
	DAD	D	;SET TOP OF MEMORY (ALLOWING 1 PAGE FOR STACK)
	SHLD	TOPMEM	;SAVE TOP-OF-MEM
	MVI C,9!LXI D,SIGNIN2!PUSH H!CALL 0005H!POP H	;Print this message
	MVI C,9!LXI D,SIGNIN!PUSH H!CALL 0005H!POP H	;Print this message
	PUSH B!PUSH D!CALL READFILE!POP D!POP B	;READ IN FILE IN FCB INTO WORKSPACE
GETCH:	CALL READCHAR
	CPI	07FH
	JZ	CLEFT1	;RUBOUT = BACKSPACE
	CPI	32
	JC CNTRL	;CONTROL CHAR
	MOV	M,A
	PUSH D!MOV E,A	;Write the character in A
	call writech
	POP D
	INX H!PUSH B!PUSH D!CALL ADJPTRS!POP D!POP B
	JMP	GETCH
CNTRL:	XCHG
	MOV	C,A
	MVI	B,0	;PUT CHAR IN BC
	LXI	H,JTABLE
	DAD	B
	DAD	B	;GET TABLE INDEX
	MOV	C,M
	INX	H
	MOV	B,M
	MOV H,B!MOV L,C	;PUT ADDR IN HL
	PCHL		;JUMP TO ADDR IN HL
	;THE CONTROL CHAR JUMPTABLE
JTABLE:	DW	BELL,INSERT,BOTTOM,CHNG,DELETE,ERASE,FILE,BELL	;NULL-G
	DW	CLEFT,TAB,CDOWN,CUP,CRIGHT,RETURN,BELL,SPOOL	;H-O
	DW	SPRINT,QUIT,RSTART,SEARCH,CTOPFL,BELL,BELL,WIDTH;P-W
	DW	LINE,BELL,BELL,ISCREEN,BELL,BELL,CHOME,BELL	;X-31
	;RING BELL FOR INPUT ERROR
BELL:	XCHG
BELLN:	MVI	E,7!call writech	;RING BELL
	JMP	GETCH

	;PUT TAB IN WORKSPACE
TAB:	XCHG
	MVI M,'^'
	MVI	E,'^'!call writech
	INX H!PUSH B!PUSH D!CALL ADJPTRS!POP D!POP B
	MVI M,'-'
	MVI	E,'-'!call writech
	INX H!PUSH B!PUSH D!CALL ADJPTRS!POP D!POP B
	MOV	A,L	;PUT LOWER Byte of cursor in Acc
	ANI	07H	;Get lower 3 bits
	CPI	TABSTOP + 1	;IS IT ONE PAST (SINCE TAB IS ONE CHAR)
	JZ	GETCH
EXTAB:	CPI	TABSTOP	;TAB STOPS ARE SET TO EVERY 8 I.E.
			;whenever the bottom 3 bits = b. 3 bits of WORKSPACE
	JZ	GETCH
	MVI M,0!MVI	E,' '!call writech
	INX H!PUSH B!PUSH D!CALL ADJPTRS!POP D!POP B
	MOV	A,L
	ANI	07H
	JMP EXTAB

	;DO A CR
RETURN:	XCHG
	MVI M,'^'
	MVI	E,'^'!call writech
	INX H!PUSH B!PUSH D!CALL ADJPTRS!POP D!POP B
	MVI M,'_'
	MVI	E,'_'!call writech
	INX H!PUSH B!PUSH D!CALL ADJPTRS!POP D!POP B
	XCHG!LHLD BEGCURL!XCHG
	CALL CMPHLDE	;DONE IF LINE IS EXACTLY FULL
	JZ EOL7
	PUSH H!LXI H,CEOL	;Write the control character named
	PUSH B!PUSH D!CALL WRITECTRL!POP D!POP B
	POP H
	MVI	E,13!call writech	;OUTPUT CR-LF
	MVI	E,10!call writech
	XCHG!LHLD ENDCURL!XCHG
LOOP7:	CALL CMPHLDE
	JZ EOL7
	MVI	M,0	;FILL W/ NULLS
	INX	H
	JMP	LOOP7
EOL7:	PUSH B!PUSH D!CALL ADJPTRS!POP D!POP B
	JMP	GETCH

	;STORE WORKSPACE AND EXIT
FILE:	PUSH B!PUSH D!CALL WRTOUT!POP D!POP B
	PUSH H!LXI H,CLEAR	;Write the control character named
	PUSH B!PUSH D!CALL WRITECTRL!POP D!POP B
	POP H
	lda	pflag
	cpi	0
	jz	stop
	MVI C,9!LXI D,APRT!PUSH H!CALL 0005H!POP H	;Print this message
	PUSH B!PUSH D!CALL chgfl!POP D!POP B
	jmp	getch
aprt:	db	'Print spooling active - Exit when complete',13,10,'$'

	;STORE WORKSPACE AND CHANGE FILES
CHNG:	PUSH B!PUSH D!CALL CHGFL!POP D!POP B
	JMP	GETCH

	;RESTART EDITOR
RSTART:	xchg
	shld	cursor
	lhld	fcb+9
	SHLD	FTYPE
	LHLD	FCB+11	;save file type just in case
	SHLD	FTYPE+2
	PUSH H!LXI H,CLEAR	;Write the control character named
	PUSH B!PUSH D!CALL WRITECTRL!POP D!POP B
	POP H
	MVI C,9!LXI D,RSQUES!PUSH H!CALL 0005H!POP H	;Print this message
	MVI C,0FFH	;Capitalize the message
	PUSH	H
	LXI	H,BUF
	MVI	M,80	;Read a 80 character max. message
	CALL	READM!POP H
	MVI	E,0dh!call writech
	MVI	E,0ah!call writech
	LDA	BUF+2
	CPI	'Y'
	JZ	RESTART
	lhld	cursor
	call	pscreen
	JMP	GETCH
RSQUES:	DB	'RESTART (ALL WORK IS LOST)? [Y/N]$'
RESTART:PUSH B!PUSH D!CALL NXFILE!POP D!POP B
	JMP	GETCH

	;QUIT W/O FILING WORKSPACE
QUIT:	PUSH H!LXI H,CLEAR	;Write the control character named
	PUSH B!PUSH D!CALL WRITECTRL!POP D!POP B
	POP H
	xchg
	shld	cursor
	lda	pflag
	cpi	0
	jnz	aprint
	MVI C,9!LXI D,QTQUES!PUSH H!CALL 0005H!POP H	;Print this message
	MVI C,0FFH	;Capitalize the message
	PUSH	H
	LXI	H,BUF
	MVI	M,80	;Read a 80 character max. message
	CALL	READM!POP H
	LDA	BUF+2
	CPI	'Y'
	JZ	STOP	;STOP IF Y
apback:	lhld	cursor
	call	pscreen	;print the screen and restore the cursor
	JMP	GETCH
QTQUES:	DB	'QUIT W/O FILING?(Y/N)$'
aprint: mvi	b,03fh
	PUSH H!LXI H,CLEAR	;Write the control character named
	PUSH B!PUSH D!CALL WRITECTRL!POP D!POP B
	POP H
aprlp:	push	b
	PUSH H!LXI H,HOME	;Write the control character named
	PUSH B!PUSH D!CALL WRITECTRL!POP D!POP B
	POP H
	MVI C,9!LXI D,aprt!PUSH H!CALL 0005H!POP H	;Print this message
	pop	b
	dcr	b
	jnz	aprlp	;wait so message can be read
	jmp	apback	;can't quit if printing going on

        ;Print screen for insurance
iscreen: xchg
	PUSH B!PUSH D!CALL pscreen!POP D!POP B
	jmp getch

	;Spool a file to the printer
spool:	xchg
	shld	cursor	;save cursor
	lda	pflag
	cpi	0
	jnz	belln	;ring bell if printing is going on
	PUSH H!LXI H,Clear	;Write the control character named
	PUSH B!PUSH D!CALL WRITECTRL!POP D!POP B
	POP H	;Clear screen
spfl:	MVI C,9!LXI D,pques!PUSH H!CALL 0005H!POP H	;Print this message
	MVI C,0FFH	;Capitalize the message
	PUSH	H
	LXI	H,pbuf
	MVI	M,80	;Read a 80 character max. message
	CALL	READM!POP H
	mvi	d,0
	lda	pbuf+1
	mov	e,a
	lxi	h,pbuf+2
	dad	d	;find end of input
	mvi	m,26	;and mark it
	inx	h
	mvi	m,26
	lda	pbuf+3
	cpi	':'
	jz	odisk
	XRA A	;Clear A
	sta	pfcb	;use current disk
	lxi	h,pbuf+2
	lxi	d,pfcb+1
loop45:	mov	a,m
	inx	h
	cpi	'.'	;is it the dot?
	JZ EOL45
	cpi	26
	JZ EOL45
	STAX	d	;put in fcb
	inx	d
	jmp	loop45
eol45:	xchg
	lxi	b,pfcb+9
loop46:	CALL CMPHLBC
	JZ eol46
	JC eol46
	mvi	m,' '
	inx	h
	jmp	loop46
eol46:	xchg
	lxi	d,pfcb+9
loop47:	mov	a,m
	inx	h
	cpi	26
	JZ eol47
	stax	d
	inx	d
	jmp	loop47
eol47:	xchg
	lxi	b,pfcb+12
loop48:	CALL CMPHLBC
	JZ eol48
	JC eol48
	mvi	m,' '
	inx	h	;fill fcb file type with blanks
	jmp	loop48
eol48:	MVI C,9!LXI D,tabques!PUSH H!CALL 0005H!POP H	;Print this message
	call	getnum
	mov	a,l
	sta	ptablen
	XRA A	;Clear A
	sta	pfcb+12	;start with sector and extent zero
	sta	pfcb+32
	MVI C,15!LXI D,pfcb!PUSH H!CALL 0005H!POP H	;File Open
	CPI 255!JZ poperr
	lxi	h,pbuf+80h
	shld	pbufpt
	mvi	a,0ffh
	sta	pflag
	lda	ptablen
	sta	ptabcnt	;set tab count
	lhld	cursor
	PUSH H!LXI H,CLEAR	;Write the control character named
	PUSH B!PUSH D!CALL WRITECTRL!POP D!POP B
	POP H
	PUSH B!PUSH D!CALL pscreen!POP D!POP B
	jmp	getch
odisk:	lda	pbuf+2
	sui	'A'
	inr	a
	sta	pfcb	;use disk other than current disk
	lxi	h,pbuf+4
	lxi	d,pfcb+1
	jmp	loop45	;get rest of name
pques:	db	'File to output to printer? $'
poperr:	MVI C,9!LXI D,perr!PUSH H!CALL 0005H!POP H	;Print this message
	lhld	cursor
	PUSH B!PUSH D!CALL pscreen!POP D!POP B
	jmp	getch
perr:	db	'File not found',13,10,'$'
	;**** Old red block starts here ****
	;START A PRINTING OPERATION HERE
SPRINT:	xchg
	shld	cursor	;save cursor location
	LDA	PFLAG
	CPI	0
	JNZ	belln	;PRINTING ALREADY GOING ON
	PUSH H!LXI H,CLEAR	;Write the control character named
	PUSH B!PUSH D!CALL WRITECTRL!POP D!POP B
	POP H	;CLEAR SCREEN
	MVI C,9!LXI D,Printques!PUSH H!CALL 0005H!POP H	;Print this message
	CALL	STRING	;GET ANSWER TO QUESTION
	CPI	'N'
	JZ	NOPRINT	;QUIT,RESTORE SCREEN
	CPI	'Y'
	JZ	FORMATP	;FORMAT PRINT FILE
	JMP	SPRINT
PRINTQUES: DB	'Print File (Y/N)? $'

Noprint: lhld	cursor		;Printing going on
	call	pscreen
	jmp	getch

formatp: lxi	h,workspace
	mvi	a,'^'
	cmp	m	;is this a formatting block
	jz	prskip
formp:  MVI C,9!LXI D,numques!PUSH H!CALL 0005H!POP H	;Print this message
	CALL	GETNUM		;get length of line from user
	lxi	d,prtbuf
	dad	d
	shld	eoprtb
	MVI C,9!LXI D,tabques!PUSH H!CALL 0005H!POP H	;Print this message
	call	getnum		;get tab expansion length
	mov	a,l
	sta	tablen
	MVI C,9!LXI D,typeques!PUSH H!CALL 0005H!POP H	;Print this message
	call	getnum		;get printing type
	mov	a,l
	sta	ptype
prqskip:lxi	h,fcb
	lxi	d,pfcb	;copy file name and disk
	lxi	b,9
	CALL LDIR
	lxi	h,'PR'	;SET File Type to .prt
	shld	pfcb+9
	MVI	A,'T'
	STA	PFCB+11
	XRA A	;Clear A
	sta	pfcb+32	;start with sector zero
	sta	pfcb+12	;and extent zero
	MVI C,26!LXI D,pbuf!PUSH H!CALL 0005H!POP H	;Set Sector Buffer Address
	MVI C,19!LXI D,pfcb!PUSH H!CALL 0005H!POP H	;File Erase	;erase old file
	MVI C,22!LXI D,pfcb!PUSH H!CALL 0005H!POP H	;File Create	;create new .prt file
	MVI C,15!LXI D,pfcb!PUSH H!CALL 0005H!POP H	;File Open
	CPI 255!JZ poperr	;go to poerr if open error
	lda	tablen
	sta	ptabcnt
	lxi	h,pbuf
	shld	pbufpt	;init. buffer pointers
	LXI	H,Workspace ;Start of File
	XCHG!LHLD EOWKSP!XCHG	;End of File
	lxi	b,prtbuf	;Set B to buffer pointer
PFWRT:	MOV	A,M	;GET CHARACTER
	inx	h
	cpi	'^'
	jz	pctrl	;is it a control char
pback:	CPI	0	;IS IT A NULL?
	JZ	Pfwrt
	STAX	B	;STORE IN BUFFER
	INX	B	;MOV POINTER
	lda	ptabcnt
	dcr	a
	cz	resetcnt
	sta	ptabcnt
	lda	eoprtb	;least sig. byte of e-o-print buffer
	inr	a	;plus one
	cmp	c
	cz	eoljust
	CALL CMPHLDE
	jz	tdone
	jnc	pfwrt	;if not past end of loop, do it again
tdone:	DCX	b	;assume last character is garbage
			;(it is if last char was a CR)
	CALL	PCRLF
	PUSH H!LHLD pbufpt!MOV B,H!MOV C,L!POP H	;get file buffer pointer
zmore:	MVI	A,26
	STAX	b	;FILL SECTOR WITH cntl-Z's
	INX	b
	mvi	a,(0ffh and (pbuf+80h))
	CMP	c
	JNZ	ZMORE	;NOT DONE
	MVI C,21!LXI D,pfcb!PUSH H!CALL 0005H!POP H	;File Sector Write	;WRITE LAST SECTOR OUT
	MVI C,16!LXI D,pfcb!PUSH H!CALL 0005H!POP H	;File Close
	XRA A	;Clear A
	sta	pfcb+12	;start with extent zero
	sta	pfcb+32	;and sector zero
	MVI C,15!LXI D,pfcb!PUSH H!CALL 0005H!POP H	;File Open	;RE-OPEN FILE FOR READING
	LXI	H,pbuf+80h	;set buffer to empty
	shld	pbufpt
	MVI	A,0ffh
	STA	PFLAG	;SET PFLAG TO NOT ZERO
	lda	ptablen
	sta	ptabcnt	;initalize tab counter
	lhld	cursor
	PUSH B!PUSH D!CALL PSCREEN!POP D!POP B	;restore screen
	jmp	getch
prskip:	inx	h
	mvi	a,'#'
	cmp	m
	jz	prqskip	;block at top - skip questions
	jmp	formp

resetcnt: lda	tablen
	ret		;reset tab counter

	;A control character
pctrl:	mov	a,m	;get next char
	inx	h
	cpi	'_'	;is it a return
	jz	pcrlfs
	cpi	']'	;is it a overprint
	jz	povrs
	cpi	'-'	;is it a tab
	jz	ptab2s
	cpi	'#'	;is it a print control block
	jz	pcblk
	dcx	h
	mvi	a,'^'	;it is not a control char
	jmp	pback

	;SUBROUTINE TO PRINT CR-LF INTO THE PRINT BUFFER
PCRLFS:	lda	ptype	;get formatting type
	cpi	1
	cz	pcrlf		;dump if flush left
	cpi	2
	cz	fright		;flush right copy
	cpi	3
	cz	pcrlf		;dump if justified
	cpi	4
	cz	centered	;center copy
	JMP	pfwrt	;RETURN TO THE CORRECT PLACE
PCRLF:	MVI	A,0DH	;CR
	STAX	b	;STORE IN PRINT BUFFER
	INX	b
	MVI	A,0AH	;LF
	STAX	b	;STORE IN PRINT BUFFER
	INX	b
	CALL	dumpbuf	;END OF LINE
	RET

	;SUBROUTINE TO PRINT Overprints TO PRINT BUFFER
POVR:	MVI	A,0dH	;Carriage Return
	STAX	b	;STORE IN BUFFER
	INX	b
	CALL	dumpbuf	;END-OF-LINE
	RET
POVRS:	CALL	POVR
	JMP	pfwrt	;RETURN TO CORRECT PLACE

	;routine to expand tabs into buffer
ptab2s:	mvi	a,' '
	stax	b	;store blank in buffer
	inx	b
	lda	eoprtb
	cmp	c
	jz	bfull
	lda	ptabcnt
	dcr	a
	jz	tbdone
	sta	ptabcnt
	jmp	ptab2s
tbdone:	lda	tablen
	sta	ptabcnt
	jmp	pfwrt
bfull:	call	eoljust
	jmp	pfwrt

	;Use items in a print control block
pcblk:	mov	a,m
	inx	h
	inx	h	;move ptr to next number
	sui	'0'	;figure printing type
	sta	ptype
	mvi	a,2	;set num of chars to trans
	push	h
	call	fignum
	mov	a,l
	inr	a	;set margin loc
	sta	margin
	pop	h
	inx h!inx h!inx h
	push	h
	mvi	a,3	;trans next 3 chars
	call	fignum	;figure line length
	push	d
	lxi	d,prtbuf
	dad	d	;find end of buffer
	shld	eoprtb
	pop d!pop h
	inx h!inx h!inx h!inx h
	mvi	a,2	;get tab length
	push	h
	call fignum
	mov	a,l
	sta	tablen
	pop	h
	inx h!inx h!inx h!inx h	;skip trailing CR
	jmp	pfwrt

	;SUBROUTINE TO dump buffer on END-OF-LINE
EOL:	call	dumpbuf
	ret

	;BREAK AT WORD BOUNDARYS
eoljust:	DCX	b	;GET LAST CHAR
BLOOP:	LDAX	b
	CPI	' '	;IS IT A SPACE?
	JZ	BOUT
	mvi	a,(0ffh and prtbuf)	;least sig. bits of buffer start
	cmp	c
	jz	toolong	;word is toolong
	DCX	b
	DCX	H	;BACK UP UNTIL NEXT SPACE
	JMP	BLOOP
BOUT:	DCX	b
	LDAX	b
	CPI	' '
	JZ	BOUT	;only if sentinel works
	INX	b
	lda	eoprtb	;print buffer end
	cmp	c
	jz	bback	;if buffer is exactly full, dump w/o adj.
	lda	ptype	;get formating type
	cpi	2
	jz	fright	;flush right
	cpi	3
	jz	justify	;justified
	cpi	4
	jz	centered	;centered
bback:	call	pcrlf
	ret
toolong: lda	eoprtb
loop52: inx	b
	inx	h
	cmp	c
	jnz	loop52	;move pointers back to end of buffer
	call	pcrlf
	ret
ptype:	db	0	;printing type
eoprtb:	dw	0	;Line length to print
tablen:	db	0	;Tab expansion length
margin:	db	0	;margin value
fright: push h!push d
	MOV D,B!MOV E,C
	MOV H,B!MOV L,C
	lxi	b,prtbuf	;find out no. of chars to move
	CALL SUBB
	XRA A	;Clear A
	cmp	l
	jz	frdone	;nothing on that line
	MOV B,H!MOV C,L	;save no. of chars
	dcx	d	;don't move final space
	lhld	eoprtb
	dcx	h
	xchg
	CALL LDDR		;move line to top of buffer
	xchg
	lxi	d,prtbuf
	inx	h
loop51:	dcx	h
	mvi	m,' '	;fill left part of buffer with spaces
	mov	a,l
	cmp	e
	jnz	loop51
	pop d!pop h
	PUSH H!LHLD eoprtb!MOV B,H!MOV C,L!POP H	;get end of buffer addr. for CR
	jmp	bback
frdone:	pop d!pop h
	jmp	bback

	;justify the output buffer
justify:push d!push h
	XRA A	;Clear A
	sta	progflag
	lhld	eoprtb	;get end of buffer
	mvi	a,0ffh and prtbuf
	cmp	c
	jz	bkln	;print blank line if line is empty
fway:	dcx	b
	dcx	h
	ldax	b	;get the first char
	mov	m,a
	cpi	' '	;is it a space
	jz	finsert
	mvi	a,(0ffh and prtbuf)
	cmp	c	;end of buffer reached?
	jz	oway
	jmp	fway
finsert: dcx	h
	mvi	m,' '	;add a blank to the buffer
	mvi	a,0ffh
	sta	progflag	;yes, progress made on this pass
	mov	a,c
	cmp	l
	jz	jdone	;pointers the same (all space filled)
loop54: dcx	h
	dcx	b	;skip all insuing spaces
	ldax	b
	mov	m,a
	cpi	' '
	jnz	eol54
	mvi	a,(0ffh and prtbuf)
	cmp	c
	jz	oway	;end of buffer reached
	jmp	loop54
eol54:	inx	h
	inx	b	;restore pointers
	jmp	fway
oway:	mov	a,m
	stax	b
	inx	b
	inx	h
	cpi	' '	;space marks insertion point
	jz	oinsert
	lda	eoprtb
	cmp	l	;end of buffer reached
	jz	anyprog
	jmp	oway	;next char
oinsert: mvi	a,' '
	stax	b
	inx	b
	mvi	a,0ffh
	sta	progflag	;yes progress made on this pass
	mov	a,c
	cmp	l	;done yet?
	jz	jdone
loop53:	mov	a,m	;skip all spaces which are adj
	stax	b
	cpi	' '
	jnz	oway
	inx	b	;move pointers
	inx	h
	lda	eoprtb
	cmp	l
	jz	anyprog
	jmp	loop53
anyprog: lda	progflag	;any progress?
	cpi	0
	jnz	fway
	pop h!pop d		;else print what you got(it can't be just.)
	jmp	bback
bkln:	lxi b,prtbuf	;print a blank line
	pop h!pop d
	jmp	bback
jdone:	PUSH H!LHLD eoprtb!MOV B,H!MOV C,L!POP H	;set pointer to end of buffer
	pop h!pop d
	jmp	bback
progflag: db	0	;anything happen on the last pass?

centered: ;center the text in the buffer
	push h!push d
	MOV D,B!MOV E,C	;copy eol ptr
	lhld	eoprtb	;get end of buf ptr
loop56:	CALL CMPHLDE	;DE .ge. HL? (Reached end of buffer)
	jnc	eol56	;done then
	inx d!inx d	;move marker over 2
	inx	b	;move eol ptr over 1
	push b!push d!push h
	MOV H,B!MOV L,C
	MOV D,B!MOV E,C
	lxi	b,prtbuf
	CALL SUBB		;find no. of chars in buf
	MOV B,H!MOV C,L
	MOV H,D!MOV L,E
	dcx	h
	CALL LDDR		;move all chars up one
	mvi	a,' '
	sta	prtbuf	;put space in first char
	pop h!pop d!pop b
	jmp	loop56
eol56:	pop d!pop h
	jmp	bback

	;SUBROUTINE TO INPUT A Decimal Number
	;CONVERT it to BINARY, AND Leave the result IN HL
GETNUM:	PUSH PSW! PUSH B! PUSH D	;SAVE REGISTERS
	MVI C,0	;Don't capitalize the message
	PUSH	H
	LXI	H,BUF
	MVI	M,80	;Read a 80 character max. message
	CALL	READM!POP H
	lxi	h,buf+2	;buffer starting addr
	lda	buf+1
fignume:mov	b,a	;entry to figure A chars at HL
	XRA A	;Clear A
	mov	d,a
	mov	e,a	;clear DE
ZLOOP:	XRA A	;Clear A
	cmp	b	;end of buffer?
	jz	gdone	;done getting number
	dcr	b
	mov	a,m	;get the character
	inx	h	;Move pointer
	SUI	30H	;SUBTRACT ASCII ZERO TO GET MAGNITUDE
	CPI	10	;IS THIS CHARACTER A NUMBER
	JNC	ZLOOP	;NO - SKIP IT
	push	h	;save pointer
	mov	c,a	;save mag.
	push	b
	XRA A	;Clear A!mov h,a!mov l,a	;clear HL
		;MULTIPLY D BY 10
	DAD	D	;STORE D IN H
	DAD	H	;H = H*2
	DAD	H	;H = H*2 = D*4
	DAD	D	;H = H+D = D*5
	DAD	H	;H = H*2 = D*10
	MVI	B,0	;clear b so number is in BC
	DAD	B	;ADD IN NEW CHAR
	XCHG		;PUT RESULT IN D
	pop	b!pop	h;restore registers
	JMP	ZLOOP
GDONE:	XCHG		;return answer in HL
	POP D! POP B! POP PSW!	;RESTORE REGISTERS
	RET
NUMQUES:DB	'Line Length to be printed (20-250)? $'
tabques:db	'No. of characters to expand tabs to? $'
typeques: db	'Type of line [1-Flush Left; 2-Flush Right;'
	db	' 3-Justified; 4-Centered]? $'

	;figure the number starting at HL, A chars long
fignum:	push psw!push b!push d
	jmp	fignume
	;**** End of oldred.lib ****

	;Subroutine to write out the formating buffer
	;BC is assumed to hold a pointer to the last char in the buffer
Dumpbuf: push h!push d
	lxi	h,prtbuf
	XCHG!LHLD pbufpt!XCHG	;get buffer pointer
	lda	margin
marg:	dcr	a	;expand margin to a-1 blanks
	jz	loop50
	push	psw
	mvi	a,' '
	stax	d
	inx	d
	mvi	a,(0ffh and (pbuf + 80h))
	cmp	e
	cz	pwrtsect
	pop	psw
	jmp	marg
loop50:	mov	a,m
	inx	h
	stax	d
	inx	d
	mvi	a,(0ffh and (pbuf + 80h))
	cmp	e
	cz	pwrtsect
	CALL CMPHLBC
	jnz	loop50	;is print buffer empty?
	XCHG!SHLD pbufpt!XCHG
	lxi	b,prtbuf ;reset prt buffer pointer
	lda	tablen
	sta	ptabcnt	;reset tab counter
	pop d!pop h
	ret

	;write a sector to the print file
pwrtsect: PUSH B!PUSH D
	MVI C,26!LXI D,pbuf!PUSH H!CALL 0005H!POP H	;Set Sector Buffer Address
	MVI C,21!LXI D,pfcb!PUSH H!CALL 0005H!POP H	;File Sector Write
	cpi	0
	jnz	dkfull	;disk full error
	POP D!POP B
	lxi	d,pbuf	;reset the buffer pointer
	ret

	;SUBROUTINE TO READ IN STRING AND PUT FIRST CHAR IN A
STRING:	PUSH B!PUSH D		;SAVE REGISTERS
	MVI C,0FFH	;Capitalize the message
	PUSH	H
	LXI	H,BUF
	MVI	M,80	;Read a 80 character max. message
	CALL	READM!POP H
	lda	buf+1
	cpi	0
	rz		;ret null in a if no character read
	lda	buf+2	;put first character in a
	POP D!POP B	;RESTORE REGISTERS
	RET

;* end of print package subroutines *

	;HOME CURSOR
CHOME:	LHLD	TOPSCREEN
	SHLD	CURSOR
	SHLD	BEGCURL	;SET POINTERS
	XCHG
	LHLD	TOPSCREEN
	LXI	B,CPLINE
	DAD	B
	SHLD	ENDCURL	;SET END OF LINE
	XCHG
	PUSH H!LXI H,HOME	;Write the control character named
	PUSH B!PUSH D!CALL WRITECTRL!POP D!POP B
	POP H;WRITE OUT HOME CHAR
	JMP	GETCH

	;TOP OF FILE
CTOPFL:	PUSH B!PUSH D!CALL MOREDONE1!POP D!POP B
	JMP	GETCH

	;MOVE CURSOR LEFT
CLEFT1:	XCHG		;ENTRY FOR RUBOUT
CLEFT:	LHLD	BEGCURL
	CALL CMPHLDE
	jz	lwrap	;wrap-around if at left margin
	XCHG
	PUSH H!LXI H,LEFT	;Write the control character named
	PUSH B!PUSH D!CALL WRITECTRL!POP D!POP B
	POP H
	DCX	H
	SHLD	CURSOR
	;Loop until not in an unused field
LcharTest:
	XRA A	;Clear A
	Cmp	M	;If an unused character = NULL, then do it
			;again
	jnz	Getch	;Done if not a null character
	xchg	;Get the cursor address in DE
	jmp	Cleft
lwrap:	lhld	topscreen
	CALL CMPHLDE
	jz	bell	;no wrap-around at top of screen
	lxi	b,-cpline
	lhld	begcurl
	dad	b
	shld	begcurl	;adjust the line pointers
	lhld	endcurl
	dad	b
	shld	endcurl
	xchg
	dcx	h	;move the cursor
	PUSH B!PUSH D!CALL crest!POP D!POP B
	jmp	lchartest	;Test for non-stopping character

	;MOVE CURSOR RIGHT
CRIGHT:	LHLD	ENDCURL
	INX	D
	CALL CMPHLDE
	jnc	rwrap	;wrap-around if at right margin
	XCHG
	PUSH H!LXI H,RIGHT	;Write the control character named
	PUSH B!PUSH D!CALL WRITECTRL!POP D!POP B
	POP H
	SHLD	CURSOR
RcharTest:
	;Move the cursor again if this is a unused field
	XRA A	;Clear A
	Cmp	m
	jnz	Getch	;Done if char /= Null
			;otherwise move the cursor again
	xchg		;Get Cursor addr in DE
	jmp	Cright
rwrap:	PUSH B!PUSH D
	MVI	E,0dh!call writech
	MVI	E,0ah!call writech
	POP D!POP B
	xchg
	PUSH B!PUSH D!CALL adjptrs!POP D!POP B
	jmp	RcharTest

	;MOVES CURSOR DOWN
CDOWN:	LXI	B,CPLINE	;LEN OF LINE
	LHLD	EOWKSP
	XCHG
	SHLD	CURSOR
	DAD	B
	CALL CMPHLDE
	JZ	BELL1	;AT BOTTOM OF WKSP
	JC	BELL1
	PUSH H!LXI H,DOWN	;Write the control character named
	PUSH B!PUSH D!CALL WRITECTRL!POP D!POP B
	POP H
	PUSH B!PUSH D!CALL ADJPTRS!POP D!POP B
	JMP	GETCH
BELL1:	LHLD	CURSOR
	JMP	BELLN

	;MOVE CURSOR UP
CUP:	LXI	H,WORKSPACE	;TOP OF WORKSPACE
	LXI	B,-CPLINE
	XCHG
	SHLD	CURSOR	;SAVE CURSOR IN CASE OFF TOP OF SCREEN
	DAD	B
	CALL CMPHLDE
	JNC	BELL2
BACK4:	SHLD	CURSOR
	XCHG
	LHLD	BEGCURL	;ADJUST LINE POINTERS
	DAD	B
	SHLD	BEGCURL
	LHLD	ENDCURL
	DAD	B
	SHLD	ENDCURL
	;If Cursor .LT. Topscreen Then -- Off Top of visible screen 
	;    -- Scroll Screen down
	;Else -- Just Move Cursor up
	LHLD	TOPSCREEN
	CALL CMPHLDE	;SCROLL DOWN NECESSARY?
	JNC ASKIP	;DONE IF IT ISN'T
	DAD	B
	SHLD	TOPSCREEN
	LHLD	BOTSCREEN
	DAD	B
	SHLD	BOTSCREEN
	PUSH H!LXI H,SCDWN	;Write the control character named
	PUSH B!PUSH D!CALL WRITECTRL!POP D!POP B
	POP H	;CAUSE SCREEN TO BE MOVED DOWN
	LHLD	CURSOR
	PUSH B!PUSH D!CALL PRINTLINE!POP D!POP B	;PRINT LINE AND RESTORE CURSOR
	LHLD	CURSOR
	JMP	GETCH
ASKIP:	LHLD	CURSOR
	PUSH B!PUSH D
	PUSH H!LXI H,UP	;Write the control character named
	PUSH B!PUSH D!CALL WRITECTRL!POP D!POP B
	POP H
	POP D!POP B
	JMP	GETCH
BELL2:	JZ	BACK4
	LHLD	CURSOR
	JMP	BELLN

	;ERASE A LINE
ERASE:	XCHG
	LHLD	BEGCURL
	SHLD	CURSOR
	PUSH H!LHLD ENDCURL!MOV B,H!MOV C,L!POP H
	XCHG
	LHLD	EOWKSP
	CALL CMPHLBC
	JNC	EDONE	;DELETE LAST LINE OF WORKSPACE
	CALL SUBB		;SUBTRACT BC FROM HL
	MOV B,H!MOV C,L
	LHLD	BEGCURL
	XCHG
	LHLD	ENDCURL
	CALL LDIR
	LXI	B,-CPLINE
	LHLD	EOWKSP
	DAD	B
	SHLD	EOWKSP	;CORRECT END OF WORKSPACE
	LHLD	CURSOR
	PUSH B!PUSH D!CALL peoscr!POP D!POP B	;PRINT UPDATED SCREEN
	JMP	GETCH
EDONE:	LHLD	CURSOR
	SHLD	EOWKSP
	PUSH B!PUSH D!CALL PSCREEN!POP D!POP B
	JMP	GETCH

	;INSERT A LINE
LINE:	LHLD	BEGCURL
	SHLD	CURSOR	;SET CURSOR TO BEGINING OF FIRST LINE
	PUSH H!LHLD begcurl!MOV B,H!MOV C,L!POP H
	call	inline	;insert a blank line
	LHLD	CURSOR
	PUSH B!PUSH D!CALL peoscr!POP D!POP B
	JMP	GETCH

	;GO TO BOTTOM OF WORKSPACE
BOTTOM: LHLD	EOWKSP
	XCHG
	LHLD	ENDCURL
	LXI	B,CPLINE
LOOP18:	CALL CMPHLDE
	JC	EOL18	;GOT TO BOTTOM
	DAD	B	;MOVE DOWN ANOTHER LINE
	JMP	LOOP18
EOL18:	SHLD	ENDCURL
	SHLD	BOTSCREEN
	LXI	B,-CPLINE
	DAD	B	;FIGURE NEW LINE BEGINING
	SHLD	BEGCURL
	LHLD	BOTSCREEN
	LXI	B,-(CPLINE*LPSCR)
	DAD	B	;FIGURE NEW SCREEN START
	SHLD	TOPSCREEN
	LHLD	EOWKSP
	PUSH B!PUSH D!CALL PSCREEN!POP D!POP B
	JMP	GETCH

	;insert a width control block
width:	lhld	begcurl
	shld	cursor	;set cursor to begining of line
	PUSH H!LHLD begcurl!MOV B,H!MOV C,L!POP H
	call	inline	;insert a blank line
	lxi	h,workspace	;determine if a block is already present
	mvi	a,'^'
	cmp	m
	jz	posblk
defblk:lxi	d,pblk
fillblk:lhld	cursor
	lxi	b,cpline	;fill in a block
	xchg
	CALL LDIR
	lhld	cursor
	PUSH B!PUSH D!CALL pscreen!POP D!POP B
	jmp	getch
posblk: inx	h
	mvi	a,'#'
	cmp	m
	jnz	defblk		;not a width block
	lxi	d,workspace	;copy the block at the top of the file
	jmp	fillblk
pblk:	db '^#3-00-080-08^_',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	;DELETE A CHARACTER
DELETE:	XRA A	;Clear A
	XCHG
	CMP	M
	JZ	BELLN	;IF NULL, DO NOTHING (CAN'T DELETE NOTHING)
	MVI	A,'^'
	CMP	M
	JZ	PTORR
	SHLD	CURSOR
	MOV B,H!MOV C,L
BACK10:	LHLD	EOWKSP
	CALL SUBB		;FIND MAX NO. OF CHARS TO SEARCH
	MOV B,H!MOV C,L
	LHLD	CURSOR
TRYAGAIN: INX	H
	DCX	B
	MVI	A,'^'
	CALL CPIR		;FIND FIRST OCCURANCE OF ^
	JNZ	GOOD	;Found End of Workspace
			;Already pointing at next character -
			;Check it to see if we have a control sequence
	MOV	A,M
	CPI	05FH	;IS IT A CR
	JZ	GOOD
	CPI	'-'	;IS IT A TAB
	JNZ	TRYAGAIN;OTHERWISE ITS JUST A ^
GOOD:	SHLD	MOVTO
	LXI	H,1
	SHLD	NODEL
	PUSH H!LHLD NODEL!MOV B,H!MOV C,L!POP H
	LHLD CURSOR!DAD B!MOV B,H!MOV C,L
	LHLD MOVTO!CALL SUBB	;Determine number of characters to move
	MOV B,H!MOV C,L!LHLD CURSOR!MOV D,H!MOV E,L
	PUSH B!PUSH H!LHLD NODEL!MOV B,H!MOV C,L!POP H
	DAD B!POP B!INX B
	CALL LDIR
	LHLD	MOVTO
	MVI	M,0	;PUT NULL AT END
	DCX	H
	MOV	A,M
	CPI	'-'
	JNZ	WASRET	;ADJUST TABS AND RETURNS
	MVI	B,8
	XRA A	;Clear A
	INX	H
LOOP22:	CMP	M	;IF THERE ARE 8 NULLS FOLLOWING A TAB, 
	JNZ	EXDELETE;DELETE THEM ALL
	INX	H
	DCR	B
	JNZ	LOOP22
	LHLD	MOVTO
	PUSH B!PUSH D!CALL FINDCR!POP D!POP B	;FIND A CR STARTING AT MOVTO
	INX	H
	SHLD	NMOVTO
	LXI	H,8
	SHLD	NODEL
	PUSH H!LHLD NODEL!MOV B,H!MOV C,L!POP H
	LHLD MOVTO!DAD B!MOV B,H!MOV C,L
	LHLD NMOVTO!CALL SUBB	;Determine number of characters to move
	MOV B,H!MOV C,L!LHLD MOVTO!MOV D,H!MOV E,L
	PUSH B!PUSH H!LHLD NODEL!MOV B,H!MOV C,L!POP H
	DAD B!POP B!INX B
	CALL LDIR
	LHLD	NMOVTO
	shld	pdelto	;print up to here
	SHLD	MOVTO
	LXI	B,7
	MVI	M,0
	MOV D,H!MOV E,L	;WRITE IN 8 NULLS
	DCX	D
	CALL LDDR		;USING SMEAR TECH.
	XCHG!SHLD MOVTO!XCHG	;STORE MOVTO
WASRET:	MVI	B,80
	XRA A	;Clear A
	LHLD	MOVTO
	INX	H
LOOP23:	CMP	M
	JNZ	EXDELETE
	INX	H	;ARE THERE cpline NULLS FOLLOWING THE CR?
	DCR	B
	JNZ	LOOP23
	LXI	H,cpline
	SHLD	NODEL
	PUSH H!LHLD NODEL!MOV B,H!MOV C,L!POP H
	LHLD MOVTO!DAD B!MOV B,H!MOV C,L
	LHLD EOWKSP!CALL SUBB	;Determine number of characters to move
	MOV B,H!MOV C,L!LHLD MOVTO!MOV D,H!MOV E,L
	PUSH B!PUSH H!LHLD NODEL!MOV B,H!MOV C,L!POP H
	DAD B!POP B!INX B
	CALL LDIR
	LXI	B,-cpline
	LHLD	EOWKSP
	DAD	B
	SHLD	EOWKSP	;ADJUST EOWKSP TO REFLECT THE SHORTER FILE
	shld	pdelto	;print to end of workspace
EXDELETE: LHLD	CURSOR
	XCHG!LHLD pdelto!XCHG
	XRA A	;Clear A
	cmp	d
	jnz	skip6
	XCHG!LHLD movto!XCHG
skip6:	PUSH H!LHLD botscreen!MOV B,H!MOV C,L!POP H
loop41:	mov	a,m
	call	pable
	PUSH D!MOV E,A	;Write the character in A
	call writech
	POP D
	inx	h
	CALL CMPHLBC
	jz	eol41	;end of screen reached
	CALL CMPHLDE
	jnz	loop41	;end of changed area reached
	mvi	a,' '	;print a space at the end
	PUSH D!MOV E,A	;Write the character in A
	call writech
	POP D
eol41:	lxi	h,0
	shld	pdelto	;clear - so as to be able to tell if something new is there
	lhld	cursor
	call	crest	;restore cursor position
	jmp	getch
pdelto:	dw	0	;limiting address of delete print
MOVTO:	DW	0	;LIMITING ADDRESS OF MOVE
NODEL:	DW	0	;NO. OF CHARS TO DELETE
NMOVTO:	DW	0
PTORR:	SHLD	CURSOR	;TAB OR RETURN?
	INX	H
	MOV	A,M
	CPI	05FH	;RETURN?
	JZ	DELCTRL
	CPI	'-'	;TAB?
	JZ	DELCTRL
	PUSH H!LHLD CURSOR!MOV B,H!MOV C,L!POP H	;JUST A ^
	JMP	BACK10
DELCTRL:LXI	B,2
	XCHG!LHLD eowksp!XCHG	;only test to end of workspace
LOOP24:	INX	H
	XRA A	;Clear A
	CMP	M
	JNZ	EOL24
	INX	B
	CALL CMPHLDE
	jc	eol24	;quit if past end of the workspace
	JMP	LOOP24
EOL24:	PUSH H!MOV H,B!MOV L,C!SHLD NODEL!POP H
	PUSH B!PUSH D!CALL FINDCR!POP D!POP B	;FIND NEXT CR OR END-OF-WORKSPACE
	SHLD	MOVTO
	shld	pdelto
	PUSH H!LHLD NODEL!MOV B,H!MOV C,L!POP H
	LHLD CURSOR!DAD B!MOV B,H!MOV C,L
	LHLD MOVTO!CALL SUBB	;Determine number of characters to move
	MOV B,H!MOV C,L!LHLD CURSOR!MOV D,H!MOV E,L
	PUSH B!PUSH H!LHLD NODEL!MOV B,H!MOV C,L!POP H
	DAD B!POP B!INX B
	CALL LDIR	;move chars
	LHLD	MOVTO
	MVI	M,0
	MOV D,H!MOV E,L
	DCX	D
	PUSH H!LHLD NODEL!MOV B,H!MOV C,L!POP H
	DCX	B
	CALL LDDR		;FILL IN W/ NULLS BY SMEAR
	SHLD	MOVTO
	JMP	WASRET	;CHECK TO SEE IF A LINE MAY BE DELETED

	;INSERT - INSERT MODE
INSERT:	XCHG
	MOV	A,M	;TEST IF CHAR IS NULL
	CPI	0	
	JZ	BELLN	;DON'T ENTER INSERT MODE IF UNDERLYING CHAR IS NULL
insert1: shld istrt	;save the location inserted at for the print routine
	CALL READCHAR	;Get the next char of input
	CPI	07FH
	JZ	IERASE	;RUBOUT ERASES LAST CHAR
	CPI	32
	JC	ICTRL	;CONTROL CHAR
	PUSH B!PUSH D!CALL INCH!POP D!POP B
inback:	shld	cursor	;save cursor pos
	PUSH B!PUSH D!CALL pinst!POP D!POP B
inback2:PUSH B!PUSH D!CALL ADJPTRS!POP D!POP B
	JMP	INSERT1
ICTRL:	CPI	1
	jz	iexit	;CTRL-A  get out of insert
	CPI	9
	JZ	ITAB	;TAB CHAR
	CPI	13
	JZ	IRET	;RETURN CHAR
	cpi	1bh	;escape char
	jz	ireprt
IBELL:	PUSH B!PUSH D		;ELSE ERROR
	MVI	E,7!call writech	;RING BELL
	POP D!POP B
	JMP	INSERT1
iexit:	MVI	E,7!call writech	;ring the bell
	lxi	d,0	;clear 'print to' address
	XCHG!SHLD EPRT!XCHG
	mvi	b,150
loop43:	push	b
	MVI	E,0!call writech
	MVI	E,0!call writech	;seperate the 2 ringings of the bell
	pop	b
	dcr	b
	jnz	loop43
	MVI	E,7!call writech	;ring the bell twice
	jmp	getch	;go to main loop
	;Reprint screen (in case of errors)
ireprt: push	h
	PUSH B!PUSH D!CALL pscreen!POP D!POP B
	pop	h
	jmp	insert1
	;ERASE LAST CHAR (REPLACING IT WITH NULL)
IERASE:	MOV	A,M
	MVI	M,0
	DCX	H
	MOV	M,A
	JMP	INBACK
	;INSERT TAB
ITAB:	MVI	A,'^'
	CALL	INCH
	MVI	A,'-'
	CALL	INCH	;INSERT ^-
LOOP27:	MOV	A,L
	ANI	07H
	CPI	TABSTOP	;EXPAND TAB
	JZ	INBACK
	XRA A	;Clear A
	CALL	INCH
	push	h
	push	d
	XCHG!LHLD eprt!XCHG
	lhld	endcurl	;print at least to the end of the curent line
	CALL CMPHLDE
	jnc skip43
	shld	eprt
skip43:	pop	d
	pop	h
	JMP	LOOP27
	;INSERT A RETURN
IRET:	MVI	A,'^'
	CALL	INCH
	CALL	ADJPTRS
	MVI	A,'_'
	CALL	INCH	;INSERT ^_
	XCHG!LHLD ENDCURL!XCHG
LOOP31:	CALL CMPHLDE	;INSERT PROPER NO. OF NULLS
	jz	inback
	XRA A	;Clear A
	PUSH B!PUSH D!CALL INCH!POP D!POP B
	JMP	LOOP31

	;search for string
SEARCH:	XCHG
	SHLD	CURSOR
	PUSH H!LXI H,HOME	;Write the control character named
	PUSH B!PUSH D!CALL WRITECTRL!POP D!POP B
	POP H
	MVI	B,LPSCR	;MOVE CURSOR DOWN THIS MANY TIMES
LOOP33:	PUSH H!LXI H,DOWN	;Write the control character named
	PUSH B!PUSH D!CALL WRITECTRL!POP D!POP B
	POP H
	DCR	B
	JNZ	LOOP33
	MVI	E,'>'!call writech	;TYPE PROMPT
	MVI C,0	;Don't capitalize the message
	PUSH	H
	LXI	H,BUF
	MVI	M,80	;Read a 80 character max. message
	CALL	READM!POP H	;GET SEARCH STRING
	LDA	BUF+1	;GET LENGTH
	MVI	B,0
	CMP	B
	JZ	LOOKFOR	;USE OLD STRING IF LENGTH IF LENGTH IS ZERO
	STA	STLEN
	MOV	C,A
	LXI	D,STBUF
	LXI	H,BUF+2
	CALL LDIR
LOOKFOR:LHLD	CURSOR
	INX	H	;Start at the character after the Cursor
LOOP34:	LXI	D,STBUF
	LDA	STLEN
	MOV	B,A
	PUSH	H
LOOP35:	LDAX	D
	CPI	'?'	;MATCHES ALL CHARS
	JZ	CSKIP
	CMP	M	;COMPARE CHARS
	JNZ	EOL35	;GO TO NEXT COMPARISION
CSKIP:	INX	D
	INX	H	
	DCR	B	;TRY NEXT CHARS
	JNZ	LOOP35	;UNLESS THERE AREN'T ANY
	POP	H
	JMP	SUCCESS	;SUCCESSFUL SEARCH
EOL35:	POP	H
	INX	H	;TRY NEXT MATCH
	XCHG!LHLD EOWKSP!XCHG
	CALL CMPHLDE
	JNC	LOOP34	;UNLESS EOWKSP REACHED
	LHLD	CURSOR	;FAILURE
	MVI	E,7!call writech
	PUSH B!PUSH D!CALL PSCREEN!POP D!POP B
	JMP	GETCH
STLEN:	DB	0
STBUF:	DS	80
SUCCESS:SHLD	CURSOR
	XCHG
	LXI	B,CPLINE
	LHLD	ENDCURL
LOOP36:	CALL CMPHLDE	;MOVE ENDCURL DOWN AS MUCH AS NECESSARY
	JC EOL36
	DAD	B
	JMP	LOOP36
EOL36:	SHLD	ENDCURL
	CALL SUBB
	SHLD	BEGCURL	;SET BEGCURL CPLINE CHARS BACK FROM ENDCURL
	LXI	B,10*CPLINE
	LHLD	BOTSCREEN
LOOP37:	CALL CMPHLDE	;MOVE BOTSCREEN DOWN
	JC EOL37
	DAD	B
	JMP	LOOP37
EOL37:	SHLD	BOTSCREEN
	LXI	B,LPSCR*CPLINE
	CALL SUBB
	SHLD	TOPSCREEN	;SET TOPSCREEN
	XCHG
	PUSH B!PUSH D!CALL PSCREEN!POP D!POP B
	JMP	GETCH

	;FINDCR - THIS SUBROUTINE SEARCHES FOR THE NEXT OCCURANCE OF
	;A CR.  HL HOLDS THE START ADDR, AND THE RESULT (2ND CHAR OF
	;CR).
FINDCR:	MOV B,H!MOV C,L
	XCHG
	LHLD	EOWKSP
	CALL SUBB		;DETER. NO. OF CHARS TO SEARCH FOR CR
	MOV B,H!MOV C,L
	XCHG
	JMP FINDCR1
GETMORE:INX	H
	INX	H
FINDCR1: MVI	A,05FH
	CALL CPIR
	RNZ
	DCX	H
	DCX	H
	MOV	A,M
	CPI	'^'	;IS IT REALLY A CR?
	JNZ	GETMORE
	INX	H
	RET

	;ADJPTRS - THIS SUBROUTINE ADJUSTS THE POINTERS FOR SCREEN AND
	;LINE ENDS FOR MOVEMENTS DOWN & RIGHT ON THE SCREEN.
	;IT ALSO IMPLEMENTS SCROLL UP
ADJPTRS:SHLD	CURSOR	;SAVE CURSOR
	XCHG
	LHLD	ENDCURL
	CALL CMPHLDE
	JC BSKIP
	LXI	B,CPLINE	;MOVE POINTERS
	DAD	B
	SHLD	ENDCURL
	LHLD	BEGCURL
	DAD	B
	SHLD	BEGCURL
	LHLD	BOTSCREEN
	CALL CMPHLDE
	JC BSKIP		;DONE IF IT DIDN'T LEAVE THE BOTTOM OF SCREEN
	DAD	B
	SHLD	BOTSCREEN
	LHLD	TOPSCREEN
	DAD	B
	SHLD	TOPSCREEN
	XCHG
	PUSH B!PUSH D!CALL PRINTLINE!POP D!POP B	;PRINT LINE ON BOT. OF SCREEN
	XCHG
BSKIP:	LHLD	EOWKSP
	CALL CMPHLDE
	CNC	EXTEND
	XCHG
	RET
extend: lhld	topmem
	CALL CMPHLDE
	jnc	memfull	;workspace is full
	XCHG!SHLD EOWKSP!XCHG	;NEW EOWKSP = CURRENT CURSOR POSITION
	RET

	;Inline - this subroutine inserts a blank line into the workspace
	;BC contains the position to insert
inline: lhld	eowksp
	push d!push b
	CALL SUBB		;find no. of chars to move
	inx	h
	MOV B,H!MOV C,L
	lxi	d,cpline
	lhld	eowksp
	dad	d
	xchg		;find where to move chars to
	lhld	topmem
	CALL CMPHLDE	;test for full workspace
	jnc	memfull
	lhld	eowksp
	push	d
	CALL LDDR
	pop	d
	xchg!shld eowksp	;set new end of workspace
	pop	b
	MOV H,B!MOV L,C
	lxi	b,cpline	;fill line with nulls
	MOV D,H!MOV E,L
	mvi	m,0
	inx	d!dcx	b
	CALL LDIR			;use smear technique to fill the chars
	pop	d
	ret
memfull: MVI C,9!LXI D,memmess!PUSH H!CALL 0005H!POP H	;Print this message
	pop b!pop d
	ret
memmess: db	07,'Workspace is full',07,13,10,'$'

	;INCHAR - THIS SUBROUTINE INSERTS THE CHARACTER IN A AT THE
	;POSITION IN HL.
INCHAR:	PUSH	PSW
	PUSH	H	;SAVE A & HL
	XCHG!LHLD eowksp!XCHG	;get end-of-workspace
LOOP25:	MOV	A,M	;FIND FIRST NULL OR CR
	CPI	0
	JZ	FDNULL	;FOUND A NULL
	CPI	'^'
	JZ	PCR	;POSSIBLE CR
	INX	H
	CALL CMPHLDE
	jnc	loop25	;try again if not end-of-file
	inx	d
	lhld	topmem
	CALL CMPHLDE
	jnc	imemfull
	XRA A	;Clear A
	stax	d
	XCHG!SHLD eowksp!XCHG	;save new end-of-file
	xchg
	jmp	fdnull	;found null!
imemfull: MVI C,9!LXI D,memmess!PUSH H!CALL 0005H!POP H	;Print this message
	pop h!pop psw
	ret		;this may still cause a crash - I hope not
PCR:	INX	H
	MOV	A,M
	CPI	'_'	;IS NEXT CHAR LEGAL FOR CR?
	JNZ	LOOP25	;NOT CR
	INX	H
	MOV	A,M
	CPI	0
	JZ	FDNULL	;NULL FOLLOWING CR
	PUSH	H	;OTHERWISE INSERT 80 NULLS
	MOV B,H!MOV C,L
	call	inline	;insert a blank line
	lhld	eowksp
	shld	eprt	;Set to print to end-of-workspace
	pop	h
FDNULL:	SHLD	NULLPOS
	XCHG
	POP	H
	PUSH	H
	MOV B,H!MOV C,L
	XCHG
	CALL SUBB	;FIND NO. OF CHARS TO MOVE
	MOV B,H!MOV C,L
	LHLD	NULLPOS
	MOV D,H!MOV E,L	;MOVE UP ONE CHAR
	DCX	H
	CALL LDDR		;MOVE CHARS
	POP	H
	POP	PSW
	MOV	M,A	;STORE INSERT CHAR
	INX	H	;ADVANCE CURSOR
	RET
NULLPOS: DW	0	;POSITION OF NULL

	;INCH - THIS SUBROUTINE INSERTS THE CHAR IN A AT THE
	;LOCATION IN HL AND ADJUSTS TABS.
INCH:	PUSH B!PUSH D!CALL INCHAR!POP D!POP B	;INSERT THE CHAR
	PUSH	PSW	;SAVE ALL REGISTERS
	PUSH	H
	XCHG!LHLD NULLPOS!XCHG	;END OF SEARCH FOR TAB ADJUSTMENT
	DCX	D
	DCX	D	;END SEARCH TWO CHARS BACK
LOOP26:	CALL CMPHLDE
	JC	DRET	;DONE
	MOV	A,M
	CPI	'^'
	JZ	POTAB	;POSSIBLE TAB
	INX	H
	JMP	LOOP26
POTAB:	INX	H	;LOOK AT NEXT CHAR
	MOV	A,M
	CPI	'-'
	JNZ	LOOP26
	INX	H	;SEE WHAT FOLLOWS
	MOV	A,M
	CPI	0
	JZ	DRET
	XRA A	;Clear A
	PUSH B!PUSH D		;PUT NULLS AFTER TAB
LOOP32:	XRA A	;Clear A		;NULL A
	CALL	INCH	;insert a null
	MOV	A,L
	ANI	07H
	CPI	TABSTOP
	JNZ	LOOP32	;PUT NULLS UP TO TABSTOP
	POP D!POP B
DRET:	POP	H	;RESTORE CHAR POS.
	POP	PSW
	RET

	;THIS SUBROUTINE OPENS OR CREATES THE FILE WHOSE NAME IS IN
	;IN FCB AND READS IT INTO THE WORKSPACE
READFILE: MVI C,26!LXI D,BUF!PUSH H!CALL 0005H!POP H	;Set Sector Buffer Address
	MVI C,17!LXI D,FCB!PUSH H!CALL 0005H!POP H	;File Name Search
	CPI	255	;FOUND?
	JZ	NEWFILE	;IF NOT, THEN CREATE NEWFILE
	MVI C,15!LXI D,FCB!PUSH H!CALL 0005H!POP H	;File Open
	CPI 255!JZ OERR
	MVI C,16!LXI D,FCB!PUSH H!CALL 0005H!POP H	;File Close	;check for R/O by writing out the fcb
	LXI	H,WORKSPACE
	MOV B,H!MOV C,L
LOOP:	PUSH	B
	MVI C,20!LXI D,FCB!PUSH H!CALL 0005H!POP H	;File Sector Read
	POP	B
	CPI	0	;HAS EOF BEEN REACHED
	JNZ	READDONE
	LXI	D,BUF	;SET PTR TO TOP OF BUF
LOOP2:	LDAX	D	;GET A CHAR
	INX	D
	CPI	13	;IS IT A CR?
	JZ	WCRLF
	CPI	9	;IS IT A TAB?
	JZ	WTAB
	CPI	32	;IF ANY OTHER CONTROL CHAR
	JC	BACK	;SKIP IT
	MOV	M,A	;PUT CHAR IN WORKSPACE
	INX H!PUSH D!CALL ADJLPTR!POP D	;ADJUST LINE POINTER
BACK:	MVI	A,0FFH AND (BUF + 80H)
	CMP	E	;END-OF-BUFFER
	JNZ	LOOP2	;NO
	JMP	LOOP	;GET NEW SECTOR
WTAB:	MVI	M,'^'
	INX H!PUSH D!CALL ADJLPTR!POP D	;TAB CHAR IS REPRESENTED BY ^-
	MVI	M,'-'	
	INX H!PUSH D!CALL ADJLPTR!POP D
	MOV	A,L
	ANI	07H	;GET LOWER 3 BITS OF WK ADDR
	CPI	TABSTOP + 1	;IS IT ONE PAST (TAB IS ONE CHAR)
	JZ	BACK	;THIS IS AN ATTEMPT AT WHAT YOU SEE IS WHAT YOU GET
EXPTAB:	CPI	TABSTOP
	JZ	BACK
	MVI	M,0	;PUT NULL IN WKSP
	INX H!PUSH D!CALL ADJLPTR!POP D
	MOV	A,L
	ANI	07H
	JMP EXPTAB
WCRLF:	MVI	M,'^'	;REPLACE CR WITH THE
	INX H!PUSH D!CALL ADJLPTR!POP D
	MVI	M,'_'
	INX H!PUSH D!CALL ADJLPTR!POP D
LOOP3:	CALL CMPHLBC	;NULL OUT REST OF LINE
	JZ	EOL3	;DONE WHEN MATCH
	MVI	M,0	;PUT NULL IN WSPACE
	INX	H
	JMP	LOOP3
EOL3:	CALL	ADJLPTR	;ADJUST LINE POINTER
	JMP	BACK

	;SUBROUTINE TO ADJUST LINE POINTER (BC)
	;TO POINT TO THE BEGINING OF THE NEXT LINE
ADJLPTR:CALL CMPHLBC
	JC	ADJUST
	JZ	ADJUST
	RET		;IT DOESN'T NEED TO BE ADJUSTED
ADJUST:	PUSH	H
	LXI	H,CPLINE ;NO OF CHARS/LINE
	DAD	B
	MOV B,H!MOV C,L
	POP	H
	PUSH	H
	CALL	ADJLPTR	;DO IT AGAIN
	LHLD	TOPMEM	;IS WORKSPACE FULL?
	CALL CMPHLBC
	JC	RTN	;NO
	PUSH H!LXI H,CLEAR	;Write the control character named
	PUSH B!PUSH D!CALL WRITECTRL!POP D!POP B
	POP H
	MVI C,9!LXI D,MFULL!PUSH H!CALL 0005H!POP H	;Print this message
	MVI C,9!LXI D,MFULL2!PUSH H!CALL 0005H!POP H	;Print this message
	JMP 0000H  ;Reboot to Halt Program
RTN:	POP	H
	RET
MFULL:	DB	'WORKSPACE OVERFLOW - INPUT FILE TOO BIG',13,10,'$'
MFULL2:	DB	'DECREASE SIZE OF INPUT FILE W/ ED - RED ABORTED',13,10,'$'

	;CREATE AND ZERO WORKSPACE FOR A NEW FILE
NEWMESS:DB	'NEW FILE',13,10,'$'
NEWFILE:MVI C,9!LXI D,NEWMESS!PUSH H!CALL 0005H!POP H	;Print this message
	MVI C,22!LXI D,FCB!PUSH H!CALL 0005H!POP H	;File Create
	CPI 255!JZ DFULL	;DISK FULL
	MVI C,15!LXI D,FCB!PUSH H!CALL 0005H!POP H	;File Open
	LXI	H,WORKSPACE  ;GET START OF WORKSPACE
READDONE: LXI	D,EOSC
LOOP4:	CALL CMPHLDE	;IS MINIMUM WORKSPACE FULL?
	JC	MOREDONE	;YES
	MVI	M,0	;FILL WITH NULLS
	INX	H
	JMP	LOOP4
MOREDONE: SHLD	EOWKSP	;SET END OF WORKSPACE
	MVI C,16!LXI D,FCB!PUSH H!CALL 0005H!POP H	;File Close
MOREDONE1: LXI	H,WORKSPACE  ;INITIALIZE POINTERS
	SHLD	TOPSCREEN
	SHLD	CURSOR
	SHLD	BEGCURL
	LXI	H,WORKSPACE+CPLINE
	SHLD	ENDCURL
	LXI	H,WORKSPACE+CPLINE*LPSCR
	SHLD	BOTSCREEN
	LHLD	CURSOR
	PUSH B!PUSH D!CALL PRINTSCREEN
	PUSH H!LXI H,HOME	;Write the control character named
	PUSH B!PUSH D!CALL WRITECTRL!POP D!POP B
	POP H!POP D!POP B	;PRINT SCREEN
	RET

	;WRTOUT - THIS SUBROUTINE WRITES OUT THE WORKSPACE
	;TO THE FILE NAMED IN FCB.  IT ALSO ERASES THE .BAK FILE
	;OF THE SAME NAME, AND RENAMES THE SOURCE FILE TO .BAK
WRTOUT:	PUSH	H
	LHLD	FCB+9	;SAVE THE FILE TYPE
	SHLD	FTYPE
	LHLD	FCB+11
	SHLD	FTYPE+2
	LXI	H,'BA'	;SET FILE TYPE TO .BAK
	SHLD	FCB+9
	MVI	A,'K'
	STA	FCB+11
	MVI C,26!LXI D,BUF!PUSH H!CALL 0005H!POP H	;Set Sector Buffer Address
	MVI C,19!LXI D,FCB!PUSH H!CALL 0005H!POP H	;File Erase	;ERASE OLD .BAK FILE
	LXI	H,'$$'
	SHLD	FCB+9
	MOV	A,H
	STA	FCB+11	;SET FILE TYPE TO .$$$ (TEMP)
	XRA A	;Clear A
	STA	FCB+12	;START WITH EXTENT AND SECTOR ZERO
	STA	FCB+32
	MVI C,22!LXI D,FCB!PUSH H!CALL 0005H!POP H	;File Create
	CPI 255!JZ DFULL	;ABORT IF DISK FULL
	MVI C,15!LXI D,FCB!PUSH H!CALL 0005H!POP H	;File Open
	CPI 255!JZ OERR	;ABORT IF OPEN ERROR
	LXI	D,BUF
	LHLD	EOWKSP
	LXI	B,WORKSPACE ;GET START AND END OF WORKSPACE
LOOP5:	CALL CMPHLBC
	JZ	EOL5	;DONE IF WORKSPACE=EOWKSP (END REACHED)
	MOV	A,E
	CPI	0FFH AND (BUF + 80H)
	CZ	WRTSECT
	LDAX	B	;GET CHAR
	INX	B	;MOVE POINTER
	CPI	0	;DO NOTHING IF NULL
	JZ LOOP5
	CPI	'^'
	CZ	SPECHAR	;ITS A CODED CONTROL CHAR
	STAX	D
	INX	D	;STORE CHAR AND MOVE POINTER
	JMP	LOOP5
EOL5:	XCHG
	MVI	A,(0FFH AND (BUF + 080H))
LOOP6:	CMP	L
	JZ	EOL6	;LAST BUFFER FULL
	MVI	M,26	;ELSE FILL WITH CTRL-Z'S
	INX	H
	JMP	LOOP6
EOL6:	CALL	WRTSECT	;WRITE OUT LAST SECTOR
	MVI C,16!LXI D,FCB!PUSH H!CALL 0005H!POP H	;File Close
	LXI	H,'BA'
	SHLD	FCB+9
	MVI	A,'K'
	STA	FCB+11	;SET FILE TYPE TO .BAK
	LXI	B,12
	LXI	D,FCB+16
	LXI	H,FCB	;SET UP FCB FOR RENAME
	CALL LDIR
	LHLD	FTYPE
	SHLD	FCB+9
	LHLD	FTYPE+2
	SHLD	FCB+11
	MVI C,23!LXI D,FCB!PUSH H!CALL 0005H!POP H	;File Rename	;RENAME F.TYPE TO F.BAK
	LXI	B,12
	LXI	D,FCB+16
	LXI	H,FCB
	CALL LDIR
	MVI	A,'$'
	STA	FCB+9
	STA	FCB+10
	STA	FCB+11
	MVI C,23!LXI D,FCB!PUSH H!CALL 0005H!POP H	;File Rename	;RENAME F.$$$ TO F.TYPE
	POP	H
	RET

	;SPECHAR -THIS SUBROUTINE TRANSLATES OUTPUT SPECIAL CHARARTERS
	;TO THEIR TRUE CONTROL CHARACTER REPRESENTATION
SPECHAR:LDAX	B
	INX	B	;GET NEXT CHAR
	CPI	'_'
	JZ	SRETURN	;IS RETURN CHAR
	CPI	'-'
	JZ	STAB	;IS TAB CHAR
	MVI	A,'^'	;ELSE IS NO SPECIAL CHAR AT ALL
	DCX	B
	RET
SRETURN:MVI	A,10	;OUTPUT CR,LF
	DCX	B
	STAX	B	;PUT LF IN WORKSPACE
	MVI	A,13
	RET
STAB:	MVI	A,9	;OUTPUT TAB
	RET

	;WRTSECT - THIS ROUTINE WRITES A SECTOR TO THE CURRENTLY OPEN
	;FILE
WRTSECT:PUSH	B
	MVI C,21!LXI D,FCB!PUSH H!CALL 0005H!POP H	;File Sector Write
	cpi	0
	jnz	dkfull	;write error
	LXI	D,BUF
	POP	B
	RET

	;CHGFL - THIS SUBROUTINE ALLOWS THE CHANGING OF THE FILE IN
	;THE WORKSPACE
CHGFL:	PUSH B!PUSH D!CALL WRTOUT!POP D!POP B	;WRITE OUT OLD WORKSPACE
	PUSH H!LXI H,CLEAR	;Write the control character named
	PUSH B!PUSH D!CALL WRITECTRL!POP D!POP B
	POP H	;CLEAR SCREEN
NXFILE:	MVI C,9!LXI D,QUES!PUSH H!CALL 0005H!POP H	;Print this message
	MVI C,0FFH	;Capitalize the message
	PUSH	H
	LXI	H,BUF
	MVI	M,80	;Read a 80 character max. message
	CALL	READM!POP H
	MVI	D,0
	LDA	BUF+1
	CMP	D	;USE SAME FILE NAME IF ZERO
	JZ	RPEAT
	MOV	E,A
	LXI	H,BUF+2	;FIND END OF BUFFER ADDR
	DAD	D
	MVI	M,26		;MARK IT WITH CTRL-Z
	INX	H
	MVI	M,26
	lda	buf+3	;is a disk specified?
	cpi	':'
	jz	cdisk
	XRA A	;Clear A
	sta	fcb
	LXI	H,BUF+2
	LXI	D,FCB+1		;MOVE FILE NAME INTO FCB
LOOP10:	MOV	A,M	;GET CHAR
	INX	H
	CPI	'.'	;IS IT THE DOT BETWEEN THE FILE TYPES
	JZ EOL10
	CPI	26	;IS IT A CTRL-Z
	JZ EOL10
	STAX	D
	INX	D
	JMP	LOOP10
EOL10:	XCHG
	LXI	B,FCB+9
LOOP11:	CALL CMPHLBC
	JZ EOL11
	JC EOL11
	MVI	M,' '
	INX	H	;FILL FCB FILE-NAME WITH BLANKS
	JMP	LOOP11
EOL11:	XCHG
	LXI	D,FCB+9
LOOP12:	MOV	A,M	;GET CHAR
	INX	H
	CPI	26	;IS IT A CTRL-Z
	JZ EOL12
	STAX	D
	INX	D
	JMP	LOOP12
EOL12:	XCHG
	LXI	B,FCB+12
LOOP13:	CALL CMPHLBC
	JZ EOL13
	JC EOL13
	MVI	M,' '
	INX	H	;FILL FCB FILE-TYPE WITH BLANKS
	JMP	LOOP13
EOL13:	XRA A	;Clear A
	STA	FCB+12	;START WITH SECTOR & EXTENT ZERO
	STA	FCB+32
	PUSH B!PUSH D!CALL READFILE!POP D!POP B
	RET
cdisk:	lda	buf+2
	sui	'A'
	inr	a	;figure disk number
	sta	fcb
	lxi	h,buf+4
	lxi	d,fcb+1
	jmp	loop10
RPEAT:	LHLD	FTYPE	;RESET FILE TYPE
	SHLD	FCB+9	;FOR RE-INPUT
	LHLD	FTYPE+2
	SHLD	FCB+11
	JMP	EOL13
QUES:	DB	'NEW FILE NAME (OR <CR> TO EDIT MORE ON THE SAME FILE)? $'

	;THIS ROUTINE PRINTS A LINE WITHOUT RESTORING CURSOR
lines:	db 0	;a count of #lines printed so far
lincnt:	db 0	;the # of the line cursor is on
temphl:	dw 0	;temp space for hl reg
charcnt:db 0	;
maxchars equ cpline - 1
prline:	MVI	E,0dh!call writech	;write a cr
	mvi a,'_'
        cmp m;	check for cr in col 0
	jz col0;
notcr:  xra a;
	sta charcnt;	zero out character count
	xchg;	store it in d
	lhld eowksp;	put end of wksp in hl
morechs:lda charcnt;
	inr a;
	sta charcnt;
	CALL CMPHLDE;	past end of work space yet?
	jnc pexit;
	lda charcnt;
	cpi maxchars;
	jnc col78;
	;if there is a char in col78,delete the auto lf
	ldax d;	go get et?
	jnc pexit;
	lda charcnt;
	cpi maxchars;
	jnc col78;
	;if there is a char in col78,delete the auto lf
	ldax d;	go get first char to be printed
	cpi '^';	is it a cntl char?
	jz cntlchr;	if it is, go deal with it
prt:	call	pable	;generate a printable char
	PUSH D!MOV E,A	;Write the character in A
	call writech
	POP D;	write the char
	inx d;	go on to next char
	jmp morechs;	go get more chars
cntlchr:push d
	MVI	E,'^'!call writech
	pop d
	lda charcnt
	inr a
	sta charcnt
	inx d;	get last 'half' of cntl char
	ldax d;	load it in a
	cpi '_';	test for cr
	jnz prt;	if anything but cr, print it
prtcr:	MVI	E,'_'!call writech
pexit:	PUSH H!LXI H,CEOL	;Write the control character named
	PUSH B!PUSH D!CALL WRITECTRL!POP D!POP B
	POP H;clear to end of line
	MVI	E,0dh!call writech
	MVI	E,0ah!call writech
movup:	PUSH H!LXI H,UP	;Write the control character named
	PUSH B!PUSH D!CALL WRITECTRL!POP D!POP B
	POP H
	ret
col0:   dcx h;	if printing in col 0, check to see if it is a cr
	lda '^';
	cmp m;	see if previous char was '^'
	inx h;	this uses the fact that inx does not modify any flags
	jnz notcr;	if not, this must not be a cr
	jmp prtcr;	go print cr if it is
col78:  ldax d;	if printing in col 78, supress auto line feed
	call	pable
	PUSH D!MOV E,A	;Write the character in A
	call writech
	POP D
	inx d;
	ldax d
	call	pable
	PUSH D!MOV E,A	;Write the character in A
	call writech
	POP D;	print the last 2 chars on the line
	jmp movup;	go back and defeat the auto lf

	;this routine returns a printable char in a
	;the char in a if it is not a control char, or a blank if it is
pable:	cpi	7fh	;rubout or illegal char (over 80h)
	jnc	blank
	cpi	20h	;control char
	rnc
blank:	mvi	a,20h
	ret

	;this routine prints a line and restores the cursor 
printline:PUSH B!PUSH D
	shld cursor	;save cursor
	lhld begcurl	;get begining of line
	call prline;	print the line, then deal with cursor
	lhld cursor
	xchg;	put cursor posn in de
	lhld begcurl;	put begcurl in hl
notyet:	CALL CMPHLDE;	see if cursor is restored yet
	jz finish;	if so, finish up
	PUSH H!LXI H,right	;Write the control character named
	PUSH B!PUSH D!CALL WRITECTRL!POP D!POP B
	POP H;	if not, move cursor right 1 space
	inx h;
	jmp notyet;
finish:	lhld cursor;	finish up-- restore cursor to hl
	POP D!POP B;	restore regs
	ret;

	; this routine prints the screen
printscreen: shld cursor;
	PUSH B!PUSH D
	PUSH H!LXI H,CLEAR	;Write the control character named
	PUSH B!PUSH D!CALL WRITECTRL!POP D!POP B
	POP H
	lhld botscreen;
	xchg;	put bottom of screen in de
	lhld topscreen;	put top of screen in hl
	lxi b,cpline;	put # chars/line in bc
notdone:CALL CMPHLDE;	see if end of screen yet
	jnz morelines;	go print another line
	lhld cursor;
	POP D!POP B;	restore regs
	ret;
morelines: push h
	PUSH B!PUSH D
	CALL prline;	print a line
	MVI	E,0ah!call writech	;Line feed
	POP D!POP B
	pop h
	dad b;
	;add line length to hl (current "top" of screen)
	jmp notdone;	go back and see if more lines to print

	;this routine prints the relavent parts of the screen for insert mode
eprt:	dw	0	;print up to this address
istrt:	dw	0	;address at which insertion started
pinst:	lhld	nullpos
	XCHG!LHLD eprt!XCHG	;use the bigger of these 2
	CALL CMPHLDE
	jnc	skip5
	shld	eprt	;if nullpos is bigger, save it
	xchg
skip5:	lhld	istrt
	inx	d	;print character moved into, too
	PUSH H!LHLD botscreen!MOV B,H!MOV C,L!POP H;only print to the bottom of the screen
loop42:	PUSH B!PUSH D
	call ready
	POP D!POP B
	jnz	quitp	;stop printing if a character is ready
	mov	a,m
	call	pable	;make into a printable character
	PUSH D!MOV E,A	;Write the character in A
	call writech
	POP D
	inx	h
	CALL CMPHLBC
	jz	donep	;hit bottom of screen
	CALL CMPHLDE
	jnz	loop42	;if not end then do it again
donep:	lxi	h,0
	shld	eprt	;clear print-to addr.
quitp:	lhld	cursor
	call	crest
	ret

	;print to end of screen
peoscr:	shld	cursor
	XCHG!LHLD botscreen!XCHG
	lhld	begcurl
	lxi	b,cpline
loop40:	push	h
	PUSH B!PUSH D!CALL prline!POP D!POP B	;print a line
	pop	h
	dad	b		;go to the next line
	CALL CMPHLDE
	jz	eol40
	jc	eol40	;done with printing
	PUSH B!PUSH D
	MVI	E,0ah!call writech	;print a line feed
	POP D!POP B
	jmp	loop40
eol40:	lhld	cursor
	PUSH B!PUSH D!CALL crest!POP D!POP B	;restore cursor
	ret

	;THIS SUBROUTINE PRINTS THE SCREEN AND RESTORES THE
	;OLD CURSOR POSITION
pscreen: call	printscreen
	call	crest
	ret

	;restore the cursor
crest:	PUSH H!LXI H,HOME	;Write the control character named
	PUSH B!PUSH D!CALL WRITECTRL!POP D!POP B
	POP H
	LXI	B,CPLINE
	XCHG
	LHLD	TOPSCREEN
LOOP15:	CALL CMPHLDE
	JC ACROSS
	JZ EOL15
	DAD	B
	PUSH B!PUSH D
	PUSH H!LXI H,DOWN	;Write the control character named
	PUSH B!PUSH D!CALL WRITECTRL!POP D!POP B
	POP H
	POP D!POP B
	JMP	LOOP15
ACROSS:	PUSH B!PUSH D
	PUSH H!LXI H,UP	;Write the control character named
	PUSH B!PUSH D!CALL WRITECTRL!POP D!POP B
	POP H
	POP D!POP B
	LHLD	BEGCURL
LOOP16:	CALL CMPHLDE
	JZ	EOL15
	PUSH	D
	PUSH H!LXI H,RIGHT	;Write the control character named
	PUSH B!PUSH D!CALL WRITECTRL!POP D!POP B
	POP H
	POP	D
	INX	H
	JMP	LOOP16
EOL15:	XCHG
	RET

	;Print file to printer
prtout:	lda	pflag
	cpi	0	;printing?
	rz		;return if not
	Call Lready
	rz		;return if printer not ready
	lda	ptabfg
	cpi	0	;printing a tab
	jnz	ptab
	lhld	pbufpt
	mvi	a,(pbuf+80h) and 00ffh
	cmp	l
	cz	preadsect
	mov	a,m
	inx	h
	shld	pbufpt
	cpi	26	;CTRL-Z?
	jz	pdone
	cpi	09	;TAB
	jz	ptab2
	cpi	10
	cz	settab
	cpi	13
	cz	settab
	call list
	lda	ptabcnt
	dcr	a	;decrease tab count
	cz	settab2	;if 0, wrap around
	sta	ptabcnt
	ret
ptab:	lda	ptabcnt
	dcr	a
	sta	ptabcnt
	jnz	skip45
	sta	ptabfg
	call	settab2
skip45:	mvi	a,' '
	call list
	ret
ptab2:	mvi	a,0ffh	;turn on print flag
	sta	ptabfg
	jmp	ptab
settab:	push	psw
	lda	ptablen
	inr	a
	sta	ptabcnt	;reset tab counter
	pop	psw
	ret
settab2: lda	ptablen
	sta	ptabcnt
	ret
	;read a sector of the print file
preadsect: MVI C,26!LXI D,pbuf!PUSH H!CALL 0005H!POP H	;Set Sector Buffer Address
	MVI C,20!LXI D,pfcb!PUSH H!CALL 0005H!POP H	;File Sector Read
	cpi	0
	jnz	pdone	;end-of-file
	lxi	h,pbuf
	ret
pdone:	XRA A	;Clear A
	sta	pflag
	ret
 
	;OPEN ERROR
OERR:	MVI C,9!LXI D,OMESS!PUSH H!CALL 0005H!POP H	;Print this message
	JMP 0000H  ;Reboot to Halt Program
OMESS:	DB	'FILE OPEN ERROR - RED ABORTED',13,10,'$'

	;DISK DIRECTORY IS FULL
DFULL:	MVI C,9!LXI D,DIRF!PUSH H!CALL 0005H!POP H	;Print this message
	JMP 0000H  ;Reboot to Halt Program
dirf:	db	'The Disk Directory is Full, no file written',13,10,'$'

	;The disk is full
dkfull:	MVI C,9!LXI D,DSKFL!PUSH H!CALL 0005H!POP H	;Print this message
	JMP 0000H  ;Reboot to Halt Program
dskfl:	db	'The Disk is Full, no file written',13,10,'$'

	;PROGRAM ENDS HERE
STOP:	JMP 0000H  ;Reboot to Halt Program

PFLAG:		db	0	;Printing going on? 0=no
PBUF:		ds	129	;print buffer
		db	'*'	;a sentinel char at the beg. of the buf.
prtbuf:		ds	256	;print formating buffer
PFCB:		ds	33	;file control block for print file
PBUFPT:		dw	0	;pointer into buffer
PTABFG:		db	0	;tab flag
PTABCNT:	db	0	;tab counter
ptablen:	db	8	;length of tab to be expanded
FTYPE:		DW	0,0	;SAVE FILE TYPE HERE
BEGCURL:	DW	0	;BEGINING OF CURRENT LINE
ENDCURL:	DW	0	;END OF CURRENT LINE
CURSOR:		DW	0	;CURRENT CURSOR LOCATION
BOTSCREEN:	DW	0	;BOTTOM OF SCREEN
TOPSCREEN:	DW	0	;TOP OF SCREEN
TOPMEM:		DW	0	;TOP OF POSSIBLE WORKSPACE
EOWKSP:		DW	0	;TOP OF ALLOCATED WORKSPACE
WORKSPACE:	DS	CPLINE*LPSCR
EOSC:		DS	1
TABSTOP	EQU	(07H AND WORKSPACE)	;TAB STOP
	END	100H
